(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*            Reynolds paradox                                               *)
(*                                                                           *)
(*****************************************************************************)
(*            Uses: Log_Rel1                                                 *)
(*****************************************************************************)


(* Reynolds operator *)

Definition PHI = [A:Prop](A->Bool)->Bool.

(* we extend this map functorialy *)

Definition phi:(A,B:Prop)(A->B)->(PHI A)->(PHI B) =
   [A,B:Prop][f:A->B][z:(PHI A)][u:B->Bool](z [x:A](u (f x))).

(* preinitial PHI-algebra. We need the axiom (Prop,Prop) *)

Definition A0 = (A:Prop)((PHI A)->A)->A.

Definition iter_A0 = [X:Prop][f:(PHI X)->X][u:A0](u X f).

Definition intro : (PHI A0)->A0 =
    [z:(PHI A0)][A:Prop][f:(PHI A)->A](f (phi A0 A (iter_A0 A f) z)).

(* Extension of PHI to relations. We can thus consider PHI as a functor
   on sets, that are types with a relations *)

Definition phi2 : (A:Prop)(Rel A)->(Rel (PHI A)) =
[A:Prop][R:(Rel A)](power (A->Bool) (power A R)).

(* Partial equivalence relation defined on A0, so that the set A0,E0
   is an initial PHI-algebra in the category of sets *)

Definition teta : A0 -> (PHI A0) =
        (iter_A0 (PHI A0) (phi (PHI A0) A0 intro)).

Definition E0 : (Rel A0) = [x1,x2:A0](E:(Rel A0))
	(per A0 E) ->
	((z1,z2:(PHI A0))(phi2 A0 E z1 z2)->(E (intro z1) (intro z2))) ->
     	((x1,x2:A0)(E x1 x2)->(E x1 (intro (teta x2)))) ->
	(E x1 x2).

Definition F0 : (Rel (A0->Bool)) = (power A0 E0).

Definition G0 : (Rel (PHI A0)) = (power (A0->Bool) F0).

(* the goal of what follows is to show that the set A0,E0 is in one-to-one
   correspondance with the set (PHI A0),(phi2 A0 E0), via intro,teta.
   From this, we deduce a contradiction via Cantor-Russell's argument *)

Goal (sym A0 E0).
Unfold sym; Intros x y h1.
Unfold E0; Intros E h2 h3 h4.
Elim h2.
Unfold sym; Intros h5 h6.
Apply h5.
Apply h1.
Exact h2.
Exact h3.
Exact h4.
Save sym_E0.

Goal (trans A0 E0).
Unfold trans; Intros x y z h1 h2.
Unfold E0; Intros E h3 h4 h5.
Elim h3.
Unfold sym trans; Intros h6 h7.
Apply h7 with y.
Apply h1; Auto.
Apply h2; Auto.
Save trans_E0.

Goal (per A0 E0).
Apply per_intro.
Exact sym_E0.
Exact trans_E0.
Save per_E0.

(* intro is a map from (PHI A0),(phi2 A0 E0) to A0,E0 *)
Goal (z1,z2:(PHI A0))(G0 z1 z2)->(E0 (intro z1) (intro z2)).
Unfold E0; Intros z1 x2 h1 E h2 h3 h4.
Apply h3; Hnf; Intros x y h5.
Apply h1; Hnf; Intros x0 y0 h6.
Apply h5.
Apply h6; Auto.
Save lemma1.

Goal (per (A0->Bool) F0).
Unfold F0.
Unfold power.
Elim per_E0; Intros h1 h2.
Elim per_Eq; Intros h3 h4.
Apply per_intro.
Unfold sym; Intros x y h5.
Unfold exp; Intros x0 y0 h6.
Apply h3.
Apply h5.
Apply h1.
Exact h6.
Unfold trans; Intros x y z h5 h6.
Unfold exp; Intros x0 y0 h7.
Apply h4.
Instantiate (y y0).
Apply h5.
Exact h7.
Apply h6.
Apply h2.
Instantiate x0.
Apply h1.
Exact h7.
Exact h7.
Save per_F0.

Goal (per (PHI A0) G0).
Unfold G0.
Unfold power.
Elim per_F0; Intros h1 h2.
Elim per_Eq; Intros h3 h4.
Apply per_intro.
Unfold sym; Intros x y h5.
Unfold exp; Intros x0 y0 h6.
Apply h3.
Apply h5.
Apply h1; Auto.
Unfold trans; Intros x y z h5 h6.
Unfold exp; Intros x0 y0 h7.
Apply h4.
Instantiate (y y0).
Apply h5.
Exact h7.
Apply h6.
Apply h2.
Instantiate x0.
Apply h1.
Exact h7.
Exact h7.
Save per_G0.

Goal (x1,x2:A0)(E0 x1 x2)->(E0 x1 (intro (teta x2))).
Intros x1 x2 h1; Unfold E0; Intros E h2 h3 h4.
Apply h4.
Apply h1; Auto.
Save id_intro_teta.

Goal (z1,z2:(PHI A0))(G0 z1 z2)->(G0 z1 (teta (intro z2))).
Intros z1 z2 h1; Hnf; Intros x y h2.
Change (Eq (z1 x) (z2 [x:A0](y (intro (teta x))))).
Apply h1; Unfold F0 power exp; Intros x0 y0 h3.
Apply h2.
Apply id_intro_teta; Auto.
Save id_teta_intro.

Goal (x1,x2:A0)(E0 x1 x2)->(G0 (teta x1) (teta x2)).
Intros x1 x2 h1.
Change ([u,v:A0](G0 (teta u) (teta v)) x1 x2).
Apply h1.
Elim per_G0.
Intros h2 h3.
Apply per_intro.
Unfold sym.
Intros x y h4.
Apply h2.
Exact h4.
Unfold trans; Intros x y z h4 h5.
Apply h3.
Instantiate (teta y).
Exact h4.
Exact h5.
Intros z1 z2 h2; Hnf; Intros x y h3.
Change (Eq (z1 [u:A0](x (intro (teta u)))) 
	      (z2 [u:A0](y (intro (teta u))))).
Apply h2; Unfold power exp; Intros x0 y0 h4.
Apply h3.
Apply lemma1; Auto.
Intros x3 x4 h2; Apply id_teta_intro; Auto.
Save lemma_teta.

Definition f0.
Body [x,y:A0->Bool](I (F0 x y)).

Definition psi : (A0->Bool)->A0 =
[u:A0->Bool](intro (f0 u)).

Definition inter : (PHI A0)->A0->Bool =
[C:(PHI A0)][x:A0](I (P:A0->Bool)(F0 P P)->(T (C P))->(T (P x))).

Definition INTER: (PHI A0)->A0->Prop =
[C:(PHI A0)][x:A0](P:A0->Bool)(F0 P P)->(T (C P))->(T (P x)).

Goal (z1,z2:(PHI A0))(G0 z1 z2)->(F0 (inter z1) (inter z2)).
Intros z1 z2 H; Hnf; Intros x y H0.
Unfold Eq.
Apply equiv_intro; Intro H1.

Unfold inter.
Apply E1; Intros P H2 H3.
Cut (Eq (P x) (P y)).
Unfold Eq; Intro H4.
Elim H4; Intros H5 H6.
Apply H5.
Cut (P:A0->Bool)(F0 P P)->(T (z1 P))->(T (P x)).
Intro H7; Apply H7.
Exact H2.
Cut (Eq (z1 P) (z2 P)).
Unfold Eq; Intro H8.
Elim H8; Intros H9 H10.
Exact (H10 H3).
Apply H.
Exact H2.
Apply E2.
Apply H1.
Apply H2.
Exact H0.

Unfold inter.
Apply E1; Intros P H2 H3.
Cut (Eq (P x) (P y)).
Unfold Eq; Intro H4.
Elim H4; Intros H5 H6.
Apply H6.
Cut (P:A0->Bool)(F0 P P)->(T (z2 P))->(T (P y)).
Intro H7; Apply H7.
Exact H2.
Cut (Eq (z1 P) (z2 P)).
Unfold Eq; Intro H8.
Elim H8; Intros H9 H10.
Exact (H9 H3).
Apply H.
Exact H2.
Apply E2.
Apply H1.
Apply H2.
Exact H0.
Save lemma_inter.

(* we follow Cantor-Russell's paradox *)

Definition khi : A0 -> (A0->Bool) = [x:A0](inter (teta x)).

Section paradox.

Variable p:Prop.

Definition u0: A0->Bool = [x:A0](I ((T (khi x x))->p)).

Definition x0: A0 = (psi u0).

Goal (E0 x0 x0).
Unfold x0.
Unfold psi.
Apply lemma1; Hnf; Intros x y H.
Elim per_F0; Intros H0 H1.
Unfold f0 Eq.
Apply equiv_intro; Intro H2.
Apply E1.
Apply H1.
Instantiate x.
Apply E2.
Exact H2.
Exact H.
Apply E1.
Apply H1.
Instantiate y.
Apply E2.
Exact H2.
Apply H0.
Exact H.
Save lemma4.

Goal (F0 u0 u0).
Hnf; Intros x y H.
Cut (F0 (khi x) (khi y)).
Unfold khi; Intro H0.
Cut (Eq (khi x x) (khi y y)).
Unfold Eq; Intro H1.
Elim H1; Intros H2 H3.
Unfold u0.
Apply equiv_intro; Intro H4.
Apply E1; Intro H5.
Apply (E2 (T (khi x x))->p H4).
Exact (H3 H5).
Apply E1; Intro H5.
Apply (E2 (T (khi y y))->p H4).
Exact (H2 H5).
Unfold khi; Apply H0.
Exact H.
Unfold khi.
Apply lemma_inter.
Apply lemma_teta; Auto.
Save lemma3.

Goal (F0 u0 (khi x0)).
Unfold x0 psi.
Unfold khi.
Cut (per A0->Bool F0).
Intro H; Elim H; Intros H0 H1.
Apply H1.
Instantiate (inter (f0 u0)).
Hnf; Intros x y H2.
Unfold Eq.
Apply equiv_intro; Intro H3.

Unfold inter.
Apply E1; Intros P H4 H5.
Cut (Eq (u0 x) (P y)).
Unfold Eq; Intro H6.
Elim H6; Intros H7 H8.
Exact (H7 H3).
Cut (F0 u0 P).
Intro H6; Apply H6; Auto.
Apply E2; Auto.

Cut (F0 u0 u0).
Intro H4.
Cut (Eq (u0 x) (u0 y)).
Unfold Eq; Intro H5.
Elim H5; Intros H6 H7.
Apply H7.
Cut (INTER (f0 u0) y).
Intro H8; Apply H8.
Exact H4.
Exact (E1 (F0 u0 u0) H4).
Apply E2; Apply H3.
Apply H4.
Exact H2.
Exact lemma3.

Apply lemma_inter.
Hnf; Intros x y H2.
Cut (G0 (f0 u0) (teta (intro (f0 u0)))).
Intro H3; Apply H3.
Exact H2.
Apply id_teta_intro.
Hnf; Intros x0 y0 H3.
Unfold Eq.
Apply equiv_intro; Intro H4.

Unfold f0.
Apply E1.
Apply H1.
Instantiate x0.
Apply E2; Auto.
Exact H3.
Unfold f0.
Apply E1.
Apply H1.
Instantiate y0.
Apply E2; Auto.
Apply H0; Auto.
Apply per_F0.

Save lemma5.

Goal (Eq (u0 x0) (khi x0 x0)).
Apply lemma5.
Exact lemma4.
Save lemma6.

Goal (T (u0 x0)).
Unfold u0.
Apply E1; Intro H.
Cut (Eq (u0 x0) (khi x0 x0)).
Unfold Eq; Intro H0.
Elim H0; Intros H1 H2.
Cut (T (u0 x0)).
Intro H3.
Exact (E2 (T (khi x0 x0))->p H3 H).
Exact (H2 H).
Apply lemma6.
Save lemma7.

Goal p.
Cut (Eq (u0 x0) (khi x0 x0)).
Unfold Eq;Intro H.
Apply (E2 (T (khi x0 x0))->p lemma7).
Elim H; Intros H0 H1.
Exact (H0 lemma7).
Exact lemma6.
Save Reynolds.
Provide Reynolds1.
