(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*            Logical Relations : basic notions for Reynolds paradox         *)
(*                                                                           *)
(*****************************************************************************)


(* We derive the proof-irrelevance principle from the excluded middle *)

Variable Bool:Prop.

Variable T:Bool->Prop.

Variable I:Prop->Bool.

Variable E1:(x:Prop)x->(T (I x)).

Variable E2:(x:Prop)(T (I x))->x.

Goal (A,B:Prop)A->(A->B)->B.
Auto.
Save cut.

(* First, some general definition about relations *)

Inductive Definition equiv [A,B:Prop]:Prop  = 
		equiv_intro : (A->B)->(B->A)->(equiv A B).

Section Relation.

Definition Rel = [A:Prop]A->A->Prop.

Definition sym = [A:Prop][R:(Rel A)](x,y:A)(R x y)->(R y x).

Definition trans = [A:Prop][R:(Rel A)](x,y,z:A)(R x y)->(R y z)->(R x z).

Definition inclus = [A:Prop][R,S:(Rel A)](x,y:A)(R x y)->(S x y).

End Relation.

Inductive Definition per [A:Prop;R:(Rel A)]:Prop = 
	per_intro : (sym A R)->(trans A R)->(per A R).

Definition Eq = [x,y:Bool](equiv (T x) (T y)).

(* Eq is a partial equivalence relation over Bool *)
Goal (per Bool Eq).
Unfold Eq ; Apply per_intro.
(* 1: (sym Bool [x:Bool][y:Bool](equiv (T x) (T y))) *)
Unfold sym.
Induction 1; 
Intros; Apply equiv_intro; Trivial.
(* 2: (trans Bool [x:Bool][y:Bool](equiv (T x) (T y))) *)
Unfold trans.
Induction 2.
Elim H.
Intros; Apply equiv_intro; Auto.
Save per_Eq.

Section logical_relation.

Definition exp : (A:Prop)(Rel A)->(B:Prop)(Rel B)->(Rel (A->B)) = 
	[A:Prop][R:(Rel A)][B:Prop][S:(Rel B)][f,g:A->B]
	(x,y:A)(R x y)->(S (f x) (g y)).

Definition power : (A:Prop)(Rel A)->(Rel (A->Bool)) = 
        [A:Prop][R:(Rel A)](exp A R Bool Eq).

End logical_relation.

Provide Log_Rel1.
