(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*            Logical Relations : basic notions for Reynolds paradox         *)
(*                                                                           *)
(*****************************************************************************)


Goal (A,B:Prop)A->(A->B)->B.
Auto.
Save cut.

(* First, some general definition about relations *)

Inductive Definition equiv [A,B:Prop]:Prop  = 
		equiv_intro : (A->B)->(B->A)->(equiv A B).

Section relation.

Definition Rel.
Body [A:Type]A->A->Prop.

Definition sym.
Body [A:Type][R:(Rel A)](x,y:A)(R x y)->(R y x).

Definition trans.
Body [A:Type][R:(Rel A)](x,y,z:A)(R x y)->(R y z)->(R x z).

Definition inclus.
Body [A:Type][R,S:(Rel A)](x,y:A)(R x y)->(S x y).

End relation.

Inductive Definition per [A:Type;R:(Rel A)]:Prop = 
	per_intro : (sym A R)->(trans A R)->(per A R).

(* equiv is a partial equivalence relation over Prop *)

Goal (per Prop equiv).
Apply per_intro.
(*    subgoal   (sym Prop equiv) *)
Unfold sym ; Intros x y h.
(*    h : (equiv x y)
      y : Prop
      x : Prop
      subgoal (equiv y x) *)
Elim h ; Intros f1 f2.
(*    f2 : y->x
      f1 : x->y
      subgoal (equiv y x) *)
Apply equiv_intro.
(*    subgoal  y->x *)
Exact f2.
(*    Solves subgoal. Next subgoal:
      x->y *)
Exact f1.
(*    Solves subgoal. Next subgoal:
      (trans Prop equiv) *)
Unfold trans ; Intros x y z h1 h2.
(*    h2 : (equiv y z)
      h1 : (equiv x y)
      z : Prop
      y : Prop
      x : Prop
      subgoal (equiv x z) *)
Elim h2 ; Elim h1 ; Intros f1 f2 f3 f4.
(*    f4 : z->y
      f3 : y->z
      f2 : y->x
      f1 : x->y
      subgoal (equiv x z) *)
Apply equiv_intro ; Intro a.
(*    a : x
      subgoal z *)
Exact (f3 (f1 a)).
(*    Solves subgoal. Next subgoal:
      x *)
Exact (f2 (f4 a)).
(*    Solves subgoal. *)
Save per_equiv.

Section logical_relation.

Definition exp : (A:Type)(Rel A)->(B:Type)(Rel B)->(Rel (A->B)) = 
	[A:Type][R:(Rel A)][B:Type][S:(Rel B)][f,g:A->B]
	(x,y:A)(R x y)->(S (f x) (g y)).

Definition power : (A:Type)(Rel A)->(Rel (A->Prop)) = 
[A:Type][R:(Rel A)](exp A R Prop equiv).

End logical_relation.





Provide Log_Rel.
