(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

(* Arithmetic tests *)

Require Gt.

(* Pattern-matching lemmas for comparing 2 naturals 
   Similar to lemmas in Compare_prog *)

Lemma test : (n,m:nat){le n m}+{gt n m}.
Goal.
Induction n; Induction m; Simpl; Auto.
Intros m' H'; Elim (H m'); Auto.
Save.

Lemma le_lt : (n,m:nat)(le n m)->{lt n m}+{<nat>n=m}.
Goal.
Induction n; Induction m; Simpl; Auto.
Intros m' H1 H2; Elim (H m'); Auto.
Save.

Lemma compare : (n,m:nat){lt n m}+{<nat>n=m}+{gt n m}.
Goal.
Intros n m; Elim (test n m); Auto.
Left; Apply le_lt; Trivial.
Save.

Provide Test.
