(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

Require Test.

(* Lambda terms with de Bruijn's indexes *)

Inductive Set lambda =
    Ref : nat -> lambda
  | Abs : lambda -> lambda
  | App : lambda -> lambda -> lambda.


(* Lifting *)

(* Let lift_rec n N k = Match N with
    Ref(i)   -> if i<k then Ref(i) 
                       else Ref(n+i)
  | Abs(M)   -> Abs(lift_rec n M (k+1))
  | App(M,N) -> App(lift_rec n M k,lift_rec n N k). *)

Definition lift_rec : nat -> lambda -> nat -> lambda =
    [n:nat][P:lambda](<nat->lambda>Match P with
      (* (Ref i) *) [i,k:nat](<lambda>Match (test k i) with
                 (* k<=i *) [H:(le k i)] (Ref (plus n i))
                 (* k>i  *) [H:(gt k i)] (Ref i))
      (* (Abs M) *) [M:lambda][f:nat->lambda]
                    [k:nat](Abs (f (S k)))
      (* (App M N) *) [M:lambda][f:nat->lambda]
                      [N:lambda][g:nat->lambda]
                      [k:nat](App (f k) (g k))).

Definition lift = [n:nat][N:lambda](lift_rec n N O).


(* Substitution *)

(*
Let subst_rec N M k = Match M with
    Ref(i)   -> if k<i then Ref(i-1)
                if k=i then lift k N   
                if k>i then Ref(i) 
 |  Abs(P)   -> Abs(subst_rec N P (k+1))
 |  App(P,Q) -> App(subst_rec N P k, subst_rec N Q k).
*)

Definition subst_rec : lambda -> lambda -> nat -> lambda =
    [N,M:lambda](<nat->lambda>Match M with
      (* (Ref i) *) [i,k:nat](<lambda>Match (compare k i) with
           [C:{(gt i k)}+{<nat>k=i}](<lambda>Match C with
              (* k<i *) [H:(lt k i)](Ref (pred i))
              (* k=i *) [H:<nat>k=i](lift k N))
              (* k>i *) [H:(gt k i)] (Ref i))
      (* (Abs M) *) [M:lambda][f:nat->lambda]
                    [k:nat](Abs (f (S k)))
      (* (App M N) *) [M:lambda][f:nat->lambda]
                      [N:lambda][g:nat->lambda]
                      [k:nat](App (f k) (g k))).

Definition subst = [N,M:lambda](subst_rec N M O).

(* Examples
Variable P:lambda->Prop.
Goal (P (subst (Abs(Ref O)) (Abs (App (Ref O) (Ref (S O)))))).
Unfold subst; Simpl; Unfold lift; Simpl.
(* (P (Abs (App (Ref O) (Abs (Ref O))))) 
i.e. ([x][y](y x) [z]z) -> [y](y [z]z) *)

Goal (P (subst (Abs(Ref (S O))) (Abs (App (Ref (S O)) (Ref (S (S O))))))).
Unfold subst; Simpl; Unfold lift; Simpl.
(* (P (Abs (App (Abs (Ref (S (S O)))) (Ref (S O)))))
i.e. ([x][y](x u) [z]u) -> [y]([z]u u)
*)
*)

Provide Terms.
