(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

Require Redexes.
Require Test.

(****************************)
(*  Substitution of redexes *)
(****************************)

(* Lifting *)

Definition lift_rec_r : nat -> redexes -> nat -> redexes =
    [n:nat][P:redexes](<nat->redexes>Match P with
      (* (Var i) *) [i,k:nat](Var (<nat>Match (test k i) with
                 (* k<=i *) [H:(le k i)] (plus n i)
                 (* k>i  *) [H:(gt k i)] i))
      (* (Fun M) *) [M:redexes][f:nat->redexes]
                    [k:nat](Fun (f (S k)))
      (* (Ap b M N) *) [b:bool][M:redexes][f:nat->redexes]
                               [N:redexes][g:nat->redexes]
                               [k:nat](Ap b (f k) (g k))).

(* The two cases of lifting of a variable  *)

Lemma lift_le : (n,i,k:nat)(le k i)->
     <redexes>(lift_rec_r n (Var i) k) = (Var (plus n i)).
Goal.
Simpl.
Intros; Elim (test k i); Intro P; Trivial.
Absurd (gt k i); Trivial.
Apply le_not_gt; Trivial.
Save.

Lemma lift_gt : (n,i,k:nat)(gt k i)->
     <redexes>(lift_rec_r n (Var i) k) = (Var i).
Goal.
Simpl.
Intros; Elim (test k i); Intro P; Trivial.
Absurd (gt k i); Trivial.
Apply le_not_gt; Trivial.
Save.

Lemma lift1 : (U:redexes)(j,i,k:nat)<redexes>
     (lift_rec_r k (lift_rec_r j U i) (plus j i))=
     (lift_rec_r (plus j k) U i).
Goal.
Induction U; Simpl; Intros.
Intros; Elim (test i n); Simpl.
Elim (test (plus j i) (plus j n)); Simpl; Intros.
Elim plus_permute; Elim plus_assoc_l; Trivial.
Absurd (gt i n); Auto.
Apply simpl_gt_plus_l with j; Trivial.
Elim (test (plus j i) n); Simpl; Intros; Trivial.
Absurd (le i n); Auto.
Apply le_trans with (plus j i); Trivial.
Rewrite (plus_n_Sm j i); Elim H; Trivial.
Elim H; Elim H0; Trivial.
Save.

Lemma lift_lift_rec : (U:redexes)(k,p,n,i:nat)(le i n)-><redexes>
     (lift_rec_r k (lift_rec_r p U i) (plus p n))=
     (lift_rec_r p (lift_rec_r k U n) i).
Goal.
Induction U; Simpl; Intros.
2:Rewrite (plus_n_Sm p n); Rewrite H; Trivial.
2:Elim (plus_n_Sm k n); Auto.
2:Rewrite H; Trivial.
2:Rewrite H0; Trivial.
Elim (test n0 n); Elim (test i n); Simpl.
Elim (test (plus p n0) (plus p n)); Elim (test i (plus k n)); Simpl; Intros.
Rewrite plus_permute; Trivial.
Absurd (gt i n); Auto.
Apply gt_le_trans with (plus k n); Trivial.
Absurd  (gt n0 n); Auto.
Apply simpl_gt_plus_l with p; Trivial.
Absurd  (gt n0 n); Auto.
Apply simpl_gt_plus_l with p; Trivial.
Intros; Absurd (gt i n); Trivial.
Apply le_not_gt; Apply le_trans with n0; Trivial.
Intros; Elim (test (plus p n0) (plus p n)); Simpl; Intros; Trivial.
Absurd (gt n0 n); Trivial.
Apply le_not_gt; Apply simpl_le_plus_l with p; Trivial.
Intros; Elim (test (plus p n0) n); Simpl; Intros; Trivial.
Absurd (gt n0 n); Trivial.
Apply le_not_gt; Apply le_trans with (plus p n0); Trivial.
Save.

Definition lift_r = [n:nat][N:redexes](lift_rec_r n N O).

Lemma lift_lift : (U:redexes)(k,p,n:nat)<redexes>
     (lift_rec_r k (lift_r p U) (plus p n))=(lift_r p (lift_rec_r k U n)).
Goal.
Unfold lift_r; Intros; Apply lift_lift_rec; Trivial.
Save.

Lemma liftrecO : (U:redexes)(n:nat)<redexes>(lift_rec_r O U n)=U.
Goal.
Induction U; Simpl; Intros.
Elim (test n0 n); Trivial.
Rewrite H; Trivial.
Rewrite H; Rewrite H0; Trivial.
Save.

Lemma liftO : (U:redexes)<redexes>(lift_r O U)=U.
Goal.
Unfold lift_r; Intro U; Apply liftrecO.
Save.

Lemma lift_rec_lift_rec : (U:redexes)(n,p,k,i:nat)(le k (plus i n))->(le i k)-><redexes>
    (lift_rec_r p (lift_rec_r n U i) k)=(lift_rec_r (plus p n) U i).
Goal.
Induction U; Simpl; Intros.
2: Rewrite H; Trivial; Simpl; Apply le_n_S; Trivial.
2: Rewrite H; Trivial; Rewrite H0; Trivial.
Elim (test i n); Intro P.
Elim (test k (plus n0 n)); Intro Q.
Rewrite plus_assoc_r; Trivial.
Absurd (gt k (plus n0 n)); Trivial.
Apply le_not_gt; Apply le_trans with (plus i n0); Trivial.
Replace (plus i n0) with (plus n0 i); Auto; 
Apply le_reg_l; Trivial.
Elim (test k n); Intro Q; Trivial.
Absurd (gt i k).
Apply le_not_gt; Trivial.
Apply gt_le_trans with n; Trivial.
Save.

Lemma lift_rec_lift : (U:redexes)(n,p,k,i:nat)(le k n)-><redexes>
     (lift_rec_r p (lift_r n U) k)=(lift_r (plus p n) U).
Goal.
Unfold lift_r; Intros; Rewrite lift_rec_lift_rec; Trivial.
Save.


Definition subst_rec_r : redexes -> redexes -> nat -> redexes =
    [N,M:redexes](<nat->redexes>Match M with
      (* (Var i) *) [i,k:nat](<redexes>Match (compare k i) with
           [C:{(gt i k)}+{<nat>k=i}](<redexes>Match C with
              (* k<i *) [H:(lt k i)](Var (pred i))
              (* k=i *) [H:<nat>k=i](lift_r k N))
              (* k>i *) [H:(gt k i)] (Var i))
      (* (Fun M) *) [M:redexes][f:nat->redexes]
                    [k:nat](Fun (f (S k)))
      (* (Ap b M N) *) [b:bool][M:redexes][f:nat->redexes]
                               [N:redexes][g:nat->redexes]
                               [k:nat](Ap b (f k) (g k))).

(* The three cases of substitution of U for (Var n) *)

Lemma subst_eq : (U:redexes)(n:nat)<redexes>(subst_rec_r U (Var n) n) = (lift_r n U).
Goal.
Simpl.
Intros; Elim (compare n n); Intro P.
Elim P; Intro Q; Simpl; Trivial.
Absurd (gt n n); Trivial.
Absurd (gt n n); Trivial.
Save.

Lemma subst_gt : (U:redexes)(n,p:nat)(gt n p)-><redexes>(subst_rec_r U (Var n) p) = (Var (pred n)).
Goal.
Simpl.
Intros; Elim (compare p n); Intro P.
Elim P; Intro Q; Trivial.
Absurd (gt n p); Trivial; Rewrite Q; Trivial.
Absurd (gt n p); Auto.
Save.

Lemma subst_lt : (U:redexes)(n,p:nat)(gt p n)-><redexes>(subst_rec_r U (Var n) p) = (Var n).
Goal.
Simpl.
Intros; Elim (compare p n); Intro P; Trivial.
Absurd (gt p n); Trivial; Elim P; Intro Q; Auto.
Rewrite Q; Trivial.
Save.

(* Substitution lemma *)

Lemma lift_rec_subst_rec : (U,V:redexes)(k,p,n:nat)<redexes>
     (lift_rec_r k (subst_rec_r U V p) (plus p n))=
     (subst_rec_r (lift_rec_r k U n) (lift_rec_r k V (S (plus p n))) p).
Goal.
Induction V.
(* 2 Fun *) 
2: Simpl; Intros; Replace (S (plus p n)) with (plus (S p) n); Trivial.
2: Elim H; Trivial.
(* 3 Ap *)
2: Simpl; Intros; Elim H; Elim H0; Trivial.
(* 1 Var *)
Intros; Unfold subst_rec_r.
Elim (compare p n); Intro P.
(* 1.1  P : {(gt n p)}+{<nat>p=n} *)
Elim P; Intro P1.
(* 1.1.1 P1 : (gt n p) *)
Cut <nat>n=(S (pred n)).
2: Apply S_pred with p; Trivial.
Intro E; Elim (test (S (plus p n0)) n); Intro Q.
(* 1.1.1.1 Q : (le (S (plus p n0)) n) *)
Elim (compare p (plus k n)); Intro R.
(* 1.1.1.1.1 R : {(gt (plus k n) p)}+{<nat>p=(plus k n)} *)
Elim R; Intro R1; Simpl.
(* 1.1.1.1.1.1 R1 : (gt (plus k n) p) *)
Rewrite E; Simpl.
Elim (test (plus p n0) (pred n)); Intro S.
Elim (plus_n_Sm k (pred n)); Simpl; Trivial.
Absurd (gt (plus p n0) (pred n)); Trivial.
Apply le_not_gt; Apply le_S_n; Elim E; Trivial.
(* 1.1.1.1.1.2 R1 : <nat>p=(plus k n) *)
Absurd (gt n p); Trivial.
Apply le_not_gt; Rewrite R1; Trivial.
(* 1.1.1.1.2 R : (gt p (plus k n)) *)
Absurd (gt p n); Auto.
Apply gt_le_trans with (plus k n); Trivial.
(* 1.1.1.2 Q : (gt (S (plus p n0)) n) *)
Elim (compare p n); Intro R.
(* 1.1.1.2.1  R : {(gt n p)}+{<nat>p=n} *)
Elim R; Intro R1.
(* 1.1.1.2.1.1  R1 : (gt n p) *)
Elim (test (plus p n0) (pred n)); Intro C.
Absurd (gt (S (plus p n0)) n); Trivial.
Apply le_not_gt; Rewrite E; Auto.
Apply lift_gt; Trivial.
(* 1.1.1.2.1.2  R1 : <nat>p=n *)
Absurd (gt n p); Trivial.
Rewrite R1; Trivial.
(* 1.1.1.2.2  R : (gt p n) *)
Absurd (gt n p); Auto.
(* 1.1.2 P1 : <nat>p=n *)
Rewrite P1.
Elim (test (S (plus n n0)) n); Intro Q.
(* 1.1.2.1  Q : (le (S (plus n n0)) n) *)
Absurd (le (S (plus n n0)) n); Auto.
(* 1.1.2.2  Q : (gt (S (plus n n0)) n) *)
Elim (compare n n); Intro R.
(* 1.1.2.2.1  R : {(gt n n)}+{<nat>n=n} *)
Elim R; Intro R1.
(* 1.1.2.2.1.1  R1 : (gt n n) *)
Absurd (gt n n); Trivial.
(* 1.1.2.2.1.2  R1 : <nat>n=n *)
Apply lift_lift; Trivial.
(* 1.1.2.2.2  R : (gt n n) *)
Absurd (gt n n); Trivial.
(* 1.2  P : (gt p n) *)
Elim (test (S (plus p n0)) n); Intro Q.
(* 1.2.1  Q : (le (S (plus p n0)) n) *)
Absurd (gt n p); Auto.
Apply gt_le_trans with (plus p n0); Auto.
(* 1.2.2  Q : (gt (S (plus p n0)) n) *)
Elim (compare p n); Intro R.
(* 1.2.2.1  R : {(gt n p)}+{<nat>p=n} *)
Elim R; Intro R1.
(* 1.2.2.1.1 R1 : (gt n p) *)
Absurd (gt n p); Auto.
(* 1.2.2.1.2 R1 : <nat>p=n *)
Absurd (gt p n); Trivial.
Rewrite R1; Trivial.
(* 1.2.2.2 R : (gt p n) *)
Apply lift_gt.
Apply le_gt_trans with p; Trivial.
Save.


Definition subst_r = [N,M:redexes](subst_rec_r N M O).

Lemma lift_subst : (U,V:redexes)(k,n:nat)<redexes>(lift_rec_r k (subst_r U V) n)=
                 (subst_r (lift_rec_r k U n) (lift_rec_r k V (S n))).
Goal.
Unfold subst_r; Intros.
Replace (S n) with (S (plus O n)).
Elim lift_rec_subst_rec; Trivial.
Simpl; Trivial.
Save.


(* In the proof below, we would like to be able to use :
    (m,n,p:nat)(compare (plus m n) (plus m p))=(compare n p).
But not possible to state because types are not the same. *)

Lemma subst_rec_lift_rec1 : (U,V:redexes)(n,p,k:nat)(le k n)-><redexes>
       (subst_rec_r V (lift_rec_r p U k) (plus p n)) =
       (lift_rec_r p (subst_rec_r V U n) k).
Goal.
Induction U; Intros; Simpl.
2: Rewrite plus_n_Sm; Rewrite H; Trivial.
2: Apply le_n_S; Trivial.
2: Rewrite H; Trivial; Rewrite H0; Trivial.
Elim (test k n); Intro P.
(* 1 P : (le k n) *)
Elim (compare n0 n); Elim (compare (plus p n0) (plus p n)); Intros Q R.
(* 1.1  R : {(gt n n0)}+{<nat>n0=n}
        Q : {(gt (plus p n) (plus p n0))}+{<nat>(plus p n0)=(plus p n)} *)
Elim Q; Elim R; Intros R1 Q1.
Cut <nat>n=(S (pred n)).
2: Apply S_pred with n0; Trivial.
Intro E; Rewrite lift_le.
Rewrite E; Elim plus_n_Sm; Simpl; Trivial.
Apply le_trans with n0; Trivial.
Apply gt_S_le; Elim E; Trivial.
Absurd (gt n n0).
Rewrite R1; Trivial.
Apply simpl_gt_plus_l with p; Trivial.
Absurd (gt (plus p n) (plus p n0)); Auto.
Apply le_not_gt; Rewrite Q1; Trivial.
Rewrite lift_rec_lift; Trivial.
(* 1.2  R : {(gt n n0)}+{<nat>n0=n}
        Q : (gt (plus p n0) (plus p n)) *)
Absurd (gt n0 n).
Apply le_not_gt; Elim R; Intro S.
Apply gt_S_le; Apply gt_trans with n; Trivial. 
Rewrite S; Trivial.
Apply simpl_gt_plus_l with p; Trivial.
Elim Q; Intro S.
Absurd (gt n0 n); Trivial.
Apply gt_not_sym; Apply simpl_gt_plus_l with p; Trivial.
Absurd (gt n0 n); Trivial.
Apply le_not_gt; Replace n0 with n; Trivial.
Apply simpl_plus_l with p; Auto.
Rewrite lift_le; Trivial.
(* 2 P : (gt k n) *)
Elim (compare n0 n); Intro Q.
(* 2.1 Q : {(gt n n0)}+{<nat>n0=n} *)
Absurd (gt n0 n).
Apply le_not_gt; Elim Q; Intro R.
Apply gt_S_le; Apply gt_trans with n; Trivial.
Rewrite R; Trivial.
Apply le_gt_trans with k; Trivial.
(* 2.2 Q : (gt n0 n) *)
Elim (compare (plus p n0) n); Intro R.
Absurd (gt n0 n); Trivial.
Apply le_not_gt; Elim R; Intro S.
Apply le_trans with (plus p n0); Trivial.
Apply gt_S_le; Apply gt_trans with n; Trivial.
Elim S; Trivial.
Rewrite lift_gt; Trivial.
Save.

Lemma subst_rec_lift1 : (U,V:redexes)(n,p:nat)<redexes>
       (subst_rec_r V (lift_r p U) (plus p n)) =
       (lift_r p (subst_rec_r V U n)).
Goal.
Unfold lift_r; Intros; Rewrite subst_rec_lift_rec1; Trivial.
Save.


Lemma subst_rec_lift_rec : (U,V:redexes)(p,q,n:nat)(le q (plus p n)) -> (le n q) -> <redexes>
     (subst_rec_r V (lift_rec_r (S p) U n) q)=(lift_rec_r p U n).
Goal.
Induction U; Intros; Simpl.
2: Rewrite H; Trivial.
2: Elim plus_n_Sm; Simpl; Apply le_n_S; Trivial.
2: Apply le_n_S; Trivial.
2: Rewrite H; Trivial; Rewrite H0; Trivial.
Elim (test n0 n); Intro P.
(* 1  P : (le n0 n) *)
Elim (compare q (S (plus p n))); Intro Q.
(* 1.1  Q : {(gt (S (plus p n)) q)}+{<nat>q=(S (plus p n))} *)
Elim Q; Intro Q1; Simpl; Trivial.
(* 1.1.1  Q1 : <nat>q=(S (plus p n)) *)
Absurd (le q (plus p n0)); Trivial; Rewrite Q1; Auto.
(* 1.1.1  Q1 : (gt q (S (plus p n))) *)
Absurd (gt q (S (plus p n))); Trivial.
Apply le_not_gt; Apply le_trans with (plus p n); Trivial.
Apply le_trans with (plus p n0); Auto.
(* 2  P : (gt n0 n) *)
Elim (compare q n); Intro Q; Trivial.
(* 2.1 Q : {(gt n q)}+{<nat>q=n} *)
Elim Q; Intro Q1; Simpl; Trivial.
(* 2.1.1  Q1 : (gt n q) *)
Absurd (gt n0 q); Auto.
Apply gt_trans with n; Trivial.
Absurd (gt n0 q); Auto.
Rewrite Q1; Trivial.
Save.

Lemma subst_rec_lift : (U,V:redexes)(p,q:nat)(le q p) -> <redexes>
     (subst_rec_r V (lift_r (S p) U) q)=(lift_r p U).
Goal.
Unfold lift_r; Intros; Rewrite subst_rec_lift_rec; Trivial.
Elim plus_n_O; Trivial.
Save.

(* subst_rec_subst_rec *)

Lemma subst_rec_subst_rec : (U,V,W:redexes)(n,p:nat)<redexes>
       (subst_rec_r W (subst_rec_r U V p) (plus p n)) =
       (subst_rec_r (subst_rec_r W U n) (subst_rec_r W V (S (plus p n))) p).
Goal.
Induction V.
2: Simpl; Intros; Replace (S (plus p n)) with (plus (S p) n); Trivial.
2: Elim H; Trivial.
2: Simpl; Intros; Elim H; Elim H0; Trivial.
Unfold 2 5 subst_rec_r.
Intros n W i p; Elim (compare p n); Intro C.
(* 1.1  C : {(gt n p)}+{<nat>p=n} *)
Elim C; Intro D.
(* 1.1.1  D : (gt n p) *) 
Elim (compare (S (plus p i)) n); Intro P.
(* 1.1.1.1  P : {(gt n (S (plus p i)))}+{<nat>(S (plus p i))=n} *)
Elim P; Intro P1.
(* 1.1.1.1.1  P1 : (gt n (S (plus p i))) *)
Rewrite subst_gt.
Rewrite subst_gt; Auto.
Apply gt_pred; Apply gt_le_trans with (S (plus p i)); Auto.
(* 1.1.1.1.2  P1 : <nat>(S (plus p i))=n *)
Rewrite (subst_rec_lift W (subst_rec_r W U i) (plus p i) p (le_plus_l p i)).
Replace (pred n) with (plus p i).
Apply subst_eq.
Elim P1; Simpl; Trivial.
(* 1.1.1.1  P : (gt (S (plus p i)) n) *)
Rewrite subst_gt; Trivial.
Rewrite subst_lt; Trivial.
Apply gt_S_n; Replace (S (pred n)) with n; Trivial.
Apply S_pred with p; Trivial.
(* 1.1.2 D : <nat>p=n *)
Rewrite D; Elim (compare (S (plus n i)) n); Intro P.
(* 1.1.2.1  P : {(gt n (S (plus n i)))}+{<nat>(S (plus n i))=n} *)
Absurd (gt n (plus n i)); Auto.
Elim P; Intro Q.
Apply gt_trans with (S (plus n i)); Trivial.
Apply gt_S_n; Rewrite Q; Trivial.
(* 1.1.2.2  P : (gt (S (plus n i)) n) *)
Rewrite subst_eq.
Apply subst_rec_lift1.
(* 1.2  C : (gt p n) *)
Rewrite subst_lt.
Elim (compare (S (plus p i)) n); Intro P.
(* 1.2.1  P : {(gt n (S (plus p i)))}+{<nat>(S (plus p i))=n} *)
Absurd (gt p n); Trivial.
Apply gt_not_sym; Elim P; Intro Q.
Apply gt_trans with (S (plus p i)); Trivial.
Apply gt_le_trans with (plus p i); Trivial.
Elim Q.
Apply gt_le_trans with (plus p i); Trivial.
(* 1.2.2  P : (gt (S (plus p i)) n) *)
Rewrite subst_lt; Trivial.
Apply le_gt_trans with p; Trivial.
Save. 

Lemma subst_rec_subst_0 : (U,V,W:redexes)(n:nat)<redexes>
   (subst_rec_r W (subst_rec_r U V O) n) =
   (subst_rec_r (subst_rec_r W U n) (subst_rec_r W V (S n)) O).
Goal.
Intros; Pattern 1 3 n.
Replace n with (plus O n).
Rewrite (subst_rec_subst_rec U V W n O); Trivial.
Simpl; Trivial.
Save.

(**************************)
(* The Substitution Lemma *)
(**************************)

Lemma substitution : 
  (U,V,W:redexes)(n:nat)<redexes>(subst_rec_r W (subst_r U V) n) =
                         (subst_r (subst_rec_r W U n) (subst_rec_r W V (S n))).
Goal.
Unfold subst_r; Intros; Apply subst_rec_subst_0; Trivial.
Save.

(* Substitution preserves compatibility *)

Lemma lift_rec_preserve_comp : (U1,V1:redexes)(comp U1 V1) -> 
     (n,m:nat)(comp (lift_rec_r n U1 m) (lift_rec_r n V1 m)).
Goal.
Induction 1; Unfold lift_rec_r; Auto.
Save.

Lemma subst_rec_preserve_comp : 
     (U1,V1,U2,V2:redexes)(comp U1 V1) -> (comp U2 V2) -> 
     (n:nat)(comp (subst_rec_r U1 U2 n) (subst_rec_r V1 V2 n)).
Goal.
Induction 2; Simpl; Auto.
Intros n n0; Elim (compare n0 n); Trivial.
Induction a; Trivial.
Intro; Unfold lift_r; Apply lift_rec_preserve_comp; Trivial.
Save.

Lemma subst_preserve_comp : 
    (U1,V1,U2,V2:redexes)(comp U1 V1) -> (comp U2 V2) -> 
    (comp (subst_r U2 U1) (subst_r V2 V1)).
Goal.
Intros; Unfold subst_r; Apply subst_rec_preserve_comp; Trivial.
Save.

(* Substitution preserves regularity *)

Lemma lift_rec_preserve_regular : 
      (U:redexes)(regular U) -> (n,m:nat)(regular (lift_rec_r n U m)).
Goal.
Induction U; Unfold lift_rec_r; Simpl; Auto.
Induction b; Induction y; Try Contradiction.
Intros; Elim H2; Auto.
Intros; Elim H1; Auto.
Intros; Elim H2; Auto.
Intros; Elim H3; Auto.
Save.

Lemma subst_rec_preserve_regular : 
  (U,V:redexes)(regular U) -> (regular V) -> (n:nat)(regular (subst_rec_r U V n)).
Goal.
Induction V; Unfold subst_rec_r; Simpl; Auto.
Intros; Elim (compare n0 n).
Induction a; Simpl; Trivial.
Intros; Unfold lift_r; Apply lift_rec_preserve_regular; Trivial.
Simpl; Trivial.
Induction b; Induction y; Try Contradiction.
Intros; Elim H3; Auto.
Intros; Elim H2; Auto.
Intros; Elim H3; Auto.
Intros; Elim H4; Auto.
Save.

Lemma subst_preserve_regular : 
      (U,V:redexes)(regular U) -> (regular V) -> (regular (subst_r U V)).
Goal.
Unfold subst_r; Intros; Apply subst_rec_preserve_regular; Trivial.
Save.

Provide Substitution.
