(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

(* Reduction of a term by a set of redexes *)

Require Marks.
Require Substitution.

(* Commuting mark and subst *)

Lemma mark_lift_rec : (M:lambda)(n,k:nat)
      <redexes>(lift_rec_r n (mark M) k)=(mark (lift_rec n M k)).
Goal.
Induction M; Simpl; Intros.
Elim (test k n); Simpl; Intros; Trivial.
Elim H; Trivial.
Elim H; Elim H0; Trivial.
Save.

Lemma mark_lift : 
      (M:lambda)(n:nat)<redexes>(lift_r n (mark M))=(mark (lift n M)).
Goal.
Unfold lift; Unfold lift_r; Intros; Apply mark_lift_rec.
Save.

Lemma mark_subst_rec : (M,N:lambda)(n:nat)
      <redexes>(subst_rec_r (mark M) (mark N) n)=(mark (subst_rec M N n)).
Goal.
Induction N; Simpl; Intros.
Rewrite (mark_lift M n0).
Elim (compare n0 n); Intro H.
Elim H; Intro H'.
Simpl; Trivial.
Trivial.
Simpl; Trivial.
Elim H; Trivial.
Elim H; Elim H0; Trivial.
Save.

Lemma mark_subst : 
      (M,N:lambda)<redexes>(subst_r (mark M) (mark N))=(mark (subst M N)).
Goal.
Unfold subst; Unfold subst_r; Intros; Apply mark_subst_rec.
Save.

Require Reduction.
Require Residuals.

(* residuals simulates par_red1 *)

Lemma simulation : (M,M':lambda)(par_red1 M M')-><redexes>Ex([V:redexes]
                   (residuals (mark M) V (mark M'))).
Goal.
Induction 1; Simpl; Intros.
Elim H1; Intros V1 P1.
Elim H3; Intros V2 P2.
Exists (Ap true (Fun V1) V2).
Elim mark_subst; Auto.
Exists (Var n); Trivial.
Elim H1; Intros V1 P1.
Exists (Fun V1); Auto.
Elim H1; Intros V1 P1.
Elim H3; Intros V2 P2.
Exists (Ap false V1 V2); Auto.
Save.

(* Commuting unmark and subst *)

Lemma unmark_lift_rec : (U:redexes)(n,k:nat)
      <lambda>(lift_rec n (unmark U) k) = (unmark (lift_rec_r n U k)).
Goal.
Induction U; Simpl; Intros.
Elim (test k n); Trivial.
Elim H; Trivial.
Elim H; Elim H0; Trivial.
Save.

Lemma unmark_lift : (U:redexes)(n:nat)
      <lambda>(lift n (unmark U))=(unmark (lift_r n U)).
Goal.
Unfold lift; Unfold lift_r; Intros; Apply unmark_lift_rec.
Save.

Lemma unmark_subst_rec : (U,V:redexes)(n:nat)
      <lambda>(subst_rec (unmark U) (unmark V) n)=(unmark (subst_rec_r U V n)).
Goal.
Induction V; Simpl; Intros.
Rewrite (unmark_lift U n0).
Elim (compare n0 n); Intro H; Simpl; Trivial.
Elim H; Trivial.
Elim H; Trivial.
Elim H; Elim H0; Trivial.
Save.

Lemma unmark_subst : (U,V:redexes)
     <lambda>(subst (unmark U) (unmark V))=(unmark (subst_r U V)).
Goal.
Unfold subst; Unfold subst_r; Intros; Apply unmark_subst_rec.
Save.


Lemma completeness : 
     (U,V,W:redexes)(residuals U V W) -> (par_red1 (unmark U) (unmark W)).
Goal.
Induction 1; Simpl; Auto.
Intros; Elim unmark_subst; Auto.
Save.


(**************************************************)
(* Reduction of a lambda term by a set of redexes *)
(**************************************************)

Definition reduction = 
    [M:lambda][U:redexes][N:lambda](residuals (mark M) U (mark N)).

Lemma reduction_function : 
     (M,N,P:lambda)(U:redexes)(reduction M U N) -> (reduction M U P) ->
     <lambda>N=P.
Goal.
Unfold reduction; Intros; Cut (comp (mark N) (mark P)).
Intro; Rewrite (inverse N); Rewrite (inverse P); Apply comp_unmark_eq; Trivial.
Apply residuals_preserve_comp with (mark M) (mark M) U; Trivial.
Apply comp_refl.
Save.

Provide Simulation.
