(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

Require Substitution.

(*************************************************)
(* Parallel beta reduction with residual tracing *)
(*************************************************)

(* (residuals U V W) means W are residuals of redexes U by step V *)

Inductive Definition residuals : redexes -> redexes -> redexes -> Prop =
   Res_Var : (n:nat)(residuals (Var n) (Var n) (Var n))
 | Res_Fun : (U,V,W:redexes)(residuals U V W) -> 
                                (residuals (Fun U) (Fun V) (Fun W))
 | Res_Ap : (U1,V1,W1:redexes)(residuals U1 V1 W1) -> 
            (U2,V2,W2:redexes)(residuals U2 V2 W2) -> 
            (b:bool)(residuals (Ap b U1 U2) (Ap false V1 V2) (Ap b W1 W2))
 | Res_redex : (U1,V1,W1:redexes)(residuals U1 V1 W1) -> 
               (U2,V2,W2:redexes)(residuals U2 V2 W2) -> 
  (b:bool)(residuals (Ap b (Fun U1) U2) (Ap true (Fun V1) V2) (subst_r W2 W1)).


Hint Res_Var Res_Fun Res_Ap Res_redex.

(* Inversion principle for residuals *)
Definition Res = [U,V,W:redexes](<Prop>Match V with
 (* Var *) [n:nat]((<redexes>U=(Var n)) /\ (<redexes>W=(Var n)))
 (* Fun *) [V1:redexes][P1:Prop](<Prop>Match U with
             (* Var *) [m:nat]False
             (* Fun *) [U1:redexes][P1:Prop](<Prop>Match W with
                       (* Var *) [p:nat]False
                       (* Fun *) [W1:redexes][P1:Prop](residuals U1 V1 W1)
                       (* Ap  *) [b:bool][W1:redexes][P1:Prop][W2:redexes][P2:Prop]False)
             (* Ap  *) [bu:bool][U1:redexes][P1:Prop][U2:redexes][P2:Prop]False)
 (* Ap  *) [bv:bool][V1:redexes][P1:Prop][V2:redexes][P2:Prop]
      (<Prop>Match U with
             (* Var *) [m:nat]False
             (* Fun *) [U1:redexes][P1:Prop]False
             (* Ap  *) [bu:bool][U1:redexes][P1:Prop][U2:redexes][P2:Prop]
         (<Prop>Match bv with
     (* true *) (<Prop>Match V1 with
                       (* Var *) [p:nat]False
                       (* Fun *) [V1:redexes][P1:Prop]
                  (<Prop>Match U1 with
                  (* Var *) [m:nat]False
                  (* Fun *) [U1:redexes][P1:Prop]<redexes>Ex([W1:redexes]
             ((residuals U1 V1 W1) /\ <redexes>Ex([W2:redexes]((residuals U2 V2 W2) /\
                                      <redexes>W=(subst_r W2 W1)))))
                  (* Ap  *) [b:bool][U1:redexes][P1:Prop][U2:redexes][P2:Prop]False)
                       (* Ap  *) [b:bool][W1:redexes][P1:Prop][W2:redexes][P2:Prop]False)
     (* false *) (<Prop>Match W with
                  (* Var *) [p:nat]False
                  (* Fun *) [W1:redexes][P1:Prop]False
                  (* Ap  *) [bw:bool][W1:redexes][P1:Prop][W2:redexes][P2:Prop]
               ((<bool>bw=bu) /\ (residuals U1 V1 W1) /\ (residuals U2 V2 W2)))))).


Lemma res_Res : (U,V,W:redexes)(residuals U V W) -> (Res U V W).
Goal.
Induction 1; Simpl; Intros; Auto.
Exists W1; Split; Trivial.
Exists W2; Split; Trivial.
Save.
Hint res_Res.


(* residuals is a partial function *)
Lemma uni1 : (U,V,W:redexes)(residuals U V W) -> (W':redexes)(Res U V W') -> 
       <redexes>W'=W.
Goal.
Induction 1.
Induction W'; Simpl; Intros.
Elim H0; Induction 2; Trivial.
Elim H1; Induction 2; Trivial.
Elim H2; Induction 2; Trivial.
Induction W'; Simpl; Intros.
Elim H2.
Elim H1 with y; Auto.
Elim H4.
Induction W'; Simpl; Intros.
Elim H4.
Elim H5.
Elim H6; Induction 1; Induction 1; Intros.
Elim H1 with y; Auto.
Elim H3 with y0; Auto.
Induction 5.
Induction 1; Intros.
Elim H7; Intros.
Elim H8; Intros.
Elim H1 with x; Auto.
Elim H3 with x0; Auto.
Save. 

Lemma residuals_function : 
    (U,V,W:redexes)(residuals U V W) -> (W':redexes)(residuals U V W') ->
          <redexes>W'=W.
Goal.
Intros; Apply uni1 with U V; Auto.
Save.

(* Commutation theorem *)

Lemma residuals_lift_rec : (U1,U2,U3:redexes)
   (residuals U1 U2 U3) -> (k,n:nat)
   (residuals (lift_rec_r k U1 n) (lift_rec_r k U2 n) (lift_rec_r k U3 n)).
Goal.
Induction 1; Simpl; Intros; Auto.
Rewrite lift_subst; Auto.
Save.

Lemma residuals_lift : (U1,U2,U3:redexes)
   (residuals U1 U2 U3) -> (k:nat)
   (residuals (lift_r k U1) (lift_r k U2) (lift_r k U3)).
Goal.
Unfold lift_r; Intros; Apply residuals_lift_rec; Trivial.
Save.
Hint residuals_lift.

Lemma residuals_subst_rec : (U1,U2,U3,V1,V2,V3:redexes)
   (residuals U1 U2 U3) -> (residuals V1 V2 V3) -> (k:nat)
   (residuals (subst_rec_r V1 U1 k) (subst_rec_r V2 U2 k) (subst_rec_r V3 U3 k)).
Goal.
Induction 1; Simpl; Auto.
Intros n R k; Elim (compare k n); Auto.
Induction a; Auto.
Intros; Rewrite substitution; Auto.
Save.
Hint residuals_subst_rec.

(***************************)
(* The Commutation Theorem *)
(***************************)

Theorem commutation : (U1,U2,U3,V1,V2,V3:redexes)
   (residuals U1 U2 U3) -> (residuals V1 V2 V3) -> 
   (residuals (subst_r V1 U1) (subst_r V2 U2) (subst_r V3 U3)).
Goal.
Unfold subst_r; Auto.
Save.
Lemma residuals_comp : (U,V,W:redexes)(residuals U V W) -> (comp U V).
Goal.
Induction 1; Simpl; Auto.
Save.

Lemma preservation1 : (U,V,UV:redexes)(residuals U V UV) ->
                      (T:redexes)(Union U V T) -> (residuals T V UV).
Goal.
Induction 1; Induction T; Simpl; Try Contradiction.
Induction 1; Intros E E0; Rewrite E0; Trivial.
Induction 2; Contradiction.
Induction 3; Contradiction.
Auto.
Rewrite (max_false b).
Induction 3; Induction 2; Induction 2; Auto.
Intros b0 FT; Induction 3; Induction 2.
Cut (Union (Fun U1) (Fun V1) FT); Auto.
Elim FT; Simpl; Try Contradiction.
Auto.
Save.

Lemma preservation : (U,V,W,UV:redexes)(union U V W) ->
                     (residuals U V UV) -> (residuals W V UV).
Goal.
Intros; Apply preservation1 with U; Auto.
Save.

Lemma Res_preserve_comp : (W,U,UW:redexes)(Res U W UW) -> 
                            (V,VW:redexes)(Res V W VW) -> (comp UW VW).
Goal.
Induction W; Simpl.
(* 1: Var *)
Induction 1; Intros E1 E2; Induction 1; Intros E3 E4; Rewrite E2; Rewrite E4; Trivial.
(* 2: Fun *)
Induction U; Induction UW; Try Contradiction.
Induction V; Induction VW; Try Contradiction.
Intros; Apply Comp_Fun; Apply H with y0 y2; Auto.
(* 3: Ap *)
Induction b.
(* 3:1 Redex *)
Intros W1 HW1 W2 HW2; Induction U; Try Contradiction.
Intros bU U1 HU1 U2 HU2; Clear HU1 HU2.
Generalize HW1.
Elim W1; Try Contradiction.
Intros W' HW' H'; Clear HW'.
Generalize (H' U1). (* H'' *)
Elim U1; Try Contradiction.
Intros U' HU' H'' UW H; Clear HU'.
Induction V; Try Contradiction.
Intros bV V1 HV1 V2 HV2; Clear HV1 HV2.
Generalize [UW:redexes][R:(Res (Fun U') (Fun W') UW)](H'' UW R V1).
Elim V1; Try Contradiction.
Intros V' HV' H1; Clear HV'.
Elim H; Intros UW' C1; Elim C1; Intro R1; Induction 1; Intros UW2 C2; Elim C2; Intros R2 E1 VW.
Induction 1; Intros VW' C3; Elim C3; Intro R3; Induction 1; Intros VW2 C4; Elim C4; Intros R4 E2.
Rewrite E1; Rewrite E2; Apply subst_preserve_comp.
Cut (Comp (Fun UW') (Fun VW')); Trivial.
Apply comp_Comp; Auto.
Apply HW2 with U2 V2; Auto.
(* 3:2 No redex *)
Induction U; Induction UW; Try Contradiction.
Induction V; Induction VW; Try Contradiction.
Elim H5; Induction 2; Induction 5; Induction 2; Intros; Apply Comp_Ap.
Apply H with y1 y5; Auto.
Apply H0 with y2 y6; Auto.
Save.

Lemma residuals_preserve_comp : (U,V:redexes)(comp U V) ->
   (W,UW,VW:redexes)(residuals U W UW) -> (residuals V W VW) -> (comp UW VW).
Goal.
Intros; Apply Res_preserve_comp with W U V; Auto.
Save.

(* We take residuals only by regular redexes *)

Lemma residuals_regular : (U,V,W:redexes)(residuals U V W) -> (regular V).
Goal.
Induction 1; Simpl; Auto.
Save.

(* Conversely, residuals by compatible regular redexes always exist 
   (and are unique by residuals_function lemma above) *)

Lemma residuals_intro : (U,V:redexes)(comp U V) -> (regular V) ->
                        <redexes>Ex([W:redexes](residuals U V W)).
Goal.
Induction 1; Simpl.
Intro n; Exists (Var n); Trivial.
Intros U0 V0 C E O; Elim (E O); Intros W0 R; Exists (Fun W0); Auto.
Induction b2.
Generalize H1.
Elim H0; Try Contradiction.
Intros; Elim H7; Intros H8 H9; Elim (H6 H8); Intros FW0 R.
Cut (Res (Fun U0) (Fun V0) FW0); Auto.
Elim FW0; Simpl; Try Contradiction.
Intro W0; Intros; Elim (H3 H9); Intros W2 R2; Exists (subst_r W2 W0); Auto.
Induction 1; Intros O1 O2; Elim (H1 O1); Intro W1; Elim (H3 O2); Intro W2.
Intros; Exists (Ap b1 W1 W2); Auto.
Save.

(* Residuals preserve regularity *)

Lemma residuals_preserve_regular : 
      (U,V,W:redexes)(residuals U V W) -> (regular U) -> (regular W).
Goal.
Induction 1; Simpl; Auto.     
Induction b.
Generalize H1; Elim H0; Try Contradiction.
Intros; Elim H7; Split; Auto.
Induction 1; Split; Auto.
Induction b; Intros; Apply subst_preserve_regular; Elim H4; Auto.
Save.


Provide Residuals.

