(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

Require Terms.

(* Beta reduction *)
Inductive Definition red1 : lambda -> lambda -> Prop =
   beta :      (M,N:lambda)(red1 (App (Abs M) N) (subst N M))
 | abs_red :   (M,N:lambda)(red1 M N) -> (red1 (Abs M) (Abs N))
 | app_red_l : (M1,N1:lambda)(red1 M1 N1) ->
                  (M2:lambda)(red1 (App M1 M2) (App N1 M2))
 | app_red_r : (M2,N2:lambda)(red1 M2 N2) ->
                  (M1:lambda)(red1 (App M1 M2) (App M1 N2)).

(* Transitive closure of red1 *)
Inductive Definition red : lambda -> lambda -> Prop =
   one_step_red  : (M,N:lambda)(red1 M N) -> (red M N)
 | refl_red  : (M:lambda)(red M M)
 | trans_red : (M,N,P:lambda)(red M N) -> (red N P) -> (red M P).

Lemma red_abs : (M,M':lambda)(red M M') -> (red (Abs M) (Abs M')).
Goal.
Induction 1; Intros.
Apply one_step_red; Apply abs_red; Trivial.
Apply refl_red.
Apply trans_red with (Abs N); Trivial.
Save.

Lemma red_appl : (M,M':lambda)(red M M') ->
                 (N:lambda)(red (App M N) (App M' N)).
Goal.
Induction 1; Intros.
Apply one_step_red; Apply app_red_l; Trivial.
Apply refl_red.
Apply trans_red with (App N N0); Trivial.
Save.

Lemma red_appr : (M,M':lambda)(red M M') ->
                 (N:lambda)(red (App N M) (App N M')).
Goal.
Induction 1; Intros.
Apply one_step_red; Apply app_red_r; Trivial. 
Apply refl_red.
Apply trans_red with (App N0 N); Trivial.
Save.

Lemma red_app : (M,M',N,N':lambda)(red M M') -> (red N N') -> 
                                  (red (App M N) (App M' N')).
Goal.
Intros; Apply trans_red with (App M' N).
Apply red_appl; Trivial.
Apply red_appr; Trivial.
Save.

Lemma red_beta : 
  (M,M',N,N':lambda)(red M M') -> (red N N') -> 
                    (red (App (Abs M) N) (subst N' M')).
Goal.
Intros; Apply trans_red with (App (Abs M') N').
Apply red_app; Trivial.
Apply red_abs; Trivial.
Apply one_step_red; Apply beta.
Save.

(* Parallel beta reduction *)
Inductive Definition par_red1 : lambda -> lambda -> Prop =
   par_beta    : (M,M':lambda)(par_red1 M M') -> (N,N':lambda)(par_red1 N N') ->
                              (par_red1 (App (Abs M) N) (subst N' M'))
 | ref_par_red : (n:nat)(par_red1 (Ref n) (Ref n))
 | abs_par_red : (M,M':lambda)(par_red1 M M') -> (par_red1 (Abs M) (Abs M'))
 | app_par_red : (M,M':lambda)(par_red1 M M') -> (N,N':lambda)(par_red1 N N') ->
                              (par_red1 (App M N) (App M' N')).

Hint par_beta ref_par_red abs_par_red app_par_red.

Lemma refl_par_red1 : (M:lambda)(par_red1 M M).
Goal.
Induction M; Auto.
Save.

Hint refl_par_red1.

Lemma red1_par_red1 : (M,N:lambda)(red1 M N) -> (par_red1 M N).
Goal.
Induction 1; Auto.
Save.

(* Multi-step parallel beta reduction *)

Inductive Definition par_red : lambda -> lambda -> Prop =
   one_step_par_red : (M,N:lambda)(par_red1 M N) -> (par_red M N)
 | trans_par_red : (M,N,P:lambda)(par_red M N) -> (par_red N P) -> (par_red M P).


(* Equivalence between reduction and parallel reduction *)

Lemma red_par_red : (M,N:lambda)(red M N) -> (par_red M N).
Goal.
Induction 1; Intros.
Apply one_step_par_red; Apply red1_par_red1; Trivial.
Apply one_step_par_red; Auto.
Apply trans_par_red with N0; Trivial.
Save.

Lemma par_red_red : (M,N:lambda) (par_red M N) -> (red M N).
Goal.
Induction 1.
2:Intros; Apply trans_red with N0; Trivial.
Induction 1.
Intros; Apply red_beta; Trivial.
Intros; Apply refl_red.
Intros; Apply red_abs; Trivial.
Intros; Apply red_app; Trivial.
Save.

Provide Reduction.

