(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

(************************************)
(* Lambda terms with marked redexes *)
(************************************)

Inductive Set redexes =
    Var : nat -> redexes
  | Fun : redexes -> redexes
  | Ap  : bool -> redexes -> redexes -> redexes.

(* A redex is marked as (Ap true (Fun M) N) *)

(* The Boolean algebra of sets of redexes *)

Inductive Definition sub : redexes -> redexes -> Prop =
    Sub_Var : (n:nat)(sub (Var n) (Var n))
  | Sub_Fun : (U,V:redexes)(sub U V) -> (sub (Fun U) (Fun V))
  | Sub_Ap1 : (U1,V1:redexes)(sub U1 V1) -> (U2,V2:redexes)(sub U2 V2) -> 
                    (b:bool)(sub (Ap false U1 U2) (Ap b V1 V2))
  | Sub_Ap2 : (U1,V1:redexes)(sub U1 V1) -> (U2,V2:redexes)(sub U2 V2) -> 
                    (b:bool)(sub (Ap true U1 U2) (Ap true V1 V2)).

Definition Sub = [U:redexes](<redexes->Prop>Match U with
  (* Var *) [n:nat][V:redexes](<Prop>Match V with
    (* Var *) [n':nat]<nat>n=n'
    (* Fun *) [V1:redexes][Q:Prop]False
    (* Ap  *) [b':bool][V1:redexes][P':Prop]
                       [V2:redexes][Q':Prop]False)
  (* Fun *) [U1:redexes][P:redexes->Prop][V:redexes](<Prop>Match V with
    (* Var *) [n:nat]False
    (* Fun *) [V1:redexes][Q:Prop](sub U1 V1)
    (* Ap  *) [b':bool][V1:redexes][P':Prop]
                       [V2:redexes][Q':Prop]False)
  (* Ap  *) [b:bool][U1:redexes][P1:redexes->Prop]
                    [U2:redexes][P2:redexes->Prop]
                [V:redexes](<Prop>Match V with
    (* Var *) [n:nat]False
    (* Fun *) [U1:redexes][R:Prop]False
    (* Ap  *) [b':bool][V1:redexes][Q1:Prop][V2:redexes][Q2:Prop]
                (<Prop>Match b' with
        (* true *) ((sub U1 V1) /\ (sub U2 V2))
        (* false *) (<Prop>Match b with
            (* false *) False
        (* false *) ((sub U1 V1) /\ (sub U2 V2)))))).

Lemma sub_Sub : (U,V:redexes)(sub U V) -> (Sub U V).
Goal.
Induction 1; Simpl; Auto.
Induction b; Auto.
Save.
Hint sub_Sub.

Lemma not_sub_Var_Fun : (n:nat)(U:redexes)~(sub (Var n) (Fun U)).
Goal.
Unfold not; Intros; Cut (Sub (Var n) (Fun U)); Trivial.
Auto.
Save.

Lemma not_sub_Ap_Fun : (b:bool)(U,V,W:redexes)~(sub (Ap b U V) (Fun W)).
Goal.
Unfold not; Intros; Cut (Sub (Ap b U V) (Fun W)); Trivial.
Auto.
Save. 

Definition bool_max = [b,b':bool](<bool>Match b with true b').

Lemma max_false : (b:bool)<bool>(bool_max b false)=b.
Goal.
Induction b; Simpl; Trivial.
Save.

Inductive Definition union : redexes -> redexes -> redexes -> Prop =
    Union_Var : (n:nat)(union (Var n) (Var n) (Var n))
  | Union_Fun : (U,V,W:redexes)(union U V W) -> (union (Fun U) (Fun V) (Fun W))
  | Union_Ap : (U1,V1,W1:redexes)(union U1 V1 W1) -> 
               (U2,V2,W2:redexes)(union U2 V2 W2) -> 
       (b1,b2:bool)(union (Ap b1 U1 U2) (Ap b2 V1 V2) (Ap (bool_max b1 b2) W1 W2)).

Definition Union = [U:redexes](<redexes->redexes->Prop>Match U with
  (* Var *) [n:nat][V:redexes](<redexes->Prop>Match V with
    (* Var *) [n':nat][W:redexes]((<nat>n=n') /\ (<Prop>Match W with
      (* Var *) [n'':nat]<nat>n=n''
      (* Fun *) [V1:redexes][Q:Prop]False
      (* Ap  *) [b':bool][V1:redexes][P':Prop]
                         [V2:redexes][Q':Prop]False))
    (* Fun *) [V1:redexes][Q:redexes->Prop][W:redexes]False
    (* Ap  *) [b':bool][V1:redexes][P':redexes->Prop]
                       [V2:redexes][Q':redexes->Prop][W:redexes]False)
  (* Fun *) [U1:redexes][P:redexes->redexes->Prop][V:redexes]
                  (<redexes->Prop>Match V with
    (* Var *) [n:nat][W:redexes]False
    (* Fun *) [V1:redexes][Q:redexes->Prop][W:redexes](<Prop>Match W with
      (* Var *) [n:nat]False
      (* Fun *) [W1:redexes][R:Prop](union U1 V1 W1)
      (* Ap  *) [b':bool][W1:redexes][Q1:Prop][W2:redexes][Q2:Prop]False)
    (* Ap  *) [b':bool][V1:redexes][P':redexes->Prop]
                       [V2:redexes][Q':redexes->Prop][W:redexes]False)
  (* Ap  *) [b:bool][U1:redexes][P1:redexes->redexes->Prop]
                    [U2:redexes][P2:redexes->redexes->Prop]
                [V:redexes](<redexes->Prop>Match V with
    (* Var *) [n:nat][W:redexes]False
    (* Fun *) [V1:redexes][R:redexes->Prop][W:redexes]False
    (* Ap  *) [b':bool][V1:redexes][Q1:redexes->Prop]
              [V2:redexes][Q2:redexes->Prop][W:redexes](<Prop>Match W with
      (* Var *) [n:nat]False
      (* Fun *) [W1:redexes][R:Prop]False
      (* Ap  *) [b'':bool][W1:redexes][Q1:Prop][W2:redexes][Q2:Prop]
                (union U1 V1 W1) /\ (union U2 V2 W2) /\
                <bool>b''=(bool_max b b')))).

Lemma union_Union : (U,V,W:redexes)(union U V W) -> (Union U V W).
Goal.
Induction 1; Simpl; Auto.
Save.
Hint union_Union.

Lemma union_l : (U,V,W:redexes)(union U V W) -> (sub U W).
Goal.
Induction 1; Intros.
Apply Sub_Var.
Apply Sub_Fun; Trivial.
Elim b1.
Elim b2; Simpl; Apply Sub_Ap2; Trivial.
Elim b2; Simpl; Apply Sub_Ap1; Trivial.
Save.

Lemma union_r : (U,V,W:redexes)(union U V W) -> (sub V W).
Goal.
Induction 1; Intros.
Apply Sub_Var.
Apply Sub_Fun; Trivial.
Elim b2.
Elim b1; Simpl; Apply Sub_Ap2; Trivial.
Elim b1; Simpl; Apply Sub_Ap1; Trivial.
Save.

Lemma bool_max_Sym : (b,b':bool)<bool>(bool_max b b')=(bool_max b' b).
Goal.
Induction b; Induction b'; Simpl; Trivial.
Save.

Lemma union_sym : (U,V,W:redexes)(union U V W) -> (union V U W).
Goal.
Induction 1; Intros.
Apply Union_Var; Trivial.
Apply Union_Fun; Trivial.
Rewrite (bool_max_Sym b1 b2); Apply Union_Ap; Trivial.
Save.

(* Compatibility *)
(* (comp U V) iff <lambda>(unmark U)=(unmark V) *)

Inductive Definition comp : redexes -> redexes -> Prop =
    Comp_Var : (n:nat)(comp (Var n) (Var n))
  | Comp_Fun : (U,V:redexes)(comp U V) -> (comp (Fun U) (Fun V))
  | Comp_Ap : (U1,V1:redexes)(comp U1 V1) -> 
               (U2,V2:redexes)(comp U2 V2) -> 
       (b1,b2:bool)(comp (Ap b1 U1 U2) (Ap b2 V1 V2)).

Hint Comp_Var Comp_Fun Comp_Ap.

Definition Comp = [U:redexes](<redexes->Prop>Match U with
  (* Var *) [n:nat][V:redexes](<Prop>Match V with
    (* Var *) [n':nat]<nat>n=n'
    (* Fun *) [V1:redexes][Q:Prop]False
    (* Ap  *) [b':bool][V1:redexes][P':Prop]
                       [V2:redexes][Q':Prop]False)
  (* Fun *) [U1:redexes][P:redexes->Prop][V:redexes](<Prop>Match V with
    (* Var *) [n:nat]False
    (* Fun *) [V1:redexes][Q:Prop](comp U1 V1)
    (* Ap  *) [b':bool][V1:redexes][P':Prop]
                       [V2:redexes][Q':Prop]False)
  (* Ap  *) [b:bool][U1:redexes][P1:redexes->Prop]
                    [U2:redexes][P2:redexes->Prop]
                [V:redexes](<Prop>Match V with
    (* Var *) [n:nat]False
    (* Fun *) [U1:redexes][R:Prop]False
    (* Ap  *) [b':bool][V1:redexes][Q1:Prop][V2:redexes][Q2:Prop]
               ((comp U1 V1) /\ (comp U2 V2)))).

Lemma comp_Comp : (U,V:redexes)(comp U V) -> (Comp U V).
Goal.
Induction 1; Simpl; Auto.
Save.
Immediate comp_Comp.

Lemma not_comp_Var_Fun : (n:nat)(U:redexes)~(comp (Var n) (Fun U)).
Goal.
Unfold not; Intros; Cut (Comp (Var n) (Fun U)); Trivial.
Auto.
Save.

Lemma not_comp_Ap_Fun : (b:bool)(U,V,W:redexes)~(comp (Ap b U V) (Fun W)).
Goal.
Unfold not; Intros; Cut (Comp (Ap b U V) (Fun W)); Trivial.
Auto.
Save.

Lemma Comp_comp : (U,V:redexes)(Comp U V) -> (comp U V).
Goal.
Induction U; Induction V; Simpl; Auto; Try Contradiction.
Induction 1; Auto.
Induction 3; Auto.
Save.
Hint Comp_comp.

Lemma comp_refl : (U:redexes)(comp U U).
Goal.
Induction U; Auto.
Save.

Lemma comp_sym : (U,V:redexes)(comp U V) -> (comp V U).
Goal.
Induction 1; Auto.
Save.

Lemma comp_trans1 : 
      (U,V:redexes)(comp U V) -> (W:redexes)(Comp V W) -> (comp U W).
Goal.
Induction 1; Induction W; Simpl; Try Contradiction.
Induction 1; Auto.
Auto.
Induction 3; Auto.
Save.

Lemma comp_trans : 
      (U,V:redexes)(comp U V) -> (W:redexes)(comp V W) -> (comp U W).
Goal.
Intros; Apply comp_trans1 with V; Auto.
Save.


Lemma union_defined : 
      (U,V:redexes)(comp U V) -> <redexes>Ex([W:redexes](union U V W)).
Goal.
Induction 1.
Intro n; Exists (Var n); Apply Union_Var.
Induction 2; Intros W0 H2; Exists (Fun W0); Apply Union_Fun; Trivial.
Intros U1 V1 H1 E1 U2 V2 H2 E2; Elim E1; Elim E2.
Intros W2 A W1 B b1 b2; Exists (Ap (bool_max b1 b2) W1 W2). 
Apply Union_Ap; Trivial.
Save.


(* A element of type redexes is said to be regular if its true marks label
   redexes *)
(*
Let regular U = Match U with
     Var(n) -> True
   | Fun(V) -> regular(V)
   | Ap(true,V,W) -> (Match V with Fun(_) -> regular(V) /\ regular(W)
                                 | _ -> False)
   | Ap(false,V,W) -> regular(V) /\ regular(W).
*)

Definition regular = [U:redexes](<Prop>Match U with
  (* Var *) [n:nat]True
  (* Fun *) [U1:redexes][P:Prop]P
  (* Ap  *) [b:bool][V:redexes][P:Prop][W:redexes][Q:Prop](<Prop>Match b with
        (* true *) (<Prop>Match V with 
  (* Var *) [n:nat]False
  (* Fun *) [U1:redexes][R:Prop](P /\ Q)
  (* Ap  *) [b':bool][V':redexes][P':Prop][W':redexes][Q':Prop]False)
        (* false *) (P /\ Q))).


Lemma union_preserve_regular : 
    (U,V,W:redexes)(union U V W) -> (regular U) -> (regular V) -> (regular W).
Goal.
Induction 1; Simpl; Trivial.
Induction b1; Induction b2; Simpl.
Generalize H1.
Elim H0; Try Contradiction.
Intros; Elim H7; Elim H8; Auto.
Generalize H1.
Elim H0; Try Contradiction.
Intros; Elim H7; Elim H8; Auto.
Induction 1.
Generalize H1.
Elim H0; Try Contradiction.
Intros; Elim H10; Auto.
Induction 1; Intros O1 O2; Induction 1; Auto.
Save.


Provide Redexes.
