(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

Require Terms.
Require Redexes.

(* Translation from terms to redexes *)

Definition mark = [M:lambda](<redexes>Match M with
  (* Ref *) [n:nat](Var n)
  (* Abs *) [M:lambda][U:redexes](Fun U)
  (* App *) [M:lambda][U:redexes][N:lambda][V:redexes](Ap false U V)).

(* Reverse translation *)
Definition unmark = [U:redexes](<lambda>Match U with
  (* Var *) [n:nat](Ref n)
  (* Fun *) [U:redexes][M:lambda](Abs M)
  (* Ap  *) [b:bool][U:redexes][M:lambda][V:redexes][N:lambda](App M N)).

Lemma inverse : (M:lambda)<lambda>M=(unmark (mark M)).
Goal.
Induction M; Simpl; Trivial; Induction 1; Trivial.
Induction 1; Trivial.
Save.

Lemma comp_unmark_eq : (U,V:redexes)(comp U V) -> <lambda>(unmark U)=(unmark V).
Goal.
Induction 1; Simpl; Trivial.
Induction 2; Trivial.
Induction 2; Induction 2; Trivial.
Save.

(* The converse is true, but not needed in the following *)

Provide Marks.
