(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)

Require Residuals.

(*****************)
(* Prism Theorem *)
(*****************)

(* Auxiliary notion : compat 
   Used to generate the right simultaneous induction on U, V and W *)

(* (compat U V W) iff U,V,W are compatible markings, and (sub V U) *)
Inductive Definition compat : redexes -> redexes -> redexes -> Prop =
    Compat_Var : (n:nat)(compat (Var n) (Var n) (Var n))
  | Compat_Fun : (U,V,W:redexes)(compat U V W) -> (compat (Fun U) (Fun V) (Fun W))
  | Compat_Ap1 : (U1,V1,W1:redexes)(compat U1 V1 W1) -> 
        (U2,V2,W2:redexes)(compat U2 V2 W2) -> (b:bool) 
      (compat (Ap false U1 U2) (Ap false V1 V2) (Ap b W1 W2))
  | Compat_Ap2 : (U1,V1,W1:redexes)(compat U1 V1 W1) -> 
        (U2,V2,W2:redexes)(compat U2 V2 W2) -> (b,b':bool)
      (compat (Ap true (Fun U1) U2) (Ap b (Fun V1) V2) (Ap b' (Fun W1) W2)).


Lemma prism0 : (U,V,W:redexes)(compat U V W) -> (UV:redexes)(Res U V UV) ->
               (WU,WV:redexes)(Res W U WU) -> (Res W V WV) -> 
                              (residuals WV UV WU).
Goal.
Induction 1; Simpl.
(* 1 compat_Var *)
Induction 1; Intros A E1; Induction 1; Intros B E2; Induction 1; Intros C E3.
Rewrite E1; Rewrite E2; Rewrite E3; Trivial.
(* 2 compat_Fun *)
Induction UV; Try Contradiction.
Induction WU; Try Contradiction.
Induction WV; Try Contradiction.
Auto.
(* 3 compat_Ap1 *)
Induction UV; Try Contradiction.
Induction 3; Intros E C; Elim C; Intros C1 C2; Rewrite E.
Induction WU; Try Contradiction.
Induction WV; Try Contradiction.
Induction 3; Intros E1 D; Elim D; Intros D1 D2; Rewrite E1.
Induction 1; Intros E2 F; Elim F; Intros F1 F2; Rewrite E2; Auto.
(* 4 compat_Ap2 *)
Induction b.
(* 4-1 b=true *)
Induction 2; Intros W'1 C1; Elim C1.
Induction 2; Intros W'2 C2; Elim C2; Intros R1 E1; Rewrite E1.
Induction 1; Intros WU1 C3; Elim C3.
Induction 2; Intros WU2 C4; Elim C4; Intros R2 E2; Rewrite E2.
Induction 1; Intros WV1 C5; Elim C5.
Induction 2; Intros WV2 C6; Elim C6; Intros R3 E3; Rewrite E3.
Apply commutation; Auto.
(* 4-2 b=false *)
Induction UV; Try Contradiction.
Induction 3; Intros E C; Elim C; Intros C1 C2; Rewrite E.
Induction 1; Intros WU1 C3; Elim C3.
Induction 2; Intros WU2 C4; Elim C4; Intros R1 E1; Rewrite E1.
Elim WV; Try Contradiction.
Induction 3; Intros E2 C5; Elim C5; Intros R2 R3.
Cut (Res (Fun U1) (Fun V1) y); Auto.
Elim y; Simpl; Try Contradiction.
Cut (Res (Fun W1) (Fun V1) y1); Auto.
Elim y1; Simpl; Try Contradiction.
Auto.
Save.


(* Auxiliary for compat_decomposition proof below *)
Lemma compat_inv_Fun : 
      (U,V,W:redexes)(compat (Fun U) (Fun V) (Fun W)) -> (compat U V W).
Goal.
Local Compat_inv_Fun = [U:redexes](<redexes->redexes->Prop>Match U with
  (* Var *) [n:nat][V:redexes][W:redexes]True
  (* Fun *) [U1:redexes][P:redexes->redexes->Prop][V:redexes]
                  (<redexes->Prop>Match V with
    (* Var *) [n:nat][W:redexes]True
    (* Fun *) [V1:redexes][Q:redexes->Prop][W:redexes](<Prop>Match W with
      (* Var *) [n:nat]True
      (* Fun *) [W1:redexes][R:Prop](compat U1 V1 W1)
      (* Ap  *) [b':bool][W1:redexes][Q1:Prop][W2:redexes][Q2:Prop]True)
    (* Ap  *) [b':bool][V1:redexes][P':redexes->Prop]
                       [V2:redexes][Q':redexes->Prop][W:redexes]True)
  (* Ap  *) [b:bool][U1:redexes][P1:redexes->redexes->Prop]
                    [U2:redexes][P2:redexes->redexes->Prop]
                [V:redexes][W:redexes]True).
Intros U V W C; Cut (Compat_inv_Fun (Fun U) (Fun V) (Fun W)).
Simpl; Trivial.
Elim C; Simpl; Auto.
Save.

(* La preuve du lemme suivant serait plus simple si Sub et Comp
   recurraient independamment de sub et comp : plus besoin des lemmes
   not_sub_Var_Fun, not_sub_Ap_Fun, not_comp_Var_Fun, not_comp_Ap_Fun *)

Lemma compat_decomposition : 
(U,V,W:redexes)(regular U) -> (Sub V U) -> (Comp W V) -> (compat U V W).
Goal.
Induction U; Induction V; Simpl; Induction W; Simpl; Try Contradiction.
(* 1. Var *)
Intros n1 T E0 E1; Elim E0; Rewrite E1; Apply Compat_Var.
(* 2. Fun *)
Intros; Apply Compat_Fun; Auto.
(* 3. Ap *)
Elim b.
(* 3.1 U redex *)
Intros b1 y3 H3 y4 H4.
Generalize (H y1 y3).
Elim y; Simpl; Try Contradiction.
Elim y1.
Induction 4; Intro; Absurd (sub (Var n) (Fun y5)); Trivial.
Apply not_sub_Var_Fun.
2: Induction 6; Intro; Absurd (sub (Ap b2 y5 y6) (Fun y7)); Trivial.
2: Apply not_sub_Ap_Fun. 
Elim y3.
Induction 6; Intro; Absurd (comp (Var n) (Fun y5)); Trivial.
Apply not_comp_Var_Fun.
2: Induction 8; Intro; Absurd (comp (Ap b2 y5 y6) (Fun y7)); Trivial.
2: Apply not_comp_Ap_Fun. 
Intros; Elim H9; Elim H10; Elim H11; Intros; Apply Compat_Ap2; Auto.
Apply compat_inv_Fun; Auto.
(* 3.2 U not a redex *)
Elim b0; Try Contradiction.
Intros; Elim H5; Elim H6; Elim H7; Intros; Apply Compat_Ap1; Auto.
Save.

Lemma compat_intro : (U,V:redexes)(sub V U) -> 
   (W,WU,WV:redexes)(residuals W U WU) -> (residuals W V WV) -> (compat U V W).
Goal.
Intros; Apply compat_decomposition; Auto.
Apply residuals_regular with W WU; Trivial.
Apply comp_Comp; Apply residuals_comp with WV; Trivial.
Save.


(*****************************************************************)
(* Theorem prism : (U,V,W:redexes)(sub V U) ->                   *)
(*     (UV:redexes)(residuals U V UV) ->                         *)
(*     (WV:redexes)(residuals W V WV) ->                         *)
(*     (WU:redexes)(residuals W U WU) <-> (residuals WV UV WU).  *)
(*****************************************************************)

Lemma prism1 : (U,V,W:redexes)(sub V U) -> (UV:redexes)(residuals U V UV) ->
     (WV:redexes)(residuals W V WV) -> 
     (WU:redexes)(residuals W U WU) -> (residuals WV UV WU).
Goal.
Intros; Apply prism0 with U V W; Auto.
Apply compat_intro with WU WV; Trivial.
Save.

(* Converse of prism1 but needs regularity of U *)
Lemma prism2 : 
      (U,V,W:redexes)(sub V U) -> (regular U) -> 
      (UV:redexes)(residuals U V UV) ->
      (WV:redexes)(residuals W V WV) -> 
      (WU:redexes)(residuals WV UV WU) -> (residuals W U WU).
Goal.
Intros.
Elim (residuals_intro W U); Trivial.
Intros WU' R; Elim (residuals_function WV UV WU) with WU'; Trivial.
Apply prism1 with U V W; Trivial.
Apply comp_trans with V.
Apply residuals_comp with WV; Trivial.
Apply comp_sym; Apply residuals_comp with UV; Trivial.
Save.

Theorem prism : (U,V,W:redexes)(sub V U) -> 
                (UV:redexes)(residuals U V UV) ->
                (WV:redexes)(residuals W V WV) -> 
   ((WU:redexes)(residuals W U WU) <-> (regular U) /\ (residuals WV UV WU)).
Goal.
Intros; Unfold iff; Split.
Intro; Split.
Apply residuals_regular with W WU; Trivial.
Apply prism1 with U V W; Trivial.
Induction 1; Intros; Apply prism2 with V UV WV; Trivial.
Save.

(**************************************************************************)
(*  Levy's cube lemma :                                                   *)
(*  (U,V,UV,VU:redexes)  (residuals U V UV) -> (residuals V U VU) ->      *)
(*  (W,WU,WV,WUV:redexes)(residuals W U WU) -> (residuals WU VU WUV) ->   *)
(*                       (residuals W V WV) -> (residuals WV UV WUV).     *)
(**************************************************************************)


Lemma cube :
  (U,V,UV,VU:redexes)  (residuals U V UV) -> (residuals V U VU) ->
  (W,WU,WV,WUV:redexes)(residuals W U WU) -> (residuals WU VU WUV) ->
                       (residuals W V WV) -> (residuals WV UV WUV).
Goal.
Intros.
Cut (comp U V).
2: Apply residuals_comp with UV; Trivial.
Intro C; Elim (union_defined U V C); Intros T UVT.
Apply prism1 with T V W; Trivial.
Apply union_r with U; Trivial.
Apply preservation with U; Trivial.
Apply prism2 with U VU WU; Trivial.
Apply union_l with V; Trivial.
Apply union_preserve_regular with U V; Trivial.
Apply residuals_regular with V VU; Trivial.
Apply residuals_regular with U UV; Trivial.
Apply preservation with V; Trivial.
Apply union_sym; Trivial.
Save.


(* 3-dimensional paving diagram *)
Lemma paving : 
  (U,V,W,WU,WV:redexes)(residuals W U WU) -> (residuals W V WV) ->
  <redexes>Ex([UV:redexes]<redexes>Ex([VU:redexes]<redexes>Ex([WUV:redexes]
           ((residuals WU VU WUV) /\ (residuals WV UV WUV))))).
Goal.
Intros; Elim (residuals_intro U V).
Intros UV R1; Exists UV.
Elim (residuals_intro V U).
Intros VU R2; Exists VU.
Elim (residuals_intro WU VU).
Intros WUV R3; Exists WUV.
Split; Trivial.
Apply cube with U V VU W WU; Trivial.
Apply residuals_preserve_comp with W V U; Trivial.
Apply residuals_comp with WV; Trivial.
Apply residuals_preserve_regular with V U; Trivial.
Apply residuals_regular with U UV; Trivial.
Apply comp_sym; Apply residuals_comp with UV; Trivial.
Apply residuals_regular with W WU; Trivial.
Apply comp_trans with W.
Apply comp_sym; Apply residuals_comp with WU; Trivial.
Apply residuals_comp with WV; Trivial.
Apply residuals_regular with W WV; Trivial.
Save.

Provide Cube.
