Require Reduction.

Inductive Definition conv1 : lambda -> lambda -> Prop =
   red1_conv  : (M,N:lambda)(red1 M N) -> (conv1 M N)
 | exp1_conv  : (M,N:lambda)(red1 N M) -> (conv1 M N).

(* Beta conversion *)
Inductive Definition conv : lambda -> lambda -> Prop =
   one_step_conv  : (M,N:lambda)(conv1 M N) -> (conv M N)
 | refl_conv  : (M:lambda)(conv M M)
 | trans_conv : (M,N,P:lambda)(conv M N) -> (conv N P) -> (conv M P).

Lemma sym_conv : (M,N:lambda)(conv M N) -> (conv N M).
Goal.
Induction 1.
Induction 1; Intros; Apply one_step_conv.
Apply exp1_conv; Trivial.
Apply red1_conv; Trivial.
Intro; Apply refl_conv; Trivial.
Intros; Apply trans_conv with N0; Trivial.
Save.

Require Confluence.

Theorem Church_Rosser : (M,N:lambda)(conv M N) ->
        <lambda>Ex([P:lambda](red M P) /\ (red N P)).
Goal.
Induction 1.
Induction 1; Intros.
Exists N1; Split; [Apply one_step_red; Trivial | Apply refl_red; Trivial].
Exists M1; Split; [Apply refl_red; Trivial | Apply one_step_red; Trivial].
Intro M0; Exists M0; Split; Apply refl_red; Trivial.
Intros; Elim H1; Intros P0 C0; Elim H3; Intros P1 C1; Elim C0; Elim C1; Intros.
Elim confluence_beta_reduction with N0 P0 P1; Trivial.
Intros Q C3; Exists Q; Elim C3; Split.
Apply trans_red with P0; Trivial.
Apply trans_red with P1; Trivial.
Save.

Provide Conversion.
