(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*      A Formal Theory of beta-reduction in pure lambda-calculus            *)
(*                                                                           *)
(*      Gerard Huet                                                          *)
(*                                                                           *)
(*      January 1993                                                         *)
(*                                                                           *)
(*****************************************************************************)


(* Confluence *)

Definition confluence [A:Set][R:A->A->Prop]
    (x,y:A)(R x y) -> (z:A)(R x z) -> <A>Ex([u:A] (R y u) /\ (R z u)).

Require Reduction.

Lemma lemma1 : (confluence lambda par_red) -> (confluence lambda red).
Goal.
Unfold all confluence; Intros.
Cut <lambda>Ex([u:lambda] (par_red y u) /\ (par_red z u)).
Induction 1.
Intros u C; Exists u; Elim C; Intros; Split; Apply par_red_red; Trivial.
Apply H with x; Apply red_par_red; Trivial.
Save.


(* Strip lemmas *)

Definition strip = (x,y:lambda)(par_red x y) ->
                     (z:lambda)(par_red1 x z) -> 
          <lambda>Ex([u:lambda](par_red1 y u) /\ (par_red z u)).

Lemma strip_lemma_r : (confluence lambda par_red1) -> strip.
Goal.
Unfold strip; Induction 2; Intros.
Elim H with M N z; Trivial.
Intros u C; Exists u; Elim C; Intros; Split; Trivial.
Apply one_step_par_red; Trivial.
Elim (H2 z H5); Intros.
Elim H6; Intros.
Elim (H4 x0 H7); Intros.
Elim H9; Intros.
Exists x1; Split; Trivial.
Apply trans_par_red with x0; Trivial.
Save.

Lemma strip_lemma_l : strip -> (confluence lambda par_red).
Goal.
Unfold confluence; Induction 2; Intros.
Elim (H M z H2 N H1).
Intros u C; Exists u; Elim C; Intros; Split; Trivial.
Apply one_step_par_red; Trivial.
Elim (H2 z H5); Intros.
Elim H6; Intros.
Elim (H4 x0 H7); Intros.
Elim H9; Intros.
Exists x1; Split; Trivial.
Apply trans_par_red with x0; Trivial.
Save.

Lemma lemma2 : (confluence lambda par_red1) -> (confluence lambda par_red).
Goal.
Intro C; Unfold confluence; Intros.
Apply (strip_lemma_l (strip_lemma_r C) x); Trivial.
Save.

Require Cube.
Require Simulation.

(***************************************)
(* Parallel moves lemma and confluence *)
(***************************************)

Lemma parallel_moves : (confluence lambda par_red1).
Goal.
Red; Intros M N R1 P R2.
Elim (simulation M N); Trivial.
Elim (simulation M P); Trivial.
Intros V RV U RU.  
Elim (paving U V (mark M) (mark N) (mark P)); Trivial.
Intros UV C1; Elim C1.
Intros VU C2; Elim C2.
Intros UVW C3; Elim C3; Intros P1 P2.
Exists (unmark UVW); Split.
Rewrite (inverse N).
Apply completeness with VU; Trivial.
Rewrite (inverse P).
Apply completeness with UV; Trivial.
Save.

Lemma confluence_parallel_reduction : (confluence lambda par_red).
Goal.
Apply lemma2; Exact parallel_moves.
Save.

Theorem confluence_beta_reduction : (confluence lambda red).
Goal.
Apply lemma1; Exact confluence_parallel_reduction.
Save.

Provide Confluence.

