(****************************************************************************)
(*              The Calculus of Inductive Constructions                     *)
(*                                                                          *)
(*                            Projet Coq                                    *)
(*                                                                          *)
(*                  INRIA                        ENS                        *)
(*           Rocquencourt                        Lyon                       *)
(*                                                                          *)
(*                              Coq V5.8                                    *)
(*                            Jan 1st 1993                                  *)
(****************************************************************************)
(*                         Higman_extractor.v                               *)
(****************************************************************************)
(*                                                                          *)
(*                    Higman's lemma proof extractor                        *)
(*                                                                          *)
(*   This vernacular file creates an lml program from the impredicative     *)
(*      classical A-translated Nash-Williams proof of Higman' lemma         *)
(*                 for an alphabet of two letters                           *)
(*                                                                          *)
(*                     H. Herbelin / B. Werner                              *)
(*                                                                          *)
(****************************************************************************)
(*                                                                          *)
(*  It needs the existence of the file Higman.v where is written the        *)
(*  vernacular source of this Coq proof of Higman's lemma                   *)
(*  and creates a lml file Higman.m                                         *)
(*                                                                          *)
(****************************************************************************)

Reset Initial.

Begin Silent.
Load Higman.
End Silent.

Fml.

(*  Enter this at hand :
Reset All.
Realize lneM_rec [p,y,y0]p.
Extract.
Write Higman File Higman.
Drop.
*)
