(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*           Tarski's Theorem with theorem proving facilities                *)
(*                                                                           *)
(*****************************************************************************)


Set A.

Variable R:A->A->Prop.

Variable Eq:A->A->Prop.

Axiom Assym.
   Variable x,y:A.
Assumes (R x y) -> (R y x) -> (Eq x y).

Axiom Trans.
   Variable x,y,z:A.
Assumes (R x y) -> (R y z) -> (R x z).

Variable f:A->A.

Axiom Incr.
   Variable x,y:A.
Assumes (R x y) -> (R (f x) (f y)).

Variable M:A.

Hypothesis Up.
   Variable x:A.
Assumes (R x (f x)) -> (R x M).

Hypothesis Least.
   Variable x:A.
Assumes ((y:A)(R y (f y))->(R y x))->(R M x).

Goal (Eq M (f M)).
Cut (R M (f M)).
Intro.
Apply Assym; Trivial.
Apply Up.
Apply Incr; Trivial.
Apply Least.
Intros.
Apply Trans with (f y); Trivial.
Apply Incr.
Apply Up; Trivial.
Save Tarski_lemma.

Provide Tarski1.
