(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                 Tarski's Theorem in Basic Vernacular                      *)
(*                                                                           *)
(*****************************************************************************)

Parameter A:Set.

Parameter R:A->A->Prop.

Parameter Eq:A->A->Prop.

Axiom Assym.
Assumes (x:A)(y:A)((R x y) -> (R y x) -> (Eq x y)).

Axiom Trans.
Assumes (x:A)(y:A)(z:A)((R x y) -> (R y z) -> (R x z)).

Parameter f:A->A.

Axiom Incr.
Assumes (x:A)(y:A)((R x y) -> (R (f x) (f y))).

Definition Lub.
Body [m:A][S:A->Prop](and ((x:A) ((S x) -> (R x m))) 
                          ((y:A)  (((x:A) ((S x)->(R x y))) -> (R m y)))).

Axiom Complete.

Assumes (S:A->Prop)(<A> Ex ([x:A] (Lub x S))).
 
Theorem Tarski.

Statement <A> Ex ([x:A](Eq x (f x))).

   Local Under.
   Body [x:A](R x (f x)).

   Remark Exist_lub_under.
   Statement <A> Ex ([m:A] (Lub m Under)).
   Proof (Complete Under).

   Remark Tarski1.
 
   Statement ((M:A) ((Lub M Under) -> <A> Ex  ([m:A] (Eq m (f m))))).

      Variable M:A.

      Hypothesis LeastUp.
      Assumes (Lub M Under).

      Remark Up. 
      Statement (x:A) ((R x (f x)) -> (R x M)).
      Proof (proj1 ((x:A) ((R x (f x)) -> (R x M)))
                   ((x:A)(((y:A)(R y (f y))->(R y x))->(R M x)))
                   LeastUp).

      Remark Least.
      Statement (x:A)(((y:A)(R y (f y))->(R y x))->(R M x)).
      Proof (proj2 ((x:A) ((R x (f x)) -> (R x M)))
                   ((x:A)(((y:A)(R y (f y))->(R y x))->(R M x)))
                   LeastUp).


      Remark One.
   
      Statement (y:A)(Under y)->(R y (f M)).

         Variable y:A.

         Hypothesis v.
         Assumes (Under y).
      
         Remark T.
         Statement (R y M).
         Proof (Up y v).

         Remark T'.
         Statement (R (f y) (f M)).
         Proof (Incr y M T).

      Proof (Trans y (f y) (f M) v T').

      Remark Two.
      Statement (R M (f M)).
      Proof (Least (f M) One).

      Remark Three.
      Statement (R (f M) (f (f M))).
      Proof (Incr M (f M) Two).

      Remark Four.
      Statement (R (f M) M).
      Proof (Up (f M) Three).

      Remark Five.
      Statement (Eq M (f M)).
      Proof (Assym M (f M) Two Four).

   Proof (ex_intro A ([m:A] (Eq m (f m))) M Five).


Proof (ex_ind A ([M:A](Lub M Under)) (<A>Ex([x:A](Eq x (f x))))
              Tarski1 Exist_lub_under).

Provide Tarski.
