(* A few demos of Coq V5.8 - continued - G. Huet, July 1993 *)

Require Demo.

Lemma plus_swap : (n,m,p:nat)<nat>(plus n (plus m p))=(plus m (plus n p)).
Goal.
Intros n m p; Rewrite plus_assoc.
Rewrite plus_assoc.
Replace (plus n m) with (plus m n); Auto.
Save.

Lemma multO : (n:nat)<nat>(mult n O)=O.
Goal.
Induction n; Simpl; Auto.
Save.
Hint multO.

Lemma multS : (n,m:nat)<nat>(mult n (S m))=(plus n (mult n m)).
Goal.
Induction n; Simpl; Auto.
Intros m E p.
Rewrite E.
Rewrite plus_swap; Trivial.
Save.

Lemma mult_sym : (n,m:nat)<nat>(mult n m)=(mult m n).
Goal.
Induction n; Induction m; Simpl; Auto.
Intros p E.
Rewrite (H (S p)); Simpl.
Rewrite multS.
Rewrite plus_swap; Trivial.
Save.

Lemma plus_morph_l : (n,m,p:nat)(<nat>m=p)->(<nat>(plus n m)=(plus n p)).
Goal.
Induction 1; Trivial.
Save.

Lemma distr_l : (n,m,p:nat)<nat>
   (mult (plus n m) p) = (plus (mult n p) (mult m p)).
Goal.
Induction n; Simpl; Auto.
Intros; Rewrite assoc_plus.
Apply plus_morph_l; Trivial.
Save.

Lemma distr_r : (p,n,m:nat)<nat>
   (mult p (plus n m)) = (plus (mult p n) (mult p m)).
Goal.
Induction p; Simpl; Auto.
Intros; Rewrite assoc_plus.
Rewrite assoc_plus.
Apply plus_morph_l.
Rewrite plus_swap; Apply plus_morph_l; Trivial.
Save.

Lemma distr_d : (n,m,n',m':nat)<nat>
   (mult (plus n m) (plus n' m')) = 
   (plus (mult n n') (plus (mult m n') (plus (mult n m') (mult m m')))).
Goal.
Intros; Rewrite distr_l; Rewrite distr_r; Rewrite distr_r.
Rewrite assoc_plus.
Apply plus_morph_l.
Rewrite plus_swap; Apply plus_morph_l; Trivial.
Save.

(* (a+b)^2 = a^2 + 2ab + b^2 *)
Definition square = [n:nat](mult n n).

Definition two = (S (S O)).

Lemma Sintzoff : (n,m:nat)<nat>(square (plus n m)) =
    (plus (square n) (plus (mult (mult two n) m) (square m))).
Goal.
Unfold two; Unfold square; Simpl.
Intros; Elim (plus_n_O n).
Intros; Rewrite distr_d; Apply plus_morph_l.
Rewrite distr_l.
Rewrite plus_swap; Rewrite assoc_plus; Apply plus_morph_l.
Replace (mult m n) with (mult n m); Trivial.
Apply mult_sym.
Save.

(* A few intuitionistic tautologies *)

Goal (P,Q:Prop)((((P-> Q) -> P) -> P) -> Q) ->Q.
Auto.
Save Intui1.

Goal (P:Prop)~(~(~(~P) -> P)).
Unfold not; Intros.
Apply H; Intros.
Elim H0; Auto.
Save Intui2.

Goal (P,Q:Prop)~(~((P -> ~Q) -> (Q -> ~P))).
Unfold not; Auto.
Save Intui3.

Goal (P,Q,R:Prop)~(~((P -> Q\/R) -> ((P -> Q) \/ (P -> R)))).
Unfold not; Intros.
Apply H; Intro H'.
Left.
Cut ~P.
Unfold not; Intros P1 P2; Elim P1; Trivial.
Cut ~Q.
Cut ~R.
Unfold not; Intros NR NQ PP; Elim (H' PP); Trivial.
Unfold not; Intro; Elim H; Intro; Right; Trivial.
Unfold not; Intro; Elim H; Intro; Left; Trivial.
Save Intui4.


(* Course of values induction *)
Require Lt.

Definition lt_hereditary = [P:nat->Prop]
       (n:nat)((m:nat)(lt m n)->(P m)) -> (P n).

Lemma le_split : (m,n:nat)(le m (S n))->((le m n) \/ <nat>m=(S n)).
Goal.
Intros m n H; Elim (le_lt_or_eq m (S n)); Auto.
Save.

Lemma course_of_values : 
      (P:nat->Prop)(lt_hereditary P) -> (n,m:nat)(le m n) -> (P m).
Goal.
Unfold lt_hereditary; Induction n.
Intros; Apply H.
Elim (le_n_O_eq m); Trivial.
Intros p abs; Elim (lt_n_O p abs).
Intros.
Elim (le_split m y H1); Auto.
Intro E; Rewrite E; Apply H; Auto. (* using lt_n_Sm_le *)
Save.

Lemma complete_induction : (P:nat->Prop)(lt_hereditary P) -> (n:nat)(P n).
Goal.
Intros; Apply course_of_values with n; Auto.
Save.

Provide Demo2.
