(* A short demo of coq *)

(* Integer addition *)

(* Commented these out, since they now are standard in the Prelude. --chet--
Definition plus = [n,m:nat](<nat>Match n with 
        (* O *) m 
      (* S p *) [p:nat][plus_p_m:nat](S plus_p_m)).

Definition  mult = 
   [n,m:nat](<nat> Match n with (* O *) O 
                              (* S p *) [p:nat](plus m)).
*)
(**********************************************)
(***      A few elementary properties       ***)
(**********************************************)

Goal (n:nat)<nat>n=(plus n O).
Induction n; Simpl; Auto.
Save plus_n_O.
Hint plus_n_O.

Goal (m,n:nat) <nat>(S (plus m n))=(plus m (S n)).
Induction m; Simpl; Auto.
Save plus_S.
Hint plus_S.

Goal (n,m:nat)<nat>(plus n m)=(plus m n).
Induction m; Simpl; Auto.
Induction 1; Auto.
Save plus_com.
Immediate plus_com.

Goal (n,m,p:nat)(<nat>(plus n m)=(plus n p))-><nat>m=p.
Induction n; Simpl; Auto.
Save plus_simpl.

Goal (n,m,p:nat)<nat>(plus n (plus m p))=(plus (plus n m) p).
Induction n; Simpl; Auto.
Save plus_assoc.
Hint plus_assoc.

Goal (n,m,p:nat)<nat>(plus (plus n m) p)=(plus n (plus m p)).
Auto.
Save assoc_plus.


(************************************)
(***         Trees                ***)
(************************************)

Inductive Set tree = 
    tip  : tree 
  | node : tree -> tree -> tree.  

Definition size = [t:tree](<nat>Match t with 
   (* tip *)      (S O)
   (* node u v *) [u:tree][n1:nat][v:tree][n2:nat]
                  (plus n1 n2)).

Goal (t,u,v:tree)<nat>(size (node t (node u v)))
                    = (size (node (node t u) v)).

Simpl; Auto.
Save size_assoc.

Provide Demo.

