(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                    Variations on Ackermann's function                     *)
(*                                                                           *)
(*****************************************************************************)

Require Peano.

Inductive Definition Ack : nat->nat->nat->Prop =
     AckO : (n:nat)(Ack O n (S n))
   | AcknO : (n,p:nat)(Ack n (S O) p)->(Ack (S n) O p)
   | AckSS : (n,m,p,q:nat)
             (Ack (S n) m q)->(Ack n q p)->(Ack (S n) (S m) p).

Hint AckO AcknO.

Goal (n,m:nat){p:nat|(Ack n m p)}.
Induction n.
Intro m; Exists (S m); Auto.
Induction m.
Elim (H (S O));Intros.
Exists x; Auto.
Intros m' H'; Elim H';Intros.
Elim (H x); Intros.
Exists x0.
Apply AckSS with x; Auto.
Save Ackermann.

(* Functional definition of Ackermann :
 (ack 0 n) = (S n)
 (ack (S n) 0) = (ack n (S 0))
 (ack (S n) (S m)) = (ack n (ack (S n) m)) *)
 
Definition ack = 
   [n:nat](<nat->nat> Match n with 
           (* 0 *) S
       (* (S n) *) [n:nat][f:nat->nat][m:nat]
                   (<nat> Match m with 
                   (* 0 *) (f (S O))
                 (* S m *) [m:nat][r:nat](f r))).

Goal (n,m,p:nat)(Ack n m p)-><nat>p=(ack n m).
Induction 1; Simpl; Trivial.
Intros n1 m1 p1 q1 ASn Eq An Ep; Elim Eq; Elim Ep; Trivial.
Save ack_Ack.

Goal (n,m:nat)(Ack n m (ack n m)).
Induction n.
Simpl; Auto.
Intros n' H; Induction m.
Simpl; Auto.
Intros; Apply AckSS with (ack (S n') y); Auto.
Apply (H (ack (S n') y)).
Save Ack_ack.
Provide Ack.
