(*****************************************************************************)
(* A small piece of rings theory for chinese remainderings theorem proof     *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

Require groups.
Require Compare_dec.

(*****************************************************************************)
Section ring.

Variable S: Set.
Variable A: S -> Prop.
Variable Add, Mult: S -> S -> S.
Variable O, I: S.
Variable Opp: S -> S.
Variable v: S -> nat.
(*****************************************************************************)

(****************)
Definition is_ring =
  (commutativity S Add) /\ (is_group S A Add O Opp) /\
  (intern S A Mult) /\ (associativity S Mult) /\ (distributivity S Add Mult).

(***********)
Lemma mult_O.
Statement 
  is_ring -> (x: S) (A x) -> (<S> (Mult x O) = O /\ <S> (Mult O x) = O).

Goal.
Intros.
Elim H; Intros; Elim H2; Intros; Elim H3; Intros; Elim H4; Intros. 
Elim H6; Intros; Elim H8; Intros; Elim H10; Intros; Elim H13; Intros.
Clear H2 H4 H5 H6 H8 H9 H10 H11 H13 H14. 
(* H3: is_group, H7: intern Mult, H0: (A x), H15: (A O), H16: rest of neutral,
   H12: distributivity *)
Split.
(* x*0 = 0 *)
Apply (regular_l S A Add O Opp H3 (Mult x O) O (H7 x O H0 H15) H15 (Mult x O) (H7 x O H0 H15)).
Elim (H16 (Mult x O) (H7 x O H0 H15)); Intros; Rewrite H2.
Elim (H12 x O O); Intros; Elim H6.
Elim (H16 O H15); Intros; Rewrite H8; Reflexivity.
(* 0*x = 0 *)
Apply (regular_l S A Add O Opp H3 (Mult O x) O (H7 O x H15 H0) H15 (Mult O x) (H7 O x H15 H0)).
Elim (H16 (Mult O x) (H7 O x H15 H0)); Intros; Rewrite H2.
Elim (H12 O O x); Intros; Elim H5.
Elim (H16 O H15); Intros; Rewrite H8; Reflexivity.
Save.

(***************)
Lemma mult_opp_r.
Statement is_ring -> 
  (x, y: S) (A x) -> (A y) -> <S> (Mult x (Opp y)) = (Opp (Mult x y)).

Goal.
Intros.
Elim H; Intros; Elim H3; Intros; Elim H4; Intros; Elim H5; Intros.
Elim H7; Intros; Elim H9; Intros; Elim H11; Intros; Elim (H15 y H1); Intros.
Elim H17; Intros; Elim H19; Intros.
Clear H2 H3 H5 H6 H7 H9 H10 H11 H12 H14 H15 H16 H17 H19.
Apply (opp_unicity S A Add O Opp H4 (Mult x y) (Mult x (Opp y))).
Unfold is_opposite; Split.
Exact (H8 x y H0 H1).
Split.
Exact (H8 x (Opp y) H0 H18).
Elim (mult_O H x H0); Intros; Elim H2; Clear H H0 H1 H2 H3 H4 H8 H18.
Pattern 1 O; Elim H20; Elim H21; Clear H20 H21.
Elim (H13 x y (Opp y)); Intros; Rewrite H0; Clear H H0.
Elim (H13 x (Opp y) y); Intros; Rewrite H0; Auto.
Save.

(***************)
Lemma mult_opp_l.
Statement is_ring -> 
  (x, y: S) (A x) -> (A y) -> <S> (Mult (Opp x) y) = (Opp (Mult x y)).

Goal.
Intros.
Elim H; Intros; Elim H3; Intros; Elim H4; Intros; Elim H5; Intros.
Elim H7; Intros; Elim H9; Intros; Elim H11; Intros; Elim (H15 x H0); Intros.
Elim H17; Intros; Elim H19; Intros.
Clear H2 H3 H5 H6 H7 H9 H10 H11 H12 H14 H15 H16 H17 H19.
Apply (opp_unicity S A Add O Opp H4 (Mult x y) (Mult (Opp x) y)).
Unfold is_opposite; Split.
Exact (H8 x y H0 H1).
Split.
Exact (H8 (Opp x) y H18 H1).
Elim (mult_O H y H1); Intros; Elim H3; Clear H H0 H1 H2 H3 H4 H8 H18.
Pattern 1 O; Elim H20; Elim H21; Clear H20 H21.
Elim (H13 x (Opp x) y); Intros; Rewrite H; Clear H H0.
Elim (H13 (Opp x) x y); Intros; Rewrite H; Auto.
Save.

(*****************)
Lemma mult_opp_opp.
Statement is_ring -> 
  (x, y: S) (A x) -> (A y) -> <S> (Mult (Opp x) (Opp y)) = (Mult x y).

Goal.
Intros.
Elim H; Intros; Elim H3; Intros; Elim H4; Intros; Elim H5; Intros.
Elim H7; Intros; Elim H9; Intros; Elim H11; Intros; Elim (H15 x H0); Intros.
Elim H17; Intros; Clear H2 H3 H5 H6 H7 H9 H10 H11 H12 H13 H14 H15 H16 H17 H19.
Rewrite (mult_opp_r H (Opp x) y H18 H1).
Rewrite (mult_opp_l H x y H0 H1).
Symmetry.
Exact (opp_opp S A Add O Opp H4 (Mult x y) (H8 x y H0 H1)).
Save.

(******************)
Definition integrity = 
  (a, b: S) <S> (Mult a b) = O -> {<S> a = O}+{<S> b = O}.

(************************************)
Definition is_unitary_commutative_ring =
  is_ring /\ (commutativity S Mult) /\ (neutral S A Mult I).

(* Division *)
(***************)
Definition divide = [a, b: S] 
  (A a) /\ (A b) /\ 
    ((<S> b = O) \/ 
     (~(<S> a = O) /\ <S> Ex ([q: S] (A q) /\ (<S> b = (Mult a q))))).

(**************)
Theorem div_O_O.
Statement is_ring -> (divide O O).

Goal.
Unfold divide; Intros.
Elim H; Intros; Elim H1; Intros; Elim H2; Intros; Elim H5; Intros.
Elim H7; Intros; Elim H8; Intros.
Split. Exact H10.
Split. Exact H10.
Left; Reflexivity.
Save.

(**************)
Theorem div_add.
Statement is_ring -> 
  (a, b, d: S) (divide d a) -> (divide d b) -> (divide d (Add a b)).

Goal.
Unfold divide; Intros.
Split.
(* A d *)
Elim H0; Trivial.
Split.
(* A (a+b) *)
Elim H; Intros; Elim H3; Intros; Elim H4; Intros. 
Elim H0; Intros; Elim H9; Intros; Elim H1; Intros; Elim H13; Intros.
Exact (H6 a b H10 H14).
(* a+b = 0 or d <> 0 and a+b = d*q *)
Elim H; Intros; Elim H3; Intros; Elim H4; Intros; Elim H5; Intros.
Elim H7; Intros; Elim H9; Intros; Elim H11; Intros; Elim H14; Intros.
Clear H H2 H3 H4 H5 H7 H8 H9 H10 H11 H12 H14 H15 H16.
Elim H0; Intros; Elim H2; Intros; Clear H H0 H2.
Elim H1; Intros; Elim H0; Intros; Clear H H0 H1.
  (* a = 0 *)
Elim H4; Intros. Rewrite H. 
Elim (H17 b H2); Intros. Rewrite H1.
Exact H5.
  (* b = 0 *)
Elim H5; Intros. Rewrite H0.
Elim (H17 a H3); Intros.Rewrite H1.
Exact H4. Clear H2 H3 H4 H5 H17.
  (* a <> 0 & b <> 0 *)
Right.
Elim H; Intros; Elim H2; Intros; Elim H3; Intros; Clear H H2 H3.
Elim H0; Intros; Elim H2; Intros; Elim H3; Intros; Clear H H0 H2 H3.
Split.
Exact H1. Clear H1.
Exists (Add x x0).
Split.
Exact (H6 x x0 H4 H7). 
Elim (H13 d x x0); Intros. Clear H4 H6 H7 H13.
Rewrite H0. Clear H H0.
Elim H5; Elim H8; Reflexivity.
Save.

(***************)
Theorem div_mult.
Statement  
  is_ring -> (a, b, d: S) (divide d a) -> (A b) -> (divide d (Mult a b)).

Goal.
Unfold divide; Intros.
(* A d *)
Elim H0; Intros. Split. Exact H2. Clear H0 H2.
(* A (a*b) *)
Elim H; Intros; Elim H2; Intros; Elim H5; Intros; Elim H7; Intros.
Clear H0 H2 H4 H5 H7 H9.
Elim H3; Intros.
Split. Exact (H6 a b H0 H1). Clear H0 H3.
(* a*b = 0 or d <> 0 and a*b = d*q *)
  (* a = 0 *)
Elim H2; Intros. Rewrite H0. 
Elim (mult_O H b H1); Intros. Rewrite H4. Left; Reflexivity. Clear H H2.
  (* a <> 0 *)
Right.
Elim H0; Intros; Elim H2; Intros. Split. Exact H.
Exists (Mult x b). 
Elim H3; Intros. Split. Exact (H6 x b H4 H1).
Rewrite (H8 d x b). Elim H5; Reflexivity.
Save.

(**************)
Theorem div_opp.
Statement is_ring -> (a, d: S) (divide d a) -> (divide d (Opp a)).

Goal.
Unfold divide; Intros.
(* A d *)
Elim H0; Intros; Elim H2; Intros. Split. Exact H1. Clear H0 H2.
(* A (-a) *)
Elim H; Intros; Elim H2; Intros; Elim H5; Intros; Elim H8; Intros.
Elim H10; Intros; Elim (H12 a H3); Intros; Elim H14; Intros.
Split. Exact H15. Clear H0 H2 H3 H6 H7 H8 H9 H10 H13 H14 H15 H16.
(* (-a) = 0 or d <> 0 and (-a)= d*q *)
  (* a = 0 *)
Elim H4; Intros. Rewrite H0. Left. Exact (opp_neutral S A Add O Opp H5).
Clear H4 H11.
  (* a <> 0 *)
Right.
Elim H0; Intros; Elim H3; Intros; Elim H4; Intros. 
Split. Exact H2. Clear H0 H2 H3 H4.
Exists (Opp x). 
Elim (H12 x H6); Intros; Elim H2; Intros. Split. Exact H3. 
Clear H3 H4 H5 H6 H12.
Rewrite (mult_opp_r H d x H1 H0). Elim H7; Reflexivity.
Save.

(***************)
Definition is_gcd = [a, b, d: S]
  (divide d a) /\ (divide d b) /\ 
  ((q: S) (divide q a) -> (divide q b) -> (divide q d)).

(**************)
Lemma gcd_null.
Statement (a, b: S) (is_gcd a b O) -> (<S> a = O) /\ (<S> b = O).

Goal.
Unfold is_gcd; Intros.
Elim H; Intros; Elim H0; Intros; Elim H3; Intros.
Elim H5; Intros. Split. Exact H6. Clear H H0 H2 H3 H4 H5 H6.
Elim H1; Intros; Elim H; Intros; Elim H3; Intros; Elim H5; Intros. Exact H6.
Elim H6; Intros; Elim H7; Reflexivity.
Elim H6; Intros; Elim H7; Reflexivity.
Save.

(***************)
Lemma gcd_null2.
Statement is_ring -> (d: S) (is_gcd O O d) -> (<S> d = O).

Goal.
Unfold is_gcd. Intros.
Elim H0; Intros; Elim H2; Intros.
Elim (H4 O (div_O_O H) (div_O_O H)); Intros; Elim H6; Intros.
Elim H8; Intros. Exact H9.
Elim H9; Intros; Elim H10; Reflexivity.
Save.

(*****************************)
Lemma simplification_integrity.
Statement is_unitary_commutative_ring -> integrity -> 
  (a, x: S) (A a) -> (A x) -> ~(<S> a = O) -> 
  (<S> (Mult a x) = a) -> <S> x = I.

Goal.
Intros. Elim H; Intros; Elim H5; Intros; Elim H6; Intros; Elim H8; Intros. 
Elim H11; Intros; Elim H12; Intros; Elim H14; Intros; Elim H16; Intros.
Elim H18; Intros. Clear H6 H8 H9 H12 H13 H14 H15 H16 H17 H18 H19 H21.
Rewrite (opp_opp S A Add O Opp H11 x H2). 
Symmetry; Apply (opp_unicity S A Add O Opp H11 (Opp x) I).
Elim (H22 x H2); Intros; Elim H8; Intros; Elim H10; Intros.
Apply (opp_com S A Add O H7 (Opp x) I H9 H13). Clear H6 H8 H12 H13.
Elim (H0 a (Add (Opp x) I)); Intros. Elim H3; Exact a0. Exact b.
Elim (H20 a (Opp x) I); Intros. Rewrite H8. Elim (H14 a H1); Intros.
Rewrite H12. Clear H6 H8 H9 H12 H13 H14.
Rewrite (mult_opp_r H5 a x H1 H2). Rewrite H4.
Elim (H22 a H1); Intros; Elim H8; Intros; Elim H12; Intros; Exact H14.
Save.

(******************************) (* Pas aussi propre que je le souhaiterais *)
Lemma gcd_unicity_apart_unities.
Statement is_unitary_commutative_ring -> integrity ->
  (a, b, d1, d2: S) (is_gcd a b d1) -> (is_gcd a b d2) -> 
  <S> Ex ([x: S] (inversible S Mult I x) /\ (A x) /\ (<S> d2 = (Mult d1 x))).

Goal.
Intros.
Elim H2; Intros; Elim H4; Intros; Elim H1; Intros; Elim H8; Intros.
Elim (H6 d1 H7 H9); Intros; Elim H12; Intros; Elim H14; Intros.
(* d2 = O *)
Exists I. Unfold inversible.
Elim H; Intros; Elim H17; Intros; Elim H19; Intros.
Split. Exists I. Exact (H21 I H20). Split. Exact H20.
Elim (gcd_null a b); Intros. Rewrite H15. Rewrite (gcd_null2 H16 d1). 
Elim (mult_O H16 I); Intros. Symmetry; Exact H25. Exact H20.
Pattern 1 O; Elim H22; Elim H23; Exact H1. Elim H15; Exact H2.
(* d2 <> 0 *)
Elim H15; Intros; Elim H17; Intros. Exists x.
Elim H; Intros; Elim H20; Intros. Split. Apply (inv_com S Mult I x H21).
Elim H1; Intros; Elim H24; Intros; Elim (H26 d2 H3 H5); Intros.
Elim H28; Intros; Elim H30; Intros. Elim H16; Exact H31.
(* d1 <> 0 *)
Elim H31; Intros; Elim H33; Intros. Exists x0.
Elim H34; Intro; Clear H35. Elim H18; Intro; Intro. Rewrite H36.
Elim H; Intros H37 H38; Elim H37; Intros H39 H40; Elim H40; Intros H41 H42.
Elim H42; Intros H43 H44; Elim H44; Intros H45 H46; Elim (H45 d1 x x0); Intros.
Elim H34; Intros.
Apply (simplification_integrity H H0 d1 (Mult x x0) H11 (H43 x x0 H35 H48) H16).
Symmetry; Exact H47.
Exact H18.
Save.

(**********)
Lemma opp_O.
Statement is_ring -> (x: S) (A x) -> <S> (Opp x) = O -> <S> x = O.

Goal.
Intros.
Elim H; Intros; Elim H3; Intros. Rewrite (opp_opp S A Add O Opp H4 x H0).
Rewrite H1. Exact (opp_neutral S A Add O Opp H4).
Save.

End ring.
(*****************************************************************************)

Provide rings.
