(*****************************************************************************)
(* Miscellaneous definitions and lemmas                                      *)
(* for chinese remainderings theorem proof                                   *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(****************)
Definition antisym = [A: Set] [R: A -> A -> Prop] 
  (x, y: A) (R x y) -> (R y x) -> <A> x = y.

(********************)
Lemma pi1.
Statement (A: Set) (P: A -> Prop) {x: A | (P x)} -> A.

Goal.
Induction 1; Auto.
Save.

(********************)
Lemma pi2.
Statement (A: Set) (P: A -> Prop) (p: {x: A | (P x)}) (P (pi1 A P p)).

Goal.
Induction p; Unfold pi1; Trivial.
Save.

(*******************)
Definition inversible = [S: Set] [Mult: S -> S -> S] [I, x: S]
  <S> Ex ([y: S] (<S> (Mult x y) = I) /\ (<S> (Mult y x) = I)).

(************)
Lemma inv_com.
Statement (S: Set) (Mult: S -> S -> S) (I, x: S)
  (commutativity S Mult) -> <S> Ex ([y: S] (<S> (Mult x y) = I)) -> 
  (inversible S Mult I x).

Goal.
Intros; Unfold inversible.
Elim H0; Intros.
Exists x0.
Split. 
Assumption.
Elim (H x x0); Assumption.
Save.  

Provide misc.