(*****************************************************************************)
(* A small piece of groups theory for chinese remainderings theorem proof    *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

Require Lci.
Require misc.

(*****************************************************************************)
Section groups.

Variable S: Set.
Variable G: S -> Prop.
Variable Add: S -> S -> S.
Variable O: S.
Variable Opp: S -> S.
(*****************************************************************************)

(*****************)
Definition is_group = 
  (intern S G Add) /\ 
  (associativity S Add) /\ (neutral S G Add O) /\ (opposite S G Add O Opp). 

(**************)
Lemma regular_l.
Statement is_group -> ((y, z: S) (G y) -> (G z) -> 
     (x: S) (G x) -> ((<S> (Add x y) = (Add x z)) -> (<S> y = z))).

Goal.
Intros.
Elim H; Intros; Elim H5; Intros; Elim H7; Intros; Elim H8; Intros. 
Clear H4 H5 H7 H10.
(* use of neutral *)
Elim (H11 y H0); Intros; Elim H5; Clear H4 H5.
Elim (H11 z H1); Intros; Elim H5; Clear H4 H5 H8 H11.
(* use of opposite *)
Elim (H9 x H2); Intros; Elim H5; Intros; Elim H8; Intros; Elim H11. 
Clear H4 H5 H7 H8 H9 H10 H11.
(* use of associativity *)
Elim (H6 (Opp x) x y); Elim (H6 (Opp x) x z).
Elim H3; Reflexivity.
Save.

(************)
Lemma add_add.
Statement 
  (commutativity S Add) -> (associativity S Add) -> (x1, y1, x2, y2: S) 
     <S> (Add (Add x1 y1) (Add x2 y2)) = (Add (Add x1 x2) (Add y1 y2)).

Goal.
Intros com ass x1 y1 x2 y2.
Rewrite -> (ass (Add x1 y1) x2 y2); Elim (ass x1 y1 x2); Elim (com x2 y1).
Rewrite -> (ass x1 x2 y1); Elim (ass (Add x1 x2) y1 y2); Reflexivity.
Save.

(****************)
Lemma opp_unicity.
Statement 
  is_group -> (x, y: S) (is_opposite S G Add O x y) -> <S> y = (Opp x).

Goal.
Intros.
(* G y *)
Elim H0; Intros; Elim H2; Intros.
(* y = 0+y *)
Elim H; Intros; Elim H6; Intros; Elim H8; Intros; Elim H9; Intros.
Elim (H12 y H3); Intros; Elim H14; Clear H H2 H3 H5 H6 H8 H11 H12 H13 H14.
(* 0=(-x)+x *)
Elim (H10 x H1); Intros; Elim H2; Intros; Elim H5; Intros; Elim H8.
Clear H H1 H2 H5 H6 H8 H10.
(* ((-x)+x)+y=(-x)+(x+y) *)
Elim (H7 (Opp x) x y).
(* x+y = 0 *)
Elim H4; Intros; Rewrite H; Clear H H0 H1 H4 H7.
(* (-x)+0=(-x) *)
Elim H9; Intros; Elim (H0 (Opp x) H3); Intros. Exact H1.
Save.

(************)
Lemma opp_opp.
Statement is_group -> (x: S) (G x) -> <S> x = (Opp (Opp x)).

Goal.
Intros.
Apply (opp_unicity H (Opp x) x).
Unfold is_opposite; Split.
Elim H; Intros; Elim H2; Intros; Elim H4; Intros; Elim (H6 x H0); Intros. 
Elim H8; Trivial.
Elim H; Intros; Elim H2; Intros; Elim H4; Intros; Elim (H6 x H0); Intros.
Elim H8; Intros; Elim H10; Auto.
Save.

(************)
Lemma opp_add.
Statement is_group -> (commutativity S Add) -> (x, y: S) (G x) -> (G y) -> 
  <S> (Opp (Add x y)) = (Add (Opp x) (Opp y)).

Goal.
Intros; Symmetry; Apply (opp_unicity H (Add x y) (Add (Opp x) (Opp y))).
Unfold is_opposite; Split.
(* G (x+y) *)
Elim H; Intros; Apply (H3 x y H1 H2).
Split.
(* G ((-x)+(-y)) *)
Elim H; Intros; Elim H4; Intros; Elim H6; Intros; Clear H4 H5 H6 H7.
Elim (H8 x H1); Intros; Elim H5; Intros; Clear H4 H5 H7.
Elim (H8 y H2); Intros; Elim H5; Intros.
Apply (H3 (Opp x) (Opp y) H6 H7).
(* (x+y)+((-x)+(-y)) = 0 & ((-x)+(-y))+(x+y) = 0 *)
Elim H; Intros; Elim H4; Intros; Clear H3 H4 H6.
Rewrite -> (add_add H0 H5 x y (Opp x) (Opp y)).
Rewrite -> (add_add H0 H5 (Opp x) (Opp y) x y); Clear H5.
Elim H; Intros; Elim H4; Intros; Elim H6; Intros. 
  (* x+(-x) = 0 (-x)+x = 0 *)
Elim (H8 x H1); Intros; Elim H10; Intros; Elim H12; Intros. 
Rewrite H13; Rewrite H14.
Clear H H0 H1 H3 H4 H5 H6 H9 H10 H11 H12 H13 H14.
  (* y+(-y) = 0 (-y)+y = 0 *)
Elim (H8 y H2); Intros; Elim H0; Intros; Elim H3; Intros. 
Rewrite H4; Rewrite H5.
Clear H H0 H1 H2 H3 H4 H5 H8.
  (* 0+0 = 0 *)
Elim H7; Intros; Exact (H0 O H).
Save.

(****************)
Lemma opp_neutral.
Statement is_group -> <S> (Opp O) = O.

Goal.
Intros.
Elim (opp_unicity H O O).
Reflexivity.
Unfold is_opposite.
Elim H; Intros; Elim H1; Intros; Elim H3; Intros; Elim H4; Intros.
Elim (H7 O H6); Auto.
Save.

End groups.
(*****************************************************************************)

Provide groups.
