(*****************************************************************************)
(* Constructive recursion principle with well-founded order on Z             *)
(* for chinese remainderings theorem proof                                   *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(**********)
Lemma lt_OZ.
Statement (m: Z) ~(ltZ (absZ m) OZ).

Goal.
Intros; Unfold ltZ; Elim m.
Unfold not; Simpl; Intros; Exact H.
Unfold not; Simpl; Intros; Exact H.
Unfold not; Simpl; Intros; Exact H.
Save.

(**********)
Lemma Zrec1.
Statement (P: Z -> Set) 
  ((n: Z) ((m: Z) (lt_absZ m n) -> (P m)) -> (P n)) -> (P OZ).

Goal.
Intros; Apply (H OZ); Intros.
Unfold lt_absZ in H0; Unfold 2 absZ in H0; Elim (lt_OZ m); Assumption.
Save.

(**********************************)
Inductive Definition and_set_set_set [S1: Set; S2: Set]: Set =
  and_set_set_set_i: S2 -> S1 -> (and_set_set_set S1 S2).

(*****************)
Definition and_recZ =
  [p: nat] [P: Z -> Set]  
  (n: nat) (le n p) -> (and_set_set_set (P (pos n)) (P (neg n))).

(**********)
Lemma Zrec2.
Statement (P: Z -> Set) 
  ((n: Z) ((m: Z) (lt_absZ m n) -> (P m)) -> (P n)) -> (and_recZ O P).

Goal.
Unfold and_recZ; Intros; Apply and_set_set_set_i.
(* neg n *)
Elim (le_n_O_eq n H0). Apply (H (neg O)); Intros.
Rewrite -> (tech_lt_abs_OZ m). Apply (Zrec1 P H). Exact H1.
(* pos n *)
Elim (le_n_O_eq n H0). Apply (H (pos O)); Intros.
Rewrite -> (tech_lt_abs_OZ m). Apply (Zrec1 P H). Exact H1.
Save.

(**********)
Lemma Zrec3.
Statement (P: Z -> Set) (p: nat)
  ((n: Z) ((m: Z) (lt_absZ m n) -> (P m)) -> (P n)) ->
  ((and_recZ p P) -> (and_recZ (S p) P)).

Goal.
Unfold and_recZ; Intros; Apply and_set_set_set_i.
(* P (neg n) *)
Elim (lt_succ n p H1); Intros. Elim (H0 n a); Intros; Exact s.
Rewrite -> b. Apply (H (neg (S p))).
Intros m; Elim m. Intros; Apply (Zrec1 P H).
Unfold lt_absZ; Unfold absZ; Unfold ltZ; Unfold leZ; Intros.
Elim (H0 n0 (le_S_n n0 p H2)); Intros; Exact s0.
Unfold lt_absZ; Unfold absZ; Unfold ltZ; Unfold leZ; Intros.
Elim (H0 n0 (le_S_n n0 p H2)); Intros; Exact s.
(* P (pos n) *)
Elim (lt_succ n p H1); Intros. Elim (H0 n a); Intros; Exact s0.
Rewrite -> b. Apply (H (pos (S p))).
Intros m; Elim m. Intros; Apply (Zrec1 P H).
Unfold lt_absZ; Unfold absZ; Unfold ltZ; Unfold leZ; Intros.
Elim (H0 n0 (le_S_n n0 p H2)); Intros; Exact s0.
Unfold lt_absZ; Unfold absZ; Unfold ltZ; Unfold leZ; Intros.
Elim (H0 n0 (le_S_n n0 p H2)); Intros; Exact s.
Save.

(*************)
Theorem Zrec4.
Statement (P: Z -> Set)
  ((n: Z) ((m: Z) (lt_absZ m n) -> (P m)) -> (P n)) -> (p: nat) (and_recZ p P).

Goal.
Intros; Elim p. Exact (Zrec2 P H). Intros. Exact (Zrec3 P y H H0).
Save.

(************)
Theorem recZ.
Statement (P: Z -> Set)
  ((n: Z) ((m: Z) (lt_absZ m n) -> (P m)) -> (P n)) -> (p: Z) (P p).

Goal.
Intros; Elim p.
(* OZ *)
Exact (Zrec1 P H).
(* pos n *)
Intros. Cut (and_recZ n P). Unfold and_recZ. Intros.
Elim (H0 n (le_n n)); Intros; Exact s0. Exact (Zrec4 P H n).
(* neg n *)
Intros. Cut (and_recZ n P). Unfold and_recZ. Intros.
Elim (H0 n (le_n n)); Intros; Exact s. Exact (Zrec4 P H n).
Save.

Provide Zrec.