(*****************************************************************************)
(* Multiplication on Z for chinese remainderings theorem proof               *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)


(* Multiplication on Z, (Z, +, *, 0, 1) is a unitary commutative ring *)

(**************)
Definition multZ = 
  [x, y: Z] (<Z> Match x with
    (* OZ *)    OZ
    (* pos n *) [n: nat] (<Z> Match n with 
       (* O *)    y
       (* S n1 *) [n1: nat] [q: Z] (addZ q y))
    (* neg n *) [n: nat] (<Z> Match n with 
       (* O *)    (oppZ y)
       (* S n1 *) [n1: nat] [q: Z] (addZ q (oppZ y)))).

(*******************)
Lemma tech_mult_posZ.
Statement (x: nat) (y: Z) 
  <Z> (multZ (pos (S x)) y) = (addZ (multZ (pos x) y) y).

Goal.
Intros; Unfold multZ; Reflexivity.
Save.

(*******************)
Lemma tech_mult_negZ.
Statement (x: nat) (y: Z) 
  <Z> (multZ (neg (S x)) y) = (addZ (multZ (neg x) y) (oppZ y)).

Goal.
Intros; Unfold multZ; Reflexivity.
Save.

(*****************)
Lemma mult_succZ_l.
Statement (x, y: Z) <Z> (multZ (succZ x) y) = (addZ (multZ x y) y).

Goal.
Intros; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Simpl; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl; Symmetry. 
Elim (addZ_opposite y I); Intros. Elim H0; Intros; Elim H2; Intros; Exact H4.
(* neg (S y0) *)
Intros; Unfold succZ; Rewrite (tech_mult_negZ y0 y).
Elim (addZ_associativity (multZ (neg y0) y) (oppZ y) y).
Elim (addZ_opposite y I); Intros. Elim H1; Intros; Elim H3; Intros. Rewrite H5.
Symmetry; Exact (add_OZ (multZ (neg y0) y)).
Save.

(*****************)
Lemma mult_predZ_l.
Statement (x, y: Z) <Z> (multZ (predZ x) y) = (addZ (multZ x y) (oppZ y)).

Goal.
Intros; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Simpl; Symmetry.
Elim (addZ_opposite y I); Intros. Elim H0; Intros; Elim H2; Intros; Exact H3.
(* pos (S y0) *)
Intros; Unfold predZ; Rewrite (tech_mult_posZ y0 y).
Elim (addZ_associativity (multZ (pos y0) y) y (oppZ y)).
Elim (addZ_opposite y I); Intros. Elim H1; Intros; Elim H3; Intros; Rewrite H4.
Rewrite (add_OZ (multZ (pos y0) y)); Reflexivity.
(* neg n *)
Intros; Simpl; Reflexivity.
Save.

(*****************)
Lemma mult_succZ_r.
Statement (x, y: Z) <Z> (multZ x (succZ y)) = (addZ (multZ x y) x).

Goal.
Intros; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Simpl; Symmetry; Exact (add_IZ_succZ y).
(* pos (S y0) *)
Intros; Rewrite (tech_mult_posZ y0 (succZ y)); Rewrite (tech_mult_posZ y0 y).
Rewrite H; Elim (addZ_commutativity (pos y0) (multZ (pos y0) y)).
Elim (addZ_associativity (pos y0) (multZ (pos y0) y) (succZ y)).
Elim (addZ_commutativity (addZ (multZ (pos y0) y) (succZ y)) (pos y0)).
Rewrite (succ_addZ_r (multZ (pos y0) y) y).
Rewrite (succ_addZ_l (addZ (multZ (pos y0) y) y) (pos y0)).
Elim (succ_addZ_r (addZ (multZ (pos y0) y) y) (pos y0)).
Unfold succZ; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl; Rewrite (add_mIZ_predZ (oppZ y)); Exact (opp_succZ y).
(* neg (S yo) *)
Intros; Rewrite (tech_mult_negZ y0 (succZ y)); Rewrite (tech_mult_negZ y0 y).
Elim H; Elim (addZ_commutativity (oppZ y) (multZ (neg y0) y)).
Elim (addZ_associativity (oppZ y) (multZ (neg y0) y) (neg (S y0))).
Elim (addZ_commutativity (addZ (multZ (neg y0) y) (neg (S y0))) (oppZ y)).
Rewrite (opp_succZ y). 
Rewrite (pred_addZ_r (multZ (neg y0) (succZ y)) (oppZ y)).
Rewrite H; Elim (pred_addZ_l (addZ (multZ (neg y0) y) (neg y0)) (oppZ y)).
Elim (pred_addZ_r (multZ (neg y0) y) (neg y0)); Unfold predZ; Reflexivity.
Save.

(*****************)
Lemma mult_predZ_r.
Statement (x, y: Z) <Z> (multZ x (predZ y)) = (addZ (multZ x y) (oppZ x)).

Goal.
Intros; Elim x.
(* OZ *)
Unfold multZ; Unfold predZ; Unfold addZ; Unfold oppZ; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Simpl; Symmetry; Exact (add_mIZ_predZ y).
(* pos (S y0) *)
Intros; Unfold oppZ; Rewrite (tech_mult_posZ y0 (predZ y)).
Rewrite (tech_mult_posZ y0 y).
Rewrite (pred_addZ_r (multZ (pos y0) (predZ y)) y).
Elim (pred_addZ_l (multZ (pos y0) (predZ y)) y).
Elim (addZ_commutativity y (multZ (pos y0) y)).
Elim (addZ_associativity y (multZ (pos y0) y) (neg (S y0))).
Elim (addZ_commutativity (addZ (multZ (pos y0) y) (neg (S y0))) y).
Rewrite H; Elim (pred_addZ_r (multZ (pos y0) y) (oppZ (pos y0))).
Simpl; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl; Rewrite (add_IZ_succZ (oppZ y)); Exact (opp_predZ y).
(* neg (S y0) *)
Intros; Rewrite (tech_mult_negZ y0 (predZ y)); Rewrite (tech_mult_negZ y0 y).
Rewrite H; Rewrite (opp_predZ y).
Elim (addZ_commutativity (oppZ (neg y0)) (multZ (neg y0) y)).
Elim (addZ_associativity (oppZ (neg y0)) (multZ (neg y0) y) (succZ (oppZ y))).
Elim (addZ_commutativity (addZ (multZ (neg y0) y) (succZ (oppZ y))) (oppZ (neg y0))).
Rewrite (succ_addZ_r (multZ (neg y0) y) (oppZ y)).
Rewrite (succ_addZ_l (addZ (multZ (neg y0) y) (oppZ y)) (oppZ (neg y0))).
Elim (succ_addZ_r (addZ (multZ (neg y0) y) (oppZ y)) (oppZ (neg y0))).
Simpl; Reflexivity.
Save.

(************)
Lemma mult_OZ.
Statement (x: Z) <Z> (multZ x OZ) = OZ.

Goal.
Intros; Elim x.
(* OZ *)
Unfold multZ; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Unfold multZ; Reflexivity.
(* pos (S y) *)
Intros; Rewrite (tech_mult_posZ y OZ); Rewrite H; Unfold addZ; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Unfold multZ; Reflexivity.
(* neg (S y0) *)
Intros; Rewrite (tech_mult_negZ y OZ); Rewrite H; Unfold addZ; Reflexivity.
Save.

(************)
Lemma mult_IZ.
Statement (x: Z) <Z> (multZ x IZ) = x.

Goal.
Intros; Pattern x; Elim x.
(* OZ *)
Unfold multZ; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Unfold multZ; Reflexivity.
(* pos (S y) *)
Intros; Rewrite (tech_mult_posZ y IZ); Rewrite H. 
Rewrite (add_IZ_succZ (pos y)); Unfold succZ; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Unfold multZ; Reflexivity.
(* neg (S y) *)
Intros; Rewrite (tech_mult_negZ y IZ); Rewrite H; Unfold oppZ. 
Rewrite (add_mIZ_predZ (neg y)); Unfold predZ; Reflexivity.
Save.

(*************)
Lemma mult_mIZ.
Statement (x: Z) <Z> (multZ x (neg O)) = (oppZ x).

Goal.
Intros; Pattern x; Elim x.
(* OZ *)
Unfold multZ; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Unfold multZ; Reflexivity.
(* pos (S y) *)
Intros; Rewrite (tech_mult_posZ y (neg O)); Rewrite H. 
Rewrite (add_mIZ_predZ (oppZ (pos y))); Simpl; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Unfold multZ; Reflexivity.
(* neg (S y) *)
Intros; Rewrite (tech_mult_negZ y (neg O)); Rewrite H.
Elim (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity (neg y) (neg O) I I).
Rewrite (add_mIZ_predZ (neg y)); Simpl; Reflexivity.
Save.

(**************************)
Theorem multZ_commutativity.
Statement (commutativity Z multZ).

Goal.
Unfold commutativity; Intros; Elim x.
(* OZ *)
Rewrite (mult_OZ y); Unfold multZ; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Simpl; Symmetry; Exact (mult_IZ y).
(* pos (S y0) *)
Intros; Rewrite (tech_mult_posZ y0 y); Rewrite H. 
Elim (mult_succZ_r y (pos y0)); Unfold succZ; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl; Symmetry; Exact (mult_mIZ y).
(* neg (S y0) *)
Intros; Rewrite (tech_mult_negZ y0 y); Rewrite H. 
Elim (mult_predZ_r y (neg y0)); Unfold predZ; Reflexivity.
Save.

(********************)
Theorem multZ_neutral.
Statement (neutral Z IdZ multZ IZ).

Goal.
Unfold neutral.
Split. Exact I.
Intros. 
Split.
(* -> *)
Elim (multZ_commutativity IZ x); Unfold multZ; Reflexivity.
(* <- *)
Unfold multZ; Reflexivity.
Save.

(******************************)
Theorem mult_add_distributivity.
Statement (distributivity Z addZ multZ).

Goal.
Unfold distributivity; Intros; Elim x.
(* OZ *)
Simpl; Split; Reflexivity; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Simpl; Rewrite (mult_succZ_l y z). 
Split. Exact (addZ_commutativity (multZ y z) z). Reflexivity.
(* pos (S y0) *)
Intros.
Rewrite (tech_add_pos_succZ y0 y); Rewrite (mult_succZ_l (addZ (pos y0) y) z).
Rewrite (tech_mult_posZ y0 (addZ y z)); Rewrite (tech_mult_posZ y0 y). 
Elim H; Intros; Rewrite H0; Rewrite H1; Rewrite (tech_mult_posZ y0 z).
Elim (addZ_associativity (multZ (pos y0) z) (multZ y z) z).
Elim (addZ_commutativity z (multZ y z)).
Rewrite (addZ_associativity (multZ (pos y0) z) z (multZ y z)).
Elim (add_add Z addZ addZ_commutativity addZ_associativity (multZ (pos y0) y) (multZ (pos y0) z) y z).
Split. Reflexivity. Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl. Split. 
Rewrite (mult_predZ_l y z). Exact (addZ_commutativity (multZ y z) (oppZ z)).
Apply (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity y z I I).
(* neg (S y0) *)
Intros.
Split.
(* -> *)
Rewrite (tech_add_neg_predZ y0 y); Rewrite (mult_predZ_l (addZ (neg y0) y) z).
Elim H; Intros. Rewrite H0; Rewrite H1.
Elim (addZ_associativity (multZ (neg y0) z) (multZ y z) (oppZ z)).
Elim (addZ_commutativity (oppZ z) (multZ y z)).
Rewrite (addZ_associativity (multZ (neg y0) z) (oppZ z) (multZ y z)).
Elim (tech_mult_negZ y0 z); Reflexivity.
(* <- *)
Rewrite (tech_mult_negZ y0 (addZ y z)); Rewrite (tech_mult_negZ y0 y).
Rewrite (tech_mult_negZ y0 z); Elim H; Intros; Rewrite H1.
Elim (add_add Z addZ addZ_commutativity addZ_associativity (multZ (neg y0) y) (multZ (neg y0) z) (oppZ y)  (oppZ z)).
Elim (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity y z I I).
Reflexivity.
Save.

(****************)
Lemma mult_oppZ_r.
Statement (x, y: Z)
  <Z> (multZ x (oppZ y)) = (oppZ (multZ x y)).

Goal.
Intros; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Simpl; Reflexivity.
(* pos (S y0) *)
Intros; Rewrite (tech_mult_posZ y0 (oppZ y)); Rewrite (tech_mult_posZ y0 y).
Rewrite (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity (multZ (pos y0) y) y I I).
Elim H; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl; Reflexivity.
(* neg (S y0) *)
Intros; Rewrite (tech_mult_negZ y0 (oppZ y)); Rewrite (tech_mult_negZ y0 y).
Rewrite (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity (multZ (neg y0) y) (oppZ y) I I).
Elim H; Reflexivity.
Save.

(****************)
Lemma mult_oppZ_l.
Statement (x, y: Z)
  <Z> (multZ (oppZ x) y) = (oppZ (multZ x y)).

Goal.
Intros; Elim y.
(* OZ *)
Rewrite (mult_OZ (oppZ x)); Rewrite (mult_OZ x); Reflexivity.
(* pos n *)
Intros; Elim (multZ_commutativity (pos n) (oppZ x)). 
Elim (multZ_commutativity (pos n) x); Elim n.
(* pos O *)
Unfold oppZ; Reflexivity.
(* pos (S y) *)
Intros; Rewrite (tech_mult_posZ y0 (oppZ x)); Rewrite (tech_mult_posZ y0 x).
Rewrite H; Symmetry. 
Exact (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity (multZ (pos y0) x) x I I).
(* neg n *)
Intros; Elim (multZ_commutativity (neg n) (oppZ x)). 
Elim (multZ_commutativity (neg n) x); Elim n.
(* neg O *)
Unfold oppZ; Reflexivity.
(* neg (S y) *)
Intros; Rewrite (tech_mult_negZ y0 (oppZ x)); Rewrite (tech_mult_negZ y0 x).
Rewrite H; Symmetry.
Exact (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity (multZ (neg y0) x) (oppZ x) I I).
Save.

(********************)
Lemma tech_multZ_negO.
Statement (x: Z) <Z> (multZ (neg O) x) = (oppZ x).

Goal.
Intros; Unfold multZ; Reflexivity.
Save.

(***********************)
Lemma tech_mult_pos_posZ.
Statement (n: nat) (m: nat) 
  <Z> (multZ (pos n) (pos m)) = (pos (plus (mult n m) (plus n m))).

Goal.
Intros; Elim n.
(* O *)
Simpl; Reflexivity.
(* S y *)
Intros; Rewrite (tech_mult_posZ y (pos m));Rewrite H.
Rewrite (tech_add_pos_posZ (plus (mult y m) (plus y m)) m).
Elim (technical_lemma y m); Reflexivity.
Save.

(***********************)
Lemma tech_mult_neg_negZ.
Statement (n: nat) (m: nat) 
  <Z> (multZ (neg n) (neg m)) = (pos (plus (mult n m) (plus n m))).

Goal.
Intros; Elim n.
(* O *)
Simpl; Reflexivity.
(* S y *)
Intros; Rewrite (tech_mult_negZ y (neg m)); Rewrite H; Unfold oppZ.
Rewrite (tech_add_pos_posZ (plus (mult y m) (plus y m)) m).
Elim (technical_lemma y m); Reflexivity.
Save.

(***********************)
Lemma tech_mult_pos_negZ.
Statement (n: nat) (m: nat) 
  <Z> (multZ (pos n) (neg m)) = (neg (plus (mult n m) (plus n m))).

Goal.
Intros; Elim n.
(* O *)
Simpl; Reflexivity.
(* S y *)
Intros; Rewrite (tech_mult_posZ y (neg m)); Rewrite H.
Rewrite (tech_add_neg_negZ (plus (mult y m) (plus y m)) m).
Elim (technical_lemma y m); Reflexivity.
Save.

(***********************)
Lemma tech_mult_neg_posZ.
Statement (n: nat) (m: nat) 
  <Z> (multZ (neg n) (pos m)) = (neg (plus (mult n m) (plus n m))).

Goal.
Intros; Elim n.
(* O *)
Simpl; Reflexivity.
(* S y *)
Intros; Rewrite (tech_mult_negZ y (pos m)); Unfold oppZ; Rewrite H.
Rewrite (tech_add_neg_negZ (plus (mult y m) (plus y m)) m).
Elim (technical_lemma y m); Reflexivity.
Save.

(**************************)
Theorem multZ_associativity.
Statement (associativity Z multZ).

Goal.
Unfold associativity; Intros; Elim x.
(* OZ *)
Unfold multZ; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Unfold multZ; Reflexivity.
(* pos (S y0) *)
Intros; Rewrite (tech_mult_posZ y0 y); Rewrite (tech_mult_posZ y0 (multZ y z)).
Rewrite H; Elim (mult_oppZ_l y z).
Elim (mult_add_distributivity (multZ (pos y0) y) y z); Intros. Elim H0.
Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl; Symmetry; Exact (mult_oppZ_l y z).
(* neg (S y0) *)
Intros; Rewrite (tech_mult_negZ y0 y); Rewrite (tech_mult_negZ y0 (multZ y z)).
Rewrite H; Elim (mult_oppZ_l y z).
Elim (mult_add_distributivity (multZ (neg y0) y) (oppZ y) z); Intros. Elim H0.
Reflexivity.
Save.

(*************)
Theorem Z_ring.
Statement (is_ring Z IdZ addZ multZ OZ oppZ).

Goal.
Unfold is_ring.
Split. Exact (addZ_commutativity).
Split. Exact Z_group.
Split. Unfold intern. Intros. Exact I.
Split. Exact multZ_associativity. Exact mult_add_distributivity.
Save.

(*********************************)
Theorem Z_unitary_commutative_ring.
Statement (is_unitary_commutative_ring Z IdZ addZ multZ OZ IZ oppZ).

Goal.
Unfold is_unitary_commutative_ring.
Split. Exact Z_ring.
Split. Exact multZ_commutativity. Exact multZ_neutral.
Save.

(* Z is an integral domain *)
(********************)
Lemma tech_integ_posZ.
Statement (n: nat) (x: Z) <Z> (multZ (pos n) x) = OZ -> <Z> x = OZ.

Goal.
Intros n x; Elim x.
(* OZ *)
Reflexivity.
(* pos n0 *)
Intros n0; Rewrite (tech_mult_pos_posZ n n0); Intros.
Absurd (<Z> (pos (plus (mult n n0) (plus n n0))) = OZ). Discriminate. Exact H.
(* neg n0 *)
Intros n0; Rewrite (tech_mult_pos_negZ n n0); Intros.
Absurd (<Z> (neg (plus (mult n n0) (plus n n0))) = OZ). Discriminate. Exact H.
Save.

(********************)
Lemma tech_integ_negZ.
Statement (n: nat) (x: Z) <Z> (multZ (neg n) x) = OZ -> <Z> x = OZ.

Goal.
Intros n x; Elim x.
(* OZ *)
Reflexivity.
(* pos n0 *)
Intros n0; Rewrite (tech_mult_neg_posZ n n0); Intros.
Absurd (<Z> (neg (plus (mult n n0) (plus n n0))) = OZ). Discriminate. Exact H.
(* neg n0 *)
Intros n0; Rewrite (tech_mult_neg_negZ n n0); Intros.
Absurd (<Z> (pos (plus (mult n n0) (plus n n0))) = OZ). Discriminate. Exact H.
Save.

(*****************)
Theorem integrityZ.
Statement (integrity Z multZ OZ).

Goal.
Unfold integrity; Intros a b; Elim a.
(* OZ *)
Intros; Left; Reflexivity.
(* pos n *)
Intros; Right; Apply (tech_integ_posZ n b); Exact H.
(* neg n *)
Intros; Right; Apply (tech_integ_negZ n b); Exact H.
Save.

(************************)
Lemma tech_mult_pos_succZ. 
Statement (n, m: nat) <Z> (posOZ (mult (S n) (S m))) = (multZ (pos n) (pos m)).

Goal.
Intros; Elim m.
(* O *)
Elim multZ_neutral; Intros; Elim (H0 (pos n) I); Intros. Rewrite H1.
Elim (mult_commut (S O) (S n)). Rewrite (mult_neutr (S n)). 
Unfold posOZ; Reflexivity.
(* S y *)
Intros; Elim (multZ_commutativity (pos (S y)) (pos n)).
Rewrite (tech_mult_posZ y (pos n)); Elim (multZ_commutativity (pos n) (pos y)).
Elim H; Elim (mult_n_Sm (S n) (S y)); Elim (plus_n_Sm (mult (S n) (S y)) n).
Elim (mult_n_Sm (S n) y); Elim (plus_n_Sm (mult (S n) y) n).
Unfold posOZ; Rewrite (tech_add_pos_posZ (plus (mult (S n) y) n) n).
Reflexivity.
Save.

(************************)
Lemma tech_mult_pos_succZ2. 
Statement (n, m: nat) 
  <Z> (multZ (pos n) (pos m)) = (pos (plus (mult (S n) m) n)).

Goal.
Intros; Elim (tech_mult_pos_succZ n m).
Simpl; Elim (mult_n_Sm n m); Elim (plus_assoc_l m (mult n m) n); Reflexivity. 
Save.

(**************)
Lemma tech_div1.
Statement (n0, n, q, r: nat)
  <nat> (S n0) = (plus (mult q (S n)) r) -> 
  <Z> (pos n0) = (addZ (multZ (pos n) (posOZ q)) (posOZ r)).

Goal.
Intros n0 n q r; Elim q.
(* O O *)
Elim r.
Simpl; Intros; Absurd (<nat> (S n0) = O). Discriminate. Exact H.
(* O (S y) *)
Intros y H; Unfold posOZ; Rewrite (mult_OZ (pos n)).
Simpl; Intros; Elim (eq_add_S n0 y H0); Reflexivity.
(* (S n) O *)
Elim r.
Intros y H; Unfold posOZ; Elim (plus_n_O (mult (S y) (S n))).
Rewrite (add_OZ (multZ (pos n) (pos y))); Elim (tech_mult_pos_succZ n y).
Elim (mult_commut (S n) (S y)); Intros; Elim H0; Unfold posOZ; Reflexivity.
(* (S n) (S y) *)
Intros y H y0 H0; Unfold posOZ; Elim (plus_n_Sm (mult (S y0) (S n)) y).
Intros; Rewrite (eq_add_S n0 (plus (mult (S y0) (S n)) y) H1).
Rewrite (tech_mult_pos_succZ2 n y0).
Rewrite (tech_add_pos_posZ (plus (mult (S n) y0) n) y).
Elim (plus_sym n (mult (S n) y0)); Elim (mult_commut y0 (S n)); Simpl.
Reflexivity.
Save.

(**************)
Lemma tech_div2.
Statement (n0, n, q: nat)
  <nat> (S n0) = (mult q (S n)) -> <Z> (neg n0) = (multZ (pos n) (negOZ q)).

Goal.
Intros n0 n q; Elim q.
(* O *)
Simpl; Intros; Absurd (<nat> (S n0) = O). Discriminate. Exact H.
(* S y *)
Intros y H; Unfold negOZ. Rewrite (tech_mult_pos_negZ n y); Intros.
Rewrite (eq_add_S n0 (plus n (mult y (S n))) H0).
Elim (mult_commut (S n) y); Simpl; Elim (plus_sym (plus n y) (mult n y)).
Elim (plus_assoc_l n y (mult n y)); Reflexivity.
Save.

(***************)
Lemma tech_div31.
Statement (n, q: nat)
  <Z> (addZ (oppZ (multZ (pos n) (pos q))) (pos n)) = 
      (oppZ (multZ (pos n) (posOZ q))).

Goal.
Intros; Elim q.
(* O *)
Unfold posOZ; Rewrite (mult_OZ (pos n)). 
Cut (<Z> IZ = (pos O)); Intros. Elim H. Rewrite (mult_IZ (pos n)).
Elim (addZ_opposite (pos n) I); Intros; Elim H1; Intros; Elim H3; Intros.
Rewrite H5; Unfold oppZ; Reflexivity. Reflexivity.
(* S y *)
Intros; Unfold posOZ; Elim (multZ_commutativity (pos (S y)) (pos n)).
Rewrite (tech_mult_posZ y (pos n)).
Rewrite (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity (multZ (pos y) (pos n)) (pos n) I I).
Elim (addZ_associativity (oppZ (multZ (pos y) (pos n))) (oppZ (pos n)) (pos n)).
Elim (addZ_opposite (pos n) I); Intros; Elim H1; Intros; Elim H3; Intros.
Rewrite H5; Rewrite (add_OZ (oppZ (multZ (pos y) (pos n)))).
Elim (multZ_commutativity (pos y) (pos n)); Reflexivity.
Save.

(***************)
Lemma tech_div32.
Statement (n, q, r: nat)
  (gt (S n) r) -> <Z> (pos (minus n r)) = (addZ (pos n) (oppZ (posOZ r))).

Goal.
Intros n q r; Elim r.
(* O *)
Unfold posOZ; Unfold oppZ; Rewrite (add_OZ (pos n)); Elim (minus_n_O n).
Reflexivity.
(* S y *)
Intros y H; Unfold posOZ; Unfold oppZ; Symmetry. 
Exact (tech_add_pos_neg_posZ n y (gt_S_n y n H0)).
Save.

(**************)
Lemma tech_div3.
Statement (n0, n, q, r: nat)
  <nat> (S n0) = (plus (mult q (S n)) r) -> (gt (S n) r) -> 
  <Z> (neg n0) = (addZ (multZ (pos n) (neg q)) (pos (minus n r))).

Goal.
Intros.
Elim (tech_opp_pos_negZ q); Intros; Elim H1.
Rewrite (mult_oppZ_r (pos n) (pos q)); Rewrite (tech_div32 n q r H0).
Rewrite (addZ_associativity (oppZ (multZ (pos n) (pos q))) (pos n) (oppZ (posOZ r))).
Rewrite (tech_div31 n q).
Elim (opp_add Z IdZ addZ OZ oppZ Z_group addZ_commutativity (multZ (pos n) (posOZ q)) (posOZ r) I I).
Elim (tech_div1 n0 n q r H); Unfold oppZ; Reflexivity.
Save.

(**************)
Lemma tech_div4.
Statement (n0, n, q, r: nat)
  <nat> (S n0) = (plus (mult q (S n)) r) -> 
  <Z> (pos n0) = (addZ (multZ (neg n) (negOZ q)) (posOZ r)).

Goal.
Intros; Cut <Z> (multZ (neg n) (negOZ q)) = (multZ (pos n) (posOZ q)); Intros.
Rewrite H0; Intros; Exact (tech_div1 n0 n q r H).
Cut (<Z> (negOZ q) = (oppZ (posOZ q))); Intros. Rewrite H0.
Elim (tech_opp_pos_negZ n); Intros; Elim H1.
Apply (mult_opp_opp Z IdZ addZ multZ OZ oppZ Z_ring (pos n) (posOZ q) I I).
Elim q; Simpl; Reflexivity.
Save.

(**************)
Lemma tech_div5.
Statement (n0, n, q: nat)
  <nat> (S n0) = (mult q (S n)) -> <Z> (neg n0) = (multZ (neg n) (posOZ q)).

Goal.
Intros; Cut (<Z> (posOZ q) = (oppZ (negOZ q))); Intros. Rewrite H0.
Elim (tech_opp_pos_negZ n); Intros; Elim H1.
Rewrite (mult_opp_opp Z IdZ addZ multZ OZ oppZ Z_ring (pos n) (negOZ q) I I).
Exact (tech_div2 n0 n q H).
Elim q; Simpl; Reflexivity.
Save.

(**************)
Lemma tech_div6.
Statement (n0, n, q, r: nat)
  <nat> (S n0) = (plus (mult q (S n)) r) -> (gt (S n) r) -> 
  <Z> (neg n0) = (addZ (multZ (neg n) (pos q)) (pos (minus n r))).

Goal.
Intros.
Elim (tech_opp_pos_negZ q); Intros; Elim H2.
Elim (tech_opp_pos_negZ n); Intros; Elim H3.
Rewrite (mult_opp_opp Z IdZ addZ multZ OZ oppZ Z_ring (pos n) (neg q) I I).
Apply (tech_div3 n0 n q r H H0).
Save.

(****************)
Lemma inversibleZ.
Statement (x: Z) 
  (inversible Z multZ IZ x) -> ((<Z> x = IZ) \/ (<Z> x = (oppZ IZ))).

Goal.
Intros x; Elim x.
(* OZ *)
Intros; Elim H; Intros; Elim H0; Intros; Elim H1.
Unfold multZ; Left; Reflexivity.
(* pos n *)
Intros n; Elim n.
(* pos O *)
Intros; Left; Reflexivity.
(* pos (S y) *)
Intros; Elim H0; Intros; Elim H1; Intros.
Absurd <Z> (multZ (pos (S y)) x0) = IZ. Elim x0.
Rewrite (mult_OZ (pos (S y))). Discriminate.
Intros; Rewrite (tech_mult_pos_posZ (S y) n0).
Elim (plus_sym (plus (S y) n0) (mult (S y) n0)).
Elim (plus_assoc_l (S y) n0 (mult (S y) n0)); Simpl.
Apply (tech_pos_not_posZ (S (plus y (plus n0 (plus n0 (mult y n0))))) O).
Discriminate.
Intros; Rewrite (tech_mult_pos_negZ (S y) n0).
Elim (plus_sym (plus (S y) n0) (mult (S y) n0)).
Elim (plus_assoc_l (S y) n0 (mult (S y) n0)); Simpl; Discriminate.
Exact H2.
(* neg n *) 
Intros n; Elim n.
(* neg O *)
Right; Unfold oppZ; Reflexivity.
(* neg (S y) *)
Intros; Elim H0; Intros; Elim H1; Intros.
Absurd <Z> (multZ (neg (S y)) x0) = IZ. Elim x0.
Rewrite (mult_OZ (neg (S y))). Discriminate.
Intros; Rewrite (tech_mult_neg_posZ (S y) n0).
Elim (plus_sym (plus (S y) n0) (mult (S y) n0)).
Elim (plus_assoc_l (S y) n0 (mult (S y) n0)); Simpl; Discriminate.
Intros; Rewrite (tech_mult_neg_negZ (S y) n0).
Elim (plus_sym (plus (S y) n0) (mult (S y) n0)).
Elim (plus_assoc_l (S y) n0 (mult (S y) n0)); Simpl.
Apply (tech_pos_not_posZ (S (plus y (plus n0 (plus n0 (mult y n0))))) O).
Discriminate.
Exact H2.
Save.

(************)
Lemma sgn_abs.
Statement (x: Z) <Z> (multZ x (sgnZ x)) = (absZ x).

Goal.
Intros; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Unfold sgnZ; Unfold absZ.
Intros; Exact (mult_IZ (pos n)).
(* neg n *)
Intros; Unfold sgnZ; Unfold absZ.
Intros; Exact (mult_mIZ (neg n)).
Save.

Provide Zmult.
