(*****************************************************************************)
(* Onred on Z for chinese remainderings theorem proof                         *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(**************)
(* order on Z *)
(**************)

(************)
Definition leZ =
  [x, y: Z] (<Prop> Match x with 
    (* OZ *) (<Prop> Match y with
       (* OZ *)    True
       (* pos n *) [n: nat] True
       (* neg n *) [n: nat] False)
    (* pos n *) [n: nat] (<Prop> Match y with
       (* OZ *)    False
       (* pos m *) [m: nat] (le n m)
       (* neg m *) [m: nat] False)
    (* neg n *) [n: nat] (<Prop> Match y with
       (* OZ *)    True
       (* pos m *) [m: nat] True
       (* neg m *) [m: nat] (le m n))).

(**************)
Lemma sign_absZ.
Statement (x: Z) (leZ OZ (absZ x)).

Goal.
Intros; Elim x; Simpl. Exact I. Intro; Simpl. Exact I. Intro; Simpl. Exact I.
Save.

(********************)
Lemma tech_le_pos_abs.
Statement (x: Z) (leZ OZ x) -> <Z> (absZ x) = x.

Goal.
Intros x; Elim x. 
Unfold absZ; Reflexivity. Unfold absZ; Reflexivity. Intros; Elim H.
Save.

(************************)
Theorem leZ_antisymmetric.
Statement (antisym Z leZ).

Goal.
Unfold antisym; Intros x y; Elim x.
(* OZ *)
Elim y.
(* OZ OZ *)
Reflexivity.
(* OZ (pos n) *)
Intros; Elim H0.
(* OZ (neg n) *)
Intros; Elim H.
(* (pos n) *)
Intros n; Elim y.
(* (pos n) OZ *)
Intros; Elim H.
(* (pos n) (pos n0) *)
Simpl; Intros; Elim (le_antisym n n0 H H0); Reflexivity.
(* (pos n) (neg n0) *)
Intros; Elim H.
(* (neg n) *)
Intros n; Elim y.
(* (neg n) OZ *)
Intros; Elim H0.
(* (neg n) (pos n0) *)
Intros; Elim H0.
(* (neg n) (neg n0) *)
Simpl; Intros; Elim (le_antisym n0 n H H0); Reflexivity.
Save.

(************)
Definition ltZ = [x, y: Z] (leZ (succZ x) y).

(****************)
Definition lt_absZ = [x, y: Z] (ltZ (absZ x) (absZ y)).

(*******************)
Lemma tech_lt_abs_OZ.
Statement (x: Z) (lt_absZ x (pos O)) -> <Z> x = OZ.

Goal.
Induction x.
(* OZ *)
Reflexivity.
(* pos n *)
Unfold lt_absZ; Unfold absZ; Unfold ltZ; Unfold leZ; Intros. 
Elim (le_Sn_O n H).
(* neg n *)
Unfold lt_absZ; Unfold absZ; Unfold ltZ; Unfold leZ; Intros. 
Elim (le_Sn_O n H).
Save.

(*******************)
Lemma tech_posOZ_pos.
Statement (n: nat) (leZ OZ (posOZ n)).

Goal.
Intros; Elim n. Simpl; Exact I. Simpl; Intros; Exact I.
Save.

(**************)
Lemma le_opp_OZ_l.
Statement (x: Z) (leZ OZ x) -> (leZ (oppZ x) OZ).

Goal.
Intros x; Elim x. Simpl; Intros; Exact I. Simpl; Intros; Exact I. 
Intros; Elim H.
Save.

(**************)
Lemma le_opp_OZ.
Statement (x, y: Z) (<Z> x = (oppZ y)) -> (leZ OZ x) -> (leZ OZ y) ->
  (<Z> x = OZ).

Goal.
Intros. Apply (leZ_antisymmetric x OZ). Rewrite H. Exact (le_opp_OZ_l y H1).
Exact H0.
Save.

(***************)
Lemma le_opp_OZ2.
Statement (x, y: Z) (<Z> x = (oppZ y)) -> (leZ OZ x) -> (leZ OZ y) ->
  (<Z> x = y).

Goal.
Intros.
Rewrite (le_opp_OZ x y H H0 H1). 
Rewrite (opp_opp Z IdZ addZ OZ oppZ Z_group y I); Elim H.
Rewrite (le_opp_OZ x y H H0 H1); Simpl; Reflexivity.
Save.

Provide Zle.
