(*****************************************************************************)
(* Gcd, Bezout and chinese remainderings theorem proofs                      *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(***************************)
Lemma gcd_unicity_apart_sign.
Statement (a, b, d1, d2: Z) 
  (is_gcd Z IdZ multZ OZ a b d1) -> (is_gcd Z IdZ multZ OZ a b d2) -> 
  (<Z> d2 = d1) \/ (<Z> d2 = (oppZ d1)).

Goal.
Intros.
Elim (gcd_unicity_apart_unities Z IdZ addZ multZ OZ IZ oppZ Z_unitary_commutative_ring integrityZ a b d1 d2 H H0).
Intros.
Elim (inversibleZ x); Intros.
Left. Elim H1; Intros; Elim H4; Intros. Rewrite H6. Rewrite H2. 
Exact (mult_IZ d1).
Right. Elim H1; Intros; Elim H4; Intros. Rewrite H6. Rewrite H2.
Simpl; Exact (mult_mIZ d1).
Elim H1; Intros; Exact H2.
Save.

(***********)
Lemma gcd_OZ_absZ.
Statement (b: Z) (is_gcd Z IdZ multZ OZ OZ b (absZ b)).

Goal.
Intros. Elim (abs_eq_or_oppZ b); Intros.
(* |b|=b *)
Rewrite a.
Unfold is_gcd; Split.
Unfold divide; Unfold IdZ; Split. Exact I. Split. Exact I. Left; Reflexivity.
Split; Unfold divide; Unfold IdZ. Split. Exact I. Split. Exact I.
Elim (eq_OZ_dec b); Intros. 
Left; Exact a0.
Right. Split. Exact b0. Exists IZ. Split. Exact I. Symmetry; Exact (mult_IZ b).
Intros; Exact H0.
(* |b|=(-b) *)
Rewrite b0.
Unfold is_gcd; Split.
Unfold divide; Unfold IdZ; Split. Exact I. Split. Exact I. Left; Reflexivity.
Split; Unfold divide; Unfold IdZ; Split. Exact I. Split. Exact I.
Elim (eq_OZ_dec b); Intros. 
Left; Exact a.
Right. Split.
Unfold not; Intros; Elim b1.
Exact (opp_O Z IdZ addZ multZ OZ oppZ Z_ring b I H).
Exists (oppZ IZ); Split. Exact I.
Rewrite (mult_opp_opp Z IdZ addZ multZ OZ oppZ Z_ring b IZ I I).
Symmetry; Exact (mult_IZ b). Exact I. Split. Exact I.
Elim H0; Intros; Elim H2; Intros; Elim H4; Intros. Rewrite H5. 
Left; Reflexivity.
Right; Split. Elim H5; Intros; Exact H6. Elim H5; Intros; Elim H7; Intros.
Exists (oppZ x). Split. Exact I. Elim H8; Intros; Rewrite H10.
Symmetry; Exact (mult_opp_r Z IdZ addZ multZ OZ oppZ Z_ring q x I I).
Save.

(******************)
Inductive Definition is_gcdZ: Z -> Z -> Z -> Prop =
  gcd_OZ: (b: Z) (is_gcdZ OZ b (absZ b))
| gcd_mod: (b, a, d, q, r: Z) ~(<Z> b = OZ) -> (is_diveuclZ a b q r) -> 
               (is_gcdZ r b d) -> (is_gcdZ b a d).

(******************)
Inductive Definition have_gcdZ [a, b: Z]: Set
  = gcdZ_i: (d: Z) (is_gcdZ a b d) -> (have_gcdZ a b).

(*******************)
Lemma gcdZ_exists.
Statement (a, b: Z) (have_gcdZ a b).

Goal.
Realizer [b: Z] (recZ (Z -> Z) 
  [q: Z] [f: Z -> Z -> Z] 
    (<Z -> Z> if (eq_OZ_dec q)
                 then (* b = OZ *) absZ
                 else (* b <> OZ *) [a: Z] 
                   <Z> let (div, rem: Z) = (divZ a q) in
                         (f rem q))
    b).
Program_all.
(* (is_gcdZ n OZ OZ) *)
Rewrite a0; Apply (gcd_OZ OZ).
(* (is_gcdZ n (pos n0) (pos n0)) *)
Rewrite a0; Apply (gcd_OZ (pos n0)).
(* (is_gcdZ n (neg n0) (pos n0)) *)
Rewrite a0; Apply (gcd_OZ (neg n0)).
(* is_gcdZ (n, b0, d) with is_gcdZ (r, n, d) *)
Apply (gcd_mod n b0 d q r b i i0).
(* (lt_absZ r n) *)
Elim i; Intros; Elim H1; Intros; Elim H3; Intros.
Unfold lt_absZ; Rewrite (tech_le_pos_abs r H2); Exact H4.
Save.

(****************)
Lemma gcdZ_is_gcd.
Statement (a, b, d: Z) (is_gcdZ a b d) -> (is_gcd Z IdZ multZ OZ a b d).

Goal.
Intros. Elim H; Intros. Apply (gcd_OZ_absZ b0). Unfold is_gcd.
Split. Elim H3; Intros; Elim H5; Intros; Exact H6.
Split. Elim H1; Intros; Elim H5; Intros; Elim H7; Intros; Rewrite H9.
Apply (div_add Z IdZ addZ multZ OZ oppZ Z_ring (multZ b0 q) r d0).
Elim H3; Intros; Elim H11; Intros. 
Exact (div_mult Z IdZ addZ multZ OZ oppZ Z_ring b0 q d0 H12 I).
Elim H3; Intros; Exact H10.
Intros. Elim H3; Intros; Elim H7; Intros. Apply (H9 q0).
Cut (<Z> r = (addZ a0 (oppZ (multZ b0 q)))); Intros. Rewrite H10.
Apply (div_add Z IdZ addZ multZ OZ oppZ Z_ring a0 (oppZ (multZ b0 q)) q0 H5).
Apply (div_opp Z IdZ addZ multZ OZ oppZ Z_ring (multZ b0 q) q0).
Exact (div_mult Z IdZ addZ multZ OZ oppZ Z_ring b0 q q0 H4 I).
Elim H1; Intros; Elim H11; Intros; Elim H13; Intros; Rewrite H15.
Elim (addZ_commutativity r (multZ b0 q)).
Elim (addZ_associativity r (multZ b0 q) (oppZ (multZ b0 q))).
Elim (addZ_opposite (multZ b0 q) I); Intros. 
Elim H17; Intros. Elim H19; Intros. Rewrite H20. Symmetry. Exact (add_OZ r).
Exact H4.
Save.

(*************)
Definition gcdZ = 
  [a, b: Z] (pi1 Z (is_gcdZ a b) (gcdZ_exists a b)).

(*******************)
Theorem gcdZ_correct.
Statement (a, b: Z) (is_gcdZ a b (gcdZ a b)).
Proof [a, b: Z] (pi2 Z (is_gcdZ a b) (gcdZ_exists a b)).

(*********************)
Lemma positive_is_gcdZ.
Statement (a, b, d: Z) 
  (is_gcdZ a b d) -> (leZ OZ d).

Goal.
Intros; Elim H; Intros. Apply (sign_absZ b0). Exact H3.
Save.

(********************)
Lemma unicity_is_gcdZ.
Statement (a, b, d1, d2: Z) 
  (is_gcdZ a b d1) -> (is_gcdZ a b d2) -> <Z> d2 = d1.

Goal.
Intros.
Elim (gcd_unicity_apart_sign a b d1 d2 (gcdZ_is_gcd a b d1 H) (gcdZ_is_gcd a b d2 H0)).
Intros; Exact H1.
Intros; Apply (le_opp_OZ2 d2 d1 H1 (positive_is_gcdZ a b d2 H0) (positive_is_gcdZ a b d1 H)).
Save.

(*****************)
Lemma gcdZ_is_gcdZ.
Statement (a, b, d: Z)
  (is_gcdZ a b d) -> (<Z> d = (gcdZ a b)).

Goal.
Intros. Apply (unicity_is_gcdZ a b (gcdZ a b) d (gcdZ_correct a b) H).
Save.

(*************)
Lemma gcd_modZ.
Statement (a, b, q, r: Z) 
  ~(<Z> b = OZ) -> (is_diveuclZ a b q r) -> <Z> (gcdZ r b) = (gcdZ b a). 

Goal.
Intros. Apply (gcdZ_is_gcdZ b a (gcdZ r b)).
Apply (gcd_mod b a (gcdZ r b) q r H H0 (gcdZ_correct r b)).
Save.

(*********************************)
Inductive Definition verify_BezoutZ [a, b: Z]: Set =
  Bezout_i: (u, v: Z) <Z> (addZ (multZ a u) (multZ b v)) = (gcdZ a b) -> 
            (verify_BezoutZ a b).

(********************)
Lemma Bezout_exists.
Statement (a, b: Z) (verify_BezoutZ a b).

Goal.
Realizer [b: Z] (recZ (Z -> Z*Z) 
  [q: Z] [f: Z -> Z -> Z*Z] 
    (<Z -> Z*Z> if (eq_OZ_dec q)
                 then (* b = OZ *) [a: Z] <Z, Z> (IZ, (sgnZ a))
                 else (* b <> OZ *) [a: Z]  
                   <Z*Z> let (div, rem: Z) = (divZ a q) in
                   <Z*Z> let (u, v: Z) = (f rem q) in 
                     <Z, Z> ((addZ v (oppZ (multZ div u))), u)) b).
Program_all.
Rewrite a0. Simpl. Rewrite (sgn_abs b). 
Apply gcdZ_is_gcdZ.
Apply (gcd_OZ b).
Elim i; Intros; Elim H1; Intros; Elim H3; Intros. Pattern 1 b0. Rewrite H5.
Clear H0 H1 H2 H3 H4 H5.
Elim (mult_add_distributivity n v (oppZ (multZ q u))); Intros.
Rewrite H1; Clear H0 H1.
Elim (mult_add_distributivity (multZ n q) r u); Intros. 
Rewrite H0; Clear H0 H1.
Rewrite (mult_opp_r Z IdZ addZ multZ OZ oppZ Z_ring n (multZ q u) I I).
Elim (addZ_commutativity (multZ r u) (multZ (multZ n q) u)).
Rewrite (add_add Z addZ addZ_commutativity addZ_associativity (multZ n v) (oppZ (multZ n (multZ q u))) (multZ r u) (multZ (multZ n q) u)).
Elim (addZ_commutativity (multZ r u) (multZ n v)). Rewrite e.
Elim (multZ_associativity n q u).
Elim (addZ_opposite (multZ n (multZ q u)) I); Intros. 
Elim H1; Intros; Elim H3; Intros; Rewrite H5; Clear H0 H1 H2 H3 H4 H5. 
Rewrite (add_OZ (gcdZ r n)). Exact (gcd_modZ b0 n q r b i).
Unfold lt_absZ. Elim i; Intros; Elim H1; Intros. 
Rewrite (tech_le_pos_abs r H2). Elim H3; Intros; Exact H4.
Save.

(******************)
Definition congruentZ = 
  [x, y, n: Z] (divide Z IdZ multZ OZ n (addZ x (oppZ y))).

(*****************)
Lemma divide_selfZ.
Statement (x: Z) (divide Z IdZ multZ OZ x x).

Goal.
Intros. Unfold divide. Split. Exact I. Split. Exact I.
Elim (eq_OZ_dec x); Intros. Left; Exact a.
Right; Split. Exact b. Exists IZ. Split. Exact I. Symmetry; Exact (mult_IZ x).
Save.

(**********************************)
Theorem chinese_remaindering_theorem.
Statement (a, b, x, y: Z) <Z> (gcdZ a b) = IZ -> 
  <Z> Ex ([z: Z] (congruentZ z x a) /\ (congruentZ z y b)).

Goal.
Intros. Elim (Bezout_exists a b); Intros.
Exists (addZ (multZ x (multZ b v)) (multZ y (multZ a u))).
Unfold congruentZ. Split.
(* congruentZ (z, x, a) *)
Cut (<Z> (multZ b v) = (addZ IZ (oppZ (multZ a u)))); Intros.
Rewrite H0; Clear H0.
Elim (mult_add_distributivity x IZ (oppZ (multZ a u))); Intros.
Rewrite H1; Clear H0 H1. Rewrite (mult_IZ x).
Elim (mult_opp_r Z IdZ addZ multZ OZ oppZ Z_ring a u I I).
Rewrite (multZ_associativity x a (oppZ u)). Elim (multZ_commutativity a x).
Elim (multZ_associativity a x (oppZ u)). Rewrite (multZ_associativity y a u).
Elim (multZ_commutativity a y). Elim (multZ_associativity a y u).
Elim (addZ_associativity x (multZ a (multZ x (oppZ u))) (multZ a (multZ y u))).
Elim (addZ_commutativity (addZ (multZ a (multZ x (oppZ u))) (multZ a (multZ y u))) x).
Elim (addZ_associativity (addZ (multZ a (multZ x (oppZ u))) (multZ a (multZ y u))) x (oppZ x)).
Elim (addZ_opposite x I); Intros. Elim H1; Intros. Elim H3; Intros. 
Rewrite H4; Clear H0 H1 H2 H3 H4 H5.
Rewrite (add_OZ (addZ (multZ a (multZ x (oppZ u))) (multZ a (multZ y u)))).
Apply (div_add Z IdZ addZ multZ OZ oppZ Z_ring (multZ a (multZ x (oppZ u))) (multZ a (multZ y u)) a).
Apply (div_mult Z IdZ addZ multZ OZ oppZ Z_ring a (multZ x (oppZ u)) a (divide_selfZ a) I).
Apply (div_mult Z IdZ addZ multZ OZ oppZ Z_ring a (multZ y u) a (divide_selfZ a) I).
Elim H. Elim e.
Elim (addZ_commutativity (multZ b v) (multZ a u)).
Elim (addZ_associativity (multZ b v) (multZ a u) (oppZ (multZ a u))).
Elim (addZ_opposite (multZ a u) I); Intros. Elim H1; Intros. Elim H3; Intros.
Rewrite H4; Clear H0 H1 H2 H3 H4 H5. Symmetry; Exact (add_OZ (multZ b v)).
(* congruentZ (z y b) *)
Cut (<Z> (multZ a u) = (addZ IZ (oppZ (multZ b v)))); Intros.
Rewrite H0; Clear H0.
Elim (mult_add_distributivity y IZ (oppZ (multZ b v))); Intros.
Rewrite H1; Clear H0 H1. Rewrite (mult_IZ y).
Elim (mult_opp_r Z IdZ addZ multZ OZ oppZ Z_ring b v I I).
Rewrite (multZ_associativity y b (oppZ v)). Elim (multZ_commutativity b y).
Elim (multZ_associativity b y (oppZ v)). Rewrite (multZ_associativity x b v).
Elim (multZ_commutativity b x). Elim (multZ_associativity b x v).
Elim (addZ_commutativity (multZ b (multZ y (oppZ v))) y).
Rewrite (addZ_associativity (multZ b (multZ x v)) (multZ b (multZ y (oppZ v))) y).
Elim (addZ_associativity (addZ (multZ b (multZ x v)) (multZ b (multZ y (oppZ v)))) y (oppZ y)).
Elim (addZ_opposite y I); Intros. Elim H1; Intros. Elim H3; Intros.
Rewrite H4; Clear H0 H1 H2 H3 H4 H5.
Rewrite (add_OZ (addZ (multZ b (multZ x v)) (multZ b (multZ y (oppZ v))))).
Apply (div_add Z IdZ addZ multZ OZ oppZ Z_ring (multZ b (multZ x v)) (multZ b (multZ y (oppZ v))) b).
Apply (div_mult Z IdZ addZ multZ OZ oppZ Z_ring b (multZ x v) b (divide_selfZ b) I).
Apply (div_mult Z IdZ addZ multZ OZ oppZ Z_ring b (multZ y (oppZ v)) b (divide_selfZ b) I).
Elim H. Elim e.
Elim (addZ_associativity (multZ a u) (multZ b v) (oppZ (multZ b v))).
Elim (addZ_opposite (multZ b v) I); Intros. Elim H1; Intros. Elim H3; Intros.
Rewrite H4; Clear H0 H1 H2 H3 H4 H5. Symmetry; Exact (add_OZ (multZ a u)).
Save.

Provide Zgcd.
