(*****************************************************************************)
(* Division on Z for chinese remainderings theorem proof                     *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(********************)
Definition is_diveuclZ = [a, b, q, r: Z] 
  ~(<Z> b = OZ) /\ (leZ OZ r) /\ (ltZ r (absZ b)) /\ 
  (<Z> a = (addZ (multZ b q) r)).

(***************************)
Inductive Definition diveuclZ [a, b: Z]: Set
  = divexZ: (q, r: Z) (is_diveuclZ a b q r) -> (diveuclZ a b).

(************************)
Lemma divZ.
Statement (a, b: Z) ~(<Z> b = OZ) -> (diveuclZ a b).

Goal.
Realizer [a, b: Z] 
  (<Z*Z> Match b with
      (* OZ *) (except (Z*Z))
      (* pos m *) [m: nat] (<Z*Z> Match a with 
         (* OZ *) (<Z, Z> (OZ, OZ))
         (* pos n *) [n: nat] <Z*Z> let (q, r: nat) = (eucl_dev (S m) (S n)) in
            <Z, Z> ((posOZ q), (posOZ r))
         (* neg n *) [n: nat] <Z*Z> let (q, r: nat) = (eucl_dev (S m) (S n)) in
            (<Z*Z> if (eq_gt_O_dec r)
               then (* r = O *) <Z, Z> ((negOZ q), OZ)
               else (* gt r O *) <Z, Z> ((neg q), (pos (minus m r)))))
      (* neg m *) [m: nat] (<Z*Z> Match a with 
         (* OZ *) (<Z, Z> (OZ, OZ))
         (* pos n *) [n: nat] <Z*Z> let (q, r: nat) = (eucl_dev (S m) (S n)) in
            <Z, Z> ((negOZ q), (posOZ r))
         (* neg n *) [n: nat] <Z*Z> let (q, r: nat) = (eucl_dev (S m) (S n)) in
            (<Z*Z> if (eq_gt_O_dec r)
               then (* r = O *) <Z, Z> ((posOZ q), OZ)
               else (* gt r O *) <Z, Z> ((pos q), (pos (minus m r)))))).
Program_all.

(*Elim H; Reflexivity.*)

Unfold is_diveuclZ; Split. Discriminate. Split. Simpl. Exact I. 
Split. Unfold ltZ; Simpl; Exact (le_O_n n).
Rewrite -> (mult_OZ (pos n)); Unfold addZ; Reflexivity.

Unfold is_diveuclZ; Split. Discriminate. Split. Apply (tech_posOZ_pos r).
Split; Simpl; Unfold ltZ; Rewrite -> (tech_succ_posOZ r).
Simpl; Exact (gt_S_le r n g).
Apply (tech_div1 n0 n q r e).

Unfold is_diveuclZ; Split. Discriminate. Split. Exact I.
Split. Unfold ltZ; Simpl; Exact (le_O_n n).
Rewrite -> (add_OZ (multZ (pos n) (negOZ q))). Apply (tech_div2 n0 n q).
Rewrite -> (plus_n_O (mult q (S n))); Elim a0; Exact e.

Unfold is_diveuclZ; Split. Discriminate. Split. Simpl. Exact I.
Split. Unfold ltZ; Simpl. Unfold gt in b0. 
Exact (lt_le_S (minus n r) n (lt_minus n r (gt_S_le r n g) b0)).
Apply (tech_div3 n0 n q r e g).

Unfold is_diveuclZ. Split. Discriminate. Split. Simpl. Exact I.
Split. Unfold ltZ; Simpl; Exact (le_O_n n).
Rewrite -> (mult_OZ (neg n)); Unfold addZ; Reflexivity.

Unfold is_diveuclZ. Split. Discriminate. Split. Apply (tech_posOZ_pos r).
Split. 
Unfold ltZ; Rewrite -> (tech_succ_posOZ r); Simpl; Exact (gt_S_le r n g).
Apply (tech_div4 n0 n q r e).

Unfold is_diveuclZ. Split. Discriminate. Split. Simpl; Exact I.
Split. Unfold ltZ; Simpl; Exact (le_O_n n).
Rewrite -> (add_OZ (multZ (neg n) (posOZ q))). Apply (tech_div5 n0 n q).
Rewrite -> (plus_n_O (mult q (S n))); Elim a0; Exact e.

Unfold is_diveuclZ. Split. Discriminate. Split. Simpl; Exact I.
Split. Unfold ltZ; Simpl.
Exact (lt_le_S (minus n r) n (lt_minus n r (gt_S_le r n g) b0)).
Apply (tech_div6 n0 n q r e g).
Save.
 
Provide Zdiv.
