(*****************************************************************************)
(* Definition of Z and miscellaneous trivial lemmas                          *)
(*  for chinese remainderings theorem proof                                  *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(* Basic definitions on type Z *)

(*************)
Inductive Set Z = OZ: Z | pos: nat -> Z | neg: nat -> Z.

(***********)
Definition IZ = (pos O).

(****************)
Definition is_posn =
  [x, y: Z] (<Prop> Match x with
    (* OZ *) False
    (* pos n *) [n: nat] (<Prop> Match y with
       (* OZ *) False
       (* pos m *) [m: nat] (<nat> n = m)
       (* neg m *) [m: nat] False)
    (* neg n *) [n: nat] False).

(**********************)
Lemma tech_pos_not_posZ.
Statement (n, m: nat) ~(<nat> n = m) -> ~(<Z> (pos n) = (pos m)).

Goal.
Unfold not; Intros.
Cut (is_posn (pos n) (pos m)).
Simpl; Exact H. Rewrite H0; Simpl; Reflexivity.
Save.

(**************)
Lemma eq_OZ_dec.
Statement (x: Z) {<Z> x = OZ}+{~(<Z> x = OZ)}.

Goal.
Intros; Elim x.
Left; Reflexivity.
Intros; Right; Discriminate.
Intros; Right; Discriminate.
Save.

(**************)
Definition posOZ = 
  [n: nat] (<Z> Match n with
     (* O *) OZ
     (* S n' *) [n': nat][trash: Z] (pos n')).

(**************)
Definition negOZ = 
  [n: nat] (<Z> Match n with
     (* O *) OZ
     (* S n' *) [n': nat][trash: Z] (neg n')).

(*************)
Definition absZ =
  [x: Z] (<Z> Match x with 
    (* OZ *)    OZ 
    (* pos n *) [n: nat] (pos n)
    (* neg n *) [n: nat] (pos n)).

(*************)
Definition sgnZ = 
  [x: Z] (<Z> Match x with
    (* OZ *) OZ
    (* pos n *) [n: nat] (pos O)
    (* neg n *) [n: nat] (neg O)).

Provide Zbase.