(*****************************************************************************)
(* Addition on Z for chinese remainderings theorem proof                     *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(* Addition on Z, (Z, +) is a group *)

(*************)
Definition addZ = 
  [x, y: Z] (<Z> Match x with
    (* OZ *)    y
    (* pos n *) [n: nat] (<Z> Match n with 
       (* O *)    (succZ y)
       (* S n1 *) [n1: nat] [q: Z] (succZ q))
    (* neg n *) [n: nat] (<Z> Match n with 
       (* O *)    (predZ y)
       (* S n1 *) [n1: nat] [q: Z] (predZ q))).

(***************)
Lemma succ_addZ_l.
Statement (x, y: Z) <Z> (addZ (succZ x) y) = (succZ (addZ x y)).

Goal.
Intros; Elim x.
(* OZ *)
Reflexivity.
(* pos n *)
Intros; Simpl; Reflexivity.
(* neg n *)
Intros; Elim n. 
Simpl; Symmetry; Exact (succ_predZ y).
Intros; Symmetry; Unfold addZ.
Exact (succ_predZ (<Z>Match y0 with (predZ y) [n1:nat][q:Z](predZ q))).
Save.

(***************)
Lemma pred_addZ_l.
Statement (x, y: Z) <Z> (addZ (predZ x) y) = (predZ (addZ x y)).

Goal.
Intros; Elim x.
(* OZ *)
Reflexivity.
(* pos n *)
Intros; Elim n.
Unfold addZ; Symmetry; Exact (pred_succZ y).
Intros; Unfold addZ; Symmetry. 
Exact (pred_succZ (<Z>Match y0 with (succZ y) [n1:nat][q:Z](succZ q))).
(* neg n *)
Intros; Simpl; Reflexivity.
Save.

(**********************)
Lemma tech_add_pos_succZ.
Statement (x: nat) (y: Z) <Z> (addZ (pos (S x)) y) = (succZ (addZ (pos x) y)).

Goal.
Intros; Unfold addZ; Reflexivity.
Save.

(**********************)
Lemma tech_add_neg_predZ.
Statement (x: nat) (y: Z) <Z> (addZ (neg (S x)) y) = (predZ (addZ (neg x) y)).

Goal.
Intros; Unfold addZ; Reflexivity.
Save.

(***************)
Lemma succ_addZ_r.
Statement (x, y: Z) <Z> (addZ x (succZ y)) = (succZ (addZ x y)).

Goal.
Intros; Elim x.
(* OZ *)
Unfold addZ; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Unfold addZ; Reflexivity.
(* pos y0 *)
Intros; Rewrite (tech_add_pos_succZ y0 (succZ y)).
Rewrite (tech_add_pos_succZ y0 y); Elim H; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Unfold addZ; Symmetry; Exact (succ_pred_pred_succZ y).
(* neg y0 *)
Intros; Rewrite (tech_add_neg_predZ y0 (succZ y)); Rewrite H.
Rewrite (tech_add_neg_predZ y0 y); Symmetry.
Exact (succ_pred_pred_succZ (addZ (neg y0) y)).
Save.

(***************)
Lemma pred_addZ_r.
Statement (x, y: Z) <Z> (addZ x (predZ y)) = (predZ (addZ x y)).

Goal.
Intros; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* (pos n) *)
Intros; Elim n.
(* (pos O) *)
Simpl; Exact (succ_pred_pred_succZ y).
(* (pos (S y0)) *)
Intros; Rewrite (tech_add_pos_succZ y0 (predZ y)).
Rewrite (tech_add_pos_succZ y0 y). Rewrite H.
Exact (succ_pred_pred_succZ (addZ (pos y0) y)).
(* neg n *)
Intros; Elim n.
(* neg O *)
Unfold addZ; Reflexivity.
(* neg (S y0) *)
Intros; Rewrite (tech_add_neg_predZ y0 (predZ y)).
Rewrite (tech_add_neg_predZ y0 y); Elim H; Reflexivity.
Save.

(***********)
Lemma add_OZ.
Statement (x: Z) <Z> (addZ x OZ) = x.

Goal.
Intros; Pattern x; Elim x.
(* OZ *)
Unfold addZ; Reflexivity.
(* pos n *)
Intros; Elim n.
Simpl; Reflexivity.
Intros; Rewrite (tech_add_pos_succZ y OZ); Rewrite H; Unfold succZ.
Reflexivity.
(* neg n *)
Intros; Elim n.
Simpl; Reflexivity.
Intros; Rewrite (tech_add_neg_predZ y OZ); Rewrite H; Unfold predZ. 
Reflexivity.
Save.

(*****************)
Lemma add_IZ_succZ.
Statement (x: Z) <Z> (addZ x IZ) = (succZ x).

Goal.
Intros.
Cut (<Z> (succZ OZ) = IZ); Intros. Elim H.
Rewrite (succ_addZ_r x OZ); Rewrite (add_OZ x); Reflexivity.
Unfold succZ; Reflexivity.
Save.

(*****************)
Lemma add_mIZ_predZ.
Statement (x: Z) <Z> (addZ x (neg O)) = (predZ x).

Goal.
Intros.
Cut (<Z> (predZ OZ) = (neg O)); Intros. Elim H.
Rewrite (pred_addZ_r x OZ); Rewrite (add_OZ x); Reflexivity.
Unfold succZ; Reflexivity.
Save.

(*************************)
Theorem addZ_commutativity.
Statement (commutativity Z addZ).

Goal.
Unfold commutativity; Intros; Elim x.
(* OZ *)
Simpl; Symmetry; Exact (add_OZ y).
(* pos n *)
Intros; Elim n.
(* pos O *)
Simpl; Symmetry; Exact (add_IZ_succZ y).
(* pos (S y0) *)
Intros; Rewrite (tech_add_pos_succZ y0 y). Rewrite H.
Cut (<Z> (succZ (pos y0)) = (pos (S y0))); Intros. Elim H0.
Rewrite (succ_addZ_r y (pos y0)); Reflexivity.
Unfold succZ; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl; Symmetry; Exact (add_mIZ_predZ y).
(* neg (S y0) *)
Intros; Rewrite (tech_add_neg_predZ y0 y). Rewrite H.
Cut (<Z> (predZ (neg y0)) = (neg (S y0))); Intros. Elim H0.
Rewrite (pred_addZ_r y (neg y0)); Reflexivity.
Unfold predZ; Reflexivity.
Save.

(*************************)
Lemma tech_add_pos_neg_posZ.
Statement (n1, n2: nat) 
  (lt n2 n1) -> <Z> (addZ (pos n1) (neg n2)) = (pos (minus n1 (S n2))).

Goal.
Intro; Intro; Elim n2.
(* O *)
Intros; Elim (addZ_commutativity (neg O) (pos n1)); Unfold addZ. 
Elim (minus_n_Sm n1 O H); Elim (minus_n_O n1); Exact (tech_pred_posZ n1 H).
(* S y *)
Intros; Elim (addZ_commutativity (neg (S y)) (pos n1)).
Rewrite (tech_add_neg_predZ y (pos n1)).
Elim (addZ_commutativity (pos n1) (neg y)).
Rewrite (H (lt_trans y (S y) n1 (lt_n_Sn y) H0)).
Elim (minus_n_Sm n1 (S y) H0). 
Exact (tech_pred_posZ (minus n1 (S y)) (lt_minus2 (S y) n1 H0)).
Save.

(*************************)
Theorem addZ_associativity.
Statement (associativity Z addZ).

Goal.
Unfold associativity; Intros; Elim x.
(* OZ *)
Unfold addZ; Reflexivity.
(* pos n *)
Intros; Elim n.
(* pos O *)
Simpl; Symmetry; Exact (succ_addZ_l y z).
(* pos (S y0) *)
Intros.
Rewrite (tech_add_pos_succZ y0 (addZ y z)); Rewrite (tech_add_pos_succZ y0 y).
Rewrite (succ_addZ_l (addZ (pos y0) y) z); Elim H; Reflexivity.
(* neg n *)
Intros; Elim n.
(* neg O *)
Simpl; Symmetry; Exact (pred_addZ_l y z).
(* neg (S y0) *)
Intros.
Rewrite (tech_add_neg_predZ y0 (addZ y z)); Rewrite (tech_add_neg_predZ y0 y).
Rewrite (pred_addZ_l (addZ (neg y0) y) z); Elim H; Reflexivity.
Save.

(************)
Definition IdZ [x: Z] True.

(*******************)
Theorem addZ_neutral.
Statement (neutral Z IdZ addZ OZ).

Goal.
Unfold neutral; Intros.
Split. Exact I.
Intros. Split. Exact (add_OZ x). Unfold addZ; Reflexivity.
Save.

(*************)
Definition oppZ =
    [x: Z] (<Z> Match x with 
    (* OZ *)    OZ
    (* pos n *) [n: nat] (neg n)
    (* neg n *) [n: nat] (pos n)).

(*************)
Lemma opp_succZ.
Statement (x: Z) <Z> (oppZ (succZ x)) = (predZ (oppZ x)).

Goal.
Intros; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Simpl; Reflexivity.
(* neg n *)
Intros; Elim n. Simpl; Reflexivity. Intros; Simpl; Reflexivity.
Save.

(*************)
Lemma opp_predZ.
Statement (x: Z) <Z> (oppZ (predZ x)) = (succZ (oppZ x)).

Goal.
Intros; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Elim n. Simpl; Reflexivity. Intros; Simpl; Reflexivity.
(* neg n *)
Intros; Simpl; Reflexivity.
Save.

(*********************)
Lemma tech_add_pos_negZ.
Statement (n: nat) <Z> (addZ (pos n) (neg n)) = OZ.

Goal.
Intros; Elim n.
(* O *)
Simpl; Reflexivity.
(* S y *)
Intros; Rewrite (tech_add_pos_succZ y (neg (S y))).
Elim (succ_addZ_r (pos y) (neg (S y))); Unfold succZ; Exact H.
Save.

(*********************)
Lemma tech_add_neg_posZ.
Statement (n: nat) <Z> (addZ (neg n) (pos n)) = OZ.

Goal.
Intros; Elim (addZ_commutativity (pos n) (neg n)); Exact (tech_add_pos_negZ n).
Save.

(*********************)
Lemma tech_add_pos_posZ.
Statement (n: nat) (m: nat) 
  <Z> (addZ (pos n) (pos m)) = (pos (S (plus n m))).

Goal.
Intros; Elim n.
(* O *)
Simpl; Reflexivity.
(* S y *)
Intros; Rewrite (tech_add_pos_succZ y (pos m)); Rewrite H; Simpl; Reflexivity.
Save.

(*********************)
Lemma tech_add_neg_negZ.
Statement (n: nat) (m: nat) 
  <Z> (addZ (neg n) (neg m)) = (neg (S (plus n m))).

Goal.
Intros; Elim n.
(* O *)
Simpl; Reflexivity.
(* S y *)
Intros; Rewrite (tech_add_neg_predZ y (neg m)); Rewrite H; Simpl; Reflexivity.
Save.

(********************)
Theorem addZ_opposite.
Statement (opposite Z IdZ addZ OZ oppZ).

Goal.
Unfold opposite; Unfold is_opposite; Intros.
Split. Exact H.
Split. Exact I.
Split.
(* -> *)
Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Unfold oppZ; Exact (tech_add_pos_negZ n).
(* neg n *)
Intros; Unfold oppZ; Exact (tech_add_neg_posZ n).
(* <- *)
Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Unfold oppZ; Exact (tech_add_neg_posZ n).
(* neg n *)
Intros; Unfold oppZ; Exact (tech_add_pos_negZ n).
Save.

(**************)
Theorem Z_group.
Statement (is_group Z IdZ addZ OZ oppZ).

Goal.
Unfold is_group.
Split. Unfold intern; Intros; Exact I.
Split. Exact addZ_associativity.
Split. Exact addZ_neutral.
Exact addZ_opposite.
Save.

(********************)
Theorem abs_eq_or_oppZ.
Statement (x: Z) {<Z> (absZ x) = x}+{<Z> (absZ x) = (oppZ x)}.

Goal.
Intros; Elim x.
(* OZ *)
Left; Unfold absZ; Reflexivity.
(* pos n *)
Left; Unfold absZ; Reflexivity.
(* neg n *)
Right; Simpl; Reflexivity.
Save.

(*********************)
Lemma tech_opp_pos_negZ.
Statement (n: nat) 
  (<Z> (oppZ (pos n)) = (neg n)) /\ (<Z> (oppZ (neg n)) = (pos n)).

Goal.
Intros; Elim n.
Unfold oppZ; Split; Reflexivity; Reflexivity.
Intros; Unfold oppZ; Split; Reflexivity; Reflexivity.
Save.

Provide Zadd.