(*****************************************************************************)
(* Successor and predecessor on Z for chinese remainderings theorem proof    *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(* Succ and Pred on Z *)

(**************)
Definition succZ = 
  [x: Z] (<Z> Match x with 
    (* OZ *)    IZ 
    (* pos n *) [n: nat] (pos (S n))
    (* neg n *) [n: nat] (<Z> Match n with 
       (* O *)   OZ
       (* S m *) [m: nat] [trash: Z] (neg m))).

(**************)
Definition predZ = 
  [x: Z] (<Z> Match x with 
    (* OZ *)    (neg O)
    (* pos n *) [n: nat] (<Z> Match n with 
       (* O *)   OZ
       (* S m *) [m: nat] [trash: Z] (pos m))
    (* neg n *) [n: nat] (neg (S n))).
    
(***************)
Lemma pred_succZ.
Statement (x: Z) (<Z> (predZ (succZ x)) = x).

Goal.
Intros; Pattern x; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Simpl; Reflexivity.
(* neg n *)
Intros; Elim n.
Simpl; Reflexivity.
Intros; Simpl; Reflexivity.
Save.

(***************)
Lemma succ_predZ.
Statement (x: Z) <Z> (succZ (predZ x)) = x.

Goal.
Intros; Pattern x; Elim x.
(* OZ *)
Simpl; Reflexivity.
(* pos n *)
Intros; Elim n.
Simpl; Reflexivity.
Intros; Simpl; Reflexivity.
(* neg n *)
Simpl; Reflexivity.
Save.

(*************************)
Lemma succ_pred_pred_succZ.
Statement (x: Z) <Z> (succZ (predZ x)) = (predZ (succZ x)).

Goal.
Intros; Rewrite (pred_succZ x); Exact (succ_predZ x).
Save.

(******************)
Lemma tech_pred_posZ.
Statement (n: nat) (lt O n) -> <Z> (predZ (pos n)) = (pos (pred n)).

Goal.
Intro; Elim n; Intro. Elim (lt_n_O O); Exact H. Intros; Simpl; Reflexivity.
Save.

(********************)
Lemma tech_succ_posOZ.
Statement (n: nat) <Z> (succZ (posOZ n)) = (pos n).

Goal.
Intros; Elim n; Simpl; Reflexivity; Simpl; Reflexivity.
Save.

Provide Z_succ_pred.