(*****************************************************************************)
(* Some complements on nats for chinese remainderings theorem proof          *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

Require Nat.
Require Minus.
Require Mult.

(****************)
Lemma eq_gt_O_dec.
Statement (n: nat) {<nat> n = O}+{gt n O}.

Goal.
Intros; Elim n.
Left; Reflexivity.
Intros; Right; Exact (gt_Sn_O y).
Save.

(****************)
Lemma mult_commut.
Statement (n, m: nat) <nat> (mult n m) = (mult m n).

Goal.
Intros; Elim n.
Simpl; Exact (mult_n_O m).
Intros; Simpl; Rewrite H; Elim (mult_n_Sm m y); Exact (plus_sym m (mult m y)).
Save.

(***************)
Lemma mult_neutr.
Statement (n: nat) <nat> (mult (S O) n) = n.

Goal.
Intros; Unfold mult; Symmetry; Exact (plus_n_O n).
Save.

(********************)
Lemma technical_lemma.
Statement (y, m: nat) 
  <nat> (S (plus (plus (mult y m) (plus y m)) m)) = 
        (plus (mult (S y) m) (plus (S y) m)).

Goal.
Intros; Simpl; Elim (plus_sym m (plus (mult y m) (plus y m))).
Rewrite (plus_assoc_l m (mult y m) (plus y m)).
Exact (plus_n_Sm (plus m (mult y m)) (plus y m)).
Save.

(**************)
Lemma lt_minus2.
Statement (n, m: nat) (lt n m) -> (lt O (minus m n)).

Goal.
Intros n m; Elim m.
Intros; Elim (lt_n_O n); Exact H.
Intros; Elim (minus_Sn_m y n (lt_n_Sm_le n y H0)); Exact (lt_O_Sn (minus y n)).
Save.

(***************)
Lemma minus_n_Sm.
Statement (n, m: nat) (lt m n) -> <nat> (pred (minus n m)) = (minus n (S m)).

Goal.
Intros n m; Elim n.
(* O *)
Simpl; Reflexivity.
(* S y *)
Intros; Elim (minus_Sn_m y m (le_S_n m y (lt_le_S m (S y) H0))).
Simpl; Reflexivity.
Save.

(************)
Lemma lt_succ.
Statement (n, m: nat) (le n (S m)) -> {le n m}+{<nat> n = (S m)}.

Goal.
Intros.
Elim (le_lt_eq_dec n (S m) H); Intros.
Left; Exact (lt_n_Sm_le n m a).
Right; Exact b.
Save.

Provide Nat_complements.