(*****************************************************************************)
(* Some definitions on internal composition laws                             *)
(* for chinese remainderings theorem proof                                   *)
(* by Val\'erie M\'enissier-Morain 09/06/93 version 5.8.1 with Discriminate  *)
(*****************************************************************************)

(* Proprie'te's des lois de composition interne *)

(*****************************************************************************)
Section Internal.

Variable S: Set.
Variable G: S -> Prop.
Variable Add: S -> S -> S.
Variable O, I: S.
Variable Opp, Inv: S -> S.
(*****************************************************************************)

(***************)
Definition intern = (x, y: S) (G x) -> (G y) -> (G (Add x y)).

(**********************)
Definition commutativity = (x, y: S) (<S> (Add x y) = (Add y x)).

(**********************)
Definition associativity = 
  (x, y, z: S) (<S> (Add x (Add y z)) = (Add (Add x y) z)).

(****************)
Definition neutral = [S: Set] [G: S -> Prop] [Add: S -> S -> S] [O: S]
  (G O) /\ (x: S) (G x) -> ((<S> (Add x O) = x) /\ (<S> (Add O x) = x)).

(****************)
Lemma neutral_add.
Statement (neutral S G Add O) -> <S> O = (Add O O).

Goal.
Intros; Symmetry.
Elim H; Intros; Elim (H1 O H0); Trivial.
Save.

(********************)
Definition is_opposite = 
  [x, y: S] (G x) /\ (G y) /\ (<S> (Add x y) = O) /\ (<S> (Add y x) = O).

(************)
Lemma opp_com.
Statement commutativity -> 
  (x, y: S) ((G x) -> (G y) -> (<S> (Add x y) = O) -> (is_opposite x y)).

Goal.
Intros. Unfold is_opposite. 
Split. Exact H0. Split. Exact H1. Split. Exact H2. Elim (H x y). Exact H2.
Save.

(*****************)
Definition opposite = 
  (x: S) (G x) -> (is_opposite x (Opp x)).

(***********************)
Definition distributivity = [S: Set] [Add, Mult: S -> S -> S] 
  (x, y, z: S) (<S> (Mult (Add x y) z) = (Add (Mult x z) (Mult y z))) /\
               (<S> (Mult x (Add y z)) = (Add (Mult x y) (Mult x z))).

End Internal.
(*****************************************************************************)

Provide Lci.