(****************************************************************************)
(*                      Rem Theorem in Baire space                          *)
(*                                                                          *)
(*                           Henk Barendregt                                *)
(*                                                                          *)
(*                           Bastad, June 1993                              *)
(*                              Coq V 5.8                                   *)
(****************************************************************************)

(* Needs classical logic *)

Require Classical.

(* Baire Space *)
Definition B = nat->nat.

Definition Top = B -> Prop.

Definition inclusion = [X,Y:Top] (z:B) (X z) -> (Y z).
Definition equal = [X,Y:Top] (inclusion X Y) /\ (inclusion Y X).
Definition complement = [X:Top][z:B] ~(X z).
Definition union = [X,Y:Top][z:B] (X z) \/ (Y z).
Definition inter = [X,Y:Top] [z:B] (X z) /\ (Y z).

Definition neighbour = [f:B][n:nat][g:B](m:nat) (le m n) -> <nat> (f m) = (g m).
Definition open = [X:Top] (f:B) ((X f) -> <nat>Ex ([n:nat] (inclusion (neighbour f n) X))).
Definition closed = [X:Top] (open (complement X)).
Definition dense = [X:Top] (f:B)(n:nat) <B>Ex ([g:B](X g) /\ (neighbour f n g)).
Definition closure = [X:Top][f:B](n:nat) <B>Ex ([g:B] ((X g) /\ (neighbour f n g))).

Lemma refl_neighbour : (n:nat)(x:B)(neighbour x n x).
Goal.
Unfold neighbour; Auto.
Save.
Hint refl_neighbour.

Lemma trans_neighbour : (n:nat)(f,g,h:B)(neighbour f n g) -> (neighbour g n h)
                                     -> (neighbour f n h).
Goal.
Unfold neighbour.
Intros.
Rewrite (H m); Trivial.
Apply H0; Trivial.
Save.

Lemma closedc_clX : (X:Top)(closed (closure X)).
Goal.
Unfold closed closure.
Unfold open complement.
Intros X f complement_clX.
Generalize (not_all_ex_not ([n:nat]<B>Ex ([g:B](X g) /\ (neighbour f n g))) complement_clX). 
Induction 1; Intros n H1.
Exists n.
Unfold inclusion; Intros g fng.
Unfold not; Intro H2.
Apply H1.
Elim (H2 n).
Induction 1; Intros.
Exists x; Split; Trivial.
Apply trans_neighbour with g; Trivial.
Save.
Hint closedc_clX.

Lemma Xinc_clX : (X:Top)(inclusion X (closure X)).
Goal.
Unfold inclusion; Intros X f Xf.
Unfold closure; Intro n.
Exists f; Split; Trivial.
Save.

Lemma Lemma1 : (X:Top)(equal X (inter (closure X) (union X (complement (closure X))))).
Goal.
Unfold equal inclusion; Intro X; Split.
Unfold inter union closure; Intros.
Split.
Intro n; Exists z; Split; Auto.
Left; Trivial.
Unfold inter union closure; Intros.
Elim H; Intros.
Elim H1; Trivial.
Unfold complement; Intros.
Elim (H2 H0).
Save.

Lemma density : (X:Top)(dense (union X (complement (closure X)))).
Goal.
Unfold dense; Intros X f n.
Elim (classic (closure X f)).
Intro clXf.
Elim (clXf n).
Induction 1.
Intros; Exists x.
Split; Trivial.
Unfold union.
Left; Trivial.
Intro notclXf. 
Exists f; Intros.
Split; Trivial.
Unfold union.
Right; Trivial.
Save.
Hint density.

Require Logic_Type. (* To get ExT *)

Theorem Rem : (X:Top)<Top>ExT([Y:Top]<Top>ExT([Z:Top]
                (closed Y) /\ (dense Z) /\ (equal X (inter Y Z)))).
Goal.
Intro X; Exists (closure X).
Exists (union X (complement (closure X))).
Split; Auto.
Split; Auto.
Apply Lemma1.
Save.
Require Lt.

Definition nbh = neighbour.
Definition clopen = [X:Top]((open X)/\(closed X)).

Lemma clopenbasis : (f:B)(n:nat)(clopen (nbh f n)).
Goal.
Intros f n.
Unfold clopen.
Split.
Unfold open; Intro g.
Intro Ofng.
Exists (S n).
Unfold inclusion.
Intros h OhSnz.
Unfold nbh; Unfold neighbour.
Intros m lemn.
Unfold neighbour in OhSnz.
Unfold nbh in Ofng; Unfold neighbour in Ofng.
Generalize (Ofng m lemn).
Intro E; Rewrite E.
Auto.
Unfold closed nbh.
Unfold open complement neighbour.
Intro g.
Intro notgfn.
Exists n.
Unfold inclusion.
Intro h.
Intro hgn.
Unfold not; Intros fhn.
Apply notgfn.
Intros p psn.
Rewrite (fhn p psn).
Rewrite (hgn p psn); Trivial.
Save.



