(*****************************************************************************)
(*      Coq V5.8                                                             *)
(*****************************************************************************)
(*                                                                           *)
(*      First-order Unification                                              *)
(*                                                                           *)
(*      Joseph Rouyer                                                        *)
(*                                                                           *)
(*      November 1992                                                        *)
(*                                                                           *)
(******************* nat_complements.v ***************************************)
(*************** New theorems and lemmas on naturals. ************************)
(*****************************************************************************)

Require Prelude.
Require Specif.
Require Le.

(*********************************************************************)
(************* Lemmas on naturals proved in Nat.v and *****************)
(******************** used with the command "auto". *******************)
(*********************************************************************)
(*O_S      :(n:nat)(~<nat>O=(S n))*)
(*eq_S     :(n:nat)(m:nat)(<nat>n=m)->(<nat>(S n)=(S m))*)
(*eq_add_S :(n:nat)(m:nat)(<nat>(S n)=(S m))->(<nat>n=m)*)
(*le_pred_n:(n:nat)(le (pred n) n)*)
(*le_n_Sn  :(n:nat)(le n (S n))*)
(*le_S_n   :(n:nat)(m:nat)(le (S n) (S m))->(le n m)*)
(*le_Sn_O  :(n:nat)(~(le (S n) O))*)
(*le_n     :(n:nat)(le n n)*)
(*le_n_S   :(n:nat)(m:nat)(le n m)->(le (S n) (S m))*)
(*********************************************************************)

(*********************************************************************)
(********** Logic tools : To translate P:Prop into Q:Set : ****************)
(*********************************************************************)

Definition P_S:(A:Set)(P:A->Prop)A->Set=
[A:Set][P:A->Prop][x:A]{a:A|(<A>a=x)&(P a)}.

Goal (A:Set)(a:A)(P:A->Prop)(P a)->(P_S A P a).
Intros;Unfold P_S;Exists a;Auto.
Save P_S_proof1.

Goal (A:Set)(a:A)(P:A->Prop)(P_S A P a)->(P a).
Unfold P_S;Intros A a P h;Elim h;Intros x h0;Elim h0;Auto.
Save P_S_proof2.

(*********************************************************************)
(***************** Logic tools  To negate an equality : ******************)
(*********************************************************************)

Goal (A:Set)(f:A->Prop)(a,b:A)(f a)->(~(f b))->~<A>a=b.
Unfold not;Intros A f a b H H0 H1;Elim H0;Elim H1;Auto.
Save Diff.

(*** Replace "Apply h;Auto" by "auto" when the Type of h is False : ***)

Goal ~False.
Unfold not;Auto.
Save n_False.
Hint n_False.
(*********************************************************************)

(*********************************************************************)
(**********************) Section complement_nat. (*********************)
(*********************************************************************)

(*********************************************************************)
(**************** Decidability of the equality in the Set nat : *************)
(*********************************************************************)

Goal (x,y:nat){<nat>x=y}+{~<nat>x=y}.
Induction x.           
(*case x=O*)
Induction y;Auto.
(*... case y=O*)(*Apply refl_equal*)
(*... case y=(S z)*)(*Apply O_S*)
(*case x=(S y)*)
Induction y0.
(*... case y0=O*)
Right;Unfold not;Intros;
Absurd <nat>O=(S y);Auto.(*Apply O_S and sym_equal*)
(*... case y0=(S y1)*)
Intros y1 h;Elim (H y1);Intros.
(*... ... case y=y1*)
Auto.(*Apply eq_S*)
(*case not y=y1*)
Right;Unfold not;Intros;Absurd <nat>y=y1;
Auto.(*Apply eq_S*)(*Apply eq_add_S*)
Save nat_eq_decS.

Goal (x,y:nat)(<nat>x=y)\/(~<nat>x=y).
Intros x y;Elim (nat_eq_decS x y);Auto.
Save nat_eq_decP.

(*********************************************************************)
(************** General induction (with le) : ****************************)
(*********************************************************************)

Goal (n:nat)(P:nat->Set)(P O)->((p:nat)((q:nat)(le q p)->(P q))
->(P (S p)))->(P n).
Intros n P;Cut ((m:nat)(le m n)->(P m))->(P n).
2:Auto.(*Apply le_n*)
Intros h h0 h1;Apply h.
Elim n.
(*case n=O*)
(*... case m=O*)
Induction m.
Intros;Auto.
(*... case m=(S y0)*)    
Intros;Absurd (le (S y) O);Auto.(*le_Sn_O*)
(*case n=(S y)*)
Induction m.
(*... case m=O*)
Auto.
(*... case m=(S y0)*)    
Intros;Apply (h1 y0).
Intros;Apply H.
Apply le_trans  with y0;Auto.(*le_S_n*)
Save ind_leS.

Goal (n:nat)(P:nat->Prop)(P O)->((p:nat)((q:nat)(le q p)->(P q))
->(P (S p)))->(P n).
Intros;Apply P_S_proof2 with nat.
Apply ind_leS;Intros;Apply P_S_proof1;Auto.
Apply H0;Intros;Elim (H1 q);Intros;Auto.
Elim p0;Auto.
Save ind_leP.

(*********************************************************************)
(********** Reasoning by cases with the natural constructors : ************)
(*********************************************************************)

Goal (m:nat)(<nat>O=m)\/(<nat>m=(S (pred m))).
Intro;Elim m;Auto.
Save pred_or.

Goal (x:nat)(P:nat->Set)(P O)->((n:nat)(P (S n)))->(P x).
Intros;Elim x;Auto.
Save nat_caseS.

(*********************************************************************)
(************** Decidability of le : ************************************)
(*********************************************************************)

Goal (n,p:nat){(le n p)}+{~(le n p)}.
Induction n;Auto.           (*case n=O*)
Induction p;Auto.           (*case n=(S y)*)(*Apply le_Sn_O*)
Intros;Elim (H y0);Intros;Auto.             (*Apply le_n_S*)
Right;Unfold not;Intros;Elim b;Auto.        (*Apply le_S_n*)
Save le_decS.

Goal (n,p:nat)(le n p)\/(~(le n p)).
Intros;Elim (le_decS n p);Intros;Auto.
Save le_decP.

Goal (n,p:nat)(le n p)->{(le (S n) p)}+{<nat>n=p}.
Induction n.
Induction p;Auto.
Induction p.
Intros;Absurd (le (S y) O);Auto.
Intros;Elim (H y0);Auto.(*le_n_S*)
Save le_S_eqS.

Goal (n,p:nat)(le n p)->((le (S n) p)\/(<nat>n=p)).
Intros;Elim (le_S_eqS n p);Intros;Auto.
Save le_S_eqP.

End complement_nat.

Provide nat_complements.
