(*****************************************************************************)
(*      Coq V5.8                                                             *)
(*****************************************************************************)
(*                                                                           *)
(*      First-order Unification                                              *)
(*                                                                           *)
(*      Joseph Rouyer                                                        *)
(*                                                                           *)
(*      November 1992                                                        *)
(*                                                                           *)
(*****************************************************************************)
(************************** listv_is_in_lv.v *********************************)
(*****************************************************************************)

Require Prelude.
Require Specif.
Require Le.
Require nat_complements.
Require nat_term_eq_quasiterm.
Require is_in_quasiterm_term_subst.

(***********************************************************************)
(*********************** Lists of variables : *****************************)
(***********************************************************************)

Inductive Set listv = Nilv : listv | Consv : var -> listv -> listv.

Definition BNilv:listv->Prop=[l:listv](<Prop>Match l 
with True 
     [x:var][l:listv][b:Prop]False).

Definition BConsv:listv->Prop=[l:listv](<Prop>Match l 
with False
     [x:var][l:listv][b:Prop]True).

Definition Appv:listv->listv->listv=[l0,l1:listv](<listv>Match l0
with l1 
     [x:var][l2:listv](Consv x)).

Definition Headv:var->listv->var=[x:var][l:listv](<var>Match l
with x
     [x:var][l1:listv][y:var]x).

Definition Tailv:listv->listv=[l:listv](<listv>Match l
with Nilv
     [x:var][l1:listv][l2:listv]l1).

(***********************************************************************)
(**************** Predicate "to be member of a list" : *********************)
(***********************************************************************)

Inductive Definition is_in_lv[x:var]:listv->Prop=
is_in_lv_init:(l:listv)(is_in_lv x (Consv x l))
|is_in_lv_Consv:(l:listv)(x0:var)(is_in_lv x l)
->(is_in_lv x (Consv x0 l)).

Definition IS_IN_LV:var->listv->Prop
=[x:var][l:listv](<Prop>Match l
with False
     [y:var][l1:listv][p:Prop]p\/<var>x=y).

Goal (l:listv)(x:var)(is_in_lv x l)->(IS_IN_LV x l).
Intros;Elim H;Simpl;Auto.
Save is_in_lv_IS_IN_LV.

Goal (l:listv)(x:var)(IS_IN_LV x l)->(is_in_lv x l).
Induction l;Simpl;Intros.
Elim H.
Elim H0;Intros.
Apply is_in_lv_Consv;Auto.
Elim H1;Apply is_in_lv_init;Auto.
Save IS_IN_LV_is_in_lv.

(***********************************************************************)
(************ Properties 1) if x belongs to l and is not the head, ***********)
(************************* then x belongs to the tail. *********************)
(***********************************************************************)

Goal (x,x0:var)(l:listv)(IS_IN_LV x (Consv x0 l))->(~<var>x=x0)
->(IS_IN_LV x l).
Induction l;Simpl;Intros.
Elim H;Intros;Auto;Elim H0;Auto.
Elim H0;Intros;Auto.
Save IS_IN_LV_n_eq.

(***********************************************************************)
(********************** 2) [x0] contains only x0 . ************************)
(***********************************************************************)

Goal (x,x0:var)(IS_IN_LV x (Consv x0 Nilv))-><var>x=x0.
Intros;Elim H;Intros h;Elim h;Auto.
Save IS_IN_LV_Consv_Nilv_eq.

(***********************************************************************)
(********************** 3) Decidability of IS_IN_LV : *********************)
(***********************************************************************)

Goal (x:var)(l:listv){(IS_IN_LV x l)}+{~(IS_IN_LV x l)}.
Induction l;Simpl;Intros.
(*l=Nilv*)
Auto.
(*l=(Consv v y)*)
Elim H;Intros.
Auto.
Elim (var_eq_decS x v);Intros.
(* ... <var>x=v *)
Auto.
(*... ~<var>x=v*)
Right;Unfold not;Intros h;Elim h;Intros.
Elim b;Auto.
Elim b0;Auto.
Save IS_IN_LV_decS.

Goal (x:var)(l:listv)(IS_IN_LV x l)\/~(IS_IN_LV x l).
Intros;Elim (IS_IN_LV_decS x l);Intros;Auto.
Save IS_IN_LV_decP.

(***********************************************************************)
(*********************** IS_IN_LV and Appv *****************************)
(***********************************************************************)

Goal (l,l0:listv)(x:var)(IS_IN_LV x l)->(IS_IN_LV x (Appv l l0)).
Induction l;Simpl;Intros.
Elim H;Auto.
Elim H0;Intros;Auto.
Save IS_IN_LV_Appv1.

Goal (l,l0:listv)(x:var)(IS_IN_LV x l0)->(IS_IN_LV x (Appv l l0)).
Intros l;Elim l;Simpl;Auto.
Save IS_IN_LV_Appv2.

Goal (l,l0:listv)(x:var)(IS_IN_LV x (Appv l l0))
     ->((IS_IN_LV x l)\/(IS_IN_LV x l0)).
Induction l;Simpl;Intros;Auto.
Elim H0;Intros;Auto.
Elim (H l0 x);Auto.
Save IS_IN_LV_Appv_IS_IN_LV.

(***********************************************************************)

Provide listv_is_in_lv.
