(*****************************************************************************)
(*      Coq V5.8                                                             *)
(*****************************************************************************)
(*                                                                           *)
(*      First-order Unification                                              *)
(*                                                                           *)
(*      Joseph Rouyer                                                        *)
(*                                                                           *)
(*      November 1992                                                        *)
(*                                                                           *)
(*****************************************************************************)
(********************* is_in_quasiterm_term_subst.v **************************)
(*****************************************************************************)

Require Prelude.
Require Specif.
Require Le.
Require nat_complements.
Require nat_term_eq_quasiterm.

(***********************************************************************)
(******************* VARIABLE IN A QUASITERM *********************)
(***********************************************************************)

Inductive Definition is_in [x:var]:quasiterm->Prop
=is_in_init : (is_in x (V x))
|is_in_Root : (l:fun)(t:quasiterm)(is_in x t)->(is_in x (Root l t))
|is_in_ConsArg1 : (t1,t2:quasiterm)(is_in x t1)->(is_in x (ConsArg t1 t2))
|is_in_ConsArg2 : (t1,t2:quasiterm)(is_in x t2)
                   ->(is_in x (ConsArg t1 t2)).

Definition IS_IN : var->quasiterm->Prop
= [x:var][t:quasiterm]
(<Prop>Match t with
        [y:var](<var>x=y)
        [l:fun]False
        [l:fun][t:quasiterm][p:Prop]p
        [t1:quasiterm][p1:Prop][t2:quasiterm][p2:Prop](p1\/p2)).

Goal (x:var)(t:quasiterm)(IS_IN x t)->(is_in x t).
Induction t.
Intros.
Elim H;Apply is_in_init.
Intros;Elim H.
Intros;Apply is_in_Root;Auto.
Intros;Elim H1;Intros.
Apply is_in_ConsArg1;Auto.
Apply is_in_ConsArg2;Auto.
Save IS_IN_is_in.

Goal (x:var)(t:quasiterm)(is_in x t)->(IS_IN x t).
Intros;Elim H;Simpl;Auto.
Save is_in_IS_IN.

(***********************************************************************)
(************************* IS_IN decidability *****************************)
(***********************************************************************)

Goal (x:var)(t:quasiterm){(IS_IN x t)}+{~(IS_IN x t)}.
Induction t.
Intro;Elim (var_eq_decS x v);Intros;Simpl;Auto.
Intros;Right;Auto.
Intros f y h;Elim h;Intros;Simpl;Auto.
Intros y h y0 h0;Elim h;Elim h0;Intros;Simpl;Auto.
Right;Unfold not;Intros h1;Elim h1;Intros h2.
Elim b0;Auto.
Elim b;Auto.
Save IS_IN_decS.

Goal (x:var)(t:quasiterm)(IS_IN x t)\/(~(IS_IN x t)).
Intros;Elim (IS_IN_decS x t);Intros;Auto.
Save IS_IN_decP.

(**********************************************************************)
(************************** End of IS_IN *******************************)
(**********************************************************************)

(***********************************************************************)
(********************** QUASISUBSTITUTIONS *************************)
(***********************************************************************)

Definition quasisubst=var->quasiterm.

Definition Subst:quasisubst->quasiterm->quasiterm
=[f:quasisubst][t:quasiterm](<quasiterm>Match t 
with f
     C 
     [l:fun][t:quasiterm][u:quasiterm](Root l u)
     [t1,u1,t2,u2:quasiterm](ConsArg u1 u2)).

(*---------------------------------------------*)
(*------------ Verifications on the terms:begin -------------*)
(*---------------------------------------------*)

Inductive Definition term_subst[l:list_nat;f:quasisubst]:Prop=
term_subst_init:((x:var)(term l (f x)))->(term_subst l f).

(***********************************************************************)
(********************** If (term_subst l f), *******************************)
(********* then Length, SIMPLE, (L_TERM l) and (term l) ****************) 
(******************* are stable by (Subst f). ******************************)
(***********************************************************************)

Goal (l:list_nat)(f:quasisubst)(t:quasiterm)
(term_subst l f)-><nat>(Length t)=(Length (Subst f t)).
Induction t;Intros;Elim H;Simpl;Auto.
Intros h;Elim (h v).
Elim (f v);Simpl;Auto.
Intros.
Absurd False;Auto.
Intros.
Elim H;Elim H0;Auto.
Save term_subst_eq_Length.

Goal (l:list_nat)(f:quasisubst)(term_subst l f)
->(t:quasiterm)(SIMPLE t)->(SIMPLE (Subst f t)).
Induction t;Simpl;Auto.
Intros;Elim H;Intros h;Elim (h v);Intros;Auto.
Save SIMPLE_term_subst.

Goal (l:list_nat)(t:quasiterm)(L_TERM l t)
->(f:quasisubst)(term_subst l f)
->(L_TERM l (Subst f t)).
Intros l t H;Cut (l_term l t).
2:Try Apply L_TERM_l_term;Auto.
Intros h;Elim h;Simpl;Auto.
Intros x f h0;Elim h0.
Intros h1;Elim (h1 x);Auto.
Intros.
Split;Auto.
Replace (arity l f) with (Length t0).
Apply  term_subst_eq_Length with l;Auto.
Intros.
Split;Auto.
Apply SIMPLE_term_subst with l;Auto.
Save L_TERM_term_subst.

Goal (l:list_nat)(t:quasiterm)(term l t)
->(f:quasisubst)(term_subst l f)
->(term l (Subst f t)).
Intros;Apply term_init.
Elim H;Intros;Apply L_TERM_term_subst;Auto.
Elim H;Intros;Apply SIMPLE_term_subst with l;Auto.
Save term_term_subst.

(*---------------------------------------------*)
(*------------ Verifications on the terms:end --------------*)
(*---------------------------------------------*)

(***********************************************************************)
(************** Properties linked to IS_IN and Subst ***********************)
(***********************************************************************)

Goal (f:quasisubst)(t:quasiterm)(x:var)((y:var)(~(IS_IN x (f y))))
->~(IS_IN x (Subst f t)).
Induction t;Simpl;Auto.
Intros;Unfold not;Intros h;Elim h;Intros.
Elim (H x);Auto.
Elim (H0 x);Auto.
Save n_IS_IN_Subst.

Goal (f:quasisubst)(t:quasiterm)(x,x0:var)(IS_IN x (f x0))
->(IS_IN x0 t)->(IS_IN x (Subst f t)).
Induction t;Simpl;Auto.
Intros.
Elim H0;Auto.
Intros.
Elim H2;Intros.
Left;Apply (H x x0);Auto.
Right;Apply (H0 x x0);Auto.
Save IS_IN_Subst_IS_IN.

(***********************************************************************)
(**** If two quasisubstitutions have the same restriction ********************)
(************** on the set of the variables of t, **************************)
(************** then they transform t in the same quasiterm. **************)
(***********************************************************************)

Goal (t:quasiterm)(f,g:quasisubst)
((x:var)(IS_IN x t)-><quasiterm>(f x)=(g x))
-><quasiterm>(Subst f t)=(Subst g t).
Induction t;Simpl;Auto.
Intros.
Elim (H f0 g);Auto.
Intros.
Elim (H f g);Elim (H0 f g);Auto.
Save eq_restriction_s_t.

(***********************************************************************)
(******* If two quasisubstitutions transform t in the same quasiterm, ********)
(***** then they have the same restriction on the set of the variables of t.****)
(***********************************************************************)

Goal (t:quasiterm)(f,g:quasisubst)
(<quasiterm>(Subst f t)=(Subst g t))
->((x:var)(IS_IN x t)-><quasiterm>(f x)=(g x)).
Induction t;Simpl;Intros.
Replace x with v;Auto.
Absurd False;Auto.                         
Apply H;Auto.
Apply proj_Root2 with f f;Auto.
Elim H2;Intros.
Apply H;Auto.
Apply proj_ConsArg1 with (Subst f y0) (Subst g y0);Auto.
Apply H0;Auto.
Apply proj_ConsArg2 with (Subst f y) (Subst g y);Auto. 
Save eq_restriction_t_s.

(***********************************************************************)
(********************* End of quasisubstitutions **************************)
(***********************************************************************)

Provide is_in_quasiterm_term_subst.
