Require Words.

Definition l_inclus : wordset->wordset->Prop =
[l1,l2:wordset](w:Word)(l1 w)->(l2 w).

Lemma refl_l_inclus : (l1:wordset)(l_inclus l1 l1).
Goal.
Intros; Red;Auto.
Save.
Hint refl_l_inclus.

Lemma trans_l_inclus : (l1,l2,l3:wordset)(l_inclus l1 l2)->(l_inclus l2 l3)->(l_inclus l1 l3).
Goal.
Unfold l_inclus.
Auto.
Save.


Definition l_egal : wordset->wordset->Prop =
[l1,l2:wordset]((l_inclus l1 l2)/\(l_inclus l2 l1)).

(*predicat equivalent a eqwordset*)
(*demonstration :                *)

Lemma equiv_l_egal_eqwordset : (a,b:wordset)(l_egal a b)<->(eqwordset a b).
Goal.
Intros.
Unfold iff.
Unfold l_egal eqwordset l_inclus.
Split.
Intros.
Split;Elim H;Auto.
Intros.
Split; Intros;Elim (H w);Auto.
Save.


Lemma refl_l_egal : (l1:wordset)(l_egal l1 l1).
Goal.
Intros;Red;Split;Auto.
Save.
Hint refl_l_egal.




Section more_about_words.

Variable f:Elt->Elt. 

Local wef = (Word_ext f).

 
Lemma wef_cons : (a:Elt)(u:Word)(<Word>(wef (cons a u))=(cons (f a) (wef u))).
Proof [a:Elt][u:Word](refl_equal Word (wef (cons a u))).

Lemma wef_append : (u,v:Word)(<Word>(wef (Append u v))=(Append (wef u) (wef v))).
Goal.
Intros.
Pattern u.
Apply induction_word.

	Trivial.

	Intros.
	Replace (wef (cons x w)) with (cons (f x) (wef w));Auto.
	Replace (Append (cons x w) v) with (cons x (Append w v)); Auto.
	Replace (Append (cons (f x) (wef w)) (wef v))
		with (cons (f x) (Append (wef w)(wef v)));
			Auto.
	Rewrite <- H.
	Trivial.

Save.

Lemma wef_nil : (a:Word)(<Word>(wef a)=nil)->(<Word>a=nil).
Goal.
Intro.
Pattern a.
Apply induction_word; Auto.
Intros.
Absurd (<Word>(cons (f x) (wef w))=nil).
	Apply diff_cons_nil.
	Auto.
Save.


Lemma wef_cons :
(a,b:Word)(e:Elt)
(<Word>(cons e a)=(wef b))->
(<Elt> Ex ([x:Elt](<Word> Ex2 ([w:Word](<Word>(cons x w)=b)
			      ,[w:Word](<Elt>(f x)=e/\<Word>(wef w)=a)
			      )
		   )
	  )).

Goal.
Intros a b e.
Pattern b.
Apply induction_word.
	Intro. 
	Absurd <Word>(cons e a)=(wef nil).
		Apply diff_cons_nil.	
		Assumption.
	Intros x w temp H; Clear temp.
	Exists x .
	Exists w.
		Trivial.
		Apply cons_cons_inv;Auto.

Save.


End more_about_words.

Lemma Append_assoc : (a,b,c:Word)<Word>(Append a (Append b c))=(Append (Append a b) c).
Goal.
Intros a b c.
Pattern a.
Apply induction_word.
Trivial.
Intros x w App_eg.
Unfold Append.
Auto.
Save.
Hint Append_assoc.

Provide more_words.
