Require Words.
Require gram.
Require gram_g.
Require PushdownAutomata.


Section APD.

Variable X,V,R :Ensf.
Variable S':Elt.

Hypothesis Gram : (isGram X V R S').

Lemma Regles_X_V_R : (Regles X V R).
Goal.
Apply isGram4 with S'.
Exact Gram.
Save.

Local P=(union X V).

Local f_R_d = [a:Elt](couple (word (cons (first a) nil))
			  (couple (eps X) (second a))
			).

Local f_X_d = [x:Elt](couple (word (cons x nil))
			   (couple x (word nil))
			).

Local d=(union (map f_R_d R) (map f_X_d X)).

Local wd=(cons S' nil).

Local wa=nil.

Lemma Trans : (Transition X P d).
Goal.
Red.
Intros x dans_x_d.
ElimType (dans x (map f_R_d R))\/(dans x (map f_X_d X)).
Intros dans_x.

ElimType (<Elt> Ex ([y:Elt](dans y R)/\(<Elt>x=(f_R_d y)))).
Intros y temp;Elim temp;Clear temp.
Unfold f_R_d.
Intros dans_y_R eg_x_f_y.
Exists (cons (first y) nil).
Apply inmonoid_cons.
Trivial.
Elim (Regles_X_V_R y dans_y_R).
Intros f_y dans_f_y_V temp ;Elim temp;Clear temp.
Intros u eg_y inmono_u.
Rewrite eg_y.
Unfold first.
Unfold P.
Auto.
Exists (eps X).
Auto.
Exists (word_inv (second y)).
Elim (Regles_X_V_R y dans_y_R).
Intros f_y dans_f_y_V temp ;Elim temp;Clear temp.
Intros u eg_y inmono_u.
Rewrite eg_y.
Unfold second.
Unfold word_inv.
Assumption.

Elim (Regles_X_V_R y dans_y_R).
Intros f_y dans_f_y_V temp ;Elim temp;Clear temp.
Intros u eg_y inmono_u.
Rewrite eg_y.
Unfold word_inv.
Pattern 2 (word u).
Replace (word u) with (second y).
Rewrite <- eg_y.
Assumption.
Rewrite eg_y.
Trivial.
Apply dans_map.
Assumption.


Intros dans_x.
ElimType (<Elt> Ex ([y:Elt](dans y X)/\(<Elt>x=(f_X_d y)))).
Intros y temp;Elim temp;Clear temp.
Unfold f_X_d.
Intros dans_y_X eg_x_f_y.
Exists (cons y nil).
Apply inmonoid_cons.
Trivial.
Unfold P.
Auto.

Exists y.
Auto.
Exists nil.
Trivial.
Assumption.

Apply dans_map.
Assumption.

Auto.
Save.


Lemma X_P_wd_wa_d : (P_automata X P wd wa d).
Goal.
Red.
Split.
Unfold wd.
Apply inmonoid_cons.
Trivial.
Unfold P.
Apply union_d.
Apply isGram3 with X R .
Exact Gram.
Split.
Apply inmonoid_nil.
Exact Trans .
Save.

Lemma cut_spec : (u:Word)
		{a:Word & {b:Word | (inmonoid X a) /\ <Word>(Append a b)=u /\
					(<Word>b=nil
					\/
					(<Elt> Ex2 ([x:Elt](~(dans x X)),
						[x:Elt](<Word> Ex 
							([w:Word]
							(<Word>b=(cons x w))
							))
						    )
					)
					)}}.
Goal.
Intro u.
Pattern u.
Apply induction_word_Set.

Exists nil.
Exists nil.
Auto.
Intros x w Hyp.
Elim Hyp.
Intros a' spec ; Elim spec .
Intros b' temp;Elim temp;Clear temp.
Intros inmonoid_a' temp;Elim temp;Clear temp.
Intros spec_App spec_or.
ElimType {(dans x X)}+{~(dans x X)}.
Intro dans_x_X.
Exists (cons x a').
Exists b'.
Split.
Apply inmonoid_cons;Assumption.
Split.
Unfold Append.
Unfold Append in spec_App.
Auto.
Elim spec_or;Intro;Assumption.
Intro N_dans_x_X.
Exists nil.
Exists (cons x w).
Split.
Auto.
Split.
Auto.
Apply or_intror.
Exists x.
Assumption.
Exists w.
Apply refl_equal.
Exact (Dans_spec x X).
Save.

Definition cut =  [u:Word](<Word*Word>Match (cut_spec u) with
			[a:Word][s:{b:Word | (inmonoid X a) /\ <Word>(Append a b)=u /\
					(<Word>b=nil
					\/
					(<Elt> Ex2 ([x:Elt](~(dans x X)),
						[x:Elt](<Word> Ex 
							([w:Word]
							(<Word>b=(cons x w))
							))
						    )
					)
					)}]<Word,Word>(a,
			(<Word>Match s with 
			[b:Word][s2:(inmonoid X a) /\ <Word>(Append a b)=u /\
					(<Word>b=nil
					\/
					(<Elt> Ex2 ([x:Elt](~(dans x X)),
						[x:Elt](<Word> Ex 
							([w:Word]
							(<Word>b=(cons x w))
							))
						    )
					)
					)]b
			))
).




Definition cut1 = [u:Word](fst Word Word (cut u)).
Definition cut2 = [u:Word](snd Word Word (cut u)).

Lemma cut_unicite : (u,a,b,a',b':Word)
((inmonoid X a) /\ <Word>(Append a b)=u /\
					(<Word>b=nil
					\/
					(<Elt> Ex2 ([x:Elt](~(dans x X)),
						[x:Elt](<Word> Ex 
							([w:Word]
							(<Word>b=(cons x w))
							))
						    )
					)
					))
->
((inmonoid X a') /\ <Word>(Append a' b')=u /\
					(<Word>b'=nil
					\/
					(<Elt> Ex2 ([x:Elt](~(dans x X)),
						[x:Elt](<Word> Ex 
							([w:Word]
							(<Word>b'=(cons x w))
							))
						    )
					)
					))
->
(<Word>a=a') .
Goal.
Intros u a b a' b' temp1 temp2   ; Elim temp1; Elim temp2;Clear temp1;Clear temp2.
Intros inmon temp inmon' temp'; Elim temp; Elim temp'; Clear temp;Clear temp'.
Intros App spec_or App' spec_or'.
ElimType (<Word> Ex ([w:Word]((<Word>a=(Append a' w)/\<Word>b'=(Append w b))
		\/(<Word>a'=(Append a w)/\<Word>b=(Append w b'))))).
Intros x temp; Elim temp;Clear temp.
Pattern 2 a'.
Replace a' with (Append a' nil).
Pattern x.
Apply induction_word.
Intro temp;Elim temp.
Auto.
Intros x0 w Hyp temp;Elim temp;Clear temp.
Intros a_eg b'_eg.
Absurd (dans x0 X).
Elim spec_or'.
Rewrite b'_eg.
Intro cons_nil.
Absurd <Word>(cons x0 (Append w b))=nil.
Apply diff_cons_nil.
Assumption.
Intro temp;Elim temp;Clear temp.
Intros x1 N_dans_x1 temp;Elim temp;Clear temp.
Intros w' b'_eg_2.
Replace x0 with x1.
Assumption.
Apply cons_cons_inv1 with w' (Append w b).
Rewrite <- b'_eg_2.
Assumption.
Apply inmonoid_cons_inv2 with w.
Apply inmonoid_Append_inv2 with a'.
Rewrite <- a_eg.
Assumption.
Apply Append_w_nil.



Pattern 2 a.
Replace a with (Append a nil).
Pattern x.
Apply induction_word.
Intro temp;Elim temp.
Auto.
Intros x0 w Hyp temp;Elim temp;Clear temp.
Intros a'_eg b_eg.
Absurd (dans x0 X).
Elim spec_or.
Rewrite b_eg.
Intro cons_nil.
Absurd <Word>(cons x0 (Append w b'))=nil.
Apply diff_cons_nil.
Assumption.
Intro temp;Elim temp;Clear temp.
Intros x1 N_dans_x1 temp;Elim temp;Clear temp.
Intros w' b_eg_2.
Replace x0 with x1.
Assumption.
Apply cons_cons_inv1 with w' (Append w b').
Rewrite <- b_eg_2.
Assumption.
Apply inmonoid_cons_inv2 with w.
Apply inmonoid_Append_inv2 with a.
Rewrite <- a'_eg.
Assumption.
Apply Append_w_nil.
Apply Append_Append.
Rewrite App';Assumption.
Save.



Lemma inmonoid_cut1 : (w:Word)(inmonoid X (cut1 w)).
Goal.
Intro w.
Unfold cut1 cut.
Elim (cut_spec w).
Intros a temp; Elim temp;Clear temp.
Intros b temp;Elim temp;Clear temp.
Simpl;Auto.
Save.

Lemma cut_Append : (w:Word)<Word>w=(Append (cut1 w)(cut2 w)).
Goal.
Intro w.
Unfold cut1 cut2 cut.
Elim (cut_spec w).
Intros a temp; Elim temp;Clear temp.
Intros b temp;Elim temp;Clear temp.
Intros inm temp;Elim temp.
Simpl;Auto.
Save.

Lemma cut1_cons : (a:Elt)(w:Word)(dans a X)-><Word>(cut1 (cons a w))=(cons a (cut1 w )).
Goal.
Intros a w dans_a_X.
Unfold cut1 cut.
Elim (cut_spec w).
Intros x temp; Elim temp;Clear temp.
Intros b temp;Elim temp;Clear temp.
Intros inmon_X_x temp;Elim temp;Clear temp.

Elim (cut_spec (cons a w)).
Intros x' temp; Elim temp;Clear temp.
Intros b' temp;Elim temp;Clear temp.
Intros inmon_X_x' temp;Elim temp;Clear temp.

Intros App_eg' spec' App_eg spec.
Simpl.

Cut (inmonoid X x').
Cut <Word>(Append x' b')=(cons a w).
Pattern x'.

Apply induction_word.
Intro App_nil_b'_eg_cons_a_w.
Absurd (dans a X).
Elim spec'.
Intro b'_nil.
Absurd <Word>(cons a w)=nil.
Apply diff_cons_nil.
Rewrite <- b'_nil.
Rewrite <- App_nil_b'_eg_cons_a_w.
Trivial.
Intro temp;Elim temp;Clear temp.
Intros x0 N_dans_x0_X temp;Elim temp;Clear temp.
Intros w1 eg_b'_cons.
Replace a with x0.
Auto.
Apply cons_cons_inv1 with w1 w.
Rewrite <- eg_b'_cons.
Assumption.
Assumption.
Intros x0 w0 Hyp App_eg_cons inmon_cons.
Apply cons_cons.
Apply cons_cons_inv1 with (Append w0 b') w.
Assumption.
Apply cut_unicite with w b' b.
Split.
Apply inmonoid_cons_inv with x0;Assumption.

Split.
Apply cons_cons_inv2 with x0 a.
Assumption.
Assumption.

Split;Auto.
Assumption.
Assumption.
Save.

Lemma cut1_Append : (u,v:Word)(inmonoid X u)-><Word>(cut1 (Append u v))=(Append u (cut1 v)).
Goal.
Intros u v.
Pattern u.
Apply induction_word.
Auto.
Intros x w Hyp inmon_x_w .
Replace (cut1 (Append (cons x w) v)) with (cons x (cut1 (Append w v))).
Replace (Append (cons x w) (cut1 v)) with (cons x (Append w (cut1 v))).
Apply cons_cons.
Trivial.

Apply Hyp.
Apply inmonoid_cons_inv with x;Assumption.

Trivial.

Apply sym_equal.
Unfold Append.
Apply cut1_cons.
Apply inmonoid_cons_inv2 with w.
Trivial.
Save.






Axiom cut2_cons : (A:Elt)(v:Word)(dans A X)->
(<Word>(cut2 (cons A v))=(cut2 v)).


Lemma cut2_cons_N : (A:Elt)(v:Word)(~(dans A X))->
(<Word>(cut2 (cons A v))=(cons A v)).
Goal.
Intros A v N_dans_A_X.
Unfold cut2 cut.
Elim (cut_spec (cons A v)).
Intros a temp; Elim temp;Clear temp.
Intros b temp;Elim temp;Clear temp.
Intros inmon_a temp; Elim temp;Clear temp.
Intros App_eg spec_or.
Cut (inmonoid X a).
Cut (<Word>(Append a b)=(cons A v)).
Pattern a.
Apply induction_word.
	Auto.

	Intros x w Hyp App_eg_x_w inmon.
	Absurd (dans A X).
		Assumption.

		Replace A with x.
		Apply inmonoid_cons_inv2 with w.
		Assumption.
		Apply cons_cons_inv1 with (Append w b) v.
		Assumption.
Assumption.
Assumption.
Save.









Lemma Deriveg_imp_Deriveg_cut : (x,y:Word)(Deriveg X R x y)-><Word> Ex2 ([w:Word]<Word>(Append (cut1 x) w)=y,[w:Word](Deriveg X R (cut2 x) w)).
Goal.
Intros x y Der.
Elim Der.
Intros.
Replace (cut1 (cons A v)) with nil.
Exists (Append u v).
Trivial.
Replace (cut2 (cons A v)) with (cons A v).
Apply Deriveg1.
Assumption.
Apply sym_equal.
Apply cut2_cons_N.
Apply inter_dans with V.
Apply sym_inter.
Apply isGram2 with R S'.
Exact Gram.
Apply Regles_inv1 with X R (word u) .
Apply isGram4 with S'.
Exact Gram.
Assumption.


Unfold cut1 cut.
Elim (cut_spec (cons A v)).
Intros a p.
Elim p.
Intros b temp;Elim temp;Clear temp.
Intros inmon_a temp;Elim temp;Clear temp.

Intros App_eg spec_or.

Cut (inmonoid X a).(**)(*pour l'induction*)
Cut <Word>(Append a b)=(cons A v).(***)(*pour l'induction*)

Pattern a.
Apply induction_word.
Auto.
Intros x0 w Hyp App inmon.
Absurd (dans A X).

Intros.
Apply inter_dans with V.
Apply sym_inter.
Apply isGram2 with R S'.
Exact Gram.

Apply Regles_inv1 with X R (word u).
Apply isGram4 with S'.
Exact Gram.
Assumption.

Apply inmonoid_cons_inv2 with w.
Replace A with x0.
Assumption.
Apply cons_cons_inv1 with (Append w b) v.
Assumption.

Assumption.(**)
Assumption.(***)




Intros u v x0 dans_x0_X Deriveg_X_R_u_v temp.
Elim temp;Clear temp.
Intros w eg_App_cut Der_g_cut2.
Exists w.
Replace (cut1 (cons x0 u)) with (cons x0 (cut1 u)).
Unfold Append.
Apply cons_cons;Trivial.

Apply sym_equal.
Apply cut1_cons.
Assumption.

Replace (cut2 (cons x0 u)) with (cut2 u).
Assumption.
Apply sym_equal.
Apply cut2_cons.
Assumption.
Save.

Lemma Deriveg_imp_Deriveg_App : (x,y:Word)(Deriveg X R x y)->(u,v:Word)(<Word>(Append u v)=x)->(inmonoid X u)-><Word> Ex2 ([w:Word]<Word>(Append u w)=y,[w:Word](Deriveg X R v w)).
Goal.
Intros x y Derg.
Elim Derg.

Intros u0 v0 A dans_A_u0_R u v eg_App.
ElimType <Word>u=nil\/(<Word> Ex ([w:Word](<Elt> Ex ([x:Elt]<Word>u=(cons x w))))).
Intros u_eg.
Exists (Append u0 v0).
Rewrite u_eg.
Trivial.
Replace v with (cons A v0).
Apply Deriveg1;Assumption.
Replace v with (Append u v).
Auto.
Rewrite u_eg.
Trivial.
Intro temp ; Elim temp;Clear temp.
Intros w temp;Elim temp;Clear temp.
Intros x0 u_eg inmon_u.
Absurd (dans x0 V).
Apply inter_dans with X.
Apply isGram2 with R S'.
Exact Gram.
Apply inmonoid_cons_inv2 with w.
Rewrite <- u_eg.
Assumption.
Replace x0 with A.
Apply Regles_inv1 with X R (word u0).
Exact Regles_X_V_R.
Assumption.
Apply cons_cons_inv1 with v0 (Append w v).
Change <Word>(cons A v0)=(Append (cons x0 w) v).
Rewrite <- u_eg.
Auto.

Pattern u.
Apply induction_word.
Auto.
Intros x0 w hyp.
Apply or_intror.
Exists w.
Exists x0.
Trivial.



Intros u0 v0 x0 dans_x0_X Derg_u_v Hyp u v.
ElimType <Word>u=nil\/(<Word> Ex ([w:Word](<Elt> Ex ([x:Elt]<Word>u=(cons x w))))).
Intro eg_u. 
Rewrite eg_u.
Intros App_eg inmon_nil.
Exists (cons x0 v0).
Trivial.
Replace v with (cons x0 u0).
Apply Deriveg2.
Assumption.
Assumption.
Intro temp ; Elim temp;Clear temp.
Intros w temp;Elim temp;Clear temp.
Intros x1 u_eg .
Rewrite u_eg.
Intros App_cons_eg inmonoid_X_cons_x1_w.
ElimType (<Word>Ex2([w1:Word]<Word>(Append w w1)=v0,[w1:Word](Deriveg X R v w1))).
Intros w0 App_eg Der_v_w0.
Exists w0.
Change <Word>(cons x1 (Append w w0))=(cons x0 v0).
Apply cons_cons.
Apply cons_cons_inv1 with (Append w v) u0.
Assumption.
Assumption.
Assumption.
Apply Hyp.
Apply cons_cons_inv2 with x1 x0.
Assumption.
Apply inmonoid_cons_inv with x1.
Assumption.

Pattern u.
Apply induction_word.
Auto.
Intros x2 w hyp.
Apply or_intror.
Exists w.
Exists x2.
Trivial.

Save.


Lemma Derivegstar_imp_Der_inmon : (x,y:Word)(Derivegstar X R x y)->(u,v:Word)(<Word>(Append u v)=x)->(inmonoid X u)-><Word> Ex2 ([w:Word]<Word>(Append u w)=y,[w:Word](Derivegstar X R v w)).
Goal.
Unfold Derivegstar.
Intros x y Der_star.
Unfold Rstar in Der_star.
Pattern x y.
Apply Der_star.

Exists v.
Assumption.
Apply Rstar_reflexive.


Intros u v w Der_u_v Hyp u0 v0 App_eg inmon_u0.
ElimType <Word> Ex2 ([w1:Word]<Word>(Append u0 w1)=v,[w1:Word](Deriveg X R v0 w1)).
Intros w0 App_eg_u0_w0 Deriveg_v0_x0.
ElimType <Word> Ex2 ([w1:Word]<Word>(Append u0 w1)=w,[w1:Word](Rstar Word (Deriveg X R) w0 w1)).
Intros w1 App_eg_u0_w1_w Rstar_Der.
Exists w1.
Assumption.
Apply Rstar_R with w0.
Assumption.
Assumption.
Apply Hyp;Assumption.
Apply Deriveg_imp_Deriveg_App with u;Assumption.
Save.



Inductive Definition Derive_P_A_2 : Conf->Conf->Prop =
Derive_X : (w,u:Word)(x:Elt)(dans x X)->
(Derive_P_A_2 <Word,Word>((cons x w),(cons x u))
	<Word,Word>(w,u))
|
Derive_V : (v,w,u:Word)(x:Elt)
(dans (couple x (word u)) R)->
(Derive_P_A_2 <Word,Word>((cons x w),v)
	<Word,Word>((Append u w),v)).



Definition Derive_P_A_2_nind =
[x,y:Conf]
(<Elt> Ex2 ([a:Elt](dans a X),
[a:Elt](<Word>(fst Word Word x)=(cons a (fst Word Word y)))/\(<Word>(snd Word Word x)=(cons a (snd Word Word y)))))
\/
(<Elt> Ex ([a:Elt]<Word> Ex2 ([w:Word]<Word>(cons a w)=(fst Word Word x),
			[w:Word]<Word> Ex2 
				([u:Word](dans (couple a (word u)) R)
				,[u:Word]<Word>(Append u w)=(fst Word Word y)
				)
			     )
	)
).


Lemma Derive_P_A_2_inv : (x,y:Conf)(Derive_P_A_2 x y)->(Derive_P_A_2_nind x y).
Goal.
Intros x y Der.
Unfold Derive_P_A_2_nind.
Elim Der.
Intros w u x0 dans_x0_X .
Apply or_introl.
Exists x0;Auto.

Intros v w u x0 dans_couple_Der .
Apply or_intror.
Exists x0.
Exists w.
Auto.
Exists u;Auto.
Save.


Definition Derivestar_P_A_2 = (Rstar Conf Derive_P_A_2).

Lemma Der_cons_inv : (x:Elt)(u,v:Word)(dans x X)->(Derivestar_P_A_2 <Word,Word>((cons x u),v) <Word,Word>(nil,nil))->
<Word>
 Ex2 ([v2:Word]<Word>v=(cons x v2)
     ,[v2:Word](Derivestar_P_A_2 <Word,Word>(u,v2) <Word,Word>(nil,nil))
     )
.
Goal.
Intros x u v dans_x_X Der_star.
ElimType <Word*Word><Word,Word>((cons x u),v)=<Word,Word>(nil,nil)
\/ <Word*Word> Ex2 ([z:Conf](Derive_P_A_2 <Word,Word>((cons x u),v) z)
		,[z:Conf](Rstar Word*Word Derive_P_A_2 z <Word,Word>(nil,nil))).
Intro eg.
Absurd <Word>(cons x u)=nil.
Apply diff_cons_nil.

Change <Word>(fst Word Word <Word,Word>((cons x u),v))=(fst Word Word <Word,Word>(nil,nil)).
Apply (f_equal Word*Word Word (fst Word Word)).
Assumption.
Intro temp;Elim temp;Clear temp;Intros z Der Der_star_2.
Cut (Derive_P_A_2_nind <Word,Word>((cons x u),v) z).
Unfold Derive_P_A_2_nind.
Intro temp;Elim temp;Clear temp;Intro temp;Elim temp;Clear temp.
Simpl.
Intros x0 dans_x0_X temp;Elim temp;Clear temp.
Intros eg_cons_x_x0 eg_v_cons.
Exists  <Word,Word>Snd(z).
Replace x with x0.
Trivial.
Apply cons_cons_inv1 with <Word,Word>Fst(z) u.
Auto.
Unfold Derivestar_P_A_2.
Replace u with <Word,Word>Fst(z).
Cut (Rstar Word*Word Derive_P_A_2 z <Word,Word>(nil,nil)).
Elim z.
Auto.
Assumption.
Apply cons_cons_inv2 with x0 x.
Auto.

Simpl.
Intros x0 temp;Elim temp;Clear temp;Intros w eg temp;Elim temp;Clear temp.
Intros u0 dans_couple.
Absurd (dans x0 V).
Apply inter_dans with X.
Exact (isGram2 X V R S' Gram).
Replace x0 with x.
Trivial.
Apply cons_cons_inv1 with u w.
Auto.
Apply Regles_inv1 with X R (word u0).
Exact Regles_X_V_R.
Assumption.
Apply Derive_P_A_2_inv.
Assumption.
Apply Rstar_inv.
Assumption.
Save.



Lemma Derive_P_A_2_imp_Der_P_A_2_App : (x,y:Word)(Derivestar_P_A_2 <Word,Word>(x, y) <Word,Word>(nil,nil) )->
(u,v:Word)(<Word>(Append u v)=x)->
(inmonoid X u)-><Word> Ex2 ([w:Word]<Word>(Append u w)=y,[w:Word](Derivestar_P_A_2 <Word,Word>(v,w) <Word,Word>(nil,nil) )).
Goal.
Unfold Derivestar_P_A_2.
Intros x.
Pattern x.
Apply induction_word.
Intros y Der_P_A_2 u v.
ElimType <Word>u=nil\/(<Word> Ex ([w:Word](<Elt> Ex ([x:Elt]<Word>u=(cons x w))))).
Intros u_eg.
Rewrite u_eg.
Intros App_eg inmon_nil.
Exists y;Auto.
Replace v with nil;Trivial.

Intro temp;Elim temp;Clear temp;Intros w temp;Elim temp;Clear temp.
Intros x0 eg_u.
Rewrite eg_u.
Intros cons_eg_nil.
Absurd <Word>(cons x0 (Append w v))=nil.
Apply diff_cons_nil.
Trivial.

Pattern u;Apply induction_word.
Auto.
Intros x1 w1 Hyp; Apply or_intror ;Exists w1;Exists x1;Trivial.



Intros x0 w Hyp y Der_star_cons u v App_eg inmon_X.
ElimType <Word>u=nil\/(<Word> Ex ([w:Word](<Elt> Ex ([x:Elt]<Word>u=(cons x w))))).
Intros u_eg.
Rewrite u_eg.
Replace v with (cons x0 w).
Exists y;Trivial.
Replace v with (Append u v).
Auto.
Rewrite u_eg.
Trivial.

Intro temp;Elim temp;Clear temp;Intros w1 temp;Elim temp;Clear temp.
Intros x1 eg_u.
Rewrite eg_u.
ElimType <Word>
 Ex2 ([v2:Word]<Word>y=(cons x0 v2)
     ,[v2:Word](Derivestar_P_A_2 <Word,Word>(w,v2) <Word,Word>(nil,nil))
     )
.
Intros v2 y_eg Der_w_v2.
ElimType (<Word>Ex2 ([w:Word]<Word>(Append w1 w)=v2
		,[w:Word](Rstar Conf Derive_P_A_2 <Word,Word>(v,w)
				<Word,Word>(nil,nil))
		)
	)
.
Intros we App_w1_we_eg_v2 Rstar_Der.
Exists we.
Rewrite y_eg.
Replace (Append (cons x1 w1) we) with (cons x1 (Append w1 we)).
Apply cons_cons.
Apply cons_cons_inv1 with (Append w1 v) w.
Rewrite <- App_eg.
Rewrite eg_u.
Trivial.
Trivial.
Trivial.
Trivial.

Apply Hyp.
Trivial.
Apply cons_cons_inv2 with x1 x0.
Rewrite <- App_eg.
Rewrite eg_u.
Trivial.
Apply inmonoid_cons_inv with x1.
Rewrite <- eg_u.
Trivial.
Apply Der_cons_inv.
Replace x0 with x1.
Apply inmonoid_cons_inv2 with w1.
Rewrite <- eg_u.
Trivial.
Apply cons_cons_inv1 with (Append w1 v) w.
Rewrite <- App_eg.
Rewrite eg_u.
Trivial.
Assumption.

Pattern u;Apply induction_word.
Auto.
Intros x1 w1 tmp; Apply or_intror ;Exists w1;Exists x1;Trivial.

Save.




Lemma Derive_P_A_2_imp_Der_P_A_2_cons : (u:Elt)(x,y:Word)(Derivestar_P_A_2 <Word,Word>((cons u x), y) <Word,Word>(nil,nil) )->
(dans u X)-><Word> Ex2 ([w:Word]<Word>(cons u w)=y,[w:Word](Derivestar_P_A_2 <Word,Word>(x,w) <Word,Word>(nil,nil) )).
Goal.
Intros.
ElimType <Word> Ex2 
([w:Word]<Word>(Append (cons u nil) w)=y,
[w:Word](Derivestar_P_A_2 <Word,Word>(x,w) <Word,Word>(nil,nil) )).
Intros w eg_App Der.
Exists w;Trivial.

Apply  Derive_P_A_2_imp_Der_P_A_2_App with (cons u x); Auto.
Save.


Lemma Derivestar_P_A_2_x : (x:Word)(inmonoid X x)->(Derivestar_P_A_2 <Word,Word>(x,x) <Word,Word>(nil,nil) ).
Goal.
Intros x .
Unfold Derivestar_P_A_2.
Pattern x.
Apply induction_word.
Intro.
Apply Rstar_reflexive.
Intros x0 w Hyp inmon.
Apply Rstar_R with <Word,Word>(w,w).
Apply Derive_X.
Apply inmonoid_cons_inv2 with w;Assumption.

Apply Hyp.
Apply inmonoid_cons_inv with x0;Assumption.
Save.
Hint Derivestar_P_A_2_x.

Lemma Derivegstar_imp_Derivestar_P_A_2 : (x,y:Word)(Derivegstar X R x y)->(inmonoid X y)->
(Derivestar_P_A_2 <Word,Word>(x,y) <Word,Word>(nil,nil) ).
Goal.
Unfold Derivegstar Rstar.
Intros x y Der_star.
Pattern x y.
Apply Der_star.
Auto.

Intros u v w Derg_u_v.
Generalize w.
Elim Derg_u_v.
Intros u0 v0 A dans_couple w0 Hyp inmon_w0.
Unfold Derivestar_P_A_2.
Apply Rstar_R with <Word,Word>((Append u0 v0),w0).
Apply Derive_V.
Assumption.
Apply Hyp;Assumption.

Intros u0 v0 x0 dans_x0_v0 Der_u0_v0  Hyp1 w0 Hyp2 inmon_w0.

ElimType <Word>
 Ex2 ([v2:Word]<Word>w0=(cons x0 v2)
     ,[v2:Word](Derivestar_P_A_2 <Word,Word>(v0,v2) <Word,Word>(nil,nil))
     )
.
Intros x1 w0_eg_cons Derivestar_v0_x1.
Rewrite w0_eg_cons.
Unfold Derivestar_P_A_2.
Apply Rstar_R with <Word,Word>(u0,x1).
Apply Derive_X.
Assumption.
Apply Hyp1.
Auto.
Apply inmonoid_cons_inv with x0.
Rewrite <- w0_eg_cons.
Assumption.

Apply Der_cons_inv.
Assumption.
Exact (Hyp2 inmon_w0).
Save.
Hint Derivegstar_imp_Derivestar_P_A_2.


(*equivalence de Derive_P_A_2 et Derive_P_A*)
(*premiere implication*)
Lemma Derive_P_A_2_imp_Derive_P_A : (x,y:Word*Word)(Derive_P_A_2 x y)->(Derive_P_A X d x y).
Goal.
Intros x y Der.
Elim Der.
Intros w u x0 dans_x0_X.
Replace (cons x0 w) with (Append (cons x0 nil) w).
Pattern 2 w.
Replace w with (Append nil w).
Apply Derive_cons.
Assumption.
Unfold d.
Apply union_d.
Change (dans (f_X_d x0) (map f_X_d X)).
Apply dans_map_inv.
Assumption.
Trivial.
Trivial.

Intros v w u x0 dans_couple.
Replace (cons x0 w) with (Append (cons x0 nil) w).
Apply Derive_eps.
Unfold d.
Apply union_g.
Replace (couple (word (cons x0 nil)) (couple (eps X) (word u))) with (f_R_d (couple x0 (word u))).
Apply dans_map_inv.
Assumption.
Unfold f_R_d.
Trivial.
Trivial.
Save.
Hint Derive_P_A_2_imp_Derive_P_A.

Lemma Derivestar_P_A_2_imp_Derivestar_P_A : (x,y:Word*Word)(Derivestar_P_A_2 x y)->(Derivestar_P_A X d x y).
Goal.
Unfold Derivestar_P_A_2 Rstar Derivestar_P_A.
Intros x y Rstar_Der.
Pattern x y.
Apply Rstar_Der.
Intros.
Apply Rstar_reflexive.
Intros u v w Hyp1 Hyp2.
Apply Rstar_R with v;Auto.
Save.
Hint Derivestar_P_A_2_imp_Derivestar_P_A.


(*seconde implication*)

Lemma Derive_P_A_imp_Derive_P_A_2 : (x,y:Word*Word)(Derive_P_A X d x y)->(Derive_P_A_2 x y).
Goal.

Unfold d.
Intros x y Der.
Elim Der.
Intros w w1 w2 u x0 dans_x0_X dans_couple_d.
ElimType (dans (couple (word w1) (couple x0 (word w2))) (map f_R_d R))
\/(dans (couple (word w1) (couple x0 (word w2))) (map f_X_d X)).
Intros dans_couple.
Absurd (dans (eps X) X).
Apply not_dans_X_eps.
Replace (eps X) with x0.
Assumption.
ElimType <Elt> Ex ([r:Elt](dans r R)/\<Elt>(couple (word w1) (couple x0 (word w2)))=(f_R_d r)).
Intros r temp;Elim temp;Clear temp; Intros dans_r_R.
Unfold f_R_d r.
Intro eg.
Apply couple_couple_inv1 with (word w2) (second r).
Apply couple_couple_inv2 with (word w1) (word (cons (first r) nil)).
Assumption.
Apply dans_map.
Assumption.


Intros dans_couple.
ElimType <Elt> Ex ([r:Elt](dans r X)/\<Elt>(couple (word w1) (couple x0 (word w2)))=(f_X_d r)).
Intros r temp;Elim temp;Clear temp;Intros dans_r_X eg.

Replace w1 with (cons x0 nil).
Replace w2 with nil.
Simpl.
Replace (Append nil w) with w.
Replace (Append (cons x0 nil) w) with (cons x0 w).
Apply Derive_X.
Assumption.
Trivial.
Trivial.
Apply word_word_inv.
Apply couple_couple_inv2 with r x0.
Apply couple_couple_inv2 with (word (cons r nil)) (word w1).
Auto.
Replace x0 with r.
Apply word_word_inv.
Apply couple_couple_inv1 with (couple r (word nil)) (couple x0 (word w2)) .
Auto.
Apply couple_couple_inv1 with (word nil) (word w2).
Apply couple_couple_inv2 with (word (cons r nil)) (word w1).
Auto.

Apply dans_map.
Assumption.
Auto.

Unfold d.
Intros w w1 w2 u dans_couple_d.
ElimType (dans (couple (word w1) (couple (eps X) (word w2))) (map f_R_d R))
\/(dans (couple (word w1) (couple (eps X) (word w2))) (map f_X_d X)).
Intros dans_couple.
(*   Apply Derive_V.*)
ElimType <Elt> Ex ([r:Elt](dans r R)/\<Elt>(couple (word w1) (couple (eps X) (word w2)))=(f_R_d r)).
Intros r temp;Elim temp;Clear temp;Intros dans_r_R eg.
Replace w1 with (cons (first r) nil).
Replace (Append (cons (first r) nil) w) with  (cons (first r) w).
Apply Derive_V.
Replace (word w2) with (second r).
ElimType (<Elt>Ex2([A:Elt](dans A V),[A:Elt]<Word>Ex2([B:Word]<Elt>r=(couple A (word B)),[B:Word](inmonoid (union X V) B)))).
Intros A dans_A_V temp;Elim temp;Clear temp;Intros B eg_r inmon_B.
Rewrite eg_r.
Unfold first second.
Rewrite <- eg_r.
Assumption.
Apply Regles_X_V_R.
Assumption.
Apply couple_couple_inv2 with (eps X) (eps X).
Apply couple_couple_inv2 with (word (cons (first r) nil)) (word w1).
Auto.
Trivial.
Apply word_word_inv.
Apply couple_couple_inv1 with (couple (eps X) (second r))
				(couple (eps X) (word w2)).
Auto.
Apply dans_map.
Assumption.

Intro dans_couple.
ElimType <Elt> Ex ([r:Elt](dans r X)/\<Elt>(couple (word w1) (couple (eps X) (word w2)))=(f_X_d r)).
Intros r temp;Elim temp;Clear temp;Intros dans_r_X eg.
Absurd (dans (eps X) X).
Apply not_dans_X_eps.
Replace (eps X) with r.
Assumption.
Apply couple_couple_inv1 with (word nil) (word w2).
Apply couple_couple_inv2 with (word (cons r nil)) (word w1).
Auto.
Apply dans_map.
Assumption.
Auto.
Save.
Hint Derive_P_A_imp_Derive_P_A_2.


Lemma Derivestar_P_A_imp_Derivestar_P_A_2 : (x,y:Word*Word)(Derivestar_P_A X d x y)->(Derivestar_P_A_2 x y).
Goal.
Unfold Derivestar_P_A Rstar Derivestar_P_A_2.
Intros x y Der_star.
Pattern x y.
Apply Der_star.
Intros.
Apply Rstar_reflexive.
Intros u v w Deri_u_v Rstar_v_w.
Apply Rstar_R with v;Auto.
Save.

Hint Derivestar_P_A_imp_Derivestar_P_A_2.



(**************************************************************)
(*Tout mot reconnu par la grammaire est reconnu par l'automate*)
(**************************************************************)

Theorem Derivestar_imp_Derivestar_P_A :
(x,y:Word)
   (Derivestar R x y)->
      (inmonoid X y)->
         (Derivestar_P_A X d <Word,Word>(x,y) <Word,Word>(nil,nil) ).

Goal.
Auto.
Save.
(**************************************************************)




Inductive Definition Derive_P_A_3 : Word*Conf->Word*Conf->Prop =
Derive3_X : (w,u,s:Word)(x:Elt)(dans x X)->
(Derive_P_A_3 <Word,Word*Word>(s,<Word,Word>((cons x w),(cons x u)))
	<Word,Word*Word>((Append s (cons x nil)),<Word,Word>(w,u)))
|
Derive3_V : (v,w,u,s:Word)(x:Elt)
(dans (couple x (word u)) R)->
(Derive_P_A_3 <Word,Word*Word>(s,<Word,Word>((cons x w),v))
	<Word,Word*Word>(s,<Word,Word>((Append u w),v))).


Definition Derivestar_P_A_3 = (Rstar Word*Conf Derive_P_A_3).


Lemma Conserve_App_s_u : (s1,s2,u1,u2,v1,v2:Word)(Derive_P_A_3 <Word,Conf>(s1,<Word,Word>(u1,v1)) <Word,Conf>(s2,<Word,Word>(u2,v2)))->
<Word>(Append s1 v1)=(Append s2 v2).
Goal.
Intros s1 s2 u1 u2 v1 v2 Derive_P_A_3_s1_v1_s2_v2.
Change ([a,b:Word*Conf]
<Word>(Append <Word,Conf>Fst(a) <Word,Word>Snd(<Word,Conf>Snd(a)))=
	(Append <Word,Conf>Fst(b) <Word,Word>Snd(<Word,Conf>Snd(b)))

<Word,Conf>(s1,<Word,Word>(u1,v1)) <Word,Conf>(s2,<Word,Word>(u2,v2))).


Elim Derive_P_A_3_s1_v1_s2_v2;Simpl.
Intros w u s x dans_x_X.
Replace (cons x u) with (Append (cons x nil) u);Trivial.
Auto.
Save.

Lemma Derisvestar_P_A_3_conserve : (s1,s2,u1,u2,v1,v2:Word)(Derivestar_P_A_3 <Word,Conf>(s1,<Word,Word>(u1,v1)) <Word,Conf>(s2,<Word,Word>(u2,v2)))->
<Word>(Append s1 v1)=(Append s2 v2).
Goal.
Unfold Derivestar_P_A_3 Rstar.
Intros s1 s2 u1 u2 v1 v2 Derivestar_P_A_3_s1_v1_s2_v2.
Change ([a,b:Word*Conf]
<Word>(Append <Word,Conf>Fst(a) <Word,Word>Snd(<Word,Conf>Snd(a)))=
	(Append <Word,Conf>Fst(b) <Word,Word>Snd(<Word,Conf>Snd(b)))

<Word,Conf>(s1,<Word,Word>(u1,v1)) <Word,Conf>(s2,<Word,Word>(u2,v2))).

Apply Derivestar_P_A_3_s1_v1_s2_v2.
Trivial.
Intros u v w.
Elim u . Intros uu1 uuc. Elim uuc. Intros uu2 uu3.
Elim v. Intros vv1 vvc. Elim vvc. Intros vv2 vv3.
Simpl.
Intros Der eg1 .
Rewrite <- eg1.
Apply Conserve_App_s_u with uu2 vv2.
Assumption.
Save.



Lemma Derive_P_A_2_imp_Derive_P_A_3 :
(s:Word)(x,y:Conf)(Derive_P_A_2 x y)->
<Word> Ex ([s2:Word](Derive_P_A_3 <Word,Conf>(s,x) <Word,Conf>(s2,y))).
Goal.
Intros s x y Derive_P_A_2_x_y.
Elim Derive_P_A_2_x_y.
Intros w u x0 dans_x0_X.
Exists (Append s (cons x0 nil)).
Apply Derive3_X;Assumption.

Intros v w u x0 dans_couple.
Exists s.
Apply Derive3_V;Assumption.
Save.

Lemma Derivestar_P_A_2_imp_Derivestar_P_A_3 : 
(x,y:Conf)(Derivestar_P_A_2 x y)->
(s:Word)<Word> Ex ([s2:Word](Derivestar_P_A_3 <Word,Conf>(s,x) <Word,Conf>(s2,y))).
Goal.
Unfold Derivestar_P_A_2 Rstar Derivestar_P_A_3.
Intros x y Der_star.
Pattern x y.
Apply Der_star.
Exists s.
Apply Rstar_reflexive.

Intros u v w Der_u_v Ex_v_w s.
ElimType <Word> Ex ([s2:Word](Derive_P_A_3 <Word,Conf>(s,u) <Word,Conf>(s2,v))).
Intros s1 Der_3_s_u_s1_v.
Elim (Ex_v_w s1).
Intros s2 Rstar_s1_v_s2_w.
Exists s2.
Apply Rstar_R with <Word,Conf>(s1,v);Trivial.
Apply Derive_P_A_2_imp_Derive_P_A_3;Assumption.
Save.

Lemma Deriveg_imp_Deriveg_App_2 : (x,y,a:Word)(inmonoid X a)->(Deriveg X R x y)->
(Deriveg X R (Append a x) (Append a y)).
Goal.
Intros x y a.
Pattern a.
Apply induction_word.
Auto.

Intros x0 w Hyp inmonoid_X_cons_x0_w Der_x_y.
Change (Deriveg X R (cons x0 (Append w x)) (cons x0 (Append w y))).
Apply Deriveg2.
Apply inmonoid_cons_inv2 with w;Assumption.
Apply Hyp.
Apply inmonoid_cons_inv with x0;Assumption.
Assumption.
Save.


Lemma Derive_P_A_3_imp_Derivegstar : (x,y,x',y',s,s':Word)
(Derive_P_A_3 <Word,Conf>(s,<Word,Word>(x,y))
		<Word,Conf>(s',<Word,Word>(x',y')))->
(inmonoid X s)->
(Derivegstar X R (Append s x) (Append s' x')).
Goal.
Intros x y x' y' s s' Der .
Change ([a,a':Word*Conf](inmonoid X <Word,Conf>Fst(a))->(Derivegstar X R 
(Append <Word,Conf>Fst(a) <Word,Word>Fst(<Word,Conf>Snd(a)))
(Append <Word,Conf>Fst(a') <Word,Word>Fst(<Word,Conf>Snd(a'))))

<Word,Conf>(s,<Word,Word>(x,y)) <Word,Conf>(s',<Word,Word>(x',y'))).

Unfold Derivegstar.
Elim Der;Simpl.
Intros w u s0 x0 dans_x0_X inmon_s.
Replace (Append (Append s0 (cons x0 nil)) w) with
(Append s0 (Append (cons x0 nil) w)).
Apply Rstar_reflexive.
Auto.

Intros v w u s0 x0 dans_couple_x0_u_R inmon_s.
Apply Rstar_R with (Append s0 (Append u w)).
Apply Deriveg_imp_Deriveg_App_2.
Assumption.
Apply Deriveg1.
Assumption.
Apply Rstar_reflexive.
Save.


Lemma Derive_P_A_3_conserve_inmonoid_s : (x,y,x',y',s,s':Word)
(Derive_P_A_3 <Word,Conf>(s,<Word,Word>(x,y))
		<Word,Conf>(s',<Word,Word>(x',y')))->
(inmonoid X s)->
(inmonoid X s').
Goal.
Intros x y x' y' s s' Der .
Change ([a,a':Word*Conf](inmonoid X <Word,Conf>Fst(a))->
			(inmonoid X <Word,Conf>Fst(a'))

<Word,Conf>(s,<Word,Word>(x,y)) <Word,Conf>(s',<Word,Word>(x',y'))).

Elim Der;Simpl.
Intros.
Apply inmonoid_Append;Auto.
Auto.
Save.

Lemma Derivestar_P_A_3_imp_Derivegstar : (x,y,x',y',s,s':Word)
(Derivestar_P_A_3 <Word,Conf>(s,<Word,Word>(x,y))
		<Word,Conf>(s',<Word,Word>(x',y')))->
(inmonoid X s)->
(Derivegstar X R (Append s x) (Append s' x')).
Goal.
Unfold Derivestar_P_A_3 Rstar .
Intros x y x' y' s s' Der_star .
Change ([a,a':Word*Conf](inmonoid X <Word,Conf>Fst(a))->(Derivegstar X R 
(Append <Word,Conf>Fst(a) <Word,Word>Fst(<Word,Conf>Snd(a)))
(Append <Word,Conf>Fst(a') <Word,Word>Fst(<Word,Conf>Snd(a'))))

<Word,Conf>(s,<Word,Word>(x,y)) <Word,Conf>(s',<Word,Word>(x',y'))).

Apply Der_star;Unfold Derivegstar.

Intros.
Apply Rstar_reflexive.

Intros u v w.
Elim u. Intros u1 uc.Elim uc. Intros u2 u3.
Elim v. Intros v1 vc.Elim vc. Intros v2 v3.
Simpl.
Intros Der_3_u_v Hyp inmon_u1.
Apply Rstar_transitive with (Append v1 v2). 
Change (Derivegstar X R (Append u1 u2) (Append v1 v2)).
Apply Derive_P_A_3_imp_Derivegstar with u3 v3.
Assumption.
Assumption.
Apply Hyp.
Apply Derive_P_A_3_conserve_inmonoid_s with u2 u3 v2 v3 u1.
Assumption.
Assumption.
Save.


(*Tout mot reconnu par l'automate est reconnu par la grammaire*)
Theorem Derivestar_P_A_imp_Derivestar :
(x,y:Word)
  (Derivestar_P_A X d <Word,Word>(x,y) <Word,Word>(nil,nil) )->
    (Derivestar R x y)
.
Goal.
Intros x y Derivestar_P_A_x_y_nil_nil.
ElimType <Word> Ex ([s2:Word](Derivestar_P_A_3 <Word,Conf>(nil,<Word,Word>(x,y)) <Word,Conf>(s2,<Word,Word>(nil,nil)))).
Intros s2 Derivestar_P_A_3_x_y.
Apply Derivegstar_Derivestar with X.
Replace x with (Append nil x).
Replace y with (Append s2 nil).
Apply Derivestar_P_A_3_imp_Derivegstar with y nil.
Assumption.
Trivial.
Replace y with (Append nil y).
Apply sym_equal.
Apply Derisvestar_P_A_3_conserve with x nil.
Assumption.
Trivial.
Trivial.

Apply Derivestar_P_A_2_imp_Derivestar_P_A_3 .
Auto.
Save.

Hint Derivestar_P_A_imp_Derivestar.



(******************************************)
(*equivalence de G et de l'automate a pile*)
(******************************************)

Theorem equiv_APD_Gram : (l_egal (LA X wd wa d) (LG X V R S')).
Goal.
Red.
Unfold l_inclus LA LG.
Split.
Intros w temp; Elim temp;Intros Der inmon.
Auto.
Intros w temp; Elim temp;Intros Der inmon.
Auto.
Save.




End APD.

Provide gram_aut.
