Require Words.
Require more_words.
Require need.
Require fonctions.
Require Relations.

Definition Mots = [X:Ensf](a:Elt)(dans a X)->(<Word> Ex ([w:Word]
							 <Elt>(word w)=a
							)
					     )
.


Definition Regles = [X,V,R:Ensf]
(x:Elt)(dans x R)->
		(<Elt> Ex2(
			  [A:Elt](dans A V)

			  ,[A:Elt]<Word>Ex2(
					     [B:Word]
					     <Elt>x=(couple A (word B))

					    ,[B:Word](inmonoid (union X V) B)

					    )
			  )
		).



Lemma Regles_inv1 : (X,V,R:Ensf)(x,y:Elt)(Regles X V R)->
(dans (couple x y) R)->(dans x V).
Goal.
Intros X V R x y Regles_R dans_couple_R.
Cut 		(<Elt> Ex2(
			  [A:Elt](dans A V)

			  ,[A:Elt]<Word>Ex2(
					     [B:Word]
					     <Elt>(couple x y)=(couple A (word B))

					    ,[B:Word](inmonoid (union X V) B)

					    )
			  )
		).
Intro temp;Elim temp;Clear temp.
Intros x0 dans_x0_V temp; Elim temp;Clear temp.
Intros u eg_couple inmonoid_u.
Replace x with x0.
	Assumption.
	Apply sym_equal.
	Apply couple_couple_inv1 with y (word u); Assumption.

Apply Regles_R; Assumption.
Save.

Lemma Regles_inv2 : (X,V,R:Ensf)(x:Elt)(u:Word)(Regles X V R)->
(dans (couple x (word u)) R)->(inmonoid (union X V) u).
Goal.
Intros X V R x u Regles_R dans_couple_R.
(**) Cut 	(<Elt> Ex2(
			  [A:Elt](dans A V)

			  ,[A:Elt]<Word>Ex2(
					     [B:Word]
					     <Elt>(couple x (word u))=(couple A (word B))

					    ,[B:Word](inmonoid (union X V) B)

					    )
			  )
		).
Intro temp;Elim temp;Clear temp.
Intros x0 dans_x0_V temp; Elim temp;Clear temp.
Intros u0 eg_couple inmonoid_u0.
Replace u with u0.
	Assumption.
	Apply word_word_inv.
	Apply couple_couple_inv2 with x0 x;Auto.
(**) Apply Regles_R; Assumption.
Save.


(* Definition d'une grammaire, *)
(*X : ensemble des terminaux, *)
(*V ensemble des non-terminaux, *)
(*R ensemble des productions A -> w, *)
(*S axiome *)

Definition isGram : Ensf -> Ensf -> Ensf -> Elt -> Prop = 

[X,V,R:Ensf][S:Elt]
(
	(Mots X)
	/\(inter X V empty)
	/\(dans S V)
	/\(Regles X V R)
)



.

Section Easy_lemma_isGram.
Variable X,V,R:Ensf.
Variable S:Elt.
Local H = (isGram X V R S).
Lemma isGram1 : H->(Mots X).
Goal.
Intro H.
Elim H.
Trivial.
Save.

Lemma isGram2 : H->(inter X V empty).
Goal.
Intro H.
Elim H.
Intro.
Intro main.
Elim main.
Clear main.
Trivial.
Save.

Lemma isGram3 : H->(dans S V).
Goal.
Intro H.
Elim H.
Intro.
Intro main.
Elim main.
Clear main.
Intro.
Intro main.
Elim main.
Clear main.
Trivial.
Save.


Lemma isGram4 : H->(Regles X V R).
Goal.
Intro H.
Elim H.
Intro.
Intro main.
Elim main.
Clear main.
Intro.
Intro main.
Elim main.
Clear main.
Trivial.
Save.

Lemma isGram5 : (Mots X)->(inter X V empty)->(dans S V)->(Regles X V R)
->H.
Goal.
Intros.
Red ; Red.
Auto.
Save.


End Easy_lemma_isGram.
(*--------*)

Lemma Regles_R : (X,V,R,R':Ensf)
(inclus R' R)->
(Regles X V R)
->(Regles X V R')
.
Goal.
Unfold Regles.
Intros X V R R' incl Hyp x dans_x_R'.
Apply Hyp; Apply incl; Assumption.
Save.

Lemma Regles_V : (X,V,R,V':Ensf)
(inclus V V')->
(Regles X V R)->
(Regles X V' R).
Goal.
Unfold Regles.
Intros X V R V' inclus_V_V' Regles_X_V_R x dans_x_R.
Elim (Regles_X_V_R x dans_x_R).
Intros A dans_A_V temp; Elim temp;Clear temp.
Intros B egal_B inmonoid_B.
Exists A.
Apply inclus_V_V'; Assumption.
Exists B.
Assumption.
Apply inmonoid_inclus with (union X V); Auto.
Save.



Lemma Regles_add : (X,V,R:Ensf)(a:Elt)(u:Word)
(Regles X V R)->(dans a V)->(inmonoid (union X V) u)->
(Regles X V (add (couple a (word u))
		R)).
Goal.
Intros X V R a u R_R dans_a_V inmonoid_u_X_V_u.
Red.
Intros x dans_x_R'.
Cut (<Elt>(couple a (word u))=x)\/(dans x R).(**)
Intro temp;Elim temp; Clear temp.
	Intro egal_x_couple.
	Exists a.
		Assumption.
		Exists u;Auto.

	Intro dans_x_R.
	Apply R_R;Assumption.

(**)Apply dans_add;Assumption.
Save.

Lemma Regles_add2 : (X,V,R:Ensf)(a:Elt)
(Regles X V R)->(Regles X (add a V) R).
Goal.
Intros.
Apply Regles_V with V;Auto.
Save.


Lemma Regles_union : (X,V,R,R':Ensf)
(Regles X V R)->(Regles X V R')->
(Regles X V (union R R')).

Goal.
Unfold Regles.
Intros X V R R' R_R R_R' x dans_x_union.
Cut (dans x R)\/(dans x R').
Intro temp; Elim temp; Clear temp.
	Intro dans_x.
	Elim (R_R x dans_x).
	Intros A dans_A temp.
	Elim temp; Clear temp.
	Intros B egal_x inmonoid_B.
	Exists A. Assumption.
	Exists B; Assumption.

	Intro dans_x.
	Elim (R_R' x dans_x).
	Intros A dans_A temp.
	Elim temp; Clear temp.
	Intros B egal_x inmonoid_B.
	Exists A. Assumption.
	Exists B; Assumption.

(*Cut*)
Auto.
Save.



Lemma isGram_inclus2 : (X,V,R,R':Ensf)(S:Elt)
(inclus R' R)->
(isGram X V R S)->
(isGram X V R' S).
Goal.
Intros X V R R' S incl isGram_X_V_R_S.
Apply isGram5.
	Apply isGram1 with V R S; Assumption.
	Apply isGram2 with R S; Assumption.
	Apply isGram3 with X R; Assumption.
	Apply Regles_R with R. Assumption.
	Apply isGram4 with S; Assumption.
Save.

Lemma isGram_inclus3 : (X,V,R:Ensf)(S,a:Elt)
(isGram X V (add a R) S)->(isGram X V R S).
Goal.
Intros X V R S a isGram_X_V_a_R_S.
Apply isGram_inclus2 with (add a R).
	Red; Intros ; Auto.
	Assumption.
Save.


(*--------------------------*)




(* (Derive R u v) signifie "u se recrit en v par une production de R" *)
Inductive Definition Derive [R:Ensf] : Word -> Word -> Prop =

(*si A -R-> u alors Av -G-> uv *)
Derive1		: (u,v:Word)(A:Elt)(dans (couple A (word u)) R) 
			-> (Derive R (cons A v) (Append u v))

(*si u -G-> v alors x::u -G-> x::v*)
| Derive2		: (u,v:Word)(x:Elt)(Derive R u v)
			->(Derive R (cons x u) (cons x v))

.



Lemma Derive_inclus : (R1,R2:Ensf)(u,v:Word)
(inclus R1 R2)->(Derive R1 u v)->(Derive R2 u v).
Goal.
Intros R1 R2 u v inclus_R1_R2 Der_R1.
Elim Der_R1.
Intros.
Apply Derive1.
Apply inclus_R1_R2;Assumption.

Intros.
Apply Derive2;Assumption.
Save.


Definition Derive_inv = [R:Ensf][x,y:Word]
(<[s:sortes]Prop>Match x with
	False
	[x:Elt][Hx:Prop][e:Ensf][He:Prop]False

      [n:nat]False
      [a:Elt][Ha:Prop][b:Elt][Hb:Prop]False
      [e:Ensf][He:Prop]False
      [w:Word][Hw:Prop]False
 
      False
      [A:Elt][Ha:Prop][w:Word][Hw:Prop]
       ( (<Word> Ex2 ([u:Word](dans (couple A (word u)) R)
		    ,[u:Word](<Word> Ex2 ([v:Word](<Word>(cons A v)=x)
					 ,[v:Word](<Word>(Append u v)=y)
					)
				)
			)
	)

	\/

	(<Word> Ex2 ([v:Word](Derive R w v)
		    ,[v:Word]<Word>(cons A v)=y
		    )
	))
).


Lemma Derive_inv1 : (R:Ensf)(u,v:Word)(Derive R u v)->(Derive_inv R u v).
Goal.
Intros R x y Der_x_y.
Unfold Derive_inv.
Elim Der_x_y.
Intros u v A dans_couple.
Apply or_introl.
Exists u; [Assumption | Exists v; Apply refl_equal].
Intros u v x0 Der_u_v Der_inv_u_v.
Apply or_intror.
Exists v; Trivial.
Save.

Lemma Derive_inv2 : (R:Ensf)(x,y:Word)(Derive_inv R x y)->
<Elt> Ex ([A:Elt]
	<Word> Ex2 ([w:Word]<Word>(cons A w)=x
		   ,[w:Word]
( (<Word> Ex2 ([u:Word](dans (couple A (word u)) R)
		    ,[u:Word](<Word> Ex2 ([v:Word](<Word>(cons A v)=x)
					 ,[v:Word](<Word>(Append u v)=y)
					)
				)
			)
	)

	\/

	(<Word> Ex2 ([v:Word](Derive R w v)
		    ,[v:Word]<Word>(cons A v)=y
		    )
	))


		)
	)

.
Goal.
Intros R x y .
Pattern x.
Apply induction_word.
Unfold Derive_inv.
Intro temp; Elim temp.
Intros x0 w Hyp_rec .
Unfold Derive_inv.
Intro temp; Elim temp; Clear temp.
Intro temp; Elim temp; Clear temp.
Intros x1 dans_couple_R temp; Elim temp; Clear temp.
Intros x2 cons_x0_x2_cons_x0_w Append_x1_x2_y.
Exists x0.
Exists w.
Trivial.
Apply or_introl.
Exists x1.
Assumption.
Exists w.
Trivial.
Replace w with x2.
Assumption.
Cut (<Elt>x0=x0 /\ <Word>x2=w).
Intro temp;Elim temp;Clear temp.
Intros; Auto.
Apply cons_cons_inv; Assumption.
Intro temp; Elim temp; Clear temp.
Intros x1 der_R cons_x0_x1_y.
Exists x0.
Exists w.
Trivial.
Apply or_intror.
Exists x1;Assumption.
Save.

Lemma Derive_inv3 : (R:Ensf)(x,y:Word)(Derive R x y)->
<Elt> Ex ([A:Elt]
	<Word> Ex2 ([w:Word]<Word>(cons A w)=x
		   ,[w:Word]
( (<Word> Ex2 ([u:Word](dans (couple A (word u)) R)
		    ,[u:Word](<Word> Ex2 ([v:Word](<Word>(cons A v)=x)
					 ,[v:Word](<Word>(Append u v)=y)
					)
				)
			)
	)

	\/

	(<Word> Ex2 ([v:Word](Derive R w v)
		    ,[v:Word]<Word>(cons A v)=y
		    )
	))


		)
	)

.

Proof [R:Ensf][x,y:Word][D : (Derive R x y)]
(Derive_inv2 R x y (Derive_inv1 R x y D)).


Lemma in_mon_X_Der_imp_inmon_X :
(X,V,R:Ensf)
  (u,v:Word)
    (Regles X V R)->
      (Derive R u v)->
        (inmonoid (union X V) u)->
          (inmonoid (union X V) v).

Goal.
Intros X V1 R1 u v Regles_R1 Der_R1.
Elim Der_R1.
	Intros u0 v0 A dans_R1 inmonoid_cons_A_v0.
	Apply inmonoid_Append.
		Apply Regles_inv2 with R1 A;Assumption.
		Apply inmonoid_cons_inv with A; Assumption.

	Intros u0 v0 x Der_R1_u0 imp inmon_cons_x_u0.
	Apply inmonoid_cons.
		Apply imp.
		Apply inmonoid_cons_inv with x;Assumption.

		Apply inmonoid_cons_inv2 with u0;Assumption.

Save.


(*  (Derivestar R u v) signifie "u se recrit en v par zero ou plusieurs productions de R" *)


Definition Derivestar =
[R:Ensf](Rstar Word (Derive R)).

Lemma Derivestar_refl : (R:Ensf)(u:Word)
(Derivestar R u u).
Goal.
Intros.
Red.
Apply Rstar_reflexive.
Save.

Hint Derivestar_refl.

Lemma Derivestar_R : (R:Ensf)(u,v,w:Word)
(Derive R u v)->(Derivestar R v w)->(Derivestar R u w).
Goal.
Unfold Derivestar.
Intros.
Apply Rstar_R with v;Assumption.
Save.

 
Lemma Derivestar_inv :
(R:Ensf)(u,v:Word)(Derivestar R u v)->(<Word>u=v\/<Word> Ex2 ([w:Word](Derive R u w),
						[w:Word](Derivestar R w v))).
Goal.
Unfold Derivestar.
Intros R u v Der_R.
Apply Rstar_inv;Assumption.
Save.

Hint Derivestar_inv.


Lemma Derivestar_inclus : (R1,R2:Ensf)(u,v:Word)
(inclus R1 R2)->(Derivestar R1 u v)->(Derivestar R2 u v).
Goal.
Intros R1 R2 u v inclus_R1_R2 Der_R1.
Unfold Derivestar Rstar in Der_R1.
Pattern u v.
Apply Der_R1.
	Auto.
	Intros a b c Der_a_b Der_b_c.
	Apply Derivestar_R with b.
		Apply Derive_inclus with R1;Assumption.
		Assumption.
Save.







(* LG X V R S est l'ensemble de mots engendre par la grammaire (X V R S) *)

Definition LG : Ensf -> Ensf -> Ensf -> Elt -> wordset =
	[X,V,R:Ensf][S:Elt][w:Word]
			(Derivestar R (cons S nil) w)
			/\ (inmonoid X w)
.


Lemma LG_inv : (X:Ensf)(V:Ensf)(R:Ensf)(S:Elt)(w:Word)(LG X V R S w)->(inmonoid X w).
Goal.
Unfold LG.
Intros.
Elim H; Auto.
Save.

(*Pour toute grammaire (X,V,R,S), (LG X V R S) est un langage *)

Lemma LG_langage :
  (X,V,R:Ensf)
    (S:Elt)
      (isGram X V R S)->
        (islanguage X (LG X V R S)).
Goal.
Intros; Red ; Intros ; Elim H0; Auto.
Save.









(*Reunion de 2 grammaires *)

Definition Gunion.

Variable V1,R1:Ensf.

Variable V2,R2:Ensf.

Local V = (union V1 V2).

Local R = (union R1 R2).


Body (<Ensf,Ensf>(V,R)).

(*------------------*)
Section injprod.

Local injproduc =
[f:Elt->Elt][V:Ensf](extension V f).


Definition injproducg : Ensf -> Elt -> Elt =
	(injproduc injgauche).

Definition injproducd : Ensf -> Elt->Elt =
	(injproduc injdroite).
					
(*prennent en arguments l'ensemble de non-terminaux V,*)
(*de productions R et rendent*)
(*les injections gauche et droite*)
(*utilisees ensuite pour la definition de G_union_disj_p.*)

End injprod.


Definition Gunion_disj_p.

Variable V1,R1:Ensf.
Variable S1:Elt.

Variable V2,R2:Ensf.
Variable S2:Elt.

Variable S:Elt.

Local G = (Gunion V1 R1 V2 R2).

Local V = (fst Ensf Ensf G).
Local R = (snd Ensf Ensf G).
Local V' = (add S V).
Local R' = (add (couple S (word (cons S1 nil)))
		(add (couple S (word (cons S2 nil)))
			R
		)
	    )
.

Body <Ensf,Ensf*Elt>(V',<Ensf,Elt>(R',S)).





(* image par une fonction d'une grammaire *)

Definition imageGram.

Variable f : Elt-> Elt.
Variable X,V,R:Ensf.
Variable S:Elt.

Local fet = [w:Elt](word (Word_ext f (word_inv w))).

Local Xim = (map f X).
Local Vim = (map f V).
Local fonc = [P:Elt](couple (f (first P))
			    (fet (second P))
		      ).


Local Rim = (map fonc R).
Local Sim = (f S).

Body <Ensf,Ensf*(Ensf*Elt)>(Xim,<Ensf,Ensf*Elt>(Vim,<Ensf,Elt>(Rim,Sim))).



Provide gram.
