Require Words.
Require more_words.
Require need.

Definition comp = [f:Elt->Elt][g:Elt->Elt][x:Elt](f (g x)).

Lemma map_map_eg_map_comp : (f:Elt->Elt)(g:Elt->Elt)(E:Ensf)(<Ensf>(map f (map g E))=(map (comp f g) E)).
Goal.
Intros f g E.
Unfold map comp.
Pattern E.
Apply induction_ensf ; Auto.
Save.


Definition comp_word = [f:Word->Word][g:Word->Word][x:Word](f (g x)).

Definition eg_f_W_W = [f:Word->Word][g:Word->Word]
(x:Word)(<Word>(f x)=(g x)).


Lemma comp_Word_ext : (f:Elt->Elt)(g:Elt->Elt)
	(eg_f_W_W (Word_ext (comp f 	g)) 
		  (comp_word (Word_ext f) (Word_ext g))
	).
Goal.
Intros f g.
Red.
Intro w.
Pattern w.
Apply induction_word; Auto.
Clear w.
Intros x w Hyp.
Unfold Word_ext comp comp_word.
Auto.
Save.



Definition Id = [E:Ensf][f:Elt->Elt](x:Elt)(dans x E)->(<Elt>(f x)=x).

Lemma Id_inv : (E:Ensf)(f:Elt->Elt)(x:Elt)(dans x E)->(Id E f)->(<Elt>(f x)=x).

Proof [E:Ensf][f:Elt->Elt][x:Elt][dans_x_E:(dans x E)][Id_E_f : (Id E f)]
(Id_E_f x dans_x_E).

Lemma Id_inclus : (E:Ensf)(F:Ensf)(f:Elt->Elt)
(inclus F E)->(Id E f)->(Id F f).
Goal.
Intros E F f inclus_F_E Id_E_f.
Red.
Intros x dans_x_E.
Apply Id_E_f.
Apply inclus_F_E.
Assumption.
Save.

Lemma map_Id : (E:Ensf)(f:Elt->Elt)(Id E f)-><Ensf>(map f E)=E.
Goal.
Intros E f.
Pattern E.
Apply induction_ensf; Unfold map.
 Intro; Apply refl_equal.

 Intros a b Hyp_rec Id_a_b_f.
 Apply add_add.
	Apply Id_a_b_f.
	Apply dans_add1.

	Apply Hyp_rec.
	Apply Id_inclus with (add a b);Auto.
Save.


Definition Id_words = [E:Ensf][f:Word->Word](x:Word)(inmonoid E x)->(<Word>(f x)=x).

Lemma Id_words_inv : (E:Ensf)(f:Word->Word)(x:Word)(inmonoid E x)->(Id_words E f)->(<Word>(f x)=x).

Proof [E:Ensf][f:Word->Word][x:Word][inmonoid_E_x:(inmonoid E x)][Id_words_E_f : (Id_words E f)]
(Id_words_E_f x inmonoid_E_x).


Lemma Id_words_inclus : (E:Ensf)(F:Ensf)(f:Word->Word)
(inclus F E)->(Id_words E f)->(Id_words F f).
Goal.
Intros E F f inclus_F_E Id_E_f.
Red.
Intros x inmonoid_F_x.
Apply Id_E_f.
Apply inmonoid_inclus with F ; Assumption.
Save.


Lemma extension_Id : (E:Ensf)(f:Elt->Elt)(Id E f)->(Id_words E (Word_ext f)).
Goal.
Intros E f Id_E_f.
Red.
Intro x. 
Pattern x.
Apply induction_word; Clear x.
	Auto.

	Intros x w Hyp inmonoid_E_cons_x_w.
	Unfold Word_ext.
	Apply cons_cons.
		Apply Id_E_f; Apply inmonoid_cons_inv2 with w; Assumption.

		Apply Hyp.
		Apply inmonoid_cons_inv with x; Assumption.

Save.


Section fonctions.


Variable E : Ensf.
Variable F : Ensf.
Variable f : Elt->Elt.

(*Definition d'une application*)

Definition application =

(x:Elt)(dans x E)->(dans (f x) F).



(*Definition de l'injectivite*)

Definition is_mono = 

(x:Elt)(y:Elt)(dans x E)->(dans y E)->(<Elt>(f x)=(f y))->(<Elt>x=y).



(*Definition surjectivite*)

Definition is_epi =

application
/\
(x:Elt)(dans x F)->(<Elt> Ex2 ([y:Elt]<Elt>x=(f y)
					   ,[y:Elt](dans y E)
					   )
				)
.


Definition is_iso =
is_epi /\ is_mono.


Lemma mono_epi_imp_iso : is_mono->is_epi->is_iso.
Proof [mono:is_mono][epi:is_epi]<is_epi,is_mono>{epi,mono}.


Variable fw : Word->Word.

(*Definition d'une application pour les mots*)

Definition application_words =

(x:Word)(inmonoid E x)->(inmonoid F (fw x)).



(*Definition de l'injectivite*)


Definition is_mono_words = 

(x:Word)(y:Word)(inmonoid E x)->(inmonoid E y)->(<Word>(fw x)=(fw y))->(<Word>x=y).


(*Definition surjectivite pour les fonctions sur les monoides*)


Definition is_epi_words =

application_words

/\
(x:Word)(inmonoid F x)->(<Word> Ex2 ([y:Word]<Word>x=(fw y)
			      ,[y:Word](inmonoid E y)
			      )
		    )
.


Definition is_iso_words =
(is_mono_words /\ is_epi_words).

Lemma mono_epi_imp_iso_words : is_mono_words->is_epi_words->is_iso_words.
Proof [mono:is_mono_words][epi:is_epi_words]<is_mono_words,is_epi_words>{mono,epi}.

End fonctions.


Hint mono_epi_imp_iso.


Parameter inv : Ensf->Ensf->(Elt->Elt)->(Elt->Elt).

Axiom dans_inv_f : (E:Ensf)(F:Ensf)(f:Elt->Elt)
(is_iso E F f)->(x:Elt)(dans x F)->(dans (inv E F f x) E).


Axiom inv1 : (E:Ensf)(F:Ensf)(f:Elt->Elt)
(is_iso E F f)->(x:Elt)(dans x E)->(<Elt>((inv E F f) (f x))=x).

Axiom inv2 : (E:Ensf)(F:Ensf)(f:Elt->Elt)
(is_iso E F f)->(x:Elt)(dans x F)->(<Elt>(f (inv E F f x))=x).

Lemma inv1' : (E:Ensf)(F:Ensf)(f:Elt->Elt)
(is_iso E F f)->(Id E (comp (inv E F f) f)).
Goal.
Unfold Id comp.
Intros.
Apply inv1; Assumption.
Save.

(* On etend la fonction f : Elt-> Elt definie sur V*)
(*en la fonction F=(extension V f)*)
(*definie sur Elt par F(x) = f(x) sur V et F(x)=x ailleurs*)


Lemma extension_spec : (V:Ensf)(f:Elt->Elt)(x:Elt)
{y:Elt | ((dans x V)/\<Elt>y=(f x)) \/ (~(dans x V)/\<Elt>y=x)}.
Goal.
Realizer 
	[V:Ensf][f:Elt -> Elt][x : Elt]
			(<Elt> Match (Dans_spec x V) with 
							(*true*) (f x)
							(*false*) x
			)
.
Program_all.
Save.

Definition extension = [V:Ensf][f:Elt->Elt][x:Elt]
(<Elt>Match (extension_spec V f x) with [y:Elt][p:((dans x V)/\<Elt>y=(f x)) \/ (~(dans x V)/\<Elt>y=x)]y).


Lemma extension_in : (e:Ensf)(f:Elt->Elt)(x:Elt)(dans x e)->(<Elt>(extension e f x)=(f x)).
Goal.
Unfold extension.
Intros e f x dans_x_e.
Elim (extension_spec e f x).
Intros y temp; Elim temp;Clear temp;Intro temp; Elim temp;Clear temp.
	Auto.

	Intro N_dans_x_e.
	Elim (N_dans_x_e dans_x_e).
Save.

Lemma  extension_out : (e:Ensf)(f:Elt->Elt)(x:Elt)(~(dans x e))->(<Elt>(extension e f x)=x).
Goal.
Unfold extension.
Intros e f x N_dans_x_e.
Elim (extension_spec e f x).
Intros y temp; Elim temp;Clear temp;Intro temp; Elim temp;Clear temp.
	Intro dans_x_e.
	Elim (N_dans_x_e dans_x_e).

	Auto.
Save.



Section fonctions2.


Variable E : Ensf.
Variable F : Ensf.
Variable f : Elt->Elt.

Lemma is_epi_f_over_image : (is_epi E (map f E) f).
Goal.

Red.
Split.
Red.
Intros.
Apply dans_map_inv;Auto.


Intros.
Cut <Elt>Ex([y:Elt]((dans y E) /\ (<Elt>x=(f y)))).
	Intro temp; Elim temp ; Clear temp.
	Intros y temp; Elim temp; Clear temp ; Intros dans_y egal_y.
	Exists y;Auto.

 	Apply dans_map;Assumption.

Save.

Lemma mono_imp_iso_over_image : (is_mono E f)->(is_iso E (map f E) f).
Goal.
Hint is_epi_f_over_image.
Auto.
Save.

Local invf = (inv E F f).

Lemma inv_is_mono : (is_iso E F f)->(is_mono F invf).
Goal.

Intros.
Red.
Hint inv2.
Intros x y dans_x dans_y egal_inv.
Replace x with (f (inv E F f x));Auto.
Replace y with (f (inv E F f y));Auto.
Apply (f_equal Elt Elt);Assumption.
Save.


Lemma inv_is_epi : (is_iso E F f)->(is_epi F E invf).
Goal.

Intro is_iso_f.
Red.
Split.
 Red.
 Intros. Unfold invf. Apply dans_inv_f;Assumption.

 Hint inv1.
 Intros x dans_x.
 Unfold invf.
 Exists (f x);[ Apply sym_equal;Auto | Elim is_iso_f].
 Intros is_epi_f is_mono_f. Elim is_epi_f. Intros application_f epi_f.
 Apply application_f;Assumption.

Save.


Local wef=(Word_ext f).

Lemma application_imp_application_words :
(application E F f)->(application_words E F wef).
Goal.
Intro Hyp.
Red.
Intros x inmon; Elim inmon; Clear inmon.
	Auto.

	Intros.
	Replace (wef (cons e w)) with (cons (f e) (wef w));Auto.
(*	Apply inmonoid_cons; [Assumption | Apply Hyp; Assumption].*)

Save.

Lemma is_mono_f_imp_is_mono_words :
(is_mono E f)->(is_mono_words E wef) .
Goal.
Intro Hyp.
Red.
Intro.
Pattern x.
Apply induction_word.
	Intros.
	Apply sym_equal.
	Apply wef_nil with f.
	Auto.

	Intros x0 w0.Intros.
	Cut <Elt> Ex ([x:Elt](<Word> Ex2 ([w:Word](<Word>(cons x w)=y)
					  ,[w:Word](<Elt>(f x)=(f x0)
						/\<Word>(wef w)=(wef w0))
					  ))).
	Intro temp ; Elim temp ; Clear temp.
	Intro e.
	Intro temp ; Elim temp ; Clear temp.
	Intro r.
	Intros y_egal temp.
	Elim temp ; Clear temp.
	Intros.
	Rewrite <- y_egal.
	Apply cons_cons.
	Apply Hyp; Auto.
	Apply inmonoid_cons_inv2 with w0; Assumption.
	Apply inmonoid_cons_inv2 with r; Rewrite y_egal; Assumption.
	Apply H;Auto.
		Apply (inmonoid_cons_inv E w0 x0);Assumption.
		Apply (inmonoid_cons_inv E r e);Rewrite y_egal; Assumption.

	(*Resolution du Cut*)
	Unfold wef.
	Apply wef_cons.
	Auto.
Save.

Lemma is_epi_f_imp_is_epi_words :
(is_epi E F f)->(is_epi_words E F wef).
Goal.
Intro temp; Elim temp;Clear temp.
Intro application_f.
Intro is_epi_f.
Red.
Split.
Apply application_imp_application_words;Assumption.

Intro x.
Pattern x.
Apply induction_word; Clear x.
	Exists nil ; Auto.

	Intros x w Hyp inmonoid_F_cons.
	Cut (<Word>Ex2([y:Word]<Word>w=(wef y),[y:Word](inmonoid E y))).(*1*)
	Intro temp; Elim temp; Clear temp.
	Intros y1 y1_egal inmonoid_y1.
	Cut (<Elt> Ex2 ([x_ant:Elt]<Elt>x=(f x_ant)
			      ,[x_ant:Elt](dans x_ant E)
			      )
		    ).(*2*)
	Intro temp; Elim temp; Clear temp.
	Intros x_ant x_egal dans_x_ant.
	Exists (cons x_ant y1).
		Unfold wef Word_ext.
		Auto.
		
		Apply inmonoid_cons;Auto.
	(*Cut2*)
	Apply is_epi_f.
		Apply inmonoid_cons_inv2 with w; Assumption.
	(*Cut1*)
	Apply Hyp; Apply inmonoid_cons_inv with x; Assumption.

Save.

Lemma is_iso_f_imp_is_iso_words :
(is_iso E F f)->(is_iso_words E F wef).
Goal.
Intro is_iso_f.
Elim is_iso_f; Intros.
Red.
Split;	[ Apply is_mono_f_imp_is_mono_words; Assumption
	| Apply is_epi_f_imp_is_epi_words; Assumption].	
Save.

Local invf = (inv E F f).
Local weinvf = (Word_ext invf).
Local weinvf_wef = (comp_word weinvf wef).


Lemma is_iso_f_imp_Id_words_weinvf_wef :
(is_iso E F f)->(Id_words E weinvf_wef).
Goal.


Intro is_iso_f.
Red.
Intro x.
Unfold weinvf_wef weinvf wef. 
Cut (eg_f_W_W (Word_ext (comp invf f)) 
			(comp_word (Word_ext invf) (Word_ext f))).
Unfold eg_f_W_W.
Intro Hyp.
Rewrite <- (Hyp x).
Generalize x.
Change (Id_words E (Word_ext (comp invf f))).
Apply extension_Id.
Unfold invf.
Apply inv1'.
Assumption.


(*Cut*)
Apply comp_Word_ext.
Save.



End fonctions2.

Provide fonctions.
