Require gram_aut.

Section APD.
Variable X , P : Ensf.
Variable wd : Word.
Variable wa : Word.
Variable d : Ensf.
Local L=(LA X wd wa d).

Axiom APD : (P_automata X P wd wa d) ->(u:Word) {(L u)}+{~(L u)}.

End APD.

Section parser.
Variable X,V,R:Ensf.
Variable S':Elt.
Hypothesis H : (isGram X V R S').
Local LL=(LG X V R S').

Theorem Parser1 : (u:Word){(LL u)}+{~(LL u)}.
Goal.
Intros.
Local P=(union X V).

Local f_R_d = [a:Elt](couple (word (cons (first a) nil))
			  (couple (eps X) (second a))
			).

Local f_X_d = [x:Elt](couple (word (cons x nil))
			   (couple x (word nil))
			).

Local d=(union (map f_R_d R) (map f_X_d X)).

Local wd=(cons S' nil).

Local wa=nil.

Local L=(LA X wd wa d).

ElimType {(L u)}+{~(L u)}.

Intro Hyp.
Left.
Cut (l_egal L LL).
Intro temp;Elim temp.
Unfold l_inclus.
Intros.
Auto.
Unfold L LL wa wd d f_R_d f_X_d.
Apply equiv_APD_Gram.
Exact H.

Unfold not.
Intro Hyp.
Right.
Intro LL_u.
Apply Hyp.
Cut (l_egal L LL).
Intro temp;Elim temp.
Unfold l_inclus.
Intros.
Auto.
Unfold L LL wa wd d f_R_d f_X_d.
Apply equiv_APD_Gram.
Exact H.

Unfold L.
Apply APD with P.
Unfold P wd wa d f_R_d f_X_d.
Apply X_P_wd_wa_d.
Exact H.
Save.

End parser.

Provide extract.
