(*---------------------------------------------------------------------------*)
(*                     Les constructeurs sont distincts                      *)
(*---------------------------------------------------------------------------*)

(*---------------------------------------------------------------------------*)
(* On definit la fonction caracteristique des elements de la forme           *)
(* (natural n), pour montrer ~(natural=couple), ~(natural=word), etc         *)
(* On met ces lemmes en indications, pour eliminer automatiquement les cas   *)
(* absurdes dans les demos						     *)
(*---------------------------------------------------------------------------*)

Definition fun_natural : Elt -> Prop =
  [x:Elt]
    (<[s:sortes]Prop>Match x with
	False
        [x:Elt][Hx:Prop][e:Ensf][He:Prop]False

        [n:nat]True
        [a:Elt][Ha:Prop][b:Elt][Hb:Prop]False
	[e:Ensf][He:Prop]False
	[w:Word][Hw:Prop]False

	False
	[a:Elt][Ha:Prop][w:Word][Hw:Prop]False
    ).


Lemma diff_natural_couple : (x:nat)(a,b:Elt)
    ~(<Elt>(natural x)=(couple a b)).
Goal.
Red; Intros x a b H.
Change (fun_natural (couple a b)).
Rewrite <- H.
Red.
Exact I.
Save.
Hint diff_natural_couple.


Lemma diff_natural_up : (x:nat)(e:Ensf)
    ~(<Elt>(natural x)=(up e)).
Goal.
Red; Intros x e H.
Change (fun_natural (up e)).
Rewrite <- H.
Red.
Exact I.
Save.
Hint diff_natural_up.


Lemma diff_natural_word : (x:nat)(w:Word)
    ~(<Elt>(natural x)=(word w)).
Goal.
Red; Intros x w H.
Change (fun_natural (word w)).
Rewrite <- H.
Red.
Exact I.
Save.
Hint diff_natural_word.

(*---- inutile
Lemma diff_couple_natural : (x:nat)(a,b:Elt)
   ~(<Elt>(couple a b)=(natural x)).
Goal.
Auto.
Save.
Hint diff_couple_natural.
----*)

(*---- inutile
Lemma diff_up_natural : (x:nat)(e:Ensf)
    ~(<Elt>(up e)=(natural x)).
Goal.
Auto.
Save.
Hint diff_up_natural.
----*)

Lemma diff_word_natural : (x:nat)(w:Word)
    ~(<Elt>(word w)=(natural x)).
Goal.
Auto.
Save.
Hint diff_word_natural.


(*---------------------------------------------------------------------------*)
(*                 De meme pour les elements de la forme word                *)
(*---------------------------------------------------------------------------*)

Definition fun_word : Elt -> Prop =
  [x:Elt]
    (<[s:sortes]Prop>Match x with
	False
        [x:Elt][Hx:Prop][e:Ensf][He:Prop]False

        [n:nat]False
        [a:Elt][Ha:Prop][b:Elt][Hb:Prop]False
	[e:Ensf][He:Prop]False
	[w:Word][Hw:Prop]True

	False
	[a:Elt][Ha:Prop][w:Word][Hw:Prop]False
    ).

Lemma diff_word_couple :
(x:Word)(n:Elt)(m:Elt)~(<Elt>(word x)=(couple n m)).
Goal.
Red; Intros.
Change (fun_word (couple n m)).
Rewrite <- H.
Red.
Exact I.
Save.


(*---------------------------------------------------------------------------*)
(*                        De meme on montre word != nil                      *)
(*---------------------------------------------------------------------------*)

Definition fun_cons : Word -> Prop =
  [w:Word]
    (<[s:sortes]Prop>Match w with
	False
        [x:Elt][Hx:Prop][e:Ensf][He:Prop]False

        [n:nat]True
        [a:Elt][Ha:Prop][b:Elt][Hb:Prop]False
	[e:Ensf][He:Prop]False
	[w:Word][Hw:Prop]False

	False
	[a:Elt][Ha:Prop][w:Word][Hw:Prop]True
    ).

Lemma diff_cons_nil : (a:Elt)(w:Word)
  ~<Word>(cons a w)=nil.
Goal.
Red.
Intros a w H.
Change (fun_cons nil).
Rewrite <- H.
Red.
Auto.
Save.

Provide diff.
