(*									*)
(*  MOTS,LANGAGES							*)
(*    Le "type" Word est defini dans Ensf.v a partir des constructeurs  *)
(*    nil:Word  et cons:Elt->Word->Word.				*)
(*									*)

Require Ensf.
Require Max.

Parameter alph : Ensf.
Definition epsilon : Elt = (natural (sup alph)).
Lemma not_dans_epsilon_alph : ~(dans epsilon alph).
Goal.
Unfold epsilon.
Apply sup_out.
Save.

(*  On definit le predicat (inmonoid X w) qui signifie que le mot w	*)
(*  est dans le monoide libre engendre par X.				*)

Inductive Definition inmonoid [X:Ensf] : Word->Prop =
  inmonoid_nil  :  (inmonoid X nil)
| inmonoid_cons : (w:Word)(e:Elt)
                    (inmonoid X w)->(dans e X)->(inmonoid X (cons e w)).
Hint inmonoid_nil.
Hint inmonoid_cons.

(*  Inversion de la definition 						*)

Definition Inmonoid : Ensf -> Word -> Prop =
  [X:Ensf][w:Word](<[s:sortes]Prop>Match w with
      False
      [x:Elt][Hx:Prop][e:Ensf][He:Prop]False

      [n:nat]False
      [a:Elt][Ha:Prop][b:Elt][Hb:Prop]False
      [e:Ensf][He:Prop]False
      [w:Word][Hw:Prop]False
 
      True
      [a:Elt][Ha:Prop][w:Word][Hw:Prop]
        ( (dans a X) /\ Hw )
  ).

Lemma i_I : (X:Ensf)(w:Word)
   (inmonoid X w) -> (Inmonoid X w).
Goal.
Intros X w H.
Elim H.
Red; Auto.
Intros.
Change ( (dans e X) /\ (Inmonoid X w0) ).
Auto.
Save.
Hint i_I.

Lemma I_i : (X:Ensf)(w:Word)
   (Inmonoid X w) -> (inmonoid X w).
Goal.
Intros X w; Pattern w; Apply induction_word.
Auto.
Intros x w0 H H0.
Cut ( (dans x X) /\ (Inmonoid X w0) ); Auto.
Intro H1; Elim H1; Clear H1.
Auto.
Save.
Hint I_i.

Lemma inmonoid_cons_inv : (X:Ensf)(w:Word)(a:Elt)
  (inmonoid X (cons a w)) -> (inmonoid X w).
Goal.
Intros.
Cut (Inmonoid X w); Auto.
Cut (Inmonoid X (cons a w)); Auto.
Intro H0.
Cut ( (dans a X) /\ (Inmonoid X w) ); Auto.
Intro H1; Elim H1; Clear H1.
Auto.
Save.

Lemma inmonoid_cons_inv2 : (X:Ensf)(a:Elt)(w:Word)
  (inmonoid X (cons a w)) -> (dans a X).
Goal.
Intros.
Cut (Inmonoid X (cons a w)); Auto.
Intro.
Cut ( (dans a X) /\ (Inmonoid X w)); Auto.
Intro H1; Elim H1; Clear H1.
Auto.
Save.

Lemma inmonoid_inclus : (E:Ensf)(F:Ensf)(x:Word)
  (inclus E F) -> (inmonoid E x) -> (inmonoid F x).
Goal.
Intros E F x inclus_E_F inmonoid_E_x.
Elim inmonoid_E_x.
        Trivial.
 
        Intros w e inmonoid_E_w inmonoid_F_w dans_e_E.
        Apply inmonoid_cons; [Assumption | Apply inclus_E_F; Assumption].
Save.


(*									*)
(*  Concatenation de 2 mots : 						*)
(*    (Append w1 w2) est la concatenation de w1 et w2			*)
(*    (append w1 w2 w3) est la proposition "w3 est la conc.de w1 et w2"	*)
(*									*)

Definition Append : Word -> Word -> Word =
  [w1,w2:Word]
    (<[s:sortes]Word>Match w1 with
        nil
	[x:Elt][Hx:Word][e:Ensf][He:Word]nil
	
	[n:nat]nil
	[a:Elt][Ha:Word][b:Elt][Hb:Word]nil
	[e:Ensf][He:Word]nil
	[w:Word][Hw:Word]nil

	w2
	[a:Elt][Ha:Word][w3:Word][Hw3:Word](cons a Hw3)
    ).

Lemma Append_w_nil : (w:Word) <Word>(Append w nil)=w.
Goal.
Intro w; Pattern w; Apply induction_word.
Auto.
Intros.
Replace (Append (cons x w0) nil) with (cons x (Append w0 nil)); Auto.
Rewrite H; Auto.
Save.

Inductive Definition append : Word -> Word -> Word -> Prop =
  append_nil  : (w:Word) (append nil w w)
| append_cons : (w1,w2,w3:Word)(a:Elt)
		    (append w1 w2 w3) -> (append (cons a w1) w2 (cons a w3)).


(*  Lemmes sur inmonoid et Append...					*)

Lemma Append_inmonoid_g : (X:Ensf)(w1,w2:Word)
  (inmonoid X (Append w1 w2)) -> (inmonoid X w1).
Goal.
Intros X w1; Pattern w1; Apply induction_word.
Auto.
Intros x w H w2.
Replace (Append (cons x w) w2) with (cons x (Append w w2)); Auto.
Intro.
Apply inmonoid_cons.
Apply (H w2).
Apply inmonoid_cons_inv with x; Auto.
Apply inmonoid_cons_inv2 with (Append w w2); Auto.
Save.

Lemma Append_inmonoid_d : (X:Ensf)(w1,w2:Word)
  (inmonoid X (Append w1 w2)) -> (inmonoid X w2).
Goal.
Intros X w1; Pattern w1; Apply induction_word.
Auto.
Intros x w H w2.
Replace (Append (cons x w) w2) with (cons x (Append w w2)); Auto.
Intro.
Apply (H w2).
Apply inmonoid_cons_inv with x; Auto.
Save.

Lemma inmonoid_Append : (X:Ensf)(w1,w2:Word)
  (inmonoid X w1) -> (inmonoid X w2) 
  -> (inmonoid X (Append w1 w2)).
Goal.
Intros X w1; Pattern w1; Apply induction_word.
Auto.
Intros.
Replace (Append (cons x w) w2) with (cons x (Append w w2)); Auto.
Apply inmonoid_cons.
Apply (H w2); Auto.
Apply inmonoid_cons_inv with x; Auto.
Apply inmonoid_cons_inv2 with w; Auto.
Save.


(*									*)
(*  On definit tout d'abord le type wordset, qui est Word->Prop		*)
(*  et qui definit un ensemble de mots par sa fonction caracteristique.	*)
(*  									*)
(*  L'egalite de 2 wordset est definie comme la double implication.	*)
(*									*)

Definition wordset = Word -> Prop.

Definition eqwordset : wordset->wordset->Prop = 
  [l1,l2 : wordset]
    (w : Word)
       (    ((l1 w)->(l2 w))
         /\ ((l2 w)->(l1 w))).

Lemma eqwordset_refl : (L:wordset) (eqwordset L L).
Goal.
Red.
Auto.
Save.

Lemma eqwordset_sym : (l1,l2:wordset)
  (eqwordset l1 l2) -> (eqwordset l2 l1).
Goal.
Unfold eqwordset.
Intros.
Elim (H w); Clear H; Intros; Auto.
Save.

Lemma eqwordset_trans : (l1,l2,l3:wordset)
  (eqwordset l1 l2) -> (eqwordset l2 l3) -> (eqwordset l1 l3).
Goal.
Unfold eqwordset.
Intros.
Elim (H0 w); Clear H0; Intros.
Elim (H w); Clear H; Intros.
Auto.
Save.

(*									*)
(*  Le predicat islangage, defini sur les wordset, dit simplement	*)
(*  que les mots du wordset sont sur l'alphabet alph.			*)
(*									*)

Definition islanguage : Ensf -> wordset -> Prop =
 [X:Ensf][L:wordset](w : Word)(L w)->(inmonoid X w).


(*									*)
(*  Extension aux mots d'une fonction definie sur les elements		*)
(*									*)

Definition Word_ext =
[f : Elt -> Elt][w:Word]
	(<[s:sortes]Word> Match w with 
				nil
				[x:Elt][Wx:Word][e:Ensf][He:Word]nil
				[n:nat]nil
				[a:Elt][Ha:Word][b:Elt][Hb:Word]nil
				[e:Ensf][He:Word]nil
				[w:Word][Hw:Word]nil
				
	    nil
	    [a:Elt][Ha:Word][w:Word][extw:Word](cons (f a) extw)
     ).

Lemma inmonoid_map : (f:Elt->Elt)(a:Ensf)(w:Word)
  (inmonoid a w)->(inmonoid (map f a) (Word_ext f w)).
Goal.
Intros.
Elim H ; [Unfold Word_ext ; Auto | Intros ; Unfold Word_ext ; Apply inmonoid_cons ; Try Apply dans_map_inv ; Auto].
Save.
Hint inmonoid_map.

(*  Un petit lemme bien utile par la suite...				*)

Lemma cons_cons : (x1,x2:Elt)(w1,w2:Word)
  <Elt>x1=x2 -> <Word>w1=w2 -> <Word>(cons x1 w1)=(cons x2 w2).
Goal.
Intros.
Rewrite H0.
Rewrite H.
Auto.
Save.
Hint cons_cons.

Definition fun_consaw_a : Word -> Elt =
  [w:Word](<[s:sortes]Elt>Match w with
				zero
				[x:Elt][Wx:Elt][e:Ensf][He:Elt]zero
				[n:nat]zero
				[a:Elt][Ha:Elt][b:Elt][Hb:Elt]zero
				[e:Ensf][He:Elt]zero
				[w:Word][Hw:Elt]zero
				
	    zero
	    [a:Elt][Ha:Elt][w:Word][extw:Elt]a
  ).

Definition fun_consaw_w : Word -> Word =
  [w:Word](<[s:sortes]Word>Match w with
				nil
				[x:Elt][Wx:Word][e:Ensf][He:Word]nil
				[n:nat]nil
				[a:Elt][Ha:Word][b:Elt][Hb:Word]nil
				[e:Ensf][He:Word]nil
				[w:Word][Hw:Word]nil
				
	    nil
	    [a:Elt][Ha:Word][w0:Word][extw:Word]w0
  ).

Lemma cons_cons_inv : (x1,x2:Elt)(w1,w2:Word)
  <Word>(cons x1 w1)=(cons x2 w2) -> (<Elt>x1=x2 /\ <Word>w1=w2 ).
Goal.
Intros.
Split.
Replace x1 with (fun_consaw_a (cons x1 w1)); Auto.
Replace x2 with (fun_consaw_a (cons x2 w2)); Auto.
Apply (f_equal Word Elt); Auto.
Replace w1 with (fun_consaw_w (cons x1 w1)); Auto.
Replace w2 with (fun_consaw_w (cons x2 w2)); Auto.
Apply (f_equal Word Word); Auto.
Save.

Lemma cons_cons_inv1 : (x1,x2:Elt)(w1,w2:Word)
  <Word>(cons x1 w1)=(cons x2 w2) -> (<Elt>x1=x2).
Goal.
Intros.
Cut (<Elt>x1=x2 /\ <Word>w1=w2 ).
Intro H0; Elim H0; Auto.
Apply cons_cons_inv; Auto.
Save.

Lemma cons_cons_inv2 : (x1,x2:Elt)(w1,w2:Word)
  <Word>(cons x1 w1)=(cons x2 w2) -> (<Word>w1=w2).
Goal.
Intros.
Cut (<Elt>x1=x2 /\ <Word>w1=w2 ).
Intro H0; Elim H0; Auto.
Apply cons_cons_inv; Auto.
Save.

(*									*)
(*  Un mot est soit nil, soit de la forme (cons x w0).			*)
(*									*)

Lemma nil_or_cons : (w:Word)
  (    <Word>w=nil 
   \/  (<Elt>Ex ([x:Elt](<Word>Ex ([w0:Word]( <Word>w=(cons x w0) ))))) ).
Goal.
Intro w; Pattern w; Apply induction_word.

Left; Auto.

Intros.
Right.
Exists x.
Exists w0.
Auto.
Save.

Provide Words.
