(*                 							*)
(*  AUTOMATES FINIS       						*)
(*    On definit le predicat (automate q qd qa d), ou q represente      *)
(*    l'ensemble des etats, qd ceux de depart, qa ceux d'arrivee,	*)
(*    et d la relation de transition, comme la conjonction de :		*)
(*    qd et qa sont inclus dans q , et d est inclus dans qxalphxq	*)
(*                  							*)

Require Words.
Require Dec.

Definition automate : Ensf->Ensf->Ensf->Ensf->Prop = 
  [q,qd,qa,d : Ensf](
       (inclus qa q)
    /\ (inclus qd q)
    /\ (inclus d (prodcart q (prodcart alph q)))
  ).

Lemma automate_def1 : (q,qd,qa,d:Ensf)
  (automate q qd qa d) -> (inclus d (prodcart q (prodcart alph q))).
Goal.
Intros q qd qa d H.
Elim H.
Intros H1 H0; Elim H0; Clear H0.
Auto.
Save.

Lemma automate_def2 : (q,qd,qa,d:Ensf)
  (automate q qd qa d) -> (inclus qd q).
Goal.
Intros q qd qa d H.
Elim H.
Intros H1 H0; Elim H0; Clear H0.
Auto.
Save.

Lemma automate_def3 : (q,qd,qa,d:Ensf)
 (automate q qd qa d) -> (inclus qa q).
Goal.
Intros q qd qa d H.
Elim H.
Intros H1 H0; Elim H0; Clear H0.
Auto.
Save.

(*									*)
(*  On definit le predicat (chemin e1 e2 q d w), qui signifie :		*)
(*  On passe de e1 a e2 par le mot w dans un automate d'ensemble  	*)
(*  d'etats q et de transition d.					*)
(*									*)

Inductive Definition chemin : Elt->Elt->Ensf->Ensf->Word->Prop =
  chemin_nil  : (e1,e2:Elt)(q,d:Ensf)
                 (dans e1 q) -> (<Elt>e1=e2) -> (chemin e1 e2 q d nil)
| chemin_cons : (e1,e2:Elt)(q,d:Ensf)(w:Word)(e,a : Elt)
           (chemin e1 e2 q d w) -> (dans e q) -> (dans a alph) ->
           (dans (couple e (couple a e1)) d) -> (chemin e e2 q d (cons a w)).

(*  On definit le meme predicat d'une autre facon, qui sera plus utile	*)
(*  par la suite							*)

Definition Chemin : Elt->Elt->Ensf->Ensf->Word->Prop =
 [e1,e2:Elt][q,d:Ensf][w:Word]
  (<[s:sortes]Prop>Match w with
	False
	[x:Elt][Hx:Prop][e:Ensf][He:Prop]False

        [n:nat]False
        [a:Elt][Ha:Prop][b:Elt][Hb:Prop]False
        [e:Ensf][He:Prop]False
        [w:Word][Hw:Prop]False

     	((dans e1 q) /\ (<Elt>e1=e2))
      	[a:Elt][Ha:Prop][w:Word][H:Prop]<Elt> Ex ([e:Elt]
      	  (chemin e e2 q d w) /\ (dans e1 q) /\ (dans a alph)
   	  /\ (dans (couple e1 (couple a e)) d))
  ).

(*  On montre l'equivalence entre les 2 definitions : 			*)

Lemma Chemin_chemin : (e1,e2:Elt)(q,d:Ensf)(w:Word)
 (Chemin e1 e2 q d w)->(chemin e1 e2 q d w).
Goal.
Intros until w; Pattern w; Apply induction_word.
Intro.
Cut ((dans e1 q) /\ (<Elt>e1=e2)); Auto.
Intro H0; Elim H0; Clear H0. 
Intros; Apply chemin_nil; Auto.
Intros.
Cut (<Elt>Ex ([e:Elt]( (chemin e e2 q d w0) /\ (dans e1 q) /\ (dans x alph) /\ (dans (couple e1 (couple x e)) d) ))); Auto.
Intro H1; Elim H1.
Intros e H2; Elim H2; Clear H1 H2.
Intros H1 H2; Elim H2; Clear H2.
Intros H2 H3; Elim H3; Clear H3.
Intros.
Apply chemin_cons with e; Auto.
Save.
Hint Chemin_chemin.


Lemma chemin_Chemin : (e1,e2:Elt)(q,d:Ensf)(w:Word)
 (chemin e1 e2 q d w)->(Chemin e1 e2 q d w).
Goal.
Intros e1 e2 q d w H; Elim H; Clear H.
Red; Auto.
Red.
Intros.
Exists e0.
Auto.
Save.
Hint chemin_Chemin.


(*  									*)
(*  Si (q,qd,qa,d) est un automate alors (reconnait q qd qa d) est le   *)
(*  langage reconnu par cet automate.					*)
(*  On le definit est disant que w est dans ce langage s'il est tout	*)
(*  d'abord dans le monoid libre engendre par alph, et s'il existe	*)
(*  2 etats e1 et e2, repsectivement dans qd et qa, tels que		*)
(*  (chemin e1 e2 q d w) soit vrai.					*)
(*									*)

Definition reconnait : Ensf->Ensf->Ensf->Ensf -> Word -> Prop = 
 [q,qd,qa,d : Ensf][w : Word ]
    (   (inmonoid alph w)
     /\ ( <Elt> Ex ([e1 :Elt]( <Elt> Ex ([e2:Elt]
               (dans e1 qd)
            /\ (dans e2 qa)
            /\ (chemin e1 e2 q d w)
        ))))
    ).

(*									*)
(*  Si on a un chemin de e1 a e2 alors e1 et e2 sont dans q.		*)
(*									*)

Lemma dans_e1_q : (q,d:Ensf)(w:Word)(e1,e2:Elt)
   (chemin e1 e2 q d w) -> (dans e1 q).
Goal.
Intros until w; Pattern w ; Apply induction_word.
Intros.
Cut (Chemin e1 e2 q d nil); Auto.
Intro.
Cut ( (dans e1 q) /\ (<Elt>e1=e2) ); Auto.
Intro Ht; Elim Ht; Auto.
Intros.
Cut (Chemin e1 e2 q d (cons x w0)); Auto.
Intro.
Cut (<Elt> Ex ([e:Elt]
      	  (chemin e e2 q d w0) /\ (dans e1 q) /\ (dans x alph)
   	  /\ (dans (couple e1 (couple x e)) d)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e Ht; Elim Ht; Clear Ht.
Intros H2 Ht; Elim Ht; Auto.
Save.

Lemma dans_e2_q : (q,d:Ensf)(w:Word)(e1,e2:Elt)
   (chemin e1 e2 q d w) -> (dans e2 q).
Goal.
Intros until w; Pattern w; Apply induction_word. 
Intros.
Cut (Chemin e1 e2 q d nil); Auto.
Intro.
Cut ( (dans e1 q) /\ (<Elt>e1=e2) ); Auto.
Intro Ht; Elim Ht; Auto.
Intros.
Rewrite <- H2; Auto.
Intros.
Cut (Chemin e1 e2 q d (cons x w0)); Auto.
Intro.
Cut (<Elt> Ex ([e:Elt]
      	  (chemin e e2 q d w0) /\ (dans e1 q) /\ (dans x alph)
   	  /\ (dans (couple e1 (couple x e)) d)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e Ht; Elim Ht; Clear Ht.
Intros H2 Ht.  
Apply (H e e2); Auto.
Save.

(*									*)
(*  Un chemin est un mot sur X  					*)
(*									*)

Lemma Cheminmonoid :
  (w : Word)(q,qd,qa,d : Ensf)
    (automate q qd qa d)->(e1,e2:Elt)(chemin e1 e2 q d w)->(inmonoid alph w).
Goal.
Intro w; Pattern w ; Apply induction_word.
Auto.
Intros.
Cut (Chemin e1 e2 q d (cons x w0)); Auto.
Intro.
Cut (<Elt>Ex ([e:Elt]( (chemin e e2 q d w0) /\ (dans e1 q) /\ (dans x alph) /\ (dans (couple e1 (couple x e)) d) ))); Auto.
Intro H3; Elim H3; Clear H3.
Intros e H3;Elim H3; Clear H3.
Intros H3 H4; Elim H4; Clear H4.
Intros H4 H5; Elim H5; Clear H5; Intros.
Apply inmonoid_cons; Auto.
Apply (H q qd qa d H0 e e2); Auto.
Save.

(*									*)
(*  Si le triplet (e1,x,e2) est dans d alors on a 			*)
(*    (chemin e1 e2 q d (cons x nil))					*)
(*									*)

Lemma chemin_lettre : (e1,e2,x:Elt)(q,d:Ensf)
  (dans x alph) -> (dans e1 q) -> (dans e2 q) -> (dans (couple e1 (couple x e2)) d)
      -> (chemin e1 e2 q d (cons x nil)).
Goal.
Intros.
Apply chemin_cons with e2; Auto. 
Apply chemin_nil; Auto.
Save.

(*									*)
(*  AUTOMATES ASYNCHRONES						*)
(*									*)

Definition automate_A : Ensf->Ensf->Ensf->Ensf->Prop = 
  [q,qd,qa,d : Ensf](
       (inclus qa q)
    /\ (inclus qd q)
    /\ (inclus d (prodcart q (prodcart (add epsilon alph) q)))
  ).

Lemma automate_A_def2 : (q,qd,qa,d:Ensf)
  (automate_A q qd qa d) -> (inclus qd q).
Goal.
Intros.
Elim H.
Intros H0 Ht; Elim Ht; Auto.
Save.

(*									*)
(*  On va definir de meme la notion de chemin sur un automate		*)
(*  asynchrone en rajoutant les transitions par epsilon.		*)
(*									*)

Inductive Definition chemin_A [q,d:Ensf] : Elt->Elt->Word->Prop =
  chemin_A_nil  : (e1,e2:Elt)
		(dans e1 q) -> (<Elt>e1=e2) 
 		  -> (chemin_A q d e1 e2 nil)
| chemin_A_cons : (e1,e,e2,x:Elt)(w:Word)
                  (chemin_A q d e e2 w) -> (dans e1 q) -> (dans x alph)
		        -> (dans (couple e1 (couple x e)) d)
			-> (chemin_A q d e1 e2 (cons x w))
| chemin_A_epsilon : (e1,e,e2:Elt)(w:Word)
                  (chemin_A q d e e2 w) -> (dans e1 q)
		        -> (dans (couple e1 (couple epsilon e)) d)
			-> (chemin_A q d e1 e2 w).
Hint chemin_A_nil.

(*  Inversion de la definition...					*)

Definition Chemin_A : Ensf->Ensf->Elt->Elt->Word->Prop =
  [q,d:Ensf][e1,e2:Elt][w:Word]
    (<[s:sortes]Prop>Match w with 
	False
	[x:Elt][Hx:Prop][e:Ensf][He:Prop]False

        [n:nat]False
        [a:Elt][Ha:Prop][b:Elt][Hb:Prop]False
        [e:Ensf][He:Prop]False
        [w:Word][Hw:Prop]False

     	(   ( (dans e1 q) /\ (<Elt>e1=e2) )
         \/ (<Elt>Ex ([e:Elt]( (chemin_A q d e e2 nil) /\ (dans e1 q)
                        /\ (dans (couple e1 (couple epsilon e)) d) ))) )

      	[a:Elt][Ha:Prop][w:Word][H:Prop]
        ( (<Elt>Ex ([e:Elt]( (chemin_A q d e e2 w) /\ (dans e1 q) 
              /\ (dans a alph) /\ (dans (couple e1 (couple a e)) d) )))
        \/ (<Elt>Ex ([e:Elt]( (chemin_A q d e e2 w) /\ (dans e1 q)
              /\ (dans (couple e1 (couple epsilon e)) d) ))) )
    ).

(*----
Lemma chemin_A_Chemin_A : (q,d:Ensf)(e1,e2:Elt)(w:Word)
  (chemin_A q d e1 e2 w) -> (Chemin_A q d e1 e2 w).
Goal.
Intros.
Elim H.

Intros.
Cut (chemin_A q d e0 e3 nil); Auto.
Intro.
Red.
Auto.

Intros.
Cut (chemin_A q d e0 e3 (cons x w0)).
2:Apply chemin_A_cons with e; Auto.
Intro.
Red.

Save.
---*)

(*  Si on a un chemin pour une relation de transition d1 alors on a	*)
(*  le meme chemin pour toute relation de transition contenant d1.	*)

Lemma chemin_A_d1_d2 : (q,d1,d2:Ensf)(w:Word)(e1,e2:Elt)
  (chemin_A q d1 e1 e2 w)
  -> (inclus d1 d2)
  -> (chemin_A q d2 e1 e2 w).
Goal.
Intros q d d2 w e1 e2 H.
Elim H; Clear H.
Auto.

Intros.
Apply chemin_A_cons with e; Auto.
Apply dans_trans with d; Auto.

Intros.
Apply chemin_A_epsilon with e; Auto.
Apply dans_trans with d; Auto.
Save.

(*  De meme pour deux ensembles d'etats q1 et q2 tesl que q1 est inclus	*)
(*  dans q2.								*)

Lemma chemin_A_q1_q2 : (q1,q2,d:Ensf)(e1,e2:Elt)(w:Word)
  (chemin_A q1 d e1 e2 w)
  -> (inclus q1 q2)
  -> (chemin_A q2 d e1 e2 w).
Goal.
Intros q1 q2 d w e1 e2 H.
Elim H; Clear H.

Intros.
Apply chemin_A_nil; Auto.
Apply dans_trans with q1; Auto.

Intros.
Apply chemin_A_cons with e; Auto.
Apply dans_trans with q1; Auto.

Intros.
Apply chemin_A_epsilon with e; Auto.
Apply dans_trans with q1; Auto.
Save.


(*  Si on a un chemin au sens des AF alors on a un chemin au sens des	*)
(*  AA.									*)

Lemma chemin_chemin_A : (q,d:Ensf)(w:Word)(e1,e2:Elt)
  (chemin e1 e2 q d w) -> (chemin_A q d e1 e2 w).
Goal.
Intros q d w e1 e2 H. 
Elim H; Clear H.
Auto.

Intros.
Apply chemin_A_cons with e0; Auto.
Save.

(*									*)
(*  Si on va de e1 a e par w1 et de e a e2 par w2 alors on va de 	*)
(*  e1 a e2 par (Append w1 w2).						*)
(*									*)

Lemma chemin_Append : (e1,e,e2:Elt)(q,d:Ensf)(w1,w2:Word)
  (chemin_A q d e1 e w1) -> (chemin_A q d e e2 w2) 
    -> (chemin_A q d e1 e2 (Append w1 w2)).
Goal.
Intros e1 e e2 q d w1 w2 H.
Elim H.

Intros.
Replace (Append nil w2) with w2; Auto.
Rewrite H1; Auto.

Intros.
Replace (Append (cons x w) w2) with (cons x (Append w w2)); Auto.
Cut (chemin_A q d e3 e2 (Append w w2)); Auto.
Intro.
Apply chemin_A_cons with e3; Auto.

Intros.
Cut (chemin_A q d e3 e2 (Append w w2)); Auto.
Intro.
Apply chemin_A_epsilon with e3; Auto.
Save.

(*									*)
(*  Si on a un cheminA de e1 a e2 alors e1 et e2 sont dans q.		*)
(*									*)

Lemma dansA_e1_q : (q,d:Ensf)(w:Word)(e1,e2:Elt)
   (chemin_A q d e1 e2 w) -> (dans e1 q).
Goal.
Intros.
Elim H; Auto.
Save.

Lemma dansA_e2_q : (q,d:Ensf)(w:Word)(e1,e2:Elt)
   (chemin_A q d e1 e2 w) -> (dans e2 q).
Goal.
Intros.
Elim H; Auto.
Intros.
Rewrite <- H1.
Assumption.
Save.

(*									*)
(*  Un mot reconnu par un automate_A est dans le monoide engendre par 	*)
(*  alph.								*)
(*									*)

Lemma cheminA_monoid : (w:Word)(q,qd,qaA,dA:Ensf)
  (automate_A q qd qaA dA) -> (e1,e2:Elt)(chemin_A q dA e1 e2 w)
  -> (inmonoid alph w).
Goal.
Intros.
Elim H0; Auto.
Save.


(*  Pour un chemin de la forme (cons x w) il existe un etat 		*)
(*  intermediaire.							*)

(*---
Lemma chemin_A2_cons_inv : (q,dA:Ensf)(w:Word)(e1,e2,x:Elt)
  (chemin_A2 q dA (cons x w) e2 e1) -> (<Elt>Ex ([e:Elt](
     (chemin_A2 q dA (cons x nil) e e1) /\ (chemin_A2 q dA w e2 e)
  ))).
Goal.
Intros.
Elim H.
Intros.
Cut (Chemin e0 e2 q dA (cons x w)); Auto.
Intro.
Cut (<Elt> Ex ([e:Elt]
      	  (chemin e e2 q dA w) /\ (dans e0 q) /\ (dans x alph)
   	  /\ (dans (couple e0 (couple x e)) dA)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e Ht; Elim Ht; Clear Ht.
Intros H3 Ht; Elim Ht; Clear Ht.
Intros H4 Ht; Elim Ht; Clear Ht.
Intros H5 H6.
Exists e.
Split.
2:Apply chemin_A2_un; Auto.
2:Apply (inmonoid_cons_inv alph w x); Auto.
Cut (chemin e0 e q dA (cons x nil)); Auto.
Apply (chemin_cons e e q dA nil e0 x); Auto.
Apply chemin_nil; Auto.
Apply (dans_e1_q q dA w e e2); Auto.

Intros.
Elim H1.
Intros e0' Ht; Elim Ht; Clear Ht. 
Intros H4 H5.
Exists e0'.
Split; Auto.
Apply chemin_A2_deux with e; Auto.
Save.

Lemma chemin_A_cons_inv : (q,dA:Ensf)(w:Word)(e1,e2,x:Elt)
  (chemin_A e1 e2 q dA (cons x w)) -> (<Elt>Ex ([e:Elt](
     (chemin_A e1 e q dA (cons x nil)) /\ (chemin_A e e2 q dA w)
  ))).
Goal.
Cut (<Elt>Ex ([e:Elt](
     (chemin_A2 q dA (cons x nil) e e1) /\ (chemin_A2 q dA w e2 e)
  ))).
2:Apply chemin_A2_cons_inv; Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e Ht; Elim Ht; Clear Ht.
Intros H0 H1.
Exists e.
Auto.
Save.
---*)

(*  De meme on definit reconnait_A...  					*)

Definition reconnait_A : Ensf->Ensf->Ensf->Ensf -> Word -> Prop = 
 [q,qd,qa,d : Ensf][w : Word ]
    (  (inmonoid alph w)
     /\( <Elt> Ex ([e1 :Elt]( <Elt> Ex ([e2:Elt](dans e1 qd)
                                       /\(dans e2 qa)
                                       /\ (chemin_A q d e1 e2 w)))))
     ).

(*  									*)
(*  A partir d'une relation de transition asynchrone dA construisons	*)
(*  la relation synchrone d correspondante. On elimine les transitions	*)
(*  avec epsilon en disant :						*)
(*     dans (e,a,e') d  <->  (chemin_A e e' q dA (cons a nil))		*)
(*									*)

Definition est_dans_d2 : Ensf->Ensf->Elt->Elt->Prop =
  [q,dA:Ensf][e,y:Elt](<[s:sortes]Prop>Match y with 
            False
            [x:Elt][Hx:Prop][e:Ensf][He:Prop]False
 
            [n:nat]False
            [a:Elt][Ha:Prop][e':Elt][He':Prop](chemin_A q dA e e' (cons a nil))
            [e:Ensf][He:Prop]False
            [w:Word][Hw:Prop]False
 
            False
            [a:Elt][Ha:Prop][w:Word][Hw:Prop]False
  ).

Definition est_dans_d : Ensf->Ensf->(Elt->Prop) =
  [q,dA:Ensf][x:Elt](<[s:sortes]Prop>Match x with 
            False
            [x:Elt][Hx:Prop][e:Ensf][He:Prop]False
 
            [n:nat]False
            [e:Elt][He:Prop][y:Elt][Hy:Prop](est_dans_d2 q dA e y)
            [e:Ensf][He:Prop]False
            [w:Word][Hw:Prop]False
 
            False
            [a:Elt][Ha:Prop][w:Word][Hw:Prop]False
  ).

Definition sync_d : Ensf->Ensf->Ensf =
  [q,dA:Ensf] (tq (est_dans_d q dA) (prodcart q (prodcart alph q))).

Definition sync_qa : Ensf->Ensf->Ensf->Ensf =
  [q,qaA,dA:Ensf]
    (union qaA (tq ([e:Elt](<Elt>Ex ([e':Elt]( 
       (dans e' qaA) /\ (chemin_A q dA e e' nil)
    )))) q )).

(*  Les etats de d'arrivee de l'automate fini comprennent ceux de	*)
(*  l'automate asynchrone.						*)

Lemma inclus_qaA_qa : (q,qaA,dA:Ensf)
  (inclus qaA (sync_qa q qaA dA)).
Goal.
Intros.
Unfold sync_qa.
Unfold inclus.
Intros.
Apply union_g; Auto.
Save.

(*  Par definition on a...						*)

Lemma nouvx_dans_qa : (q,qaA,dA:Ensf)(e:Elt)
  (dans e q)
   -> (<Elt>Ex ([e':Elt]( (dans e' qaA) /\ (chemin_A q dA e e' nil) ))) 
   -> (dans e (sync_qa q qaA dA)).
Goal.
Intros.
Elim H0; Clear H0.
Intros e' Ht; Elim Ht; Clear Ht.
Intros H0 H1.
Unfold sync_qa.
Apply union_d.
Apply imp_dans_tq; Auto.
Exists e'; Auto.
Save.

(*  et aussi...								*)

Lemma sync_d_def : (e1,e2,x:Elt)(q,dA:Ensf)
  (dans x alph)
   -> (chemin_A q dA e1 e2 (cons x nil)) 
   -> (dans (couple e1 (couple x e2)) (sync_d q dA)).
Goal.
Intros.
Unfold sync_d.
Apply imp_dans_tq; Auto.
Apply coupl2_inv.
Apply (dansA_e1_q q dA (cons x nil) e1 e2); Auto.
Apply coupl2_inv; Auto.
Apply (dansA_e2_q q dA (cons x nil) e1 e2); Auto.
Save.

Lemma sync_d_def2 : (e1,e2,x:Elt)(q,dA:Ensf)
  (dans x alph)
   -> (dans (couple e1 (couple x e2)) (sync_d q dA))
   -> (chemin_A q dA e1 e2 (cons x nil)).
Goal.
Intros e1 e2 x q dA H.
Unfold sync_d.
Intro.
Cut ( ( dans (couple e1 (couple x e2)) (prodcart q (prodcart alph q)) )
   /\ ( est_dans_d q dA (couple e1 (couple x e2)) ) ).
2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht.
Intro H1.
Unfold est_dans_d.
Unfold est_dans_d2.
Auto.
Save.

Lemma trans_dA_d : (q,dA:Ensf)(e0,e,x:Elt)
  (dans e0 q) -> (dans x alph) -> (dans e q)
   -> (dans (couple e0 (couple x e)) dA)
   -> (dans (couple e0 (couple x e)) (sync_d q dA)).
Goal.
Intros.
Cut (chemin_A q dA e0 e (cons x nil)).
Intro.
Unfold sync_d.
Apply imp_dans_tq; Auto.
Cut (chemin_A q dA e e nil); Auto.
Intro.
Apply chemin_A_cons with e; Auto.
Save.

(* 									*)
(*  Commencons par montrer que si (q,qd,qaA,dA) est un automate alors   *)
(*  (q,qd,qa,d) en est un aussi, ou qa=(sunc_qa q qaA dA) et		*)
(*  d=(sync_d q dA).							*)
(*									*)

Lemma automateA_automate : (q,qd,qaA,dA:Ensf)
  (automate_A q qd qaA dA) -> (automate q qd (sync_qa q qaA dA) (sync_d q dA)).
Goal.
Intros.
Elim H.
Intros H1 H2; Elim H2; Clear H2; Intros H2 H3.
Red.
Split.
Unfold sync_qa.
Apply union_inclus; Auto.
Apply inclus_tq.
Split; Auto.
Unfold sync_d.
Apply inclus_tq.
Save.

(*									*)
(*  Si on a un chemin de e a e2 dans l'automate fini, avec e2 etat	*)
(*  d'arrivee, et s'il y a une transition de e1 a e2 par epsilon,	*)
(*  alors il y a un chemin de e1 a e2' par le meme mot, avec e2'	*)
(*  etat d'arrivee.							*)
(*									*)

Lemma epsilon_chemin : (q,qaA,dA:Ensf)(w:Word)(e1,e,e2:Elt)
  (chemin e e2 q (sync_d q dA) w) -> (dans (couple e1 (couple epsilon e)) dA)
  -> (dans e2 (sync_qa q qaA dA)) -> (dans e1 q) 
  -> (<Elt>Ex ([e2':Elt]( 
           (chemin e1 e2' q (sync_d q dA) w) /\ (dans e2' (sync_qa q qaA dA)) 
     ))).
Goal.
Intros q qaA dA w; Pattern w; Apply induction_word.

Intros.
Exists e1.
Split.
Apply chemin_nil; Auto. 
Cut (Chemin e e2 q (sync_d q dA) nil); Auto.
Intro H3.
Cut ( (dans e q) /\ (<Elt>e=e2) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros H4 H5.
Cut (chemin_A q dA e e2 nil); Auto.
Cut (chemin_A q dA e1 e2 nil).
2:Apply chemin_A_epsilon with e; Auto.
Intros.
Unfold sync_qa in H1.
Cut ( (dans e2 qaA) \/ (dans e2 (tq
      [e:Elt](<Elt>Ex ([e':Elt]( (dans e' qaA) /\ (chemin_A q dA e e' nil) )))
                  q) ) ).
2:Apply dans_union; Auto.
Intro Ht; Elim Ht; Clear Ht.
Intro; Apply nouvx_dans_qa; Auto.
Exists e2; Auto.

Intro.
Cut ( (dans e2 q) /\ ( [e:Elt](<Elt>Ex ([e':Elt]( (dans e' qaA) /\ (chemin_A q dA e e' nil) ))) e2) ).
2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros H9 Ht; Elim Ht; Clear Ht.
Intros e3 Ht; Elim Ht; Clear Ht.
Intros H10 H11.
Cut (chemin_A q dA e e3 nil); Auto.
2:Rewrite H5; Auto.
Intro H12.
Cut (chemin_A q dA e1 e3 nil).
2:Apply chemin_A_epsilon with e; Auto.
Intro; Apply nouvx_dans_qa; Auto.
Exists e3; Auto.

Intros.
Cut (Chemin e e2 q (sync_d q dA) (cons x w0)); Auto.
Intro.
Cut (<Elt> Ex ([e22:Elt]
      	  (chemin e22 e2 q (sync_d q dA) w0) /\ (dans e q) /\ (dans x alph)
   	  /\ (dans (couple e (couple x e22)) (sync_d q dA))) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e22 Ht; Elim Ht; Clear Ht.
Intros H5 Ht; Elim Ht; Clear Ht.
Intros H6 Ht; Elim Ht;Clear Ht; Intros H7 H8.
Exists e2.
Split; Auto.
Cut (chemin_A q dA e e22 (cons x nil)).
2:Apply sync_d_def2; Auto.
Intro.
Cut (chemin_A q dA e1 e22 (cons x nil)).
2:Apply chemin_A_epsilon with e; Auto.
Intro.
Cut (dans (couple e1 (couple x e22)) (sync_d q dA) ).
2:Apply sync_d_def; Auto.
Intro.
Apply chemin_cons with e22; Auto.
Save.

(*									*)
(*  Si on a un chemin de e1 a e2 par w dans un automate asynchrone	*)
(*  avec e2 etat d'arrivee, alors il existe un etat d'arrivee e2'	*)
(*  de l'automate fini correspondant et un chemin de e1 a e2 par w	*)
(*  dans cet automate.							*)
(*									*)

Lemma cheminA_chemin : (q,qd,qaA,dA:Ensf)
  (automate_A q qd qaA dA) ->
    (w:Word)(e1,e2:Elt) (chemin_A q dA e1 e2 w) -> (dans e2 qaA)
     -> (<Elt>Ex ([e2':Elt](
           (chemin e1 e2' q (sync_d q dA) w) /\ (dans e2' (sync_qa q qaA dA))
        ))).
Goal.
Intros q qd qaA dA H_aut w.
Cut (inclus qaA (sync_qa q qaA dA)).
2:Apply inclus_qaA_qa.
Intro H0.
Intros e1 e2 H1.
Elim H1.

Intros.
Exists e0.
Split.
Apply chemin_nil; Auto.
Rewrite H2.
Apply dans_trans with qaA; Auto.

Intros.
Cut (<Elt>Ex([e2':Elt]
                (chemin e e2' q (sync_d q dA) w0)
                /\(dans e2' (sync_qa q qaA dA))     )); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e2' Ht; Elim Ht; Clear Ht.
Intros H7 H8.
Exists e2'.
Split; Auto.
Apply chemin_cons with e; Auto.
Cut (dans e q).
2:Apply (dans_e1_q q (sync_d q dA) w0 e e2'); Auto.
Intro dans_e_q.
Apply trans_dA_d; Auto.

Intros.
Cut (<Elt>Ex([e2':Elt]
                (chemin e e2' q (sync_d q dA) w0)
                /\(dans e2' (sync_qa q qaA dA)) )); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e9 Ht; Elim Ht; Clear Ht.
Intros H6 H7.
Apply (epsilon_chemin q qaA dA w0 e0 e e9); Auto.
Save.

(*									*)
(*  Montrons maintenant que si (q,qd,qaA,dA) est un automate async.	*)
(*  alors (reconnait_A q qd qaA dA w) -> (reconnait q qd qa d w)	*)
(*  ou qa=(sunc_qa q qaA dA) et d=(sync_d q dA).			*)
(*									*)

Lemma reconnaitA_reconnait : (q,qd,qaA,dA:Ensf)(w:Word)
  (automate_A q qd qaA dA)
    -> (reconnait_A q qd qaA dA w) 
         -> (reconnait q qd (sync_qa q qaA dA) (sync_d q dA) w).
Goal.
Intros q qd qaA dA w H_aut.
Unfold reconnait_A.
Intro H; Elim H; Clear H.
Intros H1 H; Elim H; Clear H.
Intros e1 H; Elim H; Clear H.
Intros e2 H; Elim H; Clear H.
Intros H2 H; Elim H; Clear H; Intros H3 H4.
Unfold reconnait.
Split; Auto. 
Exists e1.
Cut (<Elt>Ex ([e2':Elt](
           (chemin e1 e2' q (sync_d q dA) w) /\ (dans e2' (sync_qa q qaA dA))
        ))). 
2:Apply (cheminA_chemin q qd qaA dA H_aut w e1 e2); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e2' Ht; Elim Ht; Clear Ht.
Intros H5 H6.
Exists e2'.
Auto.
Save.

(*									*)
(*  Reciproquement, si on a un chemin de e1 a e2 dans l'automate fini	*)
(*  correspondant a un automate asynchrone, alors on a un chemin de e1 	*)
(*  a e2 dans l'automate asynchrone.					*)
(*									*)

Lemma chemin_cheminA : (q,qd,qaA,dA:Ensf)
  (automate_A q qd qaA dA) ->
    (w:Word)(e1,e2:Elt) (chemin e1 e2 q (sync_d q dA) w) 
         -> (chemin_A q dA e1 e2  w).
Goal.
Intros q qd qaA dA H_aut w; Pattern w; Apply induction_word.
Intros.
Cut (Chemin e1 e2 q (sync_d q dA) nil); Auto.

Intro.
Cut ( (dans e1 q) /\ (<Elt>e1=e2) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros; Apply chemin_A_nil; Auto.

Intros.
Cut (Chemin e1 e2 q (sync_d q dA) (cons x w0)); Auto.
Intro H1.
Cut (<Elt> Ex ([e:Elt]
      	  (chemin e e2 q (sync_d q dA) w0) /\ (dans e1 q) /\ (dans x alph)
   	  /\ (dans (couple e1 (couple x e)) (sync_d q dA))) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e Ht; Elim Ht; Clear Ht.
Intros H2 Ht; Elim Ht; Clear Ht.
Intros H3 H4.
Cut (chemin_A q dA e e2 w0); Auto.
Intro.
Elim H4; Clear H4; Intros H4 H6.
Cut (chemin_A q dA e1 e (cons x nil)).
2:Apply sync_d_def2; Auto.
Intro.
Replace (cons x w0) with (Append (cons x nil) w0); Auto.
Apply chemin_Append with e; Auto.
Save.

(*									*)
(*  On en deduit qu'un mot reconnu par l'automate fini associe a un	*)
(*  automate asynchrone etait reconnu par l'automate asynchrone.	*)
(*									*)

Lemma reconnait_reconnaitA : (q,qd,qaA,dA:Ensf)(w:Word)
  (automate_A q qd qaA dA)
     -> (reconnait q qd (sync_qa q qaA dA) (sync_d q dA) w)
       -> (reconnait_A q qd qaA dA w).
Goal.
Intros q qd qaA dA w H_aut.
Unfold reconnait.
Intro Ht; Elim Ht; Clear Ht.
Intros H Ht; Elim Ht; Clear Ht.
Intros e1 Ht; Elim Ht; Clear Ht.
Intros e2 Ht; Elim Ht; Clear Ht.
Intros H0 Ht; Elim Ht; Clear Ht.
Intros H1 H2.
Cut (dans e2    (union qaA (tq ([e:Elt](<Elt>Ex ([e':Elt]( 
       (dans e' qaA) /\ (chemin_A q dA e e' nil)
    )))) q )) ); Auto.
Intro H3.
Cut ( (dans e2 qaA) \/ (dans e2 (tq ([e:Elt](<Elt>Ex ([e':Elt]( 
       (dans e' qaA) /\ (chemin_A q dA e e' nil)
    )))) q )) ).
2:Apply dans_union; Auto.
Intro H4.
Unfold reconnait_A.
Split; Auto.
Exists e1.
Clear H3; Elim H4.

Intro.
Exists e2.
Split; Auto.
Split; Auto.
Apply (chemin_cheminA q qd qaA dA H_aut); Auto.

Intro.
Cut ( (dans e2 q) /\ ([e:Elt](<Elt>Ex([e':Elt]((dans e' qaA) /\ (chemin_A q dA e e' nil)) )) e2) ).
2:Apply dans_tq_imp; Auto.
Simpl.
Intro Ht; Elim Ht; Clear Ht.
Intros H5 Ht; Elim Ht; Clear Ht. 
Intros e2' Ht; Elim Ht; Clear Ht.
Intros H6 H7.
Exists e2'.
Split; Auto.
Split; Auto.
Cut (chemin_A q dA e1 e2 w). 
2:Apply (chemin_cheminA q qd qaA dA H_aut); Auto.
Intro.
Replace w with (Append w nil).
Apply chemin_Append with e2; Auto.
Apply Append_w_nil.
Save.


(*									*)
(*  Et le resultat final :						*)
(*									*)
(*  Pour tout automate asynchrone (utilisant des transitions avec 	*)
(*  epsilon) il existe un automate fini reconnaissant le meme		*)
(*  langage.								*)
(*									*)

Lemma async_is_sync : (q,qd,qaA,dA:Ensf)
  (automate_A q qd qaA dA) ->
    (<Ensf>Ex ([d:Ensf](
     <Ensf>Ex ([qa:Ensf](
	    (automate q qd qa d) 
         /\ (eqwordset (reconnait_A q qd qaA dA) (reconnait q qd qa d))
    ))))).
Goal.
Intros q qd qaA dA H.   
Exists (sync_d q dA).
Exists (sync_qa q qaA dA).
Split.
Apply automateA_automate; Auto.
Unfold eqwordset.
Split.
Intro.
Apply reconnaitA_reconnait; Auto.
Intro.
Apply reconnait_reconnaitA; Auto.
Save.


(*									*)
(* Les mots reconnus par un automate forment un langage : 		*)
(*   par definition meme puisqu'un mot reconnu est dans le monoide	*)
(*   engendre par alph...						*)
(*									*)

Lemma Recislang :
  (q,qd,qa,d : Ensf)
    (automate q qd qa d)->(islanguage alph (reconnait q qd qa d)).
Goal.
Intros.
Unfold 1 islanguage.
Intro.
Unfold 1 reconnait.
Intro.
Elim H0.
Intros.
Assumption.
Save.

(*									*)
(*  Le predicat isregular definit les langages reguliers.		*)
(*									*)

Definition isregular : wordset -> Prop =
  [l : wordset]
  (<Ensf> Ex ([q : Ensf] 
     (<Ensf> Ex ([qd : Ensf] 
        (<Ensf> Ex ([qa : Ensf] 
           (<Ensf> Ex ([d : Ensf] 
                (automate q qd qa d) 
             /\ (eqwordset (reconnait q qd qa d) l))))))))).
  
Definition isregular_A : wordset -> Prop =
  [l : wordset]
  (<Ensf> Ex ([q : Ensf] 
     (<Ensf> Ex ([qd : Ensf] 
        (<Ensf> Ex ([qa : Ensf] 
           (<Ensf> Ex ([d : Ensf] 
                (automate_A q qd qa d) 
             /\ (eqwordset (reconnait_A q qd qa d) l))))))))).

Lemma isregular_A_isregular : (l:wordset)
  (isregular_A l) -> (isregular l).
Goal.
Unfold isregular_A.
Intros l Ht; Elim Ht; Clear Ht.
Intros q Ht; Elim Ht; Clear Ht.
Intros qd Ht; Elim Ht; Clear Ht.
Intros qaA Ht; Elim Ht; Clear Ht.
Intros dA Ht; Elim Ht; Clear Ht.
Intros.
Cut (<Ensf>Ex ([d:Ensf](
     <Ensf>Ex ([qa:Ensf](
	    (automate q qd qa d) 
         /\ (eqwordset (reconnait_A q qd qaA dA) (reconnait q qd qa d))
    ))))).
2:Apply async_is_sync; Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros d Ht; Elim Ht; Clear Ht.
Intros qa Ht; Elim Ht; Clear Ht.
Intros.
Unfold isregular.
Exists q.
Exists qd.
Exists qa.
Exists d.
Split; Auto.
Apply eqwordset_trans with (reconnait_A q qd qaA dA); Auto.
Apply eqwordset_sym; Auto.
Save.

Definition isregular_D : wordset -> Prop =
  [l : wordset]
  (<Ensf> Ex ([q : Ensf] 
     (<Elt> Ex ([g0 : Elt] 
        (<Ensf> Ex ([qa : Ensf] 
           (<Ensf> Ex ([d : Ensf] 
                (automate q (singleton g0) qa d) 
             /\ ((w:Word)((chemin g0 g0 q d w)->(<Word>w=nil)))
             /\ (eqwordset (reconnait q (singleton g0) qa d) l))))))))).

Definition transition_D : Elt->Elt->Elt =
  [g0,x:Elt](couple g0 (couple epsilon x)).

Definition delta_D : Elt->Ensf->Ensf =
  [g0:Elt][qd:Ensf](map (transition_D g0) qd).

Lemma automate_A_D : (q,qd,qa,d:Ensf)(g0:Elt)
  (automate q qd qa d)
  -> (automate_A (add g0 q) (singleton g0) qa (union d (delta_D g0 qd))).
Goal.
Unfold automate_A.
Split.
Apply inclus_add.
Apply automate_def3 with qd d; Auto.
Split; Auto.
Apply union_inclus.
Apply inclus_trans with (prodcart q (prodcart alph q)).
Apply automate_def1 with qd qa; Assumption.
Apply cart_inclus; Auto.
Apply cart_inclus; Auto.
Unfold delta_D.
Unfold inclus.
Intros x H2.
Cut (<Elt>Ex ([y:Elt]( (dans y qd) /\ (<Elt>x=((transition_D g0) y)) ))).
2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros t Ht; Elim Ht; Clear Ht; Intros.
Rewrite H1.
Unfold transition_D.
Apply coupl2_inv; Auto.
Apply coupl2_inv; Auto.
Apply dans_add2.
Apply dans_trans with qd; Auto.
Apply automate_def2 with qa d; Auto.
Save.

(*									*)
(*  Si on a un chemin_A de e a e2 dans l'automate D et que e est dans	*)
(*  q alors on a un chemin dans l'automate fini.			*)
(*									*)

Lemma chemin_D_chemin : (q,qd,qa,d:Ensf)(g0,e,e2:Elt)(w:Word)
  (automate q qd qa d)
  -> (~(dans g0 q)) 
  -> (chemin_A (add g0 q) (union d (delta_D g0 qd)) e e2 w)
  -> (dans e q)
  -> (chemin e e2 q d w).
Goal.
Intros q qd qa d g0 e e2 w H_aut H_g0 H.
Elim H; Clear H.

Intros.
Apply chemin_nil; Auto.

Intros.
Cut ( (dans (couple e1 (couple x e0)) d) 
   \/ (dans (couple e1 (couple x e0)) (delta_D g0 qd)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
	Intro.
	Cut (dans (couple e1 (couple x e0)) (prodcart q (prodcart alph q))).
	2:Apply dans_trans with d; Auto.
	2:Apply automate_def1 with qd qa; Auto.
	Intro.
	Cut ( (dans e1 q) /\ (dans (couple x e0) (prodcart alph q)) ).
	2:Apply coupl2; Auto.	
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( (dans x alph) /\ (dans e0 q) ).
	2:Apply coupl2; Auto.	
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Apply chemin_cons with e0; Auto.

	Unfold delta_D.
	Intro.
	Cut (<Elt>Ex ([y:Elt]( (dans y qd) 
		/\ <Elt>(couple e1 (couple x e0))=((transition_D g0) y) ))).
	2:Apply dans_map; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
	Unfold transition_D in H7.
	Cut ( <Elt>e1=g0 /\ <Elt>(couple x e0)=(couple epsilon y) ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( <Elt>x=epsilon /\ <Elt>e0=y ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans x alph); Auto.
	Rewrite H10.
	Red; Intro; Apply not_dans_epsilon_alph; Assumption.

Intros.
Cut ( (dans (couple e1 (couple epsilon e0)) d) 
   \/ (dans (couple e1 (couple epsilon e0)) (delta_D g0 qd)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
	Intro.
	Cut (dans (couple e1 (couple epsilon e0)) 
			(prodcart q (prodcart alph q))).
	2:Apply dans_trans with d; Auto.
	2:Apply automate_def1 with qd qa; Auto.
	Intro.
	Cut ( (dans e1 q) /\ (dans (couple epsilon e0) (prodcart alph q)) ).
	2:Apply coupl2; Auto.	
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( (dans epsilon alph) /\ (dans e0 q) ).
	2:Apply coupl2; Auto.	
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans epsilon alph); Auto.
	Red; Intro; Apply not_dans_epsilon_alph; Assumption.

	Unfold delta_D.
	Intro.
	Cut (<Elt>Ex ([y:Elt]( (dans y qd) 
	   /\ <Elt>(couple e1 (couple epsilon e0))=((transition_D g0) y) ))).
	2:Apply dans_map; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
	Unfold transition_D in H6.
	Cut ( <Elt>e1=g0 /\ <Elt>(couple epsilon e0)=(couple epsilon y) ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans g0 q); Auto.
	Rewrite <- H7.
	Assumption. 
Save.

(*									*)
(*  Si on a un chemin de g0 a e2 avec e2 dans qa alors il existe un 	*)
(*  etat e dans qd tel que l'on ait un chemin_A de e a e2 par le meme   *)
(*   mot.								*)
(*									*)

Lemma chemin_A_g0_e2 : (q,qd,qa,d:Ensf)(g0,e1,e2:Elt)(w:Word)
  (automate q qd qa d)
  -> (~(dans g0 q))
  -> (chemin_A (add g0 q) (union d (delta_D g0 qd)) e1 e2 w)
  -> (<Elt>e1=g0)
  -> (dans e2 qa)
  -> (<Elt>Ex ([e:Elt]( (dans e qd) 
                     /\ (chemin_A (add g0 q) (union d (delta_D g0 qd)) e e2 w)
     ))).
Goal.
Intros q qd qa d g0 e1 e2 w H_aut H_g0 H.
Elim H; Clear H.

Intros.
Absurd (dans g0 q); Auto.
Rewrite <- H1.
Rewrite H0.
Apply dans_trans with qa; Auto.
Apply automate_def3 with qd d; Auto.

Intros.
Clear H0.
Cut ( (dans (couple e0 (couple x e)) d) 
   \/ (dans (couple e0 (couple x e)) (delta_D g0 qd)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
	Intro.
	Cut (dans (couple e0 (couple x e)) (prodcart q (prodcart alph q))).
	2:Apply dans_trans with d; Auto.
	2:Apply automate_def1 with qd qa; Auto.
	Intro.
	Cut ( (dans e0 q) /\ (dans (couple x e) (prodcart alph q)) ).
	2:Apply coupl2; Auto.	
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans g0 q); Auto.
	Rewrite <- H4.
	Assumption.
	
	Unfold delta_D.
	Intro.
	Cut (<Elt>Ex ([y:Elt]( (dans y qd) 
		/\ <Elt>(couple e0 (couple x e))=((transition_D g0) y) ))).
	2:Apply dans_map; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
	Unfold transition_D in H7.
	Cut ( <Elt>e0=g0 /\ <Elt>(couple x e)=(couple epsilon y) ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( <Elt>x=epsilon /\ <Elt>e=y ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans x alph); Auto.
	Rewrite H10.
	Red; Intro; Apply not_dans_epsilon_alph; Assumption.

Intros.
Clear H0.
Exists e.
Split; [Idtac | Assumption].
Cut ( (dans (couple e0 (couple epsilon e)) d) 
   \/ (dans (couple e0 (couple epsilon e)) (delta_D g0 qd)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
	Intro.
	Cut (dans (couple e0 (couple epsilon e)) 
			(prodcart q (prodcart alph q))).
	2:Apply dans_trans with d; Auto.
	2:Apply automate_def1 with qd qa; Auto.
	Intro.
	Cut ( (dans e0 q) /\ (dans (couple epsilon e) (prodcart alph q)) ).
	2:Apply coupl2; Auto.	
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( (dans epsilon alph) /\ (dans e q) ).
	2:Apply coupl2; Auto.	
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans epsilon alph); Auto.
	Red; Intro; Apply not_dans_epsilon_alph; Assumption.
	
	Unfold delta_D.
	Intro.
	Cut (<Elt>Ex ([y:Elt]( (dans y qd) 
	   /\ <Elt>(couple e0 (couple epsilon e))=((transition_D g0) y) ))).
	2:Apply dans_map; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
	Unfold transition_D in H6.
	Cut ( <Elt>e0=g0 /\ <Elt>(couple epsilon e)=(couple epsilon y) ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( <Elt>epsilon=epsilon /\ <Elt>e=y ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Rewrite H10.
	Assumption.
Save.

(*									*)
(*  On ne peut avoir de chemin de e a g0 si e est dans q.		*)
(*									*)

Lemma chemin_A_e1_g0_abs : (q,qd,qa,d:Ensf)(g0,e,e2:Elt)(w:Word)
  (automate q qd qa d)
  -> (dans e q)
  -> (~(dans g0 q))
  -> <Elt>e2=g0
  -> ~(chemin_A (add g0 q) (union d (delta_D g0 qd)) e e2 w).
Goal.
Intros q qd qa d g0 e e2 w H_aut H H0 H1.
Red; Intro.
Cut (dans e q); Auto.
Cut <Elt>e2=g0; Auto.
Elim H2.

Intros.
Absurd (dans g0 q); Auto.
Rewrite <- H5.
Rewrite <-H4; Assumption.

Intros.
Apply H4; Auto.
Cut ( (dans (couple e1 (couple x e0)) d) 
   \/ (dans (couple e1 (couple x e0)) (delta_D g0 qd)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

	Intro.
	Cut (dans (couple e1 (couple x e0)) (prodcart q (prodcart alph q))).
	2:Apply dans_trans with d; Auto.
	2:Apply automate_def1 with qd qa; Auto.
	Intro.	
	Cut ( (dans e1 q) /\ (dans (couple x e0) (prodcart alph q)) ).
	2:Apply coupl2; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( (dans x alph) /\ (dans e0 q) ).
	2:Apply coupl2; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Assumption.
	
	Unfold delta_D.
	Intro.
	Cut (<Elt>Ex ([y:Elt]( (dans y qd) 
	         /\ (<Elt>(couple e1 (couple x e0))=((transition_D g0) y)) ))).
	2:Apply dans_map; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
	Unfold transition_D in H12.
	Cut ( <Elt>e1=g0 /\ <Elt>(couple x e0)=(couple epsilon y) ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans e1 q); Auto.
	Rewrite H13; Auto.

Intros.
Apply H4; Auto.
Cut ( (dans (couple e1 (couple epsilon e0)) d) 
   \/ (dans (couple e1 (couple epsilon e0)) (delta_D g0 qd)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

	Intro.
	Cut (dans (couple e1 (couple epsilon e0)) 
				(prodcart q (prodcart alph q))).
	2:Apply dans_trans with d; Auto.
	2:Apply automate_def1 with qd qa; Auto.
	Intro.	
	Cut ( (dans e1 q) /\ (dans (couple epsilon e0) (prodcart alph q)) ).
	2:Apply coupl2; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( (dans epsilon alph) /\ (dans e0 q) ).
	2:Apply coupl2; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans epsilon alph); Auto.
	Red; Intro; Apply not_dans_epsilon_alph; Assumption.
	
	Unfold delta_D.
	Intro.
	Cut (<Elt>Ex ([y:Elt]( (dans y qd) 
	  /\ (<Elt>(couple e1 (couple epsilon e0))=((transition_D g0) y)) ))).
	2:Apply dans_map; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
	Unfold transition_D in H11.
	Cut ( <Elt>e1=g0 /\ <Elt>(couple epsilon e0)=(couple epsilon y) ).
	2:Apply equal_couple; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans e1 q); Auto.
	Rewrite H12; Auto.
Save.


(*									*)
(*  Si on a un chemin_A de e1 a g0 alors c'est forcement par le mot	*)
(*  nil.								*)
(*									*)

Lemma chemin_A_e1_g0 : (q,qd,qa,d:Ensf)(g0,e1,e2:Elt)(w:Word)
  (automate q qd qa d)
  -> (~(dans g0 q))
  -> (chemin_A (add g0 q) (union d (delta_D g0 qd)) e1 e2 w)
  -> <Elt>e2=g0
  -> <Word>w=nil.
Goal.
Intros q qd qa d g0 e1 e2 w H_aut H_g0 H.
Elim H; Auto.
Intros.
Absurd (chemin_A (add g0 q) (union d (delta_D g0 qd)) e g0 w0).
2:Cut (chemin_A (add g0 q) (union d (delta_D g0 qd)) e e3 w0); Auto.
2:Rewrite H5; Auto.
Apply chemin_A_e1_g0_abs with qa; Auto.
Cut ( (dans (couple e0 (couple x e)) d) 
   \/ (dans (couple e0 (couple x e)) (delta_D g0 qd)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Intro.
Cut (dans (couple e0 (couple x e)) (prodcart q (prodcart alph q))).
2:Apply dans_trans with d; Auto.
2:Apply automate_def1 with qd qa; Auto.
Intro.
Cut ( (dans e0 q) /\ (dans (couple x e) (prodcart alph q)) ).
2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans x alph) /\ (dans e q) ).
2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Assumption.

Unfold delta_D. 
Intro.
Cut (<Elt>Ex ([y:Elt]( (dans y qd) 
	         /\ (<Elt>(couple e0 (couple x e))=((transition_D g0) y)) ))).
2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
Unfold transition_D in H8.
Cut ( <Elt>e0=g0 /\ <Elt>(couple x e)=(couple epsilon y) ).
2:Apply equal_couple; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( <Elt>x=epsilon /\ <Elt>e=y ).
2:Apply equal_couple; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Absurd (dans x alph); Auto.
Rewrite H11.
Red; Intro; Apply not_dans_epsilon_alph; Assumption.
Save.

(*									*)
(*  Pour tout automate A=(q,qd,qa,d) l'automate ((add g0 q),		*)
(*  (singleton g0),qa,(union d (delta_D g0 qd))) reconnait le meme 	*)
(*  langage que A et possede la propriete que seul le mot nil		*)
(*  permet de passer de g0 a g0 par un chemin.				*)
(*									*)

Lemma isregular_isregular_D_1 : (q,qd,qa,d:Ensf)(g0:Elt)
  (automate q qd qa d)
  -> (~(dans g0 q))
  -> ( (eqwordset (reconnait q qd qa d) (reconnait_A (add g0 q) (singleton g0)
           qa (union d (delta_D g0 qd))) )
    /\ ((w:Word)((chemin_A (add g0 q) (union d (delta_D g0 qd)) g0 g0 w)
                  ->(<Word>w=nil))) ).
Goal.
Intros.
Split.
Unfold eqwordset.
Intro w.
Split.
	Unfold reconnait.
	Intro Ht; Elim Ht; Clear Ht; Intros H1 Ht; Elim Ht; Clear Ht;
 	  Intros e1 Ht; Elim Ht; Clear Ht; Intros e2 Ht; Elim Ht; Clear Ht;
	  Intros H2 Ht; Elim Ht; Clear Ht; Intros.
	Unfold reconnait_A.
	Split; [Assumption | Idtac].
	Exists g0.
	Exists e2.
	Split; [Auto | Split; [Assumption | Idtac]].
	Apply chemin_A_epsilon with e1; Auto.
	Apply chemin_A_d1_d2 with d; Auto.
	Apply chemin_A_q1_q2 with q; Auto.
	Apply chemin_chemin_A; Auto.
	Apply union_d.
	Unfold delta_D.
	Replace (couple g0 (couple epsilon e1)) 
				with ((transition_D g0) e1); Auto.
	Apply dans_map_inv; Auto.
	
	Unfold reconnait_A.
	Intro Ht; Elim Ht; Clear Ht; Intros H1 Ht; Elim Ht; Clear Ht;
 	  Intros e1 Ht; Elim Ht; Clear Ht; Intros e2 Ht; Elim Ht; Clear Ht;
	  Intros H2 Ht; Elim Ht; Clear Ht; Intros.
	Unfold reconnait.
	Split; [Assumption | Idtac].
	Cut <Elt>e1=g0; Auto.
	Intro.
	Cut (<Elt>Ex ([e:Elt]( (dans e qd) 
                     /\ (chemin_A (add g0 q) (union d (delta_D g0 qd)) e e2 w)
   	  ))).
	2:Apply chemin_A_g0_e2 with qa e1; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros e Ht; Elim Ht; Clear Ht; Intros.
	Exists e.
	Exists e2.
	Split; [Assumption | Split; [Assumption | Idtac]].
	Apply chemin_D_chemin with qd qa g0; Auto.
	Apply dans_trans with qd; Auto.
	Apply automate_def2 with qa d; Auto.
	
Intros.
Apply chemin_A_e1_g0 with q qd qa d g0 g0 g0; Auto.
Save.

(*									*)
(*  Si l est regulier, alors l est regulier au sens de isregular_D,	*)
(*  ie il existe un automate a un seul etat de depart g0 et possedant	*)
(*  la propriete que seul le mot nil permet d'aller de g0 a g0 par 	*)
(*  un chemin qui reconnait l.						*)
(*									*)

Lemma isregular_isregular_D : (l:wordset)
  (isregular l) -> (isregular_D l).
Goal.
Intro l.
Unfold 1 isregular.
Intro Ht; Elim Ht; Clear Ht; Intros q Ht; Elim Ht; Clear Ht; Intros qd Ht;
  Elim Ht; Clear Ht; Intros qa Ht; Elim Ht; Clear Ht; Intros d Ht; Elim Ht;
  Clear Ht; Intros.
Cut (<Elt>Ex ([g0:Elt]( ~(dans g0 q) ))).
2:Apply exist_other.
Intro Ht; Elim Ht; Clear Ht; Intros g0 H1.

Cut (automate_A (add g0 q) (singleton g0) qa (union d (delta_D g0 qd))).
2:Apply automate_A_D; Auto.
Intro.
Unfold isregular_D.
Exists (add g0 q).
Exists g0.
Exists (sync_qa (add g0 q) qa (union d (delta_D g0 qd))).
Exists (sync_d (add g0 q) (union d (delta_D g0 qd))).
Split.
Apply automateA_automate; Auto.
Cut ( (eqwordset (reconnait q qd qa d) (reconnait_A (add g0 q) (singleton g0)
           qa (union d (delta_D g0 qd))) )
    /\ ((w:Word)((chemin_A (add g0 q) (union d (delta_D g0 qd)) g0 g0 w)
                  ->(<Word>w=nil))) ). 
2:Apply isregular_isregular_D_1; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Split.

	Intros w H5.
	Cut (chemin_A (add g0 q) (union d (delta_D g0 qd)) g0 g0 w).
	2:Apply chemin_cheminA with (singleton g0) qa; Auto.
	Intro.
	Apply (H4 w); Auto.

	Apply eqwordset_trans with (reconnait_A (add g0 q) (singleton g0) qa
 		 (union d (delta_D g0 qd))).
	Unfold eqwordset.
	Intro w.
	Split.
	Intro.
	Apply reconnait_reconnaitA; Auto.
	Intro.
	Apply reconnaitA_reconnait; Auto.
	Apply eqwordset_trans with (reconnait q qd qa d); Auto.
	Apply eqwordset_sym; Assumption.
Save.

Provide Reg.
