(*									*)
(*  RAT [ REG								*)
(*									*)
(*  On montre ici que les langages rationnels sont reguliers		*)
(*  en le montrant successivement pour {w}, L1 U L2, L1.L2 et L*	*)
(*									*)

Require Reg.
Require Rat.

(************************************************************************)
(*									*)
(*            Un langage reduit a un mot est regulier.			*)
(*									*)
(************************************************************************)

(*  Le mot vide est reconnu par un automate reduit a un etat (zero)	*)
(*  et sans transition.							*)


Lemma lwordnil_is_reg1 :
  (reconnait (singleton zero) (singleton zero) (singleton zero) 
        (prodcart empty (prodcart alph empty)) nil).
Goal.
Unfold 1 reconnait.
Split.
Apply inmonoid_nil.
Exists zero; Exists zero.
Split.
Apply singl2.
Split.
Apply singl2.
Apply chemin_nil.
Apply singl2.
Apply refl_equal.
Save.


(* Seul le mot vide est reconnu par l'automate ci-dessus.		*)

Lemma lwordnil_is_reg2 :
  (w : Word)
    (reconnait (singleton zero) (singleton zero) (singleton zero) 
        (prodcart empty (prodcart alph empty)) w) -> (<Word> w=nil).
Goal.
Unfold 1 reconnait.
Intro; Pattern w; Apply induction_word.
Auto.
Intros.
Clear H.
Elim H0; Intros; Clear H0.
Elim H1; Intros; Clear H1.
Elim H0; Intros; Clear H0.
Elim H1; Intros; Clear H1.
Elim H2; Intros; Clear H2.
Cut (Chemin x0 x1 (singleton zero)
          (prodcart empty (prodcart alph empty)) (cons x w0)).
2:Apply chemin_Chemin; Assumption.
Intros.
Absurd (dans x0 empty).
Apply empty_empty.
Elim H2; Intros; Clear H2.
Elim H4; Intros; Clear H4.
Elim H5; Intros; Clear H5.
Elim H6; Intros; Clear H6.
Cut (dans x0 empty) /\ (dans (couple x x2) (prodcart alph empty)).
2:Apply coupl2; Assumption.
Intro.
Elim H6; Auto.
Save.

(*									*)
(*  Pour pouvoir construire un automate qui reconnait (cons a w) a	*)
(*  partir d'un automate qui reconnait w, il faut un resultat un peu	*)
(*  plus precis que "il existe un automate tel que...".			*)
(*									*)
(*  On precise que cet automate a un unique etat de depart.		*)
(*									*)

Lemma lwordnil_is_regS :
 <Ensf>Ex([q:Ensf]
   <Elt>Ex([e:Elt]
     <Ensf>Ex([qa:Ensf]
       <Ensf>Ex([d:Ensf]
            (automate q (singleton e) qa d)
         /\ (eqwordset (reconnait q (singleton e) qa d) (lword nil))
  )))).  
Goal.
Exists (singleton zero).
Exists zero.
Exists (singleton zero).
Exists (prodcart empty (prodcart alph empty)).
Split; Red.
Split.
Apply refl_inclus.
Split.
Apply refl_inclus.
Apply cart_inclus.
Apply empty_inclus.
Apply cart_inclus.
Apply refl_inclus.
Apply empty_inclus.
Split.
Red.
Symmetry; Apply lwordnil_is_reg2.
Assumption.
Intro.
Rewrite <- H.
Apply lwordnil_is_reg1.
Save.

(*  D'ou bien sur...							*)

Lemma lwordnil_is_reg :
  (isregular (lword nil)).
Goal.
Cut <Ensf>Ex([q:Ensf]
   <Elt>Ex([e:Elt]
     <Ensf>Ex([qa:Ensf]
       <Ensf>Ex([d:Ensf]
            (automate q (singleton e) qa d)
         /\ (eqwordset (reconnait q (singleton e) qa d) (lword nil))
  )))). 
2:Apply lwordnil_is_regS; Auto.
Intro H; Elim H; Clear H.
Intros q H; Elim H; Clear H.
Intros e H; Elim H; Clear H.
Intros qa H; Elim H; Clear H.
Intros d H; Elim H; Clear H.
Intros.
Red.
Exists q.
Exists (singleton e).
Exists qa.
Exists d.
Auto.
Save.

(*  Le gros morceau...							*)

(*  On commence par montrer que si on a un chemin pour w alors on	*)
(*  toujours ce chemin en rajoutant un etat et une transition.		*)

Lemma extension_qd : (w:Word)(e0,e1,e2,e3,a:Elt)(q,d:Ensf)
  (chemin e1 e2 q d w) -> (chemin e1 e2 (add e0 q) (add (couple e0 (couple a e3)) d) w).
Goal.
Intro w; Pattern w; Apply induction_word.
Intros.
Cut (Chemin e1 e2 q d nil); Auto.
Intro.
Cut ( (dans e1 q) /\ <Elt>e1=e2); Auto.
Intro.
Elim H1; Clear H1.
Intros.
Apply chemin_nil; Auto.

Intros.
Cut (Chemin e1 e2 q d (cons x w0)); Auto.
Intro.
Cut <Elt>Ex ([e:Elt]( (chemin e e2 q d w0) /\ (dans e1 q) /\ (dans x alph) /\ (dans (couple e1 (couple x e)) d))); Auto.
Intro H2; Elim H2; Clear H2.
Intros e H2; Elim  H2; Clear H2.
Intros H2 H3; Elim H3; Clear H3.
Intros H3 H4; Elim H4; Clear H4.
Intros H4 H5.
Apply (chemin_cons e e2 (add e0 q) (add (couple e0 (couple a e3)) d) w0 e1 x); Auto.
Save.

(*  Si un automate reconnait un mot w sans utiliser l'etat e0 alors	*)
(*  l'automate obtenu en supprimant cet etat ainsi que la transition	*)
(*  correspondante reconnait toujours w.				*)

Lemma restriction_aut : (w:Word)(e0,e,e2,e3,a:Elt)(q,d:Ensf)
   ~(dans e0 q)
-> (dans e q)
-> (inclus d (prodcart q (prodcart alph q)))
-> (chemin e e2 (add e0 q) (add (couple e0 (couple a e3)) d) w)
-> (chemin e e2 q d w).
Goal.
Intro w; Pattern w; Apply induction_word.
Intros.
Cut (Chemin e e2 (add e0 q) (add (couple e0 (couple a e3)) d) nil); Auto.
Intro.
Cut ( (dans e (add e0 q)) /\ <Elt>e=e2 ); Auto.
Intro H4; Elim H4; Clear H4; Intros H4 H5.
Apply chemin_nil; Auto.

Intros.
Cut (Chemin e e2 (add e0 q) (add (couple e0 (couple a e3)) d) (cons x w0)); Auto.
Intro.
Cut <Elt>Ex ([e12:Elt]( (chemin e12 e2 (add e0 q) (add (couple e0 (couple a e3)) d) w0) /\ (dans e (add e0 q)) /\ (dans x alph) /\ (dans (couple e (couple x e12)) (add (couple e0 (couple a e3)) d)))); Auto.
Intro H5; Elim H5; Clear H5.
Intros e12 H5; Elim H5; Clear H5.
Intros H5 H6; Elim H6; Clear H6.
Intros H6 H7; Elim H7; Clear H7.
Intros H7 H8.
Apply (chemin_cons e12 e2 q d w0 e x); Auto.
Apply (H e0 e12 e2 e3 a q d); Auto.

Cut ( <Elt>(couple e0 (couple a e3))=(couple e (couple x e12)) \/ (dans (couple e (couple x e12)) d)).
2:Apply dans_add; Auto.
Intro H9; Elim H9; Clear H9.
Intro.
Cut <Elt>e0=e.
Intro.
Absurd (dans e0 q); Auto.
Rewrite H10; Auto.
Cut ( <Elt>e0=e /\ <Elt>(couple a e3)=(couple x e12)).
Intro H10; Elim H10; Auto.
Apply equal_couple; Auto.

Intro.
Cut (dans (couple e (couple x e12)) (prodcart q (prodcart alph q)) ).
2:Apply (dans_trans (couple e (couple x e12)) d (prodcart q (prodcart alph q))); Auto.
Intro.
Cut ( (dans e q) /\ (dans (couple x e12) (prodcart alph q))); Auto.
2:Apply coupl2; Auto.
Intro H11; Elim H11; Clear H11.
Intros.
Cut ( (dans x alph) /\ (dans e12 q) ).
2:Apply coupl2; Auto.
Intro H13; Elim H13; Clear H13; Auto.

Cut ( <Elt>(couple e0 (couple a e3))=(couple e (couple x e12)) \/ (dans (couple e (couple x e12)) d)).
2:Apply dans_add; Auto.
Intro H9; Elim H9; Clear H9.
Intro.
2:Auto.
Cut <Elt>e0=e.
Intro.
Absurd (dans e0 q); Auto.
Rewrite H10; Auto.
Cut ( <Elt>e0=e /\ <Elt>(couple a e3)=(couple x e12)).
Intro H10; Elim H10; Auto.
Apply equal_couple; Auto.
Save.

(*  Si un automate reconnait w alors en lui rajoutant un etat e0	*)
(*  et la bonne trnasition il reconnait (cons a w).			*)

Lemma extension_aut : (w:Word)(e0,e,a:Elt)(q,qa,d:Ensf)
  (reconnait q (singleton e) qa d w)
->~(dans e0 q)
->(dans a alph)
->(reconnait (add e0 q) (singleton e0) qa (add (couple e0 (couple a e)) d) (cons a w)).
Goal.
Unfold reconnait.
Intros.
Elim H; Clear H.
Intros H H2; Elim H2; Clear H2.
Intros e12 H2; Elim H2; Clear H2.
Intros e2 H2; Elim H2; Clear H2.
Intros H2 H3.
Split; Auto.
Exists e0.
Exists e2.
Split; Auto.
Elim H3; Clear H3; Intros H3 H4.
Split; Auto.
Cut <Elt>e12=e; Auto.
Intro H5; Rewrite <- H5.

Apply (chemin_cons e12 e2 (add e0 q) (add (couple e0 (couple a e12)) d) w e0 a); Auto.
Apply extension_qd; Auto.
Save.

(*									*)
(*  Si un automate (q (singleton e) qa d) reconnait exactement {w0}	*)
(*  et si e0 n'est pas dans q alors l'automate ((add e0 q) 		*)
(*  (singleton e0) qa (add (e0,a,e) d)) reconnait exactement		*)
(*  {cons a w0}.							*)
(*									*)

Axiom auto_cons : (q,qa,d:Ensf)(e0,e,a:Elt)(w0:Word)
   (dans a alph)
-> (automate q (singleton e) qa d)
-> (eqwordset (reconnait q (singleton e) qa d) (lword w0) )
-> ~(dans e0 q)
-> (eqwordset (reconnait (add e0 q) (singleton e0) qa 
         (add (couple e0 (couple a e)) d) ) (lword (cons a w0)) ).

(*--- Cette preuve est correcte mais tres longue : on laisse l'axiome...

Lemma auto_cons : (q,qa,d:Ensf)(e0,e,a:Elt)(w0:Word)
   (dans a alph)
-> (automate q (singleton e) qa d)
-> (eqwordset (reconnait q (singleton e) qa d) (lword w0) )
-> ~(dans e0 q)
-> (eqwordset (reconnait (add e0 q) (singleton e0) qa 
         (add (couple e0 (couple a e)) d) ) (lword (cons a w0)) ).
Goal.
Unfold eqwordset.
Unfold lword.
Intros q qa d e0 e a w0 dans_a_alph H H0 H1 w; Pattern w; Apply induction_word.
Split.
Intro.
Elim H2; Clear H2.
Intros H2 H3; Elim H3; Clear H3.
Intros e1 H3; Elim H3; Clear H3.
Intros e2 H3; Elim H3; Clear H3.
Intros H3 H4; Elim H4; Clear H4.
Intros.
Cut <Elt>e1=e0; Auto.
Intro.
Elim H.
Intros H7 H8.
Cut <Elt>e1=e2.
2:Cut (Chemin e1 e2 (add e0 q) (add (couple e0 (couple a e)) d) nil); Auto.
2:Intro; Cut ( (dans e1 (add e0 q)) /\ (<Elt>e1=e2) ); Auto.
2:Intro H10; Elim H10; Auto.
Intro H9.
Cut (dans e2 q).
2:Apply (dans_trans e2 qa q); Auto.
Intro H10.
Absurd (dans e0 q); Auto.
Rewrite <- H6.
Rewrite H9.
Assumption.

Intro.
Cut False.
Apply False_imp_P.
Apply (diff_cons_nil a w0); Auto.
Apply (diff_cons_nil a w0); Auto.

Intros.
Split.
Intro H3; Elim H3; Clear H3.
Intros H3 H4; Elim H4; Clear H4.
Intros e1 H4; Elim H4; Clear H4.
Intros e2 H4; Elim H4; Clear H4.
Intros H4 H5; Elim H5; Clear H5.
Intros H5 H6.


Cut (Chemin e1 e2 (add e0 q) (add (couple e0 (couple a e)) d) (cons x w1)); Auto.
Intro H7; Elim H7; Clear H7.
Intros e12 H7; Elim H7; Clear H7.
Intros H7 H8; Elim H8; Clear H8.
Intros H8 H9; Elim H9; Clear H9.
Intros H9 H10.
Cut <Elt>e1=e0; Auto.
Intro H11; Clear H4.

Cut (inclus d (prodcart q (prodcart alph q))).
2:Apply (automate_def1 q (singleton e) qa d); Auto.
Intro H12.
Cut (<Elt>(couple e0 (couple a e))=(couple e1 (couple x e12)) \/ (dans (couple e1 (couple x e12)) d)).
2:Apply dans_add; Auto.
Intro H4; Elim H4; Clear H4.

Intro.
Cut <Elt>a=x.
Intro.
2:Cut <Elt>(couple a e)=(couple x e12).
2:Intro.
2:Replace a with (first (couple a e)); Auto.
2:Replace x with (first (couple x e12)); Auto.
2:Apply (f_equal Elt Elt); Auto.
2:Replace (couple a e) with (second (couple e0 (couple a e))); Auto.
2:Replace (couple x e12) with (second (couple e1 (couple x e12))); Auto.
2:Apply (f_equal Elt Elt); Auto.

Apply cons_cons; Auto.

2:Intro.
2:Absurd (dans e0 q); Auto.
2:Cut (dans (couple e1 (couple x e12)) (prodcart q (prodcart alph q))).
2:Intro.
3:Apply (dans_trans (couple e1 (couple x e12)) d); Auto.
2:Cut (dans e1 q).
2:Rewrite H11; Auto.
2:Cut ( (dans e1 q) /\ (dans (couple x e12) (prodcart alph q))); Auto.
2:Intro H14; Elim H14; Clear H14.
2:Auto.
2:Apply coupl2; Auto.

Cut <Elt>e12=e.
2:Replace e12 with (second (second (couple e1 (couple x e12)))); Auto.
2:Replace e with (second (second (couple e0 (couple a e)))); Auto.
2:Apply (f_equal Elt Elt).
2:Apply (f_equal Elt Elt); Auto.
Intro.

Cut (chemin e e2 (add e0 q) (add (couple e0 (couple a e)) d) w1).
2:Cut (chemin e12 e2 (add e0 q) (add (couple e0 (couple a e)) d) w1); Auto.
2:Rewrite H14; Auto.
Clear H7; Intro H7.

Cut (reconnait q (singleton e) qa d w1).
Elim (H0 w1).
Auto.
Unfold reconnait.
Split.
Apply (inmonoid_cons_inv alph w1 x); Auto.
Exists e.
Exists e2.
Split; Auto.
Split; Auto.

Apply (restriction_aut w1 e0 e e2 e a q d ); Auto.
Cut (inclus (singleton e) q).
Intro; Apply inclus_singl; Auto.
Apply (automate_def2 q (singleton e) qa d); Auto.

Intro H3.
Cut ((<Elt>a=x)/\(<Word>w0=w1)).
2:Apply cons_cons_inv; Auto.
Intro H4; Elim H4; Clear H4.
Intros.
Rewrite <- H4.
Rewrite <- H5.

Apply extension_aut; Auto.
Elim (H0 w0).
Auto.
Save.
----*)

(*									*)
(*  Un langage reduit a un seul mot est regulier. 			*)
(*  A partir d'un automate qui reconnait {w} on rajoute un nouvel etat	*)
(*  (en utilisant le lemme exist_other) et la relation adequate		*)
(*  pour construire un automate reconnaissant {cons a w}.		*)
(*									*)

Lemma lword_is_regS : (w:Word)
 (inmonoid alph w) -> 
 <Ensf>Ex([q:Ensf]
   <Elt>Ex([e:Elt]
     <Ensf>Ex([qa:Ensf]
       <Ensf>Ex([d:Ensf]
            (automate q (singleton e) qa d)
         /\ (eqwordset (reconnait q (singleton e) qa d) (lword w))
  )))).
Goal.
Intro w; Pattern w; Apply induction_word.
Intro.
Apply lwordnil_is_regS.
Intros a w0 H H4.
Cut (inmonoid alph w0).
2:Apply (inmonoid_cons_inv alph w0 a); Auto.
Intro H5.
Cut  (<Ensf>Ex([q:Ensf]<Elt>Ex([e:Elt]<Ensf>Ex([qa:Ensf]<Ensf>Ex([d:Ensf]
    (automate q (singleton e) qa d)
 /\ (eqwordset (reconnait q (singleton e) qa d) (lword w0))
     ))))); Auto.
Clear H; Intro H; Elim H; Clear H.
Intros q H0; Elim H0; Clear H0.
Intros e H0; Elim H0; Clear H0.
Intros qa H0; Elim H0; Clear H0.
Intros d H0; Elim H0; Clear H0.
Intros.
Cut (<Elt>Ex ([e0:Elt] ( ~(dans e0 q)))).
2:Apply exist_other; Auto.
Intro H2; Elim H2; Clear H2.
Intros e0 H2.
Exists (add e0 q).
Exists e0.
Exists qa.
Exists (add (couple e0 (couple a e)) d).
Elim H; Clear H.
Intros H H1.
Elim H1; Clear H1.
Intros.
Split.
Red.
Split; Auto.
Split; Auto.
Apply add_inclus.
Apply coupl2_inv; Auto.
Apply coupl2_inv.
Apply (inmonoid_cons_inv2 alph a w0); Auto.
Cut (dans e q); Auto.
Apply inclus_singl; Auto.
Apply (inclus_trans d (prodcart q (prodcart alph q))); Auto.
Apply cart_inclus.
Apply inclus_add; Auto.
Apply cart_inclus; Auto.
Apply auto_cons; Auto.
Apply (inmonoid_cons_inv2 alph a w0); Auto.
Unfold automate; Auto.
Save.

(*									*)
(*  Finalement, on montre qu'un langage reduit a un mot est regulier : 	*)
(*									*)

Lemma lword_is_reg :
  (w : Word)
  (inmonoid alph w) -> (isregular (lword w)).
Goal.
Unfold isregular.
Intros.
Cut  <Ensf>Ex([q:Ensf]
   <Elt>Ex([e:Elt]
     <Ensf>Ex([qa:Ensf]
       <Ensf>Ex([d:Ensf]
            (automate q (singleton e) qa d)
         /\ (eqwordset (reconnait q (singleton e) qa d) (lword w))
  )))).
2:Apply lword_is_regS; Auto.
Intro H0; Elim H0; Clear H0.
Intros q H0; Elim H0; Clear H0.
Intros e H0; Elim H0; Clear H0.
Intros qa H0; Elim H0; Clear H0.
Intros d H0; Elim H0; Clear H0.
Intros H0 H1.
Exists q.
Exists (singleton e).
Exists qa.
Exists d.
Auto.
Save.

(************************************************************************)
(*									*)
(*      L'union de 2 langages reguliers est un langage regulier.	*)
(*									*)
(************************************************************************)

(*									*)
(*  A partir d'une relation d1 (partie de q1 x alph x q1) on construit	*)
(*  la relation d1', qui est la meme relation, mais pour les etats	*)
(*  (e,zero) au lieu de e.						*)
(*  De meme pour une relation d2 avec e -> (e,un).			*)
(*									*)

Definition est_dans_d'_2 : Ensf -> Elt -> Elt -> Prop =
  [d:Ensf][e,y:Elt](<[s:sortes]Prop>Match y with 
            False
            [x:Elt][Hx:Prop][e:Ensf][He:Prop]False
 
            [n:nat]False
            [a:Elt][Ha:Prop][e':Elt][He':Prop]
                            (dans (couple (first e) (couple a (first e'))) d)
            [e:Ensf][He:Prop]False
            [w:Word][Hw:Prop]False
 
            False
            [a:Elt][Ha:Prop][w:Word][Hw:Prop]False
  ).

Definition est_dans_d' : Ensf -> Elt -> Prop =
  [d1:Ensf][x:Elt](<[s:sortes]Prop>Match x with 
            False
            [x:Elt][Hx:Prop][e:Ensf][He:Prop]False
 
            [n:nat]False
            [e:Elt][He:Prop][y:Elt][Hy:Prop](est_dans_d'_2 d1 e y)
            [e:Ensf][He:Prop]False
            [w:Word][Hw:Prop]False
 
            False
            [a:Elt][Ha:Prop][w:Word][Hw:Prop]False
  ).

Definition injg_d1 : Ensf -> Ensf -> Ensf =
  [q1:Ensf][d1:Ensf] (tq (est_dans_d' d1) 
        (prodcart (map injgauche q1) (prodcart alph (map injgauche q1) )) ).

Definition injd_d2 : Ensf -> Ensf -> Ensf =
  [q2:Ensf][d2:Ensf] (tq (est_dans_d' d2) 
        (prodcart (map injdroite q2) (prodcart alph (map injdroite q2) )) ).

Lemma d_is_good : (q1,q2,d1,d2:Ensf)
  (inclus (union (injg_d1 q1 d1) (injd_d2 q2 d2))
     (prodcart (union_disj q1 q2) (prodcart alph (union_disj q1 q2)))).
Goal.
Intros.
Apply union_inclus.
Apply inclus_trans with (prodcart (map injgauche q1) (prodcart alph (map injgauche q1))).
Unfold injg_d1.
Apply inclus_tq.
Unfold union_disj.
Apply cart_inclus.
Apply inclus_g.
Apply cart_inclus; Auto.
Apply inclus_trans with (prodcart (map injdroite q2) (prodcart alph (map injdroite q2))).
Unfold injd_d2.
Apply inclus_tq.
Unfold union_disj. 
Apply cart_inclus; Auto.
Apply cart_inclus; Auto.
Save.

(* 									*)
(*  Deux petits lemmes sur la relation de transition construite		*)
(*  ci-dessus.								*)
(*									*)

Lemma transition_dans_d1 : (q1,d1,q2,d2:Ensf)(e1,x,e:Elt)
  (dans (couple e1 (couple x e)) (union (injg_d1 q1 d1) (injd_d2 q2 d2)))
  -> (dans e1 (map injgauche q1))
  -> (dans e (map injgauche q1)).
Goal.
Intros.
Cut ( (dans (couple e1 (couple x e)) (injg_d1 q1 d1) )
   \/ (dans (couple e1 (couple x e)) (injd_d2 q2 d2) ) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Unfold injg_d1.
Intro.
Cut ( (dans (couple e1 (couple x e)) (prodcart (map injgauche q1)
                  (prodcart alph (map injgauche q1))) )
    /\ ( (est_dans_d' d1) (couple e1 (couple x e)) ) ).
2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H2 H3.      
Cut ( (dans e1 (map injgauche q1)) /\ (dans (couple x e) (prodcart alph (map injgauche q1))) ).
2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H4 H5.
Cut ( (dans x alph) /\ (dans e (map injgauche q1)) ).
2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Auto.

Unfold injd_d2.
Intro.
Cut ( (dans (couple e1 (couple x e)) (prodcart (map injdroite q2)
                  (prodcart alph (map injdroite q2))) )
    /\ ( (est_dans_d' d2) (couple e1 (couple x e)) ) ).
2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H2 H3.      
Cut ( (dans e1 (map injdroite q2)) /\ (dans (couple x e) (prodcart alph (map injdroite q2))) ).
2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H4 H5.
Absurd (dans e1 (map injdroite q2)); Auto.
Apply absurd_injg_injd with q1; Auto.
Save.


Lemma restriction_transition_d1 : (q1,d1,q2,d2:Ensf)(e1,x,e:Elt)
  (dans (couple e1 (couple x e))
            (union (injg_d1 q1 d1) (injd_d2 q2 d2)))
  -> (dans e1 (map injgauche q1))
  -> (dans (couple (first e1) (couple x (first e))) d1).
Goal.
Intros.
Cut ( (dans (couple e1 (couple x e)) (injg_d1 q1 d1) )
   \/ (dans (couple e1 (couple x e)) (injd_d2 q2 d2) ) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Unfold injg_d1.
Intro.
Cut ( (dans (couple e1 (couple x e)) (prodcart (map injgauche q1)
                  (prodcart alph (map injgauche q1))) )
    /\ ( (est_dans_d' d1) (couple e1 (couple x e)) ) ).
2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H2 H3.      
Assumption.

Unfold injd_d2.
Intro.
Cut ( (dans (couple e1 (couple x e)) (prodcart (map injdroite q2)
                  (prodcart alph (map injdroite q2))) )
    /\ ( (est_dans_d' d2) (couple e1 (couple x e)) ) ).
2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H2 H3.      
Cut ( (dans e1 (map injdroite q2)) /\ (dans (couple x e) (prodcart alph (map injdroite q2))) ).
2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H4 H5.
Absurd (dans e1 (map injdroite q2)); Auto.
Apply absurd_injg_injd with q1; Auto.
Save.

(* 									*)
(*  Si on a un chemin dans l'automate reconnaissant l'union de l1 et	*)
(*  et l2 commencant sur un etat de l'automate reconnaissant l1		*)
(*  alors le mot reconnu est reconnu par l1.				*)
(*									*)

Lemma chemin_restriction_1 : (q1,qd1,qa1,d1,q2,qa2,d2:Ensf)(w:Word)(e1,e2:Elt)
  (automate q1 qd1 qa1 d1)
  -> (chemin e1 e2 (union_disj q1 q2) 
                              (union (injg_d1 q1 d1) (injd_d2 q2 d2)) w)
  -> (dans e1 (map injgauche q1))
  -> (dans e2 (union_disj qa1 qa2))
  -> ( (chemin (first e1) (first e2) q1 d1 w) 
    /\ (dans e2 (map injgauche qa1)) ).
Goal.
Intros q1 qd1 qa1 d1 q2 qa2 d2 w; Pattern w; Apply induction_word.
Intros.
Cut (Chemin e1 e2 (union_disj q1 q2) 
   (union (injg_d1 q1 d1) (injd_d2 q2 d2)) nil); Auto.
Intro.
Cut ( (dans e1 (union_disj q1 q2)) /\ (<Elt>e1=e2) ); Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H4 H5.
Split.
Apply chemin_nil.
2:Apply (f_equal Elt Elt); Auto.
Apply dans_map_injg; Auto.
Unfold union_disj in H2.
Cut ( (dans e2 (map injgauche qa1)) \/ (dans e2 (map injdroite qa2)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Auto.
Intro.
Absurd (dans e2 (map injdroite qa2)); Auto.
Rewrite <- H5.
Apply absurd_injg_injd with q1; Auto.

Intros.
Cut (Chemin e1 e2 (union_disj q1 q2)
            (union (injg_d1 q1 d1) (injd_d2 q2 d2)) (cons x w0)); Auto.
Intro.
Cut (<Elt>Ex ([e:Elt]( 
  (chemin e e2 (union_disj q1 q2) (union (injg_d1 q1 d1) (injd_d2 q2 d2)) w0)
  /\ (dans e1 (union_disj q1 q2)) /\ (dans x alph)
  /\ (dans (couple e1 (couple x e)) (union (injg_d1 q1 d1) (injd_d2 q2 d2)) )
    ))); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e Ht; Elim Ht; Clear Ht.
Intros H5 Ht; Elim Ht; Clear Ht.
Intros H6 Ht; Elim Ht; Clear Ht; Intros H7 H8. 
Cut (dans e (map injgauche q1)).
2:Apply transition_dans_d1 with d1 q2 d2 e1 x; Auto.
Intro.
Cut ( (chemin (first e) (first e2) q1 d1 w0) /\ (dans e2 (map injgauche qa1)) ); Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H10 H11.
Split; Auto.
Apply chemin_cons with (first e); Auto.
Apply dans_map_injg; Auto.
Apply restriction_transition_d1 with q1 q2 d2; Auto.
Save.

(*  De meme pour l2...							*)

Axiom chemin_restriction_2 : (q2,qd2,qa2,d2,q1,qa1,d1:Ensf)(w:Word)(e1,e2:Elt)
  (automate q2 qd2 qa2 d2)
  -> (chemin e1 e2 (union_disj q1 q2) 
			(union (injg_d1 q1 d1) (injd_d2 q2 d2)) w)
  -> (dans e1 (map injdroite q2))
  -> (dans e2 (union_disj qa1 qa2))
  -> ( (chemin (first e1) (first e2) q2 d2 w) 
    /\ (dans e2 (map injdroite qa2)) ).

(*									*)
(*  Inversement, si on a un chemin dans l'automate reconnaissant l1	*)
(*  pour un mot w alors on a un chemin dans l'automate reconnaissant	*)
(*  l'union de l1 et l2 pour w.						*)
(*									*)

Lemma chemin_extension_1 : (q1,qd1,qa1,d1,q2,d2:Ensf)(w:Word)(e1,e2:Elt)
  (automate q1 qd1 qa1 d1)
   -> (chemin e1 e2 q1 d1 w)
   -> (dans e1 q1)
   -> (dans e2 qa1)
   -> (chemin (couple e1 zero) (couple e2 zero) (union_disj q1 q2)
                             (union (injg_d1 q1 d1) (injd_d2 q2 d2)) w).
Goal.
Intros q1 qd1 qa1 d1 q2 d2 w; Pattern w; Apply induction_word.
Intros e1 e2 H_aut.
Intros.
Cut (Chemin e1 e2 q1 d1 nil); Auto.
Intro.
Cut ( (dans e1 q1) /\ <Elt>e1=e2 ); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros H3 H4.
Apply chemin_nil; Auto.
Unfold union_disj.
Apply union_g.
Replace (couple e1 zero) with (injgauche e1); Auto.
Apply dans_map_inv; Auto.
Rewrite H4; Auto.

Intros x w0 H e1 e2 H_aut.
Intros.
Cut (Chemin e1 e2 q1 d1 (cons x w0)); Auto.
Intro.
Cut (<Elt>Ex ([e:Elt]( (chemin e e2 q1 d1 w0) /\ (dans e1 q1) 
         /\ (dans x alph) /\ (dans (couple e1 (couple x e)) d1) ))); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros e Ht; Elim Ht; Clear Ht.
Intros H4 Ht; Elim Ht; Clear Ht.
Intros H5 Ht; Elim Ht; Clear Ht.
Intros H6 H7.
Cut (dans e q1).
Intro dans_e_q1.

2:Cut (inclus d1 (prodcart q1 (prodcart alph q1))).
3:Apply automate_def1 with qd1 qa1 ; Auto.
2:Intro.
2:Cut (dans (couple e1 (couple x e)) (prodcart q1 (prodcart alph q1)) ).
3:Apply dans_trans with d1; Auto.
2:Intro.
2:Cut ( (dans e1 q1) /\ (dans (couple x e) (prodcart alph q1)) ).
3:Apply coupl2; Auto.
2:Intro Ht; Elim Ht; Clear Ht.
2:Intros H10 H11.
2:Cut ( (dans x alph) /\ (dans e q1) ).  
3:Apply coupl2; Auto.
2:Intro Ht; Elim Ht; Clear Ht.
2:Auto.

Apply chemin_cons with (couple e zero); Auto.

Unfold union_disj.
Apply union_g.
Replace (couple e1 zero) with (injgauche e1); Auto.
Apply dans_map_inv; Auto.
Apply union_g.
Unfold injg_d1.
Apply imp_dans_tq; Auto.
Apply coupl2_inv.
Replace (couple e1 zero) with (injgauche e1); Auto.
Apply dans_map_inv; Auto.
Apply coupl2_inv; Auto.
Replace (couple e zero) with (injgauche e); Auto.
Apply dans_map_inv; Auto.
Save.

(*  De meme pour l2...							*)

Axiom chemin_extension_2 : (q2,qd2,qa2,d2,q1,d1:Ensf)(w:Word)(e1,e2:Elt)
  (automate q2 qd2 qa2 d2)
   -> (chemin e1 e2 q2 d2 w)
   -> (dans e1 q2)
   -> (dans e2 qa2)
   -> (chemin (couple e1 un) (couple e2 un) (union_disj q1 q2)
                             (union (injg_d1 q1 d1) (injd_d2 q2 d2)) w).


(* 									*)
(*  Si l'automate 1 reconnait l1 et l'automate 2 reconnait l2 alors	*)
(*  l'automate ci-dessous reconnait l'union de l1 et l2.		*)
(*									*)

Lemma lunion_is_reg1 : (q1,qd1,qa1,d1,q2,qd2,qa2,d2:Ensf)(l1,l2:wordset)
  (automate q1 qd1 qa1 d1)
  -> (eqwordset (reconnait q1 qd1 qa1 d1) l1)
  -> (automate q2 qd2 qa2 d2)
  -> (eqwordset (reconnait q2 qd2 qa2 d2) l2)
  -> (eqwordset
     (reconnait (union_disj q1 q2) (union_disj qd1 qd2)
        (union_disj qa1 qa2) (union (injg_d1 q1 d1) (injd_d2 q2 d2)))
     (lunion l1 l2)).
Goal.
Intros.
Unfold eqwordset.
Intro w.
Split.

Unfold reconnait.
Intro Ht; Elim Ht; Clear Ht.
Intros H3 Ht; Elim Ht; Clear Ht.
Intros e1 Ht; Elim Ht; Clear Ht.
Intros e2 Ht; Elim Ht; Clear Ht.
Intros H4 Ht; Elim Ht; Clear Ht.
Intros H5 H6.
Unfold union_disj in H4.
Cut ( (dans e1 (map injgauche qd1)) \/ (dans e1 (map injdroite qd2)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Intro H7.
Unfold lunion.
Left.
Cut ( (chemin (first e1) (first e2) q1 d1 w) 
     /\ (dans e2 (map injgauche qa1)) ).
2:Apply chemin_restriction_1 with qd1 q2 qa2 d2; Auto.
2:Cut (inclus qd1 q1).
3:Apply automate_def2 with qa1 d1; Auto.
2:Intro; Apply dans_map_trans with qd1; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H8 H9.
Unfold eqwordset in H0.
Elim (H0 w).
Intros H10 H11.
Apply H10.
Unfold reconnait.
Split; Auto.
Exists (first e1).
Exists (first e2).
Split.
Apply dans_map_injg; Auto.
Split.
Apply dans_map_injg; Auto.
Assumption.

Intro H7.
Unfold lunion.
Right.
Cut ( (chemin (first e1) (first e2) q2 d2 w) 
     /\ (dans e2 (map injdroite qa2)) ).
2:Apply chemin_restriction_2 with qd2 q1 qa1 d1; Auto.
2:Cut (inclus qd2 q2).
3:Apply automate_def2 with qa2 d2; Auto.
2:Intro; Apply dans_map_trans with qd2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H8 H9.
Unfold eqwordset in H2.
Elim (H2 w).
Intros H10 H11.
Apply H10.
Unfold reconnait.
Split; Auto.
Exists (first e1).
Exists (first e2).
Split.
Apply dans_map_injd; Auto.
Split.
Apply dans_map_injd; Auto.
Assumption.

Unfold lunion.
Intro Ht; Elim Ht; Clear Ht.

Intro H3.
Unfold eqwordset in H0.
Elim (H0 w).
Intros H4 H5.
Cut (reconnait q1 qd1 qa1 d1 w); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros H6 Ht; Elim Ht; Clear Ht.
Intros e1 Ht; Elim Ht; Clear Ht.
Intros e2 Ht; Elim Ht; Clear Ht.
Intros H7 Ht; Elim Ht; Clear Ht.
Intros H8 H9.
Unfold reconnait.
Split; Auto.
Exists (couple e1 zero).
Exists (couple e2 zero).
Split.
Unfold union_disj.
Apply union_g.
Replace (couple e1 zero) with (injgauche e1); Auto. 
Apply dans_map_inv; Auto.
Split.
Unfold union_disj.
Apply union_g.
Replace (couple e2 zero) with (injgauche e2); Auto. 
Apply dans_map_inv; Auto.
Apply chemin_extension_1 with qd1 qa1 ; Auto.
Apply dans_trans with qd1; Auto.
Apply automate_def2 with qa1 d1; Auto.

Intro H3.
Unfold eqwordset in H2.
Elim (H2 w).
Intros H4 H5.
Cut (reconnait q2 qd2 qa2 d2 w); Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros H6 Ht; Elim Ht; Clear Ht.
Intros e1 Ht; Elim Ht; Clear Ht.
Intros e2 Ht; Elim Ht; Clear Ht.
Intros H7 Ht; Elim Ht; Clear Ht.
Intros H8 H9.
Unfold reconnait.
Split; Auto.
Exists (couple e1 un).
Exists (couple e2 un).
Split.
Unfold union_disj.
Apply union_d.
Replace (couple e1 un) with (injdroite e1); Auto. 
Apply dans_map_inv; Auto.
Split.
Unfold union_disj.
Apply union_d.
Replace (couple e2 un) with (injdroite e2); Auto. 
Apply dans_map_inv; Auto.
Apply chemin_extension_2 with qd2 qa2 ; Auto.
Apply dans_trans with qd2; Auto.
Apply automate_def2 with qa2 d2; Auto.
Save.

(*									*)
(*  Si les langages l1 et l2 sont reguliers alors le langage		*)
(*  (lunion l1 l2) est aussi regulier.					*)
(*									*)

Lemma lunion_is_reg : 
  (l1,l2 : wordset)
    (isregular l1) -> (isregular l2) -> (isregular (lunion l1 l2)).
Goal.
Unfold isregular.
Intros l1 l2 H1 H2.

Elim H1; Clear H1.
Intros q1 H1; Elim H1; Clear H1; Intros qd1 H1; Elim H1; Clear H1; Intros qa1 H1; Elim H1; Clear H1; Intros d1 H1; Elim H1; Clear H1.
Intros H1_aut H1_eq.
Elim H2; Clear H2.
Intros q2 H2; Elim H2; Clear H2; Intros qd2 H2; Elim H2; Clear H2; Intros qa2 H2; Elim H2; Clear H2; Intros d2 H2; Elim H2; Clear H2.
Intros H2_aut H2_eq.

Exists (union_disj q1 q2).
Exists (union_disj qd1 qd2).
Exists (union_disj qa1 qa2).
Exists (union (injg_d1 q1 d1) (injd_d2 q2 d2)).
Split.

Red.
Split.
Apply inclus_union_disj.
Apply automate_def3 with qd1 d1; Auto.
Apply automate_def3 with qd2 d2; Auto.
Split.
Apply inclus_union_disj.
Apply automate_def2 with qa1 d1; Auto.
Apply automate_def2 with qa2 d2; Auto.
Apply d_is_good.

Apply lunion_is_reg1; Auto.
Save.


(************************************************************************)
(*									*)
(*  La concatenation de 2 langages reguliers est un langage regulier.	*)
(*									*)
(************************************************************************)

(*  On definit (pont qa1 qd2) comme l'ensemble des transitions		*)
(*  (e,epsilon,e') avec e dans qa1 et e' dans qd2.			*)

Definition transition_pont : Elt -> Elt =
  [x:Elt](<[s:sortes]Elt>Match x with
        zero
        [x:Elt][Hx:Elt][e:Ensf][He:Elt]zero
 
        [n:nat]zero
        [e:Elt][He:Elt][e':Elt][He':Elt]
                  (couple (couple e zero) (couple epsilon (couple e' un)))
        [e:Ensf][He:Elt]zero
        [w:Word][Hw:Elt]zero
 
        zero
        [a:Elt][Ha:Elt][w:Word][Hw:Elt]zero
  ).

Definition pont : Ensf -> Ensf -> Ensf =
  [qa1,qd2:Ensf] (map transition_pont (prodcart qa1 qd2)).

(*  L'automate construit pour reconnaitre l1.l2 est bien un automate	*)
(*  asynchrone.								*)

Lemma automate_lconc_isgood : (q1,qd1,qa1,d1,q2,qd2,qa2,d2:Ensf)
  (automate q1 qd1 qa1 d1)
  -> (automate q2 qd2 qa2 d2)
  -> (automate_A (union_disj q1 q2) (map injgauche qd1)
       (map injdroite qa2)
       (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2)))).
Goal.
Intros.
Red.
Split.
Unfold union_disj.
Apply inclus_d2.
Apply map_inclus.
Apply automate_def3 with qd2 d2; Auto.
Split.
Unfold union_disj.
Apply inclus_g2.
Apply map_inclus.
Apply automate_def2 with qa1 d1; Auto.
Apply union_inclus.
Unfold pont.
Unfold inclus.
Intros.
Cut (<Elt>Ex ([y:Elt]( (dans y (prodcart qa1 qd2)) /\ <Elt>x=(transition_pont y) ))).
2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros y Ht; Elim Ht; Clear Ht; Intros H2 H3.
Cut (<Elt>Ex ([y1:Elt]( <Elt>Ex ([y2:Elt](
   (dans y1 qa1) /\ (dans y2 qd2) /\ <Elt>y=(couple y1 y2) ))))).
2:Apply coupl3; Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros y1 Ht; Elim Ht; Clear Ht.
Intros y2 Ht; Elim Ht; Clear Ht.
Intros H4 Ht; Elim Ht; Clear Ht; Intros H5 H6.
Cut <Elt>x=(couple (couple y1 zero) (couple epsilon (couple y2 un))).
2:Rewrite H3.
2:Rewrite H6; Auto.
Intro H7.
Rewrite H7.
Apply coupl2_inv.
Unfold union_disj.
Apply union_g.
Replace (couple y1 zero) with (injgauche y1); Auto.
Apply dans_map_inv.
Apply dans_trans with qa1; Auto.
Apply automate_def3 with qd1 d1; Auto.
Apply coupl2_inv; Auto.
Unfold union_disj.
Apply union_d.
Replace (couple y2 un) with (injdroite y2); Auto.
Apply dans_map_inv.
Apply dans_trans with qd2; Auto.
Apply automate_def2 with qa2 d2; Auto.

Apply union_inclus.
Apply inclus_trans with (prodcart (map injgauche q1) (prodcart alph (map injgauche q1))).
Unfold injg_d1.
Apply inclus_tq.
Unfold union_disj.
Apply cart_inclus.
Apply inclus_g.
Apply cart_inclus; Auto.
Apply inclus_trans with (prodcart (map injdroite q2) (prodcart alph (map injdroite q2))).
Unfold injd_d2.
Apply inclus_tq.
Unfold union_disj. 
Apply cart_inclus; Auto.
Apply cart_inclus; Auto.
Save.

(*  Si on a une transition (e0,x,e) avec e0 dans (map injgauche q1)	*)
(*  et x dans alph, alors e est dans (map injgauche q1).		*)

Lemma transition_a_gauche : (q1,qa1,d1,q2,qd2,d2:Ensf)(e0,x,e:Elt)
 (dans e0 (map injgauche q1))
  -> (dans x alph)
  -> (dans (couple e0 (couple x e))  
           (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2))))
  -> (dans e (map injgauche q1)).
Goal.
Intros.
Cut ( (dans (couple e0 (couple x e)) (pont qa1 qd2)) 
   \/ (dans (couple e0 (couple x e)) (union (injg_d1 q1 d1) (injd_d2 q2 d2)))); Auto.
Intro Ht; Elim Ht; Clear Ht.
Unfold pont.
Intro.
Cut (<Elt>Ex ([y:Elt]( (dans y (prodcart qa1 qd2)) /\ (<Elt>(couple e0 (couple x e))=(transition_pont y)) ))).
	2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros H3 H4.
Cut (<Elt>Ex ([y1:Elt]( <Elt>Ex ([y2:Elt](
  (dans y1 qa1) /\ (dans y2 qd2) /\ <Elt>y=(couple y1 y2) ))))).
	2:Apply coupl3; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y1 Ht; Elim Ht; Clear Ht; Intros  y2 Ht;
   Elim Ht; Clear Ht; Intros H5 Ht; Elim Ht; Clear Ht; Intros H6 H7.
Cut <Elt>(couple e0 (couple x e))=(transition_pont (couple y1 y2)).
	2:Rewrite <- H7; Auto.
Unfold transition_pont.
Intro.
Cut <Elt>(couple x e)=(couple epsilon (couple y2 un)).
	2:Apply couple_couple_inv2 with e0 (couple y1 zero); Auto.
Intro.
Cut <Elt>x=epsilon.
	2:Apply couple_couple_inv1 with e (couple y2 un); Auto.
Intro.
Absurd (dans x alph); Auto.
Rewrite H10.
Red; Intro; Apply not_dans_epsilon_alph; Assumption.

Intro.
Clear H1.
Cut ( (dans (couple e0 (couple x e)) (injg_d1 q1 d1))
   \/ (dans (couple e0 (couple x e)) (injd_d2 q2 d2)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Unfold injg_d1.
Intro.
Cut ( (dans (couple e0 (couple x e)) (prodcart (map injgauche q1)
                  (prodcart alph (map injgauche q1))))
    /\ ( (est_dans_d' d1) (couple e0 (couple x e))) ).
	2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans e0 (map injgauche q1)) 
   /\ (dans (couple x e) (prodcart alph (map injgauche q1))) ).
	2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans x alph) /\ (dans e (map injgauche q1)) ).
	2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Auto.

Unfold injd_d2.
Intro.
Cut ( (dans (couple e0 (couple x e)) (prodcart (map injdroite q2)
                  (prodcart alph (map injdroite q2))))
    /\ ( (est_dans_d' d2) (couple e0 (couple x e))) ).
	2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans e0 (map injdroite q2)) 
   /\ (dans (couple x e) (prodcart alph (map injdroite q2))) ).
	2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Absurd (dans e0 (map injdroite q2)); Auto.
Apply absurd_injg_injd with q1; Auto.
Save.

(*  Si on a la transition (e0,x,e) dans la relation de l'automate	*)
(*  reconnaissant la concatenation , que e0 est dans (map injgauche q1)	*)
(*  et x dans alph, alors on a la transition (first e0,x,first e)	*)
(*  dans d1.								*)

Lemma transition_a_gauche_2 : (q1,qa1,d1,q2,qd2,d2:Ensf)(e0,x,e:Elt) 
  (dans e0 (map injgauche q1))
   -> (dans x alph)
   -> (dans (couple e0 (couple x e))
            (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2))))
   -> (dans (couple (first e0) (couple x (first e))) d1).
Goal.
Intros.
Cut ( (dans (couple e0 (couple x e)) (pont qa1 qd2)) 
   \/ (dans (couple e0 (couple x e)) (union (injg_d1 q1 d1) (injd_d2 q2 d2)))); Auto.
Intro Ht; Elim Ht; Clear Ht.
Unfold pont.
Intro.
Cut (<Elt>Ex ([y:Elt]( (dans y (prodcart qa1 qd2)) /\ (<Elt>(couple e0 (couple x e))=(transition_pont y)) ))).
	2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros H3 H4.
Cut (<Elt>Ex ([y1:Elt]( <Elt>Ex ([y2:Elt](
  (dans y1 qa1) /\ (dans y2 qd2) /\ <Elt>y=(couple y1 y2) ))))).
	2:Apply coupl3; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y1 Ht; Elim Ht; Clear Ht; Intros  y2 Ht;
   Elim Ht; Clear Ht; Intros H5 Ht; Elim Ht; Clear Ht; Intros H6 H7.
Cut <Elt>(couple e0 (couple x e))=(transition_pont (couple y1 y2)).
	2:Rewrite <- H7; Auto.
Unfold transition_pont.
Intro.
Cut <Elt>(couple x e)=(couple epsilon (couple y2 un)).
	2:Apply couple_couple_inv2 with e0 (couple y1 zero); Auto.
Intro.
Cut <Elt>x=epsilon.
	2:Apply couple_couple_inv1 with e (couple y2 un); Auto.
Intro.
Absurd (dans x alph); Auto.
Rewrite H10.
Red; Intro; Apply not_dans_epsilon_alph; Assumption.

Intro.
Clear H1.
Cut ( (dans (couple e0 (couple x e)) (injg_d1 q1 d1))
   \/ (dans (couple e0 (couple x e)) (injd_d2 q2 d2)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Unfold injg_d1.
Intro.
Cut ( (dans (couple e0 (couple x e)) (prodcart (map injgauche q1)
                  (prodcart alph (map injgauche q1))))
    /\ ( (est_dans_d' d1) (couple e0 (couple x e))) ).
	2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Auto.

Unfold injd_d2.
Intro.
Cut ( (dans (couple e0 (couple x e)) (prodcart (map injdroite q2)
                  (prodcart alph (map injdroite q2))))
    /\ ( (est_dans_d' d2) (couple e0 (couple x e))) ).
	2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans e0 (map injdroite q2)) 
   /\ (dans (couple x e) (prodcart alph (map injdroite q2))) ).
	2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Absurd (dans e0 (map injdroite q2)); Auto.
Apply absurd_injg_injd with q1; Auto.
Save.

(*  De meme pour d2...							*)

Axiom transition_a_droite_2 : (q1,qa1,d1,q2,qd2,d2:Ensf)(e0,x,e:Elt) 
  (dans e0 (map injdroite q2))
   -> (dans x alph)
   -> (dans (couple e0 (couple x e))
            (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2))))
   -> (dans (couple (first e0) (couple x (first e))) d2).

(*  Si on a une transition (e0,epsilon,e) alors (first e0) est dans qa1	*)
(*  et (first e) est dans qd2.						*)

Lemma transition_dans_pont : (q1,qa1,d1,q2,qd2,d2:Ensf)(e0,e:Elt) 
  (dans (couple e0 (couple epsilon e))
        (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2))))
  -> ( (dans e0 (map injgauche qa1)) /\ (dans e (map injdroite qd2)) ).
Goal.
Intros.
Cut ( (dans (couple e0 (couple epsilon e)) (pont qa1 qd2)) 
   \/ (dans (couple e0 (couple epsilon e)) (union (injg_d1 q1 d1) (injd_d2 q2 d2)))); Auto.
Intro Ht; Elim Ht; Clear Ht.

Unfold pont. 
Intro.
Cut (<Elt>Ex ([y:Elt]( (dans y (prodcart qa1 qd2)) /\ (<Elt>(couple e0 (couple epsilon e))=(transition_pont y)) ))).
	2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros H3 H4.
Cut (<Elt>Ex ([y1:Elt]( <Elt>Ex ([y2:Elt](
  (dans y1 qa1) /\ (dans y2 qd2) /\ <Elt>y=(couple y1 y2) ))))).
	2:Apply coupl3; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y1 Ht; Elim Ht; Clear Ht; Intros  y2 Ht;
   Elim Ht; Clear Ht; Intros H5 Ht; Elim Ht; Clear Ht; Intros H6 H7.
Cut <Elt>(couple e0 (couple epsilon e))=(transition_pont (couple y1 y2)).
	2:Rewrite <- H7; Auto.
Unfold transition_pont. 
Intro.
Cut <Elt>e0=(couple y1 zero).
	2:Apply couple_couple_inv1 with (couple epsilon e) 
	                            (couple epsilon (couple y2 un)); Auto.
Intro.
Cut <Elt>(couple epsilon e)=(couple epsilon (couple y2 un)).
	2:Apply couple_couple_inv2 with e0 (couple y1 zero); Auto.
Intro.
Cut <Elt>e=(couple y2 un).
	2:Apply couple_couple_inv2 with epsilon epsilon; Auto.
Intro.
Split.
Replace e0 with (couple y1 zero); Auto.
Replace (couple y1 zero) with (injgauche y1); Auto.
Apply dans_map_inv; Auto.
Replace e with (couple y2 un); Auto.
Replace (couple y2 un) with (injdroite y2); Auto.
Apply dans_map_inv; Auto.

Intro.
Cut ( (dans (couple e0 (couple epsilon e)) (injg_d1 q1 d1))
   \/ (dans (couple e0 (couple epsilon e)) (injd_d2 q2 d2)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Unfold injg_d1.
Intro.
Cut ( (dans (couple e0 (couple epsilon e)) (prodcart (map injgauche q1) 
                                         (prodcart alph (map injgauche q1)))) 
  /\ ((est_dans_d' d1) (couple e0 (couple epsilon e)) )).
	2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans e0 (map injgauche q1))
   /\ (dans (couple epsilon e) (prodcart alph (map injgauche q1))) ).
	2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans epsilon alph)
   /\ (dans e (map injgauche q1)) ).
	2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Absurd (dans epsilon alph); Auto.
Red; Intro; Apply not_dans_epsilon_alph; Assumption.

Unfold injd_d2.
Intro.
Cut ( (dans (couple e0 (couple epsilon e)) (prodcart (map injdroite q2) 
                                         (prodcart alph (map injdroite q2)))) 
  /\ ((est_dans_d' d2) (couple e0 (couple epsilon e)) )).
	2:Apply dans_tq_imp; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans e0 (map injdroite q2))
   /\ (dans (couple epsilon e) (prodcart alph (map injdroite q2))) ).
	2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans epsilon alph)
   /\ (dans e (map injdroite q2)) ).
	2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Absurd (dans epsilon alph); Auto.
Red; Intro; Apply not_dans_epsilon_alph; Assumption.
Save.

(*  Si on a une transition dans le pont alors c'est par epsilon.	*)

Lemma dans_pont_imp_epsilon : (qa1,qd2:Ensf)(e1,x,e0:Elt)
  (dans (couple e1 (couple x e0)) (pont qa1 qd2))
  -> <Elt>x=epsilon.
Goal.
Intros qa1 qd2 e1 x e0.
Unfold pont.
Intro.
Cut (<Elt>Ex ([y:Elt]( (dans y (prodcart qa1 qd2)) 
                    /\ <Elt>(couple e1 (couple x e0))=(transition_pont y) ))).
2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros H0 H1.
Cut (<Elt>Ex ([y1:Elt]( <Elt>Ex ([y2:Elt](
    (dans y1 qa1) /\ (dans y2 qd2) /\ <Elt>y=(couple y1 y2) ))))).
2:Apply coupl3; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y1 Ht; Elim Ht; Clear Ht; Intros y2 Ht; 
  Elim Ht; Clear Ht; Intros H2 Ht; Elim Ht; Clear Ht; Intros H3 H4.
Cut <Elt>(couple e1 (couple x e0))=(transition_pont (couple y1 y2)).
2:Rewrite <- H4; Assumption.
Unfold transition_pont.
Intro.
Cut <Elt>(couple x e0)=(couple epsilon (couple y2 un)).
2:Apply couple_couple_inv2 with e1 (couple y1 zero); Assumption.
Intro.
Apply couple_couple_inv1 with e0 (couple y2 un); Assumption.
Save.

(*  Si on a un chemin asynchrone uniquement dans l'automate 2 alors	*)
(*  on a le meme chemin au sens des automates finis.			*)

Lemma chemin_A_chemin_2 : (q1,qa1,d1,q2,qd2,d2:Ensf)(e,e3:Elt)(w0:Word)
   (chemin_A (union_disj q1 q2) 
            (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2)))
            e e3 w0)
  -> (dans e (map injdroite q2))
  -> (dans e3 (map injdroite q2))
  -> (chemin (first e) (first e3) q2 d2 w0).
Goal.
Intros q1 qa1 d1 q2 qd2 d2 e e3 w0 H.
Elim H; Clear H.

Intros.
Apply chemin_nil.
Apply dans_map_injd; Auto.
Apply (f_equal Elt Elt); Auto.

Intros.
Apply chemin_cons with (first e0); Auto.
Apply H0; Auto.
Cut ( (dans (couple e1 (couple x e0)) (pont qa1 qd2))
   \/ (dans (couple e1 (couple x e0)) (union (injg_d1 q1 d1) (injd_d2 q2 d2))) ); Auto.
Intro Ht; Elim Ht; Clear Ht.
	Intro.
	Cut <Elt>x=epsilon.
	2:Apply dans_pont_imp_epsilon with qa1 qd2 e1 e0; Auto.
	Intro.
	Absurd (dans x alph); Auto.
	Rewrite H7.
	Red; Intro; Apply not_dans_epsilon_alph; Assumption.

	Intro.
	Cut ( (dans (couple e1 (couple x e0)) (injg_d1 q1 d1))
	  \/  (dans (couple e1 (couple x e0)) (injd_d2 q2 d2)) ); Auto.
	Intro Ht; Elim Ht; Clear Ht.

	Unfold injg_d1.
	Intro.
	Cut ( (dans (couple e1 (couple x e0)) (prodcart (map injgauche q1)
                                        (prodcart alph (map injgauche q1))))
	 /\ ( (est_dans_d' d1) (couple e1 (couple x e0)) )).
	2:Apply dans_tq_imp; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( (dans e1 (map injgauche q1))
	  /\  (dans (couple x e0) (prodcart alph (map injgauche q1))) ).
	2:Apply coupl2; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Absurd (dans e1 (map injdroite q2)); Auto.
	Apply absurd_injg_injd with q1; Auto.

	Unfold injd_d2.
	Intro.
	Cut ( (dans (couple e1 (couple x e0)) (prodcart (map injdroite q2)
                                        (prodcart alph (map injdroite q2))))
	 /\ ( (est_dans_d' d2) (couple e1 (couple x e0)) )).
	2:Apply dans_tq_imp; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( (dans e1 (map injdroite q2))
	  /\  (dans (couple x e0) (prodcart alph (map injdroite q2))) ).
	2:Apply coupl2; Auto.
	Intro Ht; Elim Ht; Clear Ht; Intros.
	Cut ( (dans x alph)
	  /\  (dans e0 (map injdroite q2)) ).
	2:Apply coupl2; Auto.
	Intro Ht; Elim Ht; Auto.

	Apply dans_map_injd; Auto.
	
	Apply transition_a_droite_2 with q1 qa1 d1 q2 qd2; Auto.

Intros.
Cut ( (dans e1 (map injgauche qa1)) /\ (dans e0 (map injdroite qd2)) ).
2:Apply transition_dans_pont with q1 d1 q2 d2; Auto.
Intro Ht; Elim Ht; Clear Ht.
Intros.
Absurd (dans e1 (map injdroite q2)); Auto.
Apply absurd_injg_injd with qa1; Auto.
Save.


(*  Si on a un chemin par w de e1 a e2 avec e1 dans (map injgauche q1)	*)
(*  et e2 dans (map injdroite q2) alors on passe necessairement par	*)
(*  le pont.								*)

Lemma par_le_pont : (q1,qd1,qa1,d1,q2,qd2,qa2,d2:Ensf)(e1,e2:Elt)(w:Word)
  (automate q1 qd1 qa1 d1)
  -> (automate q2 qd2 qa2 d2)
  -> (chemin_A (union_disj q1 q2) (union (pont qa1 qd2)
               (union (injg_d1 q1 d1) (injd_d2 q2 d2))) e1 e2 w)
  -> (dans e1 (map injgauche q1))
  -> (dans e2 (map injdroite q2))
  -> (<Elt>Ex ([x1:Elt]( <Elt>Ex ([x2:Elt]( <Word>Ex ([w1:Word]( 
      <Word>Ex ([w2:Word](
	  (dans x1 qa1) /\ (dans x2 qd2) /\ (chemin (first e1) x1 q1 d1 w1)
       /\ (chemin x2 (first e2) q2 d2 w2) /\ (<Word>w=(Append w1 w2))
     ))))))))).
Goal.
Intros q1 qd1 qa1 d1 q2 qd2 qa2 d2 e1 e2 w H_aut1 H_aut2  H.
Elim H.
	
Intros.
Absurd (dans e3 (map injdroite q2)); Auto.
Apply absurd_injg_injd with q1.
Rewrite <- H1; Assumption.

Intros.
Cut (dans e (map injgauche q1)).
	2:Apply transition_a_gauche with qa1 d1 q2 qd2 d2 e0 x; Auto.
Intro H7.
Elim (H1 H7 H6); Clear H1.
Intros x1 Ht; Elim Ht; Clear Ht; Intros x2 Ht; Elim Ht; Clear Ht;
  Intros w1' Ht; Elim Ht; Clear Ht; Intros w2 Ht; Elim Ht;
  Clear Ht; Intros H8 Ht; Elim Ht; Clear Ht; Intros H9 Ht; Elim Ht; Clear Ht;
  Intros H10 Ht; Elim Ht; Clear Ht; Intros H11 H12.
Exists x1.
Exists x2.
Exists (cons x w1').
Exists w2.
Split; [Assumption | Split; [Assumption | Split; [Idtac | Split; 
  [Assumption | Idtac ]]]].
2:Rewrite H12; Auto.
Apply chemin_cons with (first e); Auto.
Apply dans_map_injg; Auto.
Apply transition_a_gauche_2 with q1 qa1 q2 qd2 d2; Auto.

Intros.
Clear H1.
Exists (first e0).
Exists (first e).
Exists nil.
Exists w0.
Cut ( (dans e0 (map injgauche qa1)) /\ (dans e (map injdroite qd2)) ).
	2:Apply transition_dans_pont with q1 d1 q2 d2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H6 H7.
Split; [Apply dans_map_injg; Assumption | Split; [Apply dans_map_injd; 
         Assumption | Idtac]].
Split.
Apply chemin_nil; Auto.
Apply dans_trans with qa1.
Apply dans_map_injg; Auto.
Apply automate_def3 with qd1 d1; Auto.
Split; Auto.
Apply chemin_A_chemin_2 with q1 qa1 d1 qd2; Auto.
Apply dans_map_trans with qd2; Auto.
Apply automate_def2 with qa2 d2; Auto.
Save.


(*  Si l1 reconnait w1 et l2 reconnait w2 alors l'automate construit 	*)
(*  ici reconnait (Append w1 w2).					*)

Lemma reconnait_Append : (q1,qd1,qa1,d1,q2,qd2,qa2,d2:Ensf)(w2:Word)
			 (x1,x2,e2:Elt)(w1:Word)(e1:Elt)
  (automate q1 qd1 qa1 d1)
  -> (automate q2 qd2 qa2 d2)
  -> (chemin e1 x1 q1 d1 w1) -> (dans x1 qa1) 
  -> (chemin x2 e2 q2 d2 w2) -> (dans x2 qd2) -> (dans e2 qa2)
  -> (chemin_A (union_disj q1 q2) 
        (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2)))
	(couple e1 zero) (couple e2 un)
        (Append w1 w2)).
Goal.
Intros q1 qd1 qa1 d1 q2 qd2 qa2 d2 w2 x1 x2 e2 w1; Pattern w1; Apply induction_word.
Intros e1 H_aut1 H_aut2 H H0 H1 H2 H3.
Cut (Chemin e1 x1 q1 d1 nil); Auto.
Intro H4.
Cut ( (dans e1 q1) /\ <Elt>e1=x1 ); Auto.
Intro Ht; Elim Ht; Clear Ht; Intros H5 H6.
Replace (Append nil w2) with w2; Auto.
Apply chemin_A_epsilon with (couple x2 un).
Apply chemin_A_d1_d2 with (union (injg_d1 q1 d1) (injd_d2 q2 d2)); Auto.
Apply chemin_chemin_A.
Apply chemin_extension_2 with qd2 qa2; Auto.
Apply dans_trans with qd2; Auto.
Apply automate_def2 with qa2 d2; Auto.

Replace (couple e1 zero) with (injgauche e1); Auto.
Unfold union_disj.
Apply union_g.
Apply dans_map_inv; Auto.

Apply union_g.
Unfold pont.
Rewrite H6.
Replace (couple (couple x1 zero) (couple epsilon (couple x2 un))) with (transition_pont (couple x1 x2)); Auto.
Apply dans_map_inv; Auto.

Intros.
Replace (Append (cons x w) w2) with (cons x (Append w w2)); Auto.
Cut (Chemin e1 x1 q1 d1 (cons x w)); Auto.
Intro H7.
Cut (<Elt>Ex ([e:Elt]( (chemin e x1 q1 d1 w) /\ (dans e1 q1) /\ (dans x alph)
                      /\ (dans (couple e1 (couple x e)) d1) ))); Auto.
Intro Ht; Elim Ht; Clear Ht; Intros e Ht; Elim Ht; Clear Ht; Intros H8 Ht; 
  Elim Ht; Clear Ht; Intros H9 Ht; Elim Ht; Clear Ht; Intros H10 H11.
Apply chemin_A_cons with (couple e zero); Auto.
	Unfold union_disj.
	Apply union_g.
	Replace (couple e1 zero) with (injgauche e1); Auto.
	Apply dans_map_inv; Auto.

	Apply union_d.
	Apply union_g.
	Unfold injg_d1.
	Apply imp_dans_tq; Auto.
	Apply coupl2_inv.
	Replace (couple e1 zero) with (injgauche e1); Auto.
	Apply dans_map_inv; Auto.
	Apply coupl2_inv; Auto.
	Replace (couple e zero) with (injgauche e); Auto.
	Apply dans_map_inv; Auto.
	Apply dans_e1_q with d1 w x1; Auto.
Save.


(*  Si l'automate 1 reconnait l1 et si l'automate 2 reconnait l2	*)
(*  alors l'automate ci-dessous reconnait l1.l2 .			*)

Lemma lconc_is_reg1 : (q1,qd1,qa1,d1,q2,qd2,qa2,d2:Ensf)(l1,l2:wordset)
  (automate q1 qd1 qa1 d1)
  -> (eqwordset (reconnait q1 qd1 qa1 d1) l1)  
  -> (automate q2 qd2 qa2 d2)
  -> (eqwordset (reconnait q2 qd2 qa2 d2) l2)
  -> (eqwordset
     (reconnait_A (union_disj q1 q2) (map injgauche qd1)
        (map injdroite qa2)
        (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2))))
        (lconc l1 l2)).
Goal.
Intros.
Unfold eqwordset.
Intro w.
Split.

Unfold reconnait_A.
Intro Ht; Elim Ht; Clear Ht.
Intros H3 Ht; Elim Ht; Clear Ht. 
Intros e1 Ht; Elim Ht; Clear Ht.
Intros e2 Ht; Elim Ht; Clear Ht.
Intros H4 Ht; Elim Ht; Clear Ht.
Intros H5 H6.

Cut (<Elt>Ex ([x1:Elt]( <Elt>Ex ([x2:Elt]( <Word>Ex ([w1:Word]( 
      <Word>Ex ([w2:Word](
	  (dans x1 qa1) /\ (dans x2 qd2) /\ (chemin (first e1) x1 q1 d1 w1)
       /\ (chemin x2 (first e2) q2 d2 w2) /\ (<Word>w=(Append w1 w2))
     ))))))))).
2:Apply par_le_pont with qd1 qa2; Auto.
	2:Apply dans_map_trans with qd1; Auto.
	2:Apply automate_def2 with qa1 d1; Auto.
	2:Apply dans_map_trans with qa2; Auto.
	2:Apply automate_def3 with qd2 d2; Auto.
Intros Ht; Elim Ht; Clear Ht.
Intros x1 Ht; Elim Ht; Clear Ht.
Intros x2 Ht; Elim Ht; Clear Ht.
Intros w1 Ht; Elim Ht; Clear Ht.
Intros w2 Ht; Elim Ht; Clear Ht.
Intros H7 Ht; Elim Ht; Clear Ht.
Intros H8 Ht; Elim Ht; Clear Ht.
Intros H9 Ht; Elim Ht; Clear Ht.
Intros H10 H11.
Unfold lconc.
Exists w1.
Exists w2.
Split.
	Unfold eqwordset in H0; Elim (H0 w1).
	Intros .
	Apply H12.
	Unfold reconnait.
	Split.
	Apply Append_inmonoid_g with w2.
	Rewrite <- H11; Auto.
	Exists (first e1).
	Exists x1.
	Split; Auto.
	Apply dans_map_injg; Auto.

	Split.
	Unfold eqwordset in H2; Elim (H2 w2).
	Intros .
	Apply H12.
	Unfold reconnait.
	Split.
	Apply Append_inmonoid_d with w1.
	Rewrite <- H11; Auto.
	Exists x2.
	Exists (first e2).
	Split; Auto.
	Split; [Apply dans_map_injd; Auto | Auto].

	Assumption.

Unfold lconc.
Intro Ht; Elim Ht; Clear Ht.
Intros w1 Ht; Elim Ht; Clear Ht.
Intros w2 Ht; Elim Ht; Clear Ht.
Intros H3 Ht; Elim Ht; Clear Ht.
Intros H4 H5.
Cut (reconnait q1 qd1 qa1 d1 w1).
	2:Unfold eqwordset in H0.
	2:Elim (H0 w1); Intros.
	2:Auto.
Intro H6.
Cut (reconnait q2 qd2 qa2 d2 w2).
	2:Unfold eqwordset in H2.
	2:Elim (H2 w2); Intros.
	2:Auto.
Intro H7.
Rewrite H5.
Elim H6.
Intros H8 Ht; Elim Ht; Clear Ht; Intros e1 Ht; Elim Ht; Clear Ht; Intros x1 Ht;  Elim Ht; Clear Ht; Intros H9 Ht; Elim Ht; Clear Ht; Intros H10 H11.
Elim H7.
Intros H12 Ht; Elim Ht; Clear Ht; Intros x2 Ht; Elim Ht; Clear Ht; Intros e2 Ht;  Elim Ht; Clear Ht; Intros H13 Ht; Elim Ht; Clear Ht; Intros H14 H15.
Unfold reconnait_A.
Split.
	Apply inmonoid_Append; Auto.
Exists (couple e1 zero).
Exists (couple e2 un).
Split.
	Replace (couple e1 zero) with (injgauche e1); Auto.
	Apply dans_map_inv; Auto.
Split.
	Replace (couple e2 un) with (injdroite e2); Auto.
	Apply dans_map_inv; Auto.
Apply reconnait_Append with qd1 qa2 x1 x2; Auto.
Save.

(*  Si les langages l1 et l2 sont reguliers alors l1.l2 est aussi	*)
(*  regulier.								*)

Lemma lconc_is_reg :
  (l1,l2 : wordset)
    (isregular l1) -> (isregular l2) -> (isregular (lconc l1 l2)).
Goal.
Intros.
Unfold isregular in H.
Elim H; Clear H.
Intros q1 H; Elim H; Clear H; Intros qd1 H; Elim H; Clear H; Intros qa1 H; Elim H; Clear H; Intros d1 H; Elim H; Clear H.
Intros H_aut H_eq.
Unfold isregular in H0.
Elim H0; Clear H0.
Intros q2 H0; Elim H0; Clear H0; Intros qd2 H0; Elim H0; Clear H0; Intros qa2 H0; Elim H0; Clear H0; Intros d2 H0; Elim H0; Clear H0.
Intros H0_aut H0_eq.

Apply isregular_A_isregular.
Unfold isregular_A.
Exists (union_disj q1 q2).
Exists (map injgauche qd1).
Exists (map injdroite qa2).
Exists (union (pont qa1 qd2) (union (injg_d1 q1 d1) (injd_d2 q2 d2)) ).
Split.

Apply automate_lconc_isgood; Auto.

Apply lconc_is_reg1; Auto.
Save.


(************************************************************************)
(*									*)
(*          Si l est regulier alors l* est aussi regulier.      	*)
(*									*)
(************************************************************************)

Definition transition_back : Elt->Elt->Elt =
  [g0,x:Elt](couple x (couple epsilon g0)).

Definition delta : Elt->Ensf->Ensf =
  [g0:Elt][qa:Ensf](map (transition_back g0) qa).

Definition fun_d_dstar : Elt->Ensf->Ensf->Ensf =
  [g0:Elt][qa,d:Ensf](union d (delta g0 qa)).


Lemma dstar_is_good : (q,qa,d:Ensf)(g0:Elt)
  (automate q (singleton g0) qa d)
  -> (inclus (fun_d_dstar g0 qa d) 
              (prodcart q (prodcart (add epsilon alph) q))).
Goal.
Intros.
Unfold fun_d_dstar.
Apply union_inclus.
Cut (inclus d (prodcart q (prodcart alph q))).
2:Apply automate_def1 with (singleton g0) qa; Assumption.
Intro.
Apply inclus_trans with (prodcart q (prodcart alph q)); Auto.
Apply cart_inclus; Auto.
Apply cart_inclus; Auto.
Unfold delta.
Unfold inclus.
Intros.
Cut (<Elt>Ex ([y:Elt]( (dans y qa) /\ <Elt>x=((transition_back g0) y) ))).
2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros H1 H2.
Rewrite H2.
Unfold transition_back.
Apply coupl2_inv.
Apply dans_trans with qa; Auto.
Apply automate_def3 with (singleton g0) d; Auto.
Apply coupl2_inv; Auto.
Apply dans_trans with (singleton g0); Auto.
Apply automate_def2 with qa d; Auto.
Save.


(*									*)
(*  Si on a une transition (e0,x,e) dans d* avec x dans alph alors	*)
(*  cette transition est dans d.					*)
(*									*)

Lemma transition_dans_l : (q,qa,d:Ensf)(g0,e0,x,e:Elt)
  (automate q (singleton g0) qa d)
  -> (dans x alph)
  -> (dans (couple e0 (couple x e)) (fun_d_dstar g0 qa d))
  -> (dans (couple e0 (couple x e)) d).
Goal.
Intros q qa d g0 e0 x e H H0.
Unfold fun_d_dstar.
Intro.
Cut ( (dans (couple e0 (couple x e)) d) \/ (dans (couple e0 (couple x e)) (delta g0 qa)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Intro; Assumption.

Unfold delta.
Intro.
Cut (<Elt>Ex ([y:Elt]( (dans y qa) /\ (<Elt>(couple e0 (couple x e))=((transition_back g0) y)) ))).
2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
Unfold transition_back in H4.
Cut ( <Elt>e0=y /\ <Elt>(couple x e)=(couple epsilon g0) ).
2:Apply equal_couple; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( <Elt>x=epsilon /\ <Elt>e=g0 ).
2:Apply equal_couple; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Absurd (dans x alph); Auto. 
Rewrite H7.
Red; Intro; Apply not_dans_epsilon_alph; Assumption.
Save.

(*									*)
(*  Si on a une transition (e0,epsilon,e) dans d* alors on a 		*)
(*  e0 dans qa et e=g0.							*)
(*									*)

Lemma transition_par_epsilon : (q,qa,d:Ensf)(g0,e0,e:Elt)
  (automate q (singleton g0) qa d)
  -> (dans (couple e0 (couple epsilon e)) (fun_d_dstar g0 qa d))
  -> ( (dans e0 qa) /\ (<Elt>e=g0) ).
Goal.
Intros.
Unfold fun_d_dstar in H0.
Cut ( (dans (couple e0 (couple epsilon e)) d) \/ (dans (couple e0 (couple epsilon e)) (delta g0 qa)) ); Auto.
Intro Ht; Elim Ht; Clear Ht.

Intro.
Cut (inclus d (prodcart q (prodcart alph q))).
2:Apply automate_def1 with (singleton g0) qa; Assumption.
Intro.
Cut (dans (couple e0 (couple epsilon e)) (prodcart q (prodcart alph q)) ).
2:Apply dans_trans with d; Auto.
Intro.
Cut ( (dans e0 q) /\ (dans (couple epsilon e) (prodcart alph q)) ).
2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( (dans epsilon alph) /\ (dans e q) ).
2:Apply coupl2; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Absurd (dans epsilon alph); Auto.
Red; Intro; Apply not_dans_epsilon_alph; Assumption.

Unfold delta.
Intro.
Cut (<Elt>Ex ([y:Elt]( (dans y qa) /\ (<Elt>(couple e0 (couple epsilon e))=((transition_back g0) y)) ))).
2:Apply dans_map; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros y Ht; Elim Ht; Clear Ht; Intros.
Unfold transition_back in H3.
Cut ( <Elt>e0=y /\ <Elt>(couple epsilon e)=(couple epsilon g0) ).
2:Apply equal_couple; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Cut ( <Elt>epsilon=epsilon /\ <Elt>e=g0 ).
2:Apply equal_couple; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Rewrite H4.
Auto.
Save.

(*									*)
(*  Si on a un chemin de g0 a g0 dans A alors c'est par le mot nil.	*)
(*									*)

Lemma chemin_g0_g0 : (q,qa,d:Ensf)(g0:Elt)(w0:Word)
  (automate q (singleton g0) qa d)
  -> ((e,x:Elt)((dans (couple g0 (couple x e)) d)-><Elt>x=epsilon))
  -> (chemin g0 g0 q d w0)
  -> <Word>w0=nil.
Goal.
Intros q qa d g0  w0 H_aut H_g0; Pattern w0; Apply induction_word.

Auto.

Intros.
Cut (Chemin g0 g0 q d (cons x w)); Auto.
Intro.
Cut (<Elt>Ex ([e:Elt]( (chemin e g0 q d w) /\ (dans g0 q) /\ (dans x alph)
                       /\ (dans (couple g0 (couple x e)) d) ))); Auto.
Intro Ht; Elim Ht; Clear Ht; Intros e Ht; Elim Ht; Clear Ht; Intros H2 Ht;
  Elim Ht; Clear Ht; Intros H3 Ht; Elim Ht; Clear Ht; Intros H4 H5.
Cut <Elt>x=epsilon.
2:Apply (H_g0 e x); Assumption.
Intro.
Absurd (dans x alph); Auto.
Rewrite H6.
Red; Intro; Apply not_dans_epsilon_alph; Assumption.
Save.

(*									*)
(*  Si on a un chemin dans A* de e1 a e2 par w alors :			*)
(*    -  soit on a une chemin dans A de e1 a e2 par w.			*)
(*    -  soit il existe un etat e et 2 mots w1 et w2 tels que on a	*)
(*	 un chemin de e1 a e par w1, e est dans qa, w2 est dans l*	*)
(*	 et w=w1.w2							*)
(*									*)

Lemma lstar_is_reg2_bis : (q,qa,d:Ensf)(g0,e1,e2:Elt)(w:Word)(l:wordset)
  (automate q (singleton g0) qa d)
  -> (eqwordset (reconnait q (singleton g0) qa d) l)
  -> ((w:Word)((chemin g0 g0 q d w)->(<Word>w=nil)))
  -> (chemin_A  q (fun_d_dstar g0 qa d) e1 e2 w)
  -> (<Elt>e2=g0)
  -> (   (chemin e1 e2 q d w)
      \/ (<Elt>Ex ([e:Elt](<Word>Ex ([w1:Word](
          <Word>Ex ([w2:Word]( (chemin e1 e q d w1) /\ (dans e qa)
           /\ (lstar l w2) /\ (<Word>w=(Append w1 w2))
         ))))))) ).
Goal.
Intros q qa d g0 e1 e2 w l H H_eq H_g0 H0.
Elim H0.

Intros.
Left.
Apply chemin_nil ; Auto.

Intros.
Cut (dans (couple e0 (couple x e)) d).
2:Apply transition_dans_l with q qa g0; Auto.
Intro.
Elim H2; Clear H2.
3:Assumption.

	Intro.
	Left.
	Apply chemin_cons with e; Auto.

	Intro Ht; Elim Ht; Clear Ht; Intros x1 Ht; Elim Ht; Clear Ht;
	  Intros w1 Ht; Elim Ht; Clear Ht; Intros w2 Ht; Elim Ht; Clear Ht;
	  Intros H8 Ht; Elim Ht; Clear Ht; Intros H9 Ht; Elim Ht; Clear Ht;
	  Intros H10 H11.
	Right.
	Exists x1.
	Exists (cons x w1).
	Exists w2.
	Split.
	Apply chemin_cons with e; Auto.
	Split; [Assumption | Split; [Assumption | Idtac]].
	Replace (Append (cons x w1) w2) with (cons x (Append w1 w2)); Auto.
	
Intros.
Right.
Cut ( (dans e0 qa) /\ (<Elt>e=g0) ).
2:Apply transition_par_epsilon with q d; Auto.
Intro Ht; Elim Ht; Clear Ht; Intros.
Elim H2; Clear H2.
3:Assumption.
	
	Rewrite H7.
	Rewrite H5.
	Intro.
	Cut <Word>w0=nil.
	2:Apply (H_g0 w0); Assumption.
	Intro.
	Exists e0.
	Exists nil.
	Exists nil.
	Split.
	Apply chemin_nil; Auto.
	Split; [Assumption | Split].
	Unfold lstar.
	Exists O.
	Unfold lpuiss.
	Unfold lword; Auto.
	Rewrite H8; Auto.

	Intro Ht; Elim Ht; Clear Ht; Intros x1 Ht; Elim Ht; Clear Ht;
	  Intros w1 Ht; Elim Ht; Clear Ht; Intros w2 Ht; Elim Ht; Clear Ht;
	  Intros H8 Ht; Elim Ht; Clear Ht; Intros H9 Ht; Elim Ht; Clear Ht;
	  Intros H10 H11.
	Exists e0.
	Exists nil.
	Exists (Append w1 w2).
	Split.
	Apply chemin_nil; Auto.
	Split; [Assumption | Split].
	2:Replace (Append nil (Append w1 w2)) with (Append w1 w2); Auto.
	
	Elim H10.
	Intros n H12.
	Unfold lstar.
	Exists (S n).
	Change (lconc l (lpuiss n l) (Append w1 w2) ).
	Unfold lconc.
	Exists w1.
	Exists w2.
	Split; [Idtac | Split; [Assumption | Auto]].
	Unfold eqwordset in H_eq.
	Elim (H_eq w1); Intros.
	Apply H2.
	Unfold reconnait.
	Split.
	Apply (Cheminmonoid w1 q (singleton g0) qa d H e x1 H8); Auto.
	Exists e.
	Exists x1.
	Split; [Rewrite H7; Auto | Split; [Assumption | Assumption]].
Save.

(*									*)
(*  On montre ici que si l'automate A* reconnait w alors w est dans l*  *)
(*									*)

Lemma lstar_is_reg1 : (q,qa,d:Ensf)(l:wordset)(g0:Elt)(w:Word)
  (automate q (singleton g0) qa d)
  -> ((w:Word)((chemin g0 g0 q d w)->(<Word>w=nil)))
  -> (eqwordset (reconnait q (singleton g0) qa d) l)
  -> (reconnait_A q (singleton g0) (singleton g0) (fun_d_dstar g0 qa d) w)
  -> (lstar l w).
Goal.
Intros.
Elim H2; Clear H2; Intros H2 Ht; Elim Ht; Clear Ht; Intros e1 Ht; Elim Ht; 
  Clear Ht; Intros e2 Ht; Elim Ht; Clear Ht; Intros H3 Ht; Elim Ht; Clear Ht; 
  Intros H4 H5.
Cut (   (chemin e1 e2 q d w)
      \/ (<Elt>Ex ([e:Elt](<Word>Ex ([w1:Word](
          <Word>Ex ([w2:Word]( (chemin e1 e q d w1) /\ (dans e qa)
           /\ (lstar l w2) /\ (<Word>w=(Append w1 w2))
         ))))))) ).
2:Apply lstar_is_reg2_bis with g0; Auto.
Intro Ht; Elim Ht; Clear Ht.

Intro.
Cut <Elt>e1=g0; Auto.
Cut <Elt>e2=g0; Auto.
Intros.
Cut (chemin g0 g0 q d w).
2:Cut (chemin e1 e2 q d w); Auto.
2:Rewrite H7; Rewrite H8; Auto.
Intro.
Cut <Word>w=nil.
2:Apply (H0 w); Assumption.
Intro H10.
Rewrite H10.
Unfold lstar.
Exists O.
Unfold lpuiss.
Unfold lword; Auto.

Intro Ht; Elim Ht; Clear Ht; Intros e Ht;
  Elim Ht; Clear Ht; Intros w1 Ht; Elim Ht; Clear Ht; Intros w2 Ht;
  Elim Ht; Clear Ht; Intros H6 Ht; Elim Ht; Clear Ht; Intros H7 Ht;
  Elim Ht; Clear Ht; Intros H8 H9.
Elim H8.
Intros n H10.
Unfold lstar.
Exists (S n).
Change (lconc l (lpuiss n l) w).
Unfold lconc.
Exists w1.
Exists w2.
Split; [Idtac | Split; [Assumption | Assumption]].
Unfold eqwordset in H1.
Elim (H1 w1); Intros.
Apply H11.
Unfold reconnait.
Split.
Apply (Cheminmonoid w1 q (singleton g0) qa d H e1 e H6); Auto.
Exists e1.
Exists e.
Auto.
Save.

(*									*)
(*  Et enfin le resultat : si l est regulier alors l* l'est aussi.	*)
(*									*)

Lemma lstar_is_reg :
  (l : wordset)
    (isregular l) -> (isregular (lstar l)).
Goal.
Intros l H.
Cut (isregular_D l).
2:Apply isregular_isregular_D; Auto.
Clear H; Intro H; Elim H; Clear H.
  Intros q H; Elim H; Clear H; Intros g0 H; Elim H; Clear H; Intros qa H; 
  Elim H; Clear H; Intros d H; Elim H; Clear H.
Intros H_aut Ht; Elim Ht; Clear Ht; Intros H_g0 H_eq.

Apply isregular_A_isregular.
Unfold isregular_A.
Exists q.
Exists (singleton g0).
Exists (singleton g0).
Exists (fun_d_dstar g0 qa d).
Split.
Red.
Elim H_aut.
Intros H0 H1; Elim H1; Clear H1; Intros H1 H2.
Split; [Assumption | Split; [Assumption | Idtac]].
Apply dstar_is_good; Assumption.

Unfold eqwordset.
Intro w.
Split.

Intro; Apply lstar_is_reg1 with q qa d g0 ; Auto.

Intro; Pattern w; Apply induction_star with l; Auto.
Induction n.
Unfold lpuiss.                         
Unfold lword.
Intros.
Rewrite <- H0.
Unfold reconnait_A.
Split; Auto.
Exists g0.
Exists g0.
Split; [Auto | Split; [Auto |Idtac]].
Apply chemin_A_nil; Auto.
Apply dans_trans with (singleton g0); Auto.
Apply automate_def2 with qa d; Auto.

Intros y H1 w0.
Change ((lconc l (lpuiss y l)) w0)->(reconnait_A q (singleton g0) (singleton g0) (fun_d_dstar g0 qa d) w0).
Unfold lconc.
Intros Ht; Elim Ht; Clear Ht; Intros w1 Ht; Elim Ht; Clear Ht; Intros w2 Ht;
  Elim Ht; Clear Ht; Intros H2 Ht; Elim Ht; Clear Ht; Intros H3 H4.
Cut (reconnait_A q (singleton g0) (singleton g0) (fun_d_dstar g0 qa d) w2); Auto.
Intro H5.
Unfold eqwordset in H_eq.
Elim (H_eq w1); Intros H6 H7.
Cut (reconnait q (singleton g0) qa d w1); Auto.
Intro H8.
Clear H6 H7 H1 H_eq.
Elim H8; Clear H8; Intros H8 Ht; Elim Ht; Clear Ht;Intros e1 Ht; Elim Ht;
  Clear Ht; Intros e2 Ht; Elim Ht; Clear Ht; Intros H9 Ht; Elim Ht; Clear Ht;
  Intros H10 H11. 
Elim H5; Clear H5; Intros H12 Ht; Elim Ht; Clear Ht;Intros e3 Ht; Elim Ht;
  Clear Ht; Intros e4 Ht; Elim Ht; Clear Ht; Intros H13 Ht; Elim Ht; Clear Ht;
  Intros H14 H15. 
Unfold reconnait_A.
Split.

	Rewrite H4.
	Apply inmonoid_Append; Auto.

Exists e1.
Exists e4.
Split; [Assumption | Split; [Assumption | Idtac]].
Rewrite H4.
Apply chemin_Append with e2.
Apply chemin_A_d1_d2 with d.
Apply chemin_chemin_A; Auto.
Unfold fun_d_dstar.
Apply inclus_g.
Apply chemin_A_epsilon with e3; Auto.
Apply dans_trans with qa; Auto.
Apply automate_def3 with (singleton g0) d; Auto.
Unfold fun_d_dstar.
Apply union_d.
Unfold delta.
Cut <Elt>e3=g0; Auto.
Intro H16.
Rewrite H16.
Replace (couple e2 (couple epsilon g0)) with ( (transition_back g0) e2); Auto.
Apply dans_map_inv; Auto.
Save.


(************************************************************************)
(*									*)
(*  LE RESULTAT FINAL :							*)
(*      	   	   Tout langage rationnel est regulier.		*)
(*									*)
(************************************************************************)

Lemma rat_is_reg : (L:wordset)
  (isrationnal L) -> (isregular L).
Goal.
Intros L H.
Elim H.
Intros; Apply lword_is_reg; Auto.
Intros; Apply lunion_is_reg; Auto.
Intros; Apply lconc_is_reg; Auto.
Intros; Apply lstar_is_reg; Auto.
Save.

Provide RatReg.
