(*									*)
(*  LANGAGES RATIONNELS							*)
(*									*)

(*									*)
(*    On definit la concatenation, l'union, l'intersection de 2		*)
(*    langages, le langage L* si L est un langage, ainsi que le		*)
(*    langage reduit a un mot.						*)
(*									*)

Require Words.

Definition lword : Word->wordset = 
  [w,w1 : Word]
    (<Word> w=w1).

Definition lconc : wordset->wordset->wordset = 
  [l1,l2 : wordset] [w : Word] 
       (<Word> Ex ([w1:Word]
         (<Word> Ex ([w2:Word]  
              (l1 w1)
           /\ (l2 w2)
           /\ <Word>w=(Append w1 w2) )))).

Definition lunion : wordset->wordset->wordset = 
  [l1,l2 : wordset] [w : Word] 
     (l1 w) \/ (l2 w).

Definition linter : wordset->wordset->wordset = 
  [l1,l2 : wordset] [w : Word] 
     (l1 w) /\ (l2 w).

Definition lpuiss : nat -> wordset->wordset =
  [n:nat][l:wordset](<wordset>Match n with
      (lword nil)
      [p:nat][Hp:wordset](lconc l Hp)
  ).

Definition lstar : wordset->wordset =
  [l:wordset][w:Word]
    (<nat>Ex([n:nat](lpuiss n l w))).

Lemma induction_star : (P:Word->Prop)(l:wordset)
  ( (n:nat)(w:Word) (lpuiss n l w)->(P w) ) -> ( (w:Word)(lstar l w)->(P w) ).
Goal.
Unfold lstar.
Intros.
Elim H0; Clear H0.
Intros x H0.
Apply (H x w); Auto.
Save.

(*									*)
(*  Si w est dans l alors w est dans l*.				*)
(*									*)

Lemma lw_imp_lstarlw : (l:wordset)(w:Word)
  (l w) -> (lstar l w).
Goal.
Intros.
Unfold lstar.
Exists (S O).
Change (lconc l (lpuiss O l) w).
Unfold lconc.
Exists w.
Exists nil.
Split; [Assumption | Split]. 
Unfold lpuiss.
Unfold lword; Auto.
Symmetry.
Apply Append_w_nil.
Save.

(*									*)
(*  On definit le predicat isrationnal sur les langages en signifiant	*)
(*  que le langage est d'une des 4 formes suivantes :			*)
(*    --  {w}								*)
(*    --  L1 U L2							*)
(*    --  L1.L2								*)
(*    --  L*								*)
(*  ou L, L1 et L2 sont rationnels.					*)
(*									*)

Inductive Definition isrationnal : wordset->Prop =
    israt_lword  : (w :Word)
                      (inmonoid alph w) -> (isrationnal (lword w))
  | israt_lunion : (l1,l2 : wordset)
                      (isrationnal l1) -> (isrationnal l2) -> 
                                (isrationnal (lunion l1 l2))
  | israt_conc   : (l1,l2 : wordset)
                      (isrationnal l1) -> (isrationnal l2) -> 
                                (isrationnal (lconc l1 l2))
  | israt_lstar : (l : wordset)
                      (isrationnal l) -> (isrationnal (lstar l)).


Provide Rat.
