Require Words.
Require fonctions.
Require need.
Require Relations.

Section pushdown_automata.

Variable X , P : Ensf.
Variable wd : Word.
Variable wa : Word.
Variable d : Ensf.

Definition eps = (natural (sup X)).

Lemma not_dans_X_eps : ~(dans eps X).
Goal.
Unfold eps.
Apply sup_out.
Save.




Definition Transition : Prop
= (x:Elt)(dans x d)->
(<Word> Ex2 ([w1:Word](inmonoid P w1),
	[w1:Word](<Elt> Ex2 ([y:Elt](dans y (add eps X)),
			[y:Elt](<Word> Ex2 ([w2:Word](inmonoid P w2),
					    [w2:Word](<Elt>x=(couple (word w1)
								 (couple y
								    (word w2)
								  ))
							)
					))
				)
		)
	   )
).

							

Definition P_automata =
(inmonoid P wd)
/\(inmonoid P wa)
/\(Transition).

Lemma P_automata_1 : P_automata -> (inmonoid P wd).
Goal.
Unfold P_automata.
Intro temp;Elim temp.
Auto.
Save.

Lemma P_automata_2 : P_automata -> (inmonoid P wa).
Goal.
Unfold P_automata.
Intro temp;Elim temp;Clear temp.
Intros H temp;Elim temp;Clear temp.
Auto.
Save.

Lemma P_automata_2 : P_automata -> Transition.
Goal.
Unfold P_automata.
Intro temp;Elim temp;Clear temp.
Intros H temp;Elim temp;Clear temp.
Auto.
Save.



Definition Conf= Word*Word.


Inductive Definition Derive_P_A : Conf->Conf->Prop =
Derive_cons : (w,w1,w2,u:Word)(x:Elt)(dans x X)->
	(dans (couple (word w1) (couple x (word w2))) d)->
	(Derive_P_A <Word,Word>((Append w1 w),(cons x u))
		    <Word,Word>((Append w2 w),u))

| Derive_eps : (w,w1,w2,u:Word)
	(dans (couple (word w1) (couple eps (word w2))) d)->
	(Derive_P_A <Word,Word>((Append w1 w),u)
		    <Word,Word>((Append w2 w),u)).


Definition Derivestar_P_A = (Rstar Conf Derive_P_A).


Definition LA = 
[u:Word](Derivestar_P_A <Word,Word>(wd,u) <Word,Word>(wa,nil))/\(inmonoid X u).

Lemma LA_langage : (islanguage X LA).
Goal.
Unfold LA islanguage.
Intros w temp; Elim temp;Clear temp;Auto.
Save.




End pushdown_automata.

Provide PushdownAutomata.
