(*									*)
(*  On definit ici le maximum de 2 entiers et quelques			*)
(*  proprietes de ce max.						*)
(*  									*)

Require Le.
Require Lt.
Require Ensf.

Definition max = [n:nat]
      (<nat->nat>Match n with 
      (* O *) [m:nat]m
   (* S n' *) [n':nat][maxn':nat->nat][m:nat]
              (<nat>Match m with 
              (* O *) (S n') 
           (* S m' *) [m':nat][maxSn'm':nat](S (maxn' m')))).

Lemma max_SS : (n,m:nat)<nat>(S (max n m))=(max (S n) (S m)).
Goal.
Auto.
Save.

Lemma le_max_l : (n,m:nat)(le n (max n m) ).
Goal.
Induction n; Intros; Simpl; Auto.
Elim m; Intros; Simpl; Auto.
Save.
Hint le_max_l.

Lemma le_max_r : (n,m:nat)(le m (max n m) ).
Goal.
Induction n; Simpl; Auto.
Induction m; Simpl; Auto.
Save.
Hint le_max_r.

Lemma lt_max_l : (x,y,z:nat) (lt x y) -> (lt x (max y z)).
Goal.
Intros.
Apply lt_le_trans.
Instantiate y.
Auto.
Auto.
Save.
Hint lt_max_l.

Lemma lt_max_r : (x,y,z:nat) (lt x z) -> (lt x (max y z)).
Goal.
Intros.
Apply lt_le_trans.
Instantiate z.
Auto.
Auto.
Save.
Hint lt_max_r.

(*  									*)
(*  Une propriete vraie pour n et m l'est aussi pour max(n,m)  		*)
(*									*)

Lemma max_case : (n,m:nat)(P:nat->Prop)(P n)->(P m)->(P (max n m)).
Goal.
Induction n; Simpl; Auto.
Induction m; Intros; Simpl; Auto.
Pattern (max y y0); Apply H ; Auto.
Save.


(*									*)
(*  On definit maintenant (sup x) pour un ensemble x, qui est		*)
(*    - soit O, si x ne contient pas d'entier				*)
(*    - soit (S n), si n est le plus grand entier de x			*)
(*									*)

Definition Z : Elt -> nat =
  [x:Elt]
    (<[s:sortes]nat>Match x with
	O
	[x:Elt][Hx:nat][f:Ensf][Hf:nat]O
	
	[n:nat](S n)
	[a:Elt][Ha:nat][b:Elt][Hb:nat]O
	[e:Ensf][He:nat]O
	[w:Word][Hw:nat]O

	O
	[a:Elt][Ha:nat][w:Word][Hw:nat]O
    ).

Definition sup : Ensf -> nat =
  [e:Ensf]
    (<[s:sortes]nat>Match e with
	O	
	[x:Elt][Hx:nat][f:Ensf][Hf:nat](max (Z x) Hf)
	
	[n:nat]O
	[a:Elt][Ha:nat][b:Elt][Hb:nat]O
	[e:Ensf][He:nat]O
	[w:Word][Hw:nat]O

	O
	[a:Elt][Ha:nat][w:Word][Hw:nat]O
    ).

(*  Par definition on a :  *)

Lemma sup_add : (x:Elt)(e:Ensf) <nat>(sup (add x e))=(max (Z x) (sup e)).
Goal.
Intros x e; Pattern e; Apply induction_ensf; Auto.
Save.
Hint sup_add.

(*  Finalement inutile :  *)
(*
Lemma diff_natural : (n,m:nat)~(<nat>n=m)->~(<Elt>(natural n)=(natural m)).
Goal.
Intros; Red; Intro.
Absurd (<nat>n=m).
Assumption.
Replace n with (natural_inv (natural n)).
2:Auto.
Replace m with (natural_inv (natural m)).
2:Auto.
Elim H0.
Auto.
Save.
*)

(*  Finalement inutile  *)
(*
Lemma lt_diff : (n,m:nat)(lt m n)->~(<nat>n=m).
Goal.
Intros.
Red.
Intro.
Cut (lt m n); Auto.
Elim H0.
Change ~(lt n n).
Auto.
Save.
*)

Lemma elt_not_sym : (a,b:Elt) ~(<Elt>a=b)->~(<Elt>b=a).
Goal.
Auto.
Save.

(*  (Z (natural n)) vaut (S n), donc est plus grand que n		*)

Lemma lt_n_Z : (n:nat) (lt n (Z (natural n))).
Goal.
Intro.
Replace (Z (natural n)) with (S n); Auto.
Save.

(*									*)
(*  On montre d'abord que tout entier dans x est strictement plus petit	*)
(*  que (sup x)								*)
(*									*)

Lemma lt_n_sup : (x:Ensf)(n:nat) 
  (dans (natural n) x) -> (lt n (sup x)).
Goal.
Intro x; Pattern x ; Apply induction_ensf.
Intros.
Absurd True; Auto.
Red.
Intro.
Cut (dans (natural n) empty).
Change ~(dans (natural n) empty).
Auto.
Auto.
Intros.
Replace (sup (add a b)) with (max (Z a) (sup b)).
2:Auto.
Cut ( (lt n (Z a)) \/ (lt n (sup b)) ).
Intro.
Elim H1; Auto.
Cut (<Elt>a=(natural n) \/ (dans (natural n) b) ).
2:Apply dans_add;Auto.
Intro.
Elim H1.
Intro; Left.
Rewrite H2; Apply lt_n_Z.
Intro; Right.
Apply H; Assumption.
Save.

(*								*)	
(*  On en deduit que (natural (sup x)) n'est pas dans x 	*)
(*								*) 

Lemma sup_out : (x:Ensf) ~(dans (natural (sup x)) x).
Goal.
Intro.
Red.
Intro.
Cut (lt (sup x) (sup x)).
Change ~(lt (sup x) (sup x)).
Apply lt_n_n.
Apply lt_n_sup.
Assumption.
Save.

(*									   *)
(*  Le resultat final : 						   *)
(*      Pout tout ensemble e il existe un element x n'appartenant pas a e  *)
(*	(a savoir (natural (sup x)) )					   *)
(*									   *)

Lemma exist_other : (e:Ensf) (<Elt>Ex ([x:Elt] ~(dans x e))).
Goal.
Intro.
Exists (natural (sup e)).
Apply sup_out.
Save.

Provide Max.
