Require Ensf.

(*									*)
(*  Axiome de decidabilite :						*)
(*    On ne l'utilisera qu'avec des propositions que l'on sait etre	*)
(*    decidables...							*)
(*									*)

Axiom Pdec : (P:Elt->Prop)(x:Elt) ({(P x)} + {~(P x)}).

(*									*)
(*  Grace a l'axiome de decidabilite on peut construire, a partir d'un	*)
(*  ensemble e et d'un predicat f:Elt->Prop, le sous-ensemble des	*)
(*  elements de e qui verifient f.					*)
(*									*) 

Definition tq : (Elt->Prop)->Ensf->Ensf =
   [f:Elt->Prop][e:Ensf](<[s:sortes]Ensf>Match e with

	empty
	[x:Elt][Hx:Ensf][F:Ensf][HF:Ensf](<Ensf>Match (Pdec f x) with
		(* true *)	[fx:(f x)]   (add x HF)
		(* false *)	[nfx:~(f x)] HF          )

        [n:nat] empty
        [a:Elt][Ha:Ensf][b:Elt][Hb:Ensf] empty
        [e:Ensf][He:Ensf]empty
        [w:Word][Hw:Ensf]empty
 
        empty
        [a:Elt][Ha:Ensf][w:Word][Hw:Ensf]empty
  ).

(*  									*)
(*  On montre maintenant que (tq f E) est bien l'ensemble voulu, 	*)
(*  (ie) si x est dans (tq f E) alors il est dans E et (f x) est vrai...*)
(*									*)

Lemma dans_tq_imp : (x:Elt)(f:Elt->Prop)(E:Ensf)
  (dans x (tq f E)) -> (dans x E) /\ (f x).
Goal.
Intros x f E; Pattern E; Apply induction_ensf.
Replace (tq f empty) with empty; Auto.
Intro.
Apply (dans_empty_imp_P x); Auto.
Intros a b H.
Replace (tq f (add a b)) with (<Ensf>Match (Pdec f a) with [fa:(f a)](add a (tq f b)) [nfa:~(f a)](tq f b) ); Auto.
Elim (Pdec f a).
Intros a0 H0.
Cut (<Elt>a=x \/ (dans x (tq f b))).
2:Apply dans_add; Auto.
Intro H1; Elim H1; Clear H1.
Intro H1; Rewrite <- H1; Auto.
Intro.
Cut (dans x b)/\(f x); Auto.
Intro H2; Elim H2; Auto.
Intros.
Cut (dans x b)/\(f x); Auto.
Intro H1; Elim H1; Auto.
Save.

(*  									*)
(*  ...et reciproquement si x est dans E et si (f x) est vrai alors 	*)
(*  x est dans (tq f E).						*)
(*									*)

Lemma imp_dans_tq : (x:Elt)(f:Elt->Prop)(E:Ensf)
  (dans x E) -> (f x) -> (dans x (tq f E)).
Goal.
Intros x f E; Pattern E; Apply induction_ensf.
Intro.
Apply (dans_empty_imp_P x); Auto.
Intros a b H H0 x0.
Replace (tq f (add a b)) with (<Ensf>Match (Pdec f a) with [fa:(f a)](add a (tq f b)) [nfa:~(f a)](tq f b) ); Auto.
Elim (Pdec f a).

Intro.
Cut (<Elt>a=x \/ (dans x b)). 
2:Apply dans_add; Auto.
Intro H1; Elim H1; Clear H1.
Intro H1; Rewrite H1; Auto.
Auto.

Intro.
Cut (<Elt>a=x \/ (dans x b)). 
2:Apply dans_add; Auto.
Intro H1; Elim H1; Clear H1.
Intro.
Absurd (f a); Auto.
Rewrite H1; Auto.
Auto.
Save.

(*									*)
(*  De dans_tq_imp on deduit facilement que (tq f a) est inclus		*)
(*  dans a.								*)
(*									*)

Lemma inclus_tq : (f:Elt->Prop)(a:Ensf)
  (inclus (tq f a) a).
Goal.
Unfold inclus.
Intros.
Cut (dans x a)/\(f x); Auto.
2:Apply dans_tq_imp; Auto.
Intro H0; Elim H0; Auto.
Save.

Provide Dec.
